# Simple-Python-Mini-Projects

These mini projects showcase Python's versatility in practical applications, covering fundamental programming concepts such as calculations, data manipulation, and interactive interfaces. From utilities like converters and calculators to interactive games and trackers, each project emphasizes Python's capability for both learning and real-world application development.

## Python Mini Projects

This repository contains a collection of Python mini projects. Below is a list of the projects included:

| **No.** | **Name** | 
| ------- | -------- | 
|	**01**	| **[ATM Simulator](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/ATM%20Simulator)** |
|	**02**	| **[Alarm Clock](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Alarm%20Clock)** |
|	**03**	| **[BMI_calulator](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/BMI_calulator)** |
|	**04**	| **[Binary-Decimal Converter](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Binary-Decimal%20Converter)** |
|	**05**	| **[Blood Bank Management System](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Blood%20Bank%20Management%20System)** |
|	**06**	| **[Calculator](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Calculator)** |
|	**07**	| **[Chess Game](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Chess%20Game)** |
|	**08**	| **[Countdown timer](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Countdown%20timer)** |
|	**09**	| **[Digital White Board](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Digital%20White%20Board)** |
|	**10**	| **[Get IP address and Hostname of Website](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Get%20IP%20address%20and%20Hostname%20of%20Website)** |
|	**11**	| **[Grocery Store Management System](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Grocery%20Store%20Management%20System)** |
|  **12** | **[Habit Tracker with Data Visualization](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Habit%20Tracker%20with%20Data%20Visualization)** |
|	**13**	| **[Hotel Management System](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Hotel%20Management%20System)** |
|	**14**	| **[Ludo Game](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Ludo%20Game)** |
|	**15**	| **[Number Guessing Game](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Number%20Guessing%20Game)** |
|	**16**	| **[Number to Words](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Number%20to%20Words)** |
|	**17**	| **[Palindrome Checker](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Palindrome%20Checker)** |
|	**18**	| **[Personal Expense Tracker](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Personal%20Expense%20Tracker)** |
|	**19**	| **[Personal Journal with Sentiment Analysis](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Personal%20Journal%20with%20Sentiment%20Analysis)** |
|	**20**	| **[Python Quiz Application](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Python%20Quiz%20Application)** |
|	**21**	| **[Python Task Scheduler](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Python%20Task%20Scheduler)** |
|	**22**	| **[QR Code Generator](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/QR%20Code%20Generator)** |
|	**23**	| **[Random Password Generator](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Random%20Password%20Generator)** |
|	**24**	| **[Recipe Recommendation System](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Recipe%20Recommendation%20System)** |
|	**25**	| **[Rock, Paper, Scissors Game](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Rock%2C%20Paper%2C%20Scissors%20Game)** |
|	**26**	| **[Simple Contact Book](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Simple%20Contact%20Book)** |
|	**27**	| **[Snake Game](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Snake%20Game)** |
|	**28**	| **[Stopwatch Application](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Stopwatch%20Application)** |
|	**29**	| **[Student Management System](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Student%20Management%20System)** |
|	**30**	| **[TO-DO List Application](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/TO-DO%20List%20Application)** |
|	**31**	| **[Text To Speech ](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Text%20To%20Speech)** |
|	**32**	| **[Tic Tac Teo Game](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Tic-Tac-Toe%20Game)** |
|	**33**	| **[Translate](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Translate)** |
|	**34**	| **[Virtual Plant Care Simulato](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Virtual%20Plant%20Care%20Simulato)** |
|	**35**	| **[Voice-Controlled Home Automation Simulator](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Voice-Controlled%20Home%20Automation%20Simulator)** |
|	**36**	| **[Weather App](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Weather_app)** |
|	**37**	| **[Word Count Tool](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/tree/main/Word%20Count%20Tool)** |

---

## How to Use This Repository

Follow these steps to explore and use this repository effectively:

### 1. Clone the Repository
Clone the repository to your local machine using the following command:
```bash
git clone https://github.com/ShravanDalavi/Simple-Python-Mini-Projects.git
```

Alternatively, you can download the repository as a ZIP file and extract it.

---

### 2. Navigate to the Repository
Once cloned, navigate to the project directory:
```bash
cd Simple-Python-Mini-Projects/<Project Name>
```

---

### 3. Explore the Projects
Each mini-project is stored in its own directory. You can browse through the folders to find the projects of interest. Each folder contains:
- A Python file (`*.py`) with the source code for the project.
- A `README.md` file (if available) with a brief description of the project.

---

### 4. Run a Project
To run a specific project:
1. Open a terminal or command prompt.
2. Navigate to the project directory, e.g.,
   ```bash
   cd Project-Name
   ```
3. Run the Python file using:
   ```bash
   python project_name.py
   ```

Replace `project_name.py` with the actual file name.

---

### 5. Modify or Extend Projects
Feel free to modify the projects to experiment with the code and add new features. To edit a project:
1. Open the project file in your favorite code editor (e.g., VSCode, PyCharm, or Sublime Text).
2. Make your changes and save the file.
3. Run the project to test your changes.

---

 ## Prerequisites
Before running the projects, ensure you have:
1. Python installed (version 3.x is recommended). You can download it from [python.org](https://www.python.org/).
2. Basic knowledge of Python programming.

---

## How can I read this tutorial without an Internet connection? <img alt="GIF" src="https://github.com/TheDudeThatCode/TheDudeThatCode/blob/master/Assets/hmm.gif" width="20" />
1. Go [**`here`**](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects) and click the big green ➞  **`Code`** button in the top right of the page, then click ➞ [**`Download ZIP`**](https://github.com/shravandalavi/Simple-Python-Mini-Projects/archive/refs/heads/main.zip).

  ![image](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects/assets/172488772/fe6f519f-afbd-49d1-9efc-5f6b5f234340)

2. Extract the ZIP and open it. Unfortunately I don't have any more specific instructions because how exactly this is done depends on which operating system you run.    
3. Launch ipython notebook from the folder which contains the notebooks. Open each one of them
  
    **`Kernel > Restart & Clear Output`**
    
This will clear all the outputs and now you can understand each statement and learn interactively.

If you have git and you know how to use it, you can also clone the repository instead of downloading a zip and extracting it. An advantage with doing it this way is that you don't need to download the whole tutorial again to get the latest version of it, all you need to do is to pull with git and run ipython notebook again.

---

## Licence 📜
You may use this tutorial freely at your own risk. See [LICENSE](./LICENSE).

## Contributors ✨
- Shravan Dalavi
  - Contact: shravandalavi137@gmail.com
  - GitHub: [Profile](https://github.com/ShravanDalavi)
- Ashwini Sonawane
  - Contact: ashwinisonawane@gmail.com
  - GitHub:  [Profile](https://github.com/SonawaneAshwini)



---

### Feedback and Support
We value your input! If you encounter any issues or have suggestions, please open an issue in this repository. Your feedback helps us improve!

### Show Your Support
**If you enjoyed this tutorial, don't forget to [⭐ star the repository](https://github.com/ShravanDalavi/Simple-Python-Mini-Projects) and [follow for updates](https://github.com/ShravanDalavi).**

**Thank you for exploring this repository! I hope you find these projects both interesting and useful. 😊**
