/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;

public class BSound
extends InputStream {
    public int[] samples = null;
    public boolean play = false;
    public boolean loop = false;
    public float volume = 1.0f;
    public float speed = 1.0f;
    public int position;
    public int in;
    public int out;
    private float posf = 0.0f;
    protected byte[] buf;
    protected int pos;
    protected int mark = 0;
    protected int count;

    public int readSample() {
        this.posf += this.speed;
        this.pos = (int)this.posf;
        if (this.pos >= this.out) {
            this.pos = this.in;
            this.posf = this.in;
            if (!this.loop) {
                this.play = false;
            }
        }
        if (this.pos < this.in) {
            this.pos = this.out - 1;
            this.posf = (float)this.out - 1.0f;
            if (!this.loop) {
                this.play = false;
            }
        }
        return (int)((float)this.samples[this.pos] * this.volume);
    }

    public void volume(float f) {
        this.volume = f >= 0.0f ? f : 0.0f;
    }

    public void speed(float f) {
        this.speed = f;
    }

    public void play() {
        if (this.samples == null) {
            return;
        }
        if (!this.play) {
            this.play = true;
        } else {
            this.pos = this.in;
        }
    }

    public void repeat() {
        if (this.samples == null) {
            return;
        }
        this.loop = true;
        if (!this.play) {
            this.play = true;
        } else {
            this.pos = this.in;
        }
    }

    public void pause() {
        this.play = false;
    }

    public void stop() {
        this.play = false;
        this.pos = this.in;
    }

    public void seek(int n) {
        this.pos = n;
        if (this.pos >= this.out) {
            this.pos = this.out - 1;
        }
        if (this.pos <= this.in) {
            this.pos = this.in;
        }
    }

    public void in(int n) {
        this.in = n > 0 ? (n < this.out ? n : this.out) : 0;
    }

    public void out(int n) {
        this.out = n > this.count ? (n > this.in ? n : this.in) : this.count;
    }

    public boolean playing() {
        return this.play;
    }

    public synchronized int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + n2 > this.count) {
            n2 = this.count - this.pos;
        }
        if (n2 <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.pos += n2;
        return n2;
    }

    public synchronized long skip(long l) {
        if ((long)this.pos + l > (long)this.count) {
            l = this.count - this.pos;
        }
        if (l < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l);
        return l;
    }

    public synchronized int available() {
        return this.count - this.pos;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) {
    }

    public synchronized void reset() {
        this.pos = 0;
    }

    public BSound(int n) {
        if (n < 1) {
            n = 1;
        }
        this.samples = new int[n];
        this.pos = 0;
        this.count = n;
        this.in = 0;
        this.out = this.count;
        this.position = this.pos;
        int n2 = 0;
        while (n2 < this.count) {
            this.samples[n2] = 0;
            ++n2;
        }
    }

    public BSound(int[] nArray) {
        this.samples = nArray;
        this.pos = 0;
        this.count = this.samples.length;
        this.in = 0;
        this.out = this.count;
        this.position = this.pos;
    }

    public BSound(byte[] byArray) {
        this.buf = byArray;
        this.pos = 0;
        this.count = byArray.length;
    }

    public BSound(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.pos = n;
        this.count = Math.min(n + n2, byArray.length);
    }
}

