/*
 * Decompiled with CFR 0.152.
 */
public class tissue
extends BApplet {
    int numLights;
    int numVehicles;
    Vehicle[] vehicles;
    Light[] lights;
    float maxDistance;
    int r;
    int g;
    int b;

    void setup() {
        this.size(600, 250);
        this.background(230.0f, 230.0f, 200.0f);
        this.ellipseMode(3);
        int n = 0;
        while (n < this.numLights) {
            this.lights[n] = new Light(this.random(20.0f, this.width - 20), this.random(20.0f, this.height - 20), 20, n, this.lights);
            ++n;
        }
        n = 0;
        while (n < this.numVehicles) {
            int n2 = n % 4;
            if (n2 == 0) {
                this.r = 153;
                this.g = 204;
                this.b = 0;
            } else if (n2 == 1) {
                this.r = 102;
                this.g = 102;
                this.b = 102;
            } else if (n2 == 2) {
                this.r = 153;
                this.g = 102;
                this.b = 0;
            } else if (n2 == 3) {
                this.r = 153;
                this.g = 153;
                this.b = 0;
            }
            int n3 = (int)this.random(-26.0f, 26.0f);
            this.vehicles[n] = new Vehicle(this.random(this.width), this.random(this.height), this.random(360.0f), n2, this.r + n3, this.g + n3, this.b);
            ++n;
        }
        this.maxDistance = this.sqrt(this.sq(this.width) + this.sq(this.height));
    }

    void loop() {
        int n = 0;
        while (n < this.numLights) {
            this.lights[n].update();
            this.lights[n].draw();
            ++n;
        }
        n = 0;
        while (n < this.numVehicles) {
            this.vehicles[n].update();
            this.vehicles[n].draw();
            ++n;
        }
    }

    void mouseReleased() {
        int n = 0;
        while (n < this.numLights) {
            this.lights[n].unlock();
            ++n;
        }
    }

    boolean overCircle(float f, float f2, int n) {
        float f3 = f - (float)this.mouseX;
        float f4 = f2 - (float)this.mouseY;
        return !(this.sqrt(this.sq(f3) + this.sq(f4)) >= (float)(n / 2));
    }

    float constrain(float f, float f2, float f3) {
        return this.min(this.max(f, f2), f3);
    }

    public tissue() {
        this.Block$();
    }

    private void Block$() {
        this.numLights = 3;
        this.numVehicles = 600;
        this.vehicles = new Vehicle[this.numVehicles];
        this.lights = new Light[this.numLights];
    }

    class Light {
        float lightX;
        float lightY;
        int size;
        boolean over;
        boolean pressed;
        boolean locked;
        Light[] others;
        boolean otherslocked;
        int me;

        Light(float f, float f2, int n, int n2, Light[] lightArray) {
            this.lightX = f;
            this.lightY = f2;
            this.size = n;
            this.me = n2;
            this.others = lightArray;
        }

        void update() {
            int n = 0;
            while (n < this.others.length) {
                if (this.others[n].locked) {
                    this.otherslocked = true;
                    break;
                }
                this.otherslocked = false;
                ++n;
            }
            if (!this.otherslocked) {
                this.over();
                this.pressed();
            }
            if (this.locked) {
                this.lightX = tissue.this.constrain(tissue.this.mouseX, this.size / 2, tissue.this.width - this.size / 2);
                this.lightY = tissue.this.constrain(tissue.this.mouseY, this.size / 2, tissue.this.height - this.size / 2);
            }
        }

        void over() {
            if (tissue.this.overCircle(this.lightX, this.lightY, this.size)) {
                this.over = true;
                return;
            }
            this.over = false;
        }

        void pressed() {
            if (tissue.this.mousePressed && this.over) {
                this.pressed = true;
                this.locked = true;
                return;
            }
            this.pressed = false;
        }

        void unlock() {
            this.locked = false;
        }

        void draw() {
            tissue.this.noStroke();
            if (this.over) {
                tissue.this.fill(204.0f, 153.0f, 0.0f);
            } else {
                tissue.this.fill(255.0f, 204.0f, 0.0f);
            }
            tissue.this.ellipse(this.lightX, this.lightY, this.size, this.size);
        }
    }

    class Vehicle {
        int wom_length;
        int direction;
        float pos_x;
        float pos_y;
        float lineRotate;
        float lineRotateNew;
        float lineWidth;
        float turnSpeed;
        float lineSpeed;
        float speed;
        float maxSpeed;
        float size;
        int red;
        int green;
        int blue;
        int type;
        float[] past_x;
        float[] past_y;
        int id;
        int randval;

        Vehicle(float f, float f2, float f3, int n, int n2, int n3, int n4) {
            this.Block$();
            this.pos_x = f;
            this.pos_y = f2;
            int n5 = 0;
            while (n5 < this.wom_length) {
                this.past_x[n5] = this.pos_x;
                this.past_y[n5] = this.pos_y;
                ++n5;
            }
            this.lineRotate = this.lineRotateNew = f3;
            this.type = n;
            this.lineWidth = 10.0f;
            this.turnSpeed = 0.5f;
            this.speed = 0.0f;
            this.id = n;
            this.red = n2;
            this.green = n3;
            this.blue = n4;
        }

        float hump(float f) {
            f = (f - 0.5f) * 2.0f;
            f = 1.0f - f * f;
            return f;
        }

        int clamp(float f) {
            float f2 = Math.max(0.0f, f);
            f2 = Math.min(f2, 255.0f);
            return (int)f2;
        }

        void update() {
            this.lineRotateNew = this.lineRotate / 180.0f * (float)Math.PI;
            float f = this.lineRotateNew + 0.62831855f;
            float f2 = this.pos_x + tissue.this.cos(f) * this.lineWidth;
            float f3 = this.pos_y + tissue.this.sin(f) * this.lineWidth;
            float f4 = this.lineRotateNew - 0.62831855f;
            float f5 = this.pos_x + tissue.this.cos(f4) * this.lineWidth;
            float f6 = this.pos_y + tissue.this.sin(f4) * this.lineWidth;
            this.lineSpeed = 0.0f;
            int n = 0;
            while (n < tissue.this.numLights) {
                float f7;
                float f8;
                float f9 = tissue.this.lights[n].lightX;
                float f10 = tissue.this.lights[n].lightY;
                float f11 = f9 - f2;
                float f12 = f10 - f3;
                float f13 = tissue.this.sqrt(f11 * f11 + f12 * f12);
                f11 = f9 - f5;
                f12 = f10 - f6;
                float f14 = tissue.this.sqrt(f11 * f11 + f12 * f12);
                float f15 = f13 / tissue.this.maxDistance;
                f15 = this.hump(f15);
                float f16 = f14 / tissue.this.maxDistance;
                f16 = this.hump(f16);
                float f17 = (f15 + f16) / 2.0f;
                this.lineSpeed += (this.maxSpeed - this.maxSpeed * f17) / 10.0f;
                if (this.type == 0) {
                    this.lineRotate += f13 / this.turnSpeed * (1.0f - f15);
                    this.lineRotate -= f14 / this.turnSpeed * (1.0f - f16);
                } else if (this.type == 1) {
                    this.lineRotate += f14 / this.turnSpeed * (1.0f - f15);
                    this.lineRotate -= f13 / this.turnSpeed * (1.0f - f16);
                } else if (this.type == 2) {
                    this.lineRotate -= f13 / this.turnSpeed * (1.0f - f15);
                    this.lineRotate += f14 / this.turnSpeed * (1.0f - f16);
                } else if (this.type == 3) {
                    this.lineRotate -= f14 / this.turnSpeed * (1.0f - f15);
                    this.lineRotate += f13 / this.turnSpeed * (1.0f - f16);
                }
                this.lineRotate += tissue.this.random(-2.0f, 2.0f);
                this.lineRotateNew = tissue.this.radians(this.lineRotate);
                if (!(this.lineRotateNew >= 1.5707964f)) {
                    f8 = tissue.this.sin(this.lineRotateNew) * this.lineSpeed;
                    f7 = tissue.this.cos(this.lineRotateNew) * this.lineSpeed;
                    this.pos_x += f7 * (float)this.direction;
                    this.pos_y += f8 * (float)this.direction;
                } else if (!(this.lineRotateNew >= (float)Math.PI)) {
                    this.lineRotateNew -= 1.5707964f;
                    f8 = tissue.this.cos(this.lineRotateNew) * this.lineSpeed;
                    f7 = tissue.this.sin(this.lineRotateNew) * this.lineSpeed;
                    this.pos_x -= f7 * (float)this.direction;
                    this.pos_y += f8 * (float)this.direction;
                } else if (!(this.lineRotateNew >= 4.712389f)) {
                    this.lineRotateNew -= (float)Math.PI;
                    f8 = tissue.this.sin(this.lineRotateNew) * this.lineSpeed;
                    f7 = tissue.this.cos(this.lineRotateNew) * this.lineSpeed;
                    this.pos_x -= f7 * (float)this.direction;
                    this.pos_y -= f8 * (float)this.direction;
                } else {
                    this.lineRotateNew -= 4.712389f;
                    f8 = tissue.this.cos(this.lineRotateNew) * this.lineSpeed;
                    f7 = tissue.this.sin(this.lineRotateNew) * this.lineSpeed;
                    this.pos_x += f7 * (float)this.direction;
                    this.pos_y -= f8 * (float)this.direction;
                }
                int n2 = tissue.this.width;
                int n3 = tissue.this.height;
                if (this.pos_x > (float)n2 + this.size || !(this.pos_x >= -this.size) || this.pos_y > (float)n3 + this.size || !(this.pos_y >= -this.size)) {
                    if (this.pos_x > (float)n2 + this.size) {
                        this.pos_x = this.past_x[0];
                        this.pos_y = this.past_y[0];
                    }
                    if (!(this.pos_x >= -this.size)) {
                        this.pos_x = this.past_x[0];
                        this.pos_y = this.past_y[0];
                    }
                    if (this.pos_y > (float)n3 + this.size) {
                        this.pos_x = this.past_x[0];
                        this.pos_y = this.past_y[0];
                    }
                    if (!(this.pos_y >= -this.size)) {
                        this.pos_x = this.past_x[0];
                        this.pos_y = this.past_y[0];
                    }
                    this.reset();
                }
                int n4 = this.wom_length - 1;
                while (n4 > 0) {
                    this.past_x[n4] = this.past_x[n4 - 1];
                    this.past_y[n4] = this.past_y[n4 - 1];
                    --n4;
                }
                this.past_x[0] = this.pos_x;
                this.past_y[0] = this.pos_y;
                ++n;
            }
        }

        void reset() {
            this.direction *= -1;
            this.lineRotate += 1.0f;
        }

        void draw() {
            tissue.this.stroke(this.red, this.green, this.blue);
            tissue.this.beginShape(33);
            int n = 1;
            while (n < this.wom_length) {
                if (!(this.past_x[n] >= (float)tissue.this.width)) {
                    tissue.this.vertex(this.past_x[n], this.past_y[n], 0.0f);
                }
                ++n;
            }
            tissue.this.endShape();
        }

        private void Block$() {
            this.wom_length = 20;
            this.direction = 1;
            this.lineRotateNew = 0.0f;
            this.lineWidth = 25.0f;
            this.turnSpeed = 2.0f;
            this.lineSpeed = 2.0f;
            this.speed = 0.0f;
            this.maxSpeed = 6.0f;
            this.size = 0.0f;
            this.past_x = new float[this.wom_length];
            this.past_y = new float[this.wom_length];
            this.randval = 0;
        }
    }
}

