/*
 * Decompiled with CFR 0.152.
 */
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.LinearLag;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.PanUnit;
import com.softsynth.jsyn.SampleReader_16V1;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.jsyn.SynthSampleAIFF;
import com.softsynth.jsyn.SynthSampleWAV;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

class BJSyn {
    static int maxSamples = 1000;
    public static SynthSample[] mySamp = new SynthSample[maxSamples];
    static SampleReader_16V1[] mySampler = new SampleReader_16V1[maxSamples];
    static LineOut[] myOut = new LineOut[maxSamples];
    static PanUnit[] myPan = new PanUnit[maxSamples];
    static double basePitch;
    static boolean ifApplication;
    static InputStream stream;
    static final int NUM_FRAMES = 64;
    static int count;
    static LinearLag[] myLinearLag;
    static LinearLag[] myLinearLag2;
    static LinearLag[] myLinearLag3;
    static int sampleNum;
    static int channelNum;
    static MultiplyUnit[] multiplier;
    static /* synthetic */ Class class$BJSyn;

    static int getChannels(int n) {
        return mySamp[n].getChannelsPerFrame();
    }

    static void loopSample(int n, int n2, int n3) {
        try {
            BJSyn.startCircuit(n);
            int n4 = Synth.getTickCount() + 1;
            BJSyn.mySampler[n].samplePort.clear(n4);
            BJSyn.myLinearLag2[n].time.set(n4, 0.001);
            BJSyn.myLinearLag2[n].input.set(n4, 1.0);
            BJSyn.mySampler[n].samplePort.queueLoop(n4, mySamp[n], n2, n3 - n2);
        }
        catch (SynthException synthException) {
            System.out.println(synthException);
        }
    }

    static void loopSample(int n) {
        BJSyn.loopSample(n, 0, mySamp[n].getNumFrames());
    }

    static void playSample(int n) {
        BJSyn.playSample(n, 0, mySamp[n].getNumFrames());
    }

    static void playSample(int n, int n2, int n3) {
        try {
            BJSyn.startCircuit(n);
            int n4 = Synth.getTickCount() + 1;
            BJSyn.mySampler[n].samplePort.clear(n4);
            BJSyn.myLinearLag2[n].time.set(n4, 0.001);
            BJSyn.myLinearLag2[n].input.set(n4, 1.0);
            BJSyn.mySampler[n].samplePort.queue(n4, mySamp[n], n2, n3 - n2);
        }
        catch (SynthException synthException) {
            System.out.println(synthException);
        }
    }

    static void loopSampleNum(int n, int n2, int n3, int n4) {
        try {
            BJSyn.startCircuit(n2);
            int n5 = Synth.getTickCount() + 1;
            BJSyn.mySampler[n2].samplePort.clear(n5);
            BJSyn.myLinearLag2[n2].time.set(n5, 0.001);
            BJSyn.myLinearLag2[n2].input.set(n5, 1.0);
            for (int i = 0; i < n; ++i) {
                BJSyn.mySampler[n2].samplePort.queue(n5, mySamp[n2], n3, n4 - n3);
            }
        }
        catch (SynthException synthException) {
            System.out.println(synthException);
        }
    }

    static void stopSample(int n, boolean bl, int n2) {
        try {
            if (bl) {
                BJSyn.stopCircuit(n, n2);
            }
            BJSyn.myLinearLag2[n].time.set(0.005);
            BJSyn.myLinearLag2[n].input.set(0.0);
        }
        catch (SynthException synthException) {
            System.out.println(synthException);
        }
    }

    static void startCircuit(int n) {
        try {
            myPan[n].start();
            myOut[n].start();
            mySampler[n].start();
            multiplier[n].start();
            myLinearLag[n].start();
            myLinearLag2[n].start();
            myLinearLag3[n].start();
        }
        catch (SynthException synthException) {
            SynthAlert.showError(synthException);
            System.out.println(synthException);
        }
    }

    static void stopCircuit(int n, int n2) {
        try {
            int n3 = Synth.getTickCount() + n2;
            myPan[n].stop(n3);
            myOut[n].stop(n3);
            mySampler[n].stop(n3);
            multiplier[n].stop(n3);
            myLinearLag[n].stop(n3);
            myLinearLag2[n].stop(n3);
            myLinearLag3[n].stop(n3);
        }
        catch (SynthException synthException) {
            System.out.println(synthException);
        }
    }

    static void setRate(int n, float f) {
        BJSyn.mySampler[n].rate.set(f);
    }

    static double getRate(int n) {
        return BJSyn.mySampler[n].rate.get();
    }

    static void setVolume(int n, float f) {
        BJSyn.myLinearLag[n].input.set(f);
        BJSyn.myLinearLag[n].time.set(0.03);
    }

    static void setVolume(int n, double d) {
        BJSyn.setVolume(n, (float)d);
    }

    static double getVolume(int n) {
        return BJSyn.myLinearLag[n].input.get();
    }

    static void setPan(int n, float f) {
        BJSyn.myLinearLag3[n].time.set(0.03);
        BJSyn.myLinearLag3[n].input.set(f);
    }

    static double getPan(int n) {
        return BJSyn.myLinearLag3[n].input.get();
    }

    static int getNumFrames(int n) {
        return mySamp[n].getNumFrames();
    }

    static void buildSamp(int n, String string) {
        switch (SynthSample.getFileType(string)) {
            case 1: {
                BJSyn.mySamp[n] = new SynthSampleAIFF();
                break;
            }
            case 2: {
                BJSyn.mySamp[n] = new SynthSampleWAV();
                break;
            }
            default: {
                System.err.println("Sonia SAYS: Sample must be a 'Wav' or 'Aiff' file format.");
            }
        }
    }

    static void buildEmptySamp(int n, int n2, int n3) {
        BJSyn.mySamp[n] = new SynthSample(n2);
        mySamp[n].setSampleRate(n3);
    }

    static void loadSample(int n, String string) {
        try {
            URL uRL = (class$BJSyn == null ? (class$BJSyn = BJSyn.class$("BJSyn")) : class$BJSyn).getResource(string);
            stream = uRL.openConnection().getInputStream();
            BJSyn.buildSamp(n, string);
            if (mySamp[n] != null) {
                BJSyn.loadSample(mySamp[n], stream);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        catch (SecurityException securityException) {
            System.err.println(securityException);
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Sonia SAYS: Please make sure you have entered the correct Sample file name to load");
        }
        if (mySamp[n].getChannelsPerFrame() == 1) {
            BJSyn.buildCircuit(n);
            channelNum = 1;
        } else if (mySamp[n].getChannelsPerFrame() == 2) {
            channelNum = 2;
            int n2 = mySamp[n].getNumFrames() * mySamp[n].getChannelsPerFrame();
            short[] sArray = new short[n2];
            short[] sArray2 = new short[n2 / 2];
            short[] sArray3 = new short[n2 / 2];
            mySamp[n].read(sArray);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                sArray2[n3++] = sArray[n5++];
                sArray3[n4++] = sArray[n5++];
            }
            BJSyn.buildSamp(n + 1, string);
            mySamp[n].clear(0, n2 / 2);
            mySamp[n].allocate(n2 / 2, 1);
            mySamp[n].write(0, sArray2, 0, n2 / 2);
            BJSyn.buildCircuit(n);
            BJSyn.setPan(n, -1.0f);
            mySamp[n + 1].allocate(n2 / 2, 1);
            mySamp[n + 1].write(0, sArray3, 0, n2 / 2);
            BJSyn.buildCircuit(n + 1);
            BJSyn.setPan(n + 1, 1.0f);
        }
    }

    static void loadSample(SynthSample synthSample, InputStream inputStream) throws IOException {
        synthSample.load(inputStream);
    }

    static void buildCircuit(int n) {
        BJSyn.mySampler[n] = new SampleReader_16V1();
        BJSyn.myOut[n] = new LineOut();
        BJSyn.myPan[n] = new PanUnit();
        BJSyn.multiplier[n] = new MultiplyUnit();
        BJSyn.myLinearLag[n] = new LinearLag();
        BJSyn.myLinearLag2[n] = new LinearLag();
        BJSyn.myLinearLag3[n] = new LinearLag();
        BJSyn.myLinearLag3[n].output.connect(BJSyn.myPan[n].pan);
        BJSyn.mySampler[n].output.connect(BJSyn.myPan[n].input);
        BJSyn.myPan[n].output.connect(0, BJSyn.myOut[n].input, 0);
        BJSyn.myPan[n].output.connect(1, BJSyn.myOut[n].input, 1);
        BJSyn.myLinearLag[n].output.connect(BJSyn.multiplier[n].inputB);
        BJSyn.myLinearLag2[n].output.connect(BJSyn.multiplier[n].inputA);
        BJSyn.multiplier[n].output.connect(BJSyn.mySampler[n].amplitude);
        BJSyn.startCircuit(n);
    }

    static void deleteCircuit(int n) {
        mySampler[n].delete();
        BJSyn.mySampler[n] = null;
        myOut[n].delete();
        BJSyn.myOut[n] = null;
        myPan[n].delete();
        BJSyn.myPan[n] = null;
        mySamp[n].delete();
        BJSyn.mySamp[n] = null;
        multiplier[n].delete();
        BJSyn.multiplier[n] = null;
        myLinearLag[n].delete();
        BJSyn.myLinearLag[n] = null;
        myLinearLag2[n].delete();
        BJSyn.myLinearLag2[n] = null;
        myLinearLag3[n].delete();
        BJSyn.myLinearLag3[n] = null;
    }

    static void startEngine() {
        for (int i = 0; i < count; ++i) {
            BJSyn.startCircuit(i);
        }
    }

    static void stopEngine() {
        for (int i = 0; i < count; ++i) {
            BJSyn.stopCircuit(i, 0);
            BJSyn.deleteCircuit(i);
        }
    }

    static void stop() {
        try {
            BJSyn.stopEngine();
            count = 0;
            Synth.setTrace(0);
        }
        catch (SynthException synthException) {
            System.err.println(synthException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ifApplication = false;
        count = 0;
        myLinearLag = new LinearLag[maxSamples];
        myLinearLag2 = new LinearLag[maxSamples];
        myLinearLag3 = new LinearLag[maxSamples];
        sampleNum = 0;
        multiplier = new MultiplyUnit[maxSamples];
    }
}

