/*
 * Decompiled with CFR 0.152.
 */
class FFTutils {
    float HALF_PI = 1.5707964f;
    float TWO_PI = (float)Math.PI * 2;
    int WINDOW_SIZE;
    int WS2;
    int BIT_LEN;
    int[] _bitrevtable;
    float _normF;
    float[] _equalize;
    float[] _envelope;
    float[] _fft_result;
    float[][] _fftBuffer;
    float[] _cosLUT;
    float[] _sinLUT;
    float[] _iirfX;
    float[] _iirfY;
    boolean _isEqualized;
    boolean _hasEnvelope;

    public FFTutils(int n) {
        this.WINDOW_SIZE = this.WS2 = n;
        this.WS2 >>= 1;
        this.BIT_LEN = (int)(Math.log(this.WINDOW_SIZE) / 0.693147180559945 + 0.5);
        this._normF = 2.0f / (float)this.WINDOW_SIZE;
        this._hasEnvelope = false;
        this._isEqualized = false;
        this.initFFTtables();
    }

    void initFFTtables() {
        int n;
        this._cosLUT = new float[this.BIT_LEN];
        this._sinLUT = new float[this.BIT_LEN];
        this._fftBuffer = new float[this.WINDOW_SIZE][2];
        this._fft_result = new float[this.WS2];
        float f = (float)Math.PI;
        for (n = 0; n < this.BIT_LEN; ++n) {
            this._cosLUT[n] = (float)Math.cos(f);
            this._sinLUT[n] = (float)Math.sin(f);
            f = (float)((double)f * 0.5);
        }
        this._bitrevtable = new int[this.WINDOW_SIZE];
        for (n = 0; n < this.WINDOW_SIZE; ++n) {
            this._bitrevtable[n] = n;
        }
        int n2 = 0;
        for (n = 0; n < this.WINDOW_SIZE; ++n) {
            int n3;
            if (n2 > n) {
                int n4 = this._bitrevtable[n];
                this._bitrevtable[n] = this._bitrevtable[n2];
                this._bitrevtable[n2] = n4;
            }
            for (n3 = this.WS2; n3 >= 1 && n2 >= n3; n2 -= n3, n3 >>= 1) {
            }
            n2 += n3;
        }
    }

    void useEqualizer(boolean bl) {
        this._isEqualized = bl;
        if (bl) {
            float f = -0.02f;
            float f2 = 1.0f / (float)this.WS2;
            this._equalize = new float[this.WS2];
            for (int i = 0; i < this.WS2; ++i) {
                this._equalize[i] = f * (float)Math.log((double)(this.WS2 - i) * (double)f2);
            }
        }
    }

    void useEnvelope(boolean bl, float f) {
        block4: {
            this._hasEnvelope = bl;
            if (!bl) break block4;
            float f2 = 1.0f / (float)this.WINDOW_SIZE * this.TWO_PI;
            this._envelope = new float[this.WINDOW_SIZE];
            if (f == 1.0f) {
                for (int i = 0; i < this.WINDOW_SIZE; ++i) {
                    this._envelope[i] = 0.5f + 0.5f * (float)Math.sin((float)i * f2 - this.HALF_PI);
                }
            } else {
                for (int i = 0; i < this.WINDOW_SIZE; ++i) {
                    this._envelope[i] = (float)Math.pow(0.5f + 0.5f * (float)Math.sin((float)i * f2 - this.HALF_PI), f);
                }
            }
        }
    }

    float[] computeFFT(float[] fArray) {
        int n;
        int n2;
        if (this._hasEnvelope) {
            for (n2 = 0; n2 < this.WINDOW_SIZE; ++n2) {
                n = this._bitrevtable[n2];
                this._fftBuffer[n2][0] = n < this.WINDOW_SIZE ? fArray[n] * this._envelope[n] : 0.0f;
                this._fftBuffer[n2][1] = 0.0f;
            }
        } else {
            for (n2 = 0; n2 < this.WINDOW_SIZE; ++n2) {
                n = this._bitrevtable[n2];
                this._fftBuffer[n2][0] = n < this.WINDOW_SIZE ? fArray[n] : 0.0f;
                this._fftBuffer[n2][1] = 0.0f;
            }
        }
        int n3 = 2;
        int n4 = 0;
        for (int i = 1; i <= this.BIT_LEN; ++i) {
            int n5 = n3 >> 1;
            float f = this._cosLUT[n4];
            float f2 = this._sinLUT[n4++];
            float f3 = 1.0f;
            float f4 = 0.0f;
            for (int j = 1; j <= n5; ++j) {
                float f5;
                for (n2 = j; n2 <= this.WINDOW_SIZE; n2 += n3) {
                    int n6 = n2 + n5;
                    int n7 = n6 - 1;
                    int n8 = n2 - 1;
                    f5 = this._fftBuffer[n7][0] * f3 - f4 * this._fftBuffer[n7][1];
                    float f6 = this._fftBuffer[n7][1] * f3 + f4 * this._fftBuffer[n7][0];
                    this._fftBuffer[n7][0] = this._fftBuffer[n8][0] - f5;
                    this._fftBuffer[n7][1] = this._fftBuffer[n8][1] - f6;
                    float[] fArray2 = this._fftBuffer[n8];
                    fArray2[0] = fArray2[0] + f5;
                    float[] fArray3 = this._fftBuffer[n8];
                    fArray3[1] = fArray3[1] + f6;
                }
                f5 = f3 * f - f2 * f4;
                f4 = f * f4 + f2 * f3;
                f3 = f5;
            }
            n3 <<= 1;
        }
        if (this._isEqualized) {
            for (n2 = 0; n2 < this.WS2; ++n2) {
                this._fft_result[n2] = this._equalize[n2] * (float)Math.sqrt(this._fftBuffer[n2][0] * this._fftBuffer[n2][0] + this._fftBuffer[n2][1] * this._fftBuffer[n2][1]);
            }
        } else {
            for (n2 = 0; n2 < this.WS2; ++n2) {
                this._fft_result[n2] = this._normF * (float)Math.sqrt(this._fftBuffer[n2][0] * this._fftBuffer[n2][0] + this._fftBuffer[n2][1] * this._fftBuffer[n2][1]);
            }
        }
        return this._fft_result;
    }

    void initFilter(float f, int n) {
        this._iirfX = new float[n + 1];
        this._iirfY = new float[n];
        this._iirfX[0] = 1.0f - f;
        this._iirfY[0] = f;
    }

    float[] applyFilter(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        for (int i = this._iirfY.length; i < fArray.length; ++i) {
            float f = fArray[i] * this._iirfX[0];
            for (int j = 0; j < this._iirfY.length; ++j) {
                int n = j + 1;
                f += fArray[i - n] * this._iirfX[n] + fArray2[i - n] * this._iirfY[j];
            }
            fArray2[i] = f;
        }
        return fArray2;
    }
}

