/*
 * Decompiled with CFR 0.152.
 */
import com.softsynth.jsyn.BusReader;
import com.softsynth.jsyn.BusWriter;
import com.softsynth.jsyn.ChannelIn;
import com.softsynth.jsyn.PeakFollower;
import com.softsynth.jsyn.SampleWriter;
import com.softsynth.jsyn.SampleWriter_16F1;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthSample;

class LiveInput {
    static ChannelIn[] chIn = new ChannelIn[Sonia.inDevChNum];
    static SynthSample sample;
    static SampleWriter sampleWriter;
    static BusReader myBusReader;
    static int maxSamples;
    static BusWriter[] myBusWriter;
    static PeakFollower followerL;
    static PeakFollower followerR;
    static SampleWriter[] recorder;
    static FFTutils _FFTutils;
    static float[] spectrum;
    static short[] _signal;
    static float[] signal;
    static boolean doOnce;
    static boolean micFlag;
    static int state;
    static int startframe;

    static void start(int n, int n2) {
        if (micFlag) {
            if (Synth.openCount == 1) {
                Synth.stop();
                for (int i = 0; i < 5; ++i) {
                }
                Synth.start(0, n, Sonia.inDevID, Sonia.inDevChNum, Sonia.outDevID, Sonia.outDevChNum);
                BJSyn.startEngine();
            } else if (Synth.openCount == 0) {
                Sonia.initJsyn(n, 32);
            }
        }
        doOnce = true;
        state = 1;
        _FFTutils = new FFTutils(n2 * 2);
        signal = new float[n2 * 2];
        _signal = new short[n2 * 2];
        sample = new SynthSample(n2 * 2 + 1);
        sampleWriter = new SampleWriter_16F1();
        myBusReader = new BusReader();
        LiveInput.myBusWriter[0 + LiveInput.maxSamples] = new BusWriter();
        myBusWriter[0 + maxSamples].start();
        LiveInput.myBusWriter[0 + LiveInput.maxSamples].busOutput.connect(LiveInput.myBusReader.busInput);
        LiveInput.chIn[0] = new ChannelIn(0);
        LiveInput.chIn[0].output.connect(LiveInput.myBusWriter[LiveInput.maxSamples].input);
        chIn[0].start();
        LiveInput.myBusReader.output.connect(LiveInput.sampleWriter.input);
        followerL = new PeakFollower();
        followerR = new PeakFollower();
        LiveInput.chIn[0].output.connect(LiveInput.followerL.input);
        myBusReader.start();
        followerL.start();
        followerR.start();
        sampleWriter.start();
        LiveInput.sampleWriter.samplePort.queueLoop(sample);
    }

    static void start() {
        LiveInput.start(1024);
    }

    static void start(int n) {
        if (Synth.openCount >= 1) {
            LiveInput.start((int)Synth.getFrameRate(), n);
        } else if (Synth.openCount == 0) {
            LiveInput.start(44100, n);
        }
    }

    static void start(boolean bl) {
        micFlag = bl;
    }

    static void start(int n, boolean bl) {
        micFlag = bl;
        LiveInput.start(n);
    }

    static void start(boolean bl, int n) {
        micFlag = bl;
        LiveInput.start(n);
    }

    static void stop() {
        state = 0;
        sampleWriter.stop();
        sampleWriter.delete();
        sampleWriter = null;
        sample.delete();
        sampleWriter = null;
        followerR.stop();
        followerR.delete();
        followerR = null;
        followerL.stop();
        followerL.delete();
        followerL = null;
    }

    static float[] getSignal() {
        sample.read(0, _signal, 0, _signal.length);
        int n = LiveInput.sampleWriter.samplePort.getNumFramesMoved();
        startframe = n % _signal.length;
        for (int i = 0; i < _signal.length; ++i) {
            LiveInput.signal[i] = _signal[(i + startframe) % _signal.length];
        }
        spectrum = new float[_signal.length / 2];
        return signal;
    }

    static float[] getSpectrum() {
        spectrum = _FFTutils.computeFFT(LiveInput.getSignal());
        return spectrum;
    }

    static float[] getSpectrum(boolean bl) {
        LiveInput.useEqualizer(bl);
        LiveInput.useEnvelope(bl);
        return LiveInput.getSpectrum();
    }

    static float[] getSpectrum(boolean bl, float f) {
        LiveInput.useEqualizer(bl);
        LiveInput.useEnvelope(bl, f);
        return LiveInput.getSpectrum();
    }

    static void useEqualizer(boolean bl) {
        _FFTutils.useEqualizer(bl);
    }

    static void useEnvelope(boolean bl, float f) {
        if (bl) {
            _FFTutils.useEnvelope(true, f);
        } else {
            _FFTutils.useEnvelope(false, f);
        }
    }

    static void useEnvelope(boolean bl) {
        LiveInput.useEnvelope(bl, 1.5f);
    }

    static float getLevel() {
        return (float)((LiveInput.followerL.output.get() + LiveInput.followerR.output.get()) / 2.0);
    }

    static float getLevelLeft() {
        return (float)LiveInput.followerL.output.get();
    }

    static float getLevelRight() {
        return (float)LiveInput.followerR.output.get();
    }

    static float getLevel(int n) {
        if (n == 0) {
            return (float)LiveInput.followerL.output.get();
        }
        if (n == 1) {
            return (float)LiveInput.followerR.output.get();
        }
        return 0.0f;
    }

    static void prepareRecorder(Sample sample, int n) {
        LiveInput.recorder[n] = new SampleWriter_16F1();
        LiveInput.myBusReader.output.connect(LiveInput.recorder[n].input);
    }

    static void startRec(Sample sample) {
        int n = sample.getID();
        for (int i = 0; i < sample.getNumChannels(); ++i) {
            LiveInput.prepareRecorder(sample, n + i);
            recorder[n + i].start();
            LiveInput.recorder[n + i].samplePort.queue(BJSyn.mySamp[n + i]);
        }
    }

    static void startRec(Sample sample, int n, int n2) {
        int n3 = sample.getID();
        for (int i = 0; i < sample.getNumChannels(); ++i) {
            LiveInput.prepareRecorder(sample, n3 + i);
            recorder[n3 + i].start();
            LiveInput.recorder[n3 + i].samplePort.queue(BJSyn.mySamp[n3 + i], n, n2 - n);
        }
    }

    static void startRecLoop(Sample sample) {
        int n = sample.getID();
        for (int i = 0; i < sample.getNumChannels(); ++i) {
            LiveInput.prepareRecorder(sample, n + i);
            recorder[n + i].start();
            LiveInput.recorder[n + i].samplePort.queueLoop(BJSyn.mySamp[n + i]);
        }
    }

    static void startRecLoop(Sample sample, int n) {
        int n2 = sample.getID();
        for (int i = 0; i < sample.getNumChannels(); ++i) {
            LiveInput.prepareRecorder(sample, n2 + i);
            recorder[n2 + i].start();
            LiveInput.recorder[n2 + i].samplePort.queue(BJSyn.mySamp[n2 + i], n, BJSyn.mySamp[n2 + i].getNumFrames() - n);
            LiveInput.recorder[n2 + i].samplePort.queueLoop(BJSyn.mySamp[n2 + i]);
        }
    }

    static void startRecLoop(Sample sample, int n, int n2) {
        int n3 = sample.getID();
        for (int i = 0; i < sample.getNumChannels(); ++i) {
            LiveInput.prepareRecorder(sample, n3 + i);
            recorder[n3 + i].start();
            LiveInput.recorder[n3 + i].samplePort.queueLoop(BJSyn.mySamp[n3 + i], n, n2 - n);
        }
    }

    static void stopRec(Sample sample) {
        int n = sample.getID();
        for (int i = 0; i < sample.getNumChannels(); ++i) {
            LiveInput.recorder[n + i].samplePort.queueOff(BJSyn.mySamp[n + i]);
            LiveInput.recorder[n + i].samplePort.clear();
            recorder[n + i].stop();
        }
    }

    static {
        maxSamples = BJSyn.maxSamples;
        myBusWriter = new BusWriter[4 + maxSamples];
        recorder = new SampleWriter[maxSamples];
        micFlag = true;
        state = 0;
        startframe = 0;
    }
}

