/*
 * Decompiled with CFR 0.152.
 */
import com.softsynth.jsyn.BusWriter;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SampleReader_16F1;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.util.SampleQueueOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class LiveOutput
implements Runnable {
    static SampleReader_16F1 mySampler;
    static LineOut myOut;
    static int FRAMES_PER_BLOCK;
    static int FRAMES_IN_BUFFER;
    static int NUM_CHANNELS;
    static int SAMPLES_PER_BLOCK;
    static short[] directData;
    static float[] data;
    static SampleQueueOutputStream outStream;
    static Thread t1;
    static int state;

    static void start(int n) {
        LiveOutput.start(n, n);
    }

    static void start(int n, int n2) {
        try {
            FRAMES_PER_BLOCK = n;
            FRAMES_IN_BUFFER = n2;
            SAMPLES_PER_BLOCK = FRAMES_PER_BLOCK * NUM_CHANNELS;
            directData = new short[SAMPLES_PER_BLOCK];
            data = new float[SAMPLES_PER_BLOCK];
            if (NUM_CHANNELS == 1) {
                mySampler = new SampleReader_16F1();
            } else if (NUM_CHANNELS != 2) {
                throw new RuntimeException("This example only support mono or stereo!");
            }
            myOut = new LineOut();
            LiveOutput.mySampler.amplitude.set(1.0);
            outStream = new SampleQueueOutputStream(LiveOutput.mySampler.samplePort, FRAMES_IN_BUFFER, NUM_CHANNELS);
            LiveOutput.mySampler.output.connect(0, LiveOutput.myOut.input, 0);
            LiveOutput.mySampler.output.connect(NUM_CHANNELS - 1, LiveOutput.myOut.input, 1);
            myOut.start();
            mySampler.start();
        }
        catch (SynthException synthException) {
            System.err.println(synthException);
        }
    }

    public void run() {
        try {
            while (t1 != null) {
                LiveOutput.fireEvent();
                if (!Sonia.directData) {
                    LiveOutput.convertData();
                }
                while (outStream.available() >= FRAMES_PER_BLOCK) {
                    LiveOutput.sendBuffer();
                }
                Thread.sleep(5L);
            }
        }
        catch (SynthException synthException) {
            System.out.println("run() caught " + synthException);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("run() caught " + interruptedException);
        }
    }

    static void sendBuffer() {
        outStream.write(directData, 0, FRAMES_PER_BLOCK);
    }

    public static void convertData() {
        for (int i = 0; i < data.length; ++i) {
            LiveOutput.directData[i] = (short)(data[i] * Sonia.valueMod);
        }
    }

    public static void stop() {
        try {
            LiveOutput.stopStream();
            t1 = null;
            mySampler.delete();
            mySampler = null;
            myOut.delete();
            myOut = null;
        }
        catch (SynthException synthException) {
            System.out.println(synthException);
        }
    }

    static void startStream() {
        state = 1;
        while (outStream.available() > FRAMES_PER_BLOCK) {
            LiveOutput.sendBuffer();
        }
        int n = Synth.getTickCount() + 4;
        mySampler.start(n);
        outStream.start(n);
        LiveOutput liveOutput = new LiveOutput();
        t1 = new Thread(liveOutput);
        t1.start();
    }

    static void stopStream() {
        state = 0;
        t1 = null;
        int n = Synth.getTickCount();
        mySampler.stop(n);
        outStream.stop(n);
    }

    static void fireEvent() {
        try {
            Method method = Sonia.host.getClass().getDeclaredMethod("liveOutputEvent", null);
            try {
                method.invoke((Object)Sonia.host, null);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    static void connectLiveInput(boolean bl) {
        int n = LiveInput.maxSamples + 2;
        if (bl) {
            LiveInput.myBusWriter[n] = new BusWriter();
            LiveInput.myBusWriter[n].start();
            LiveOutput.mySampler.output.connect(LiveInput.myBusWriter[n].input);
            LiveInput.myBusWriter[n].busOutput.connect(LiveInput.myBusReader.busInput);
        } else {
            LiveInput.myBusWriter[n].stop();
            LiveInput.myBusWriter[n].input.disconnect();
            LiveInput.myBusWriter[n].busOutput.disconnect();
        }
    }

    static {
        NUM_CHANNELS = 1;
        state = 0;
    }
}

