/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.SynthSound;
import java.util.Enumeration;
import java.util.Vector;

public class SynthDistributor
extends SynthInput {
    SynthOutput driver;
    int outIndex;
    Vector connected = new Vector();
    int signalType = 7;
    double lastValue;

    public SynthDistributor(SynthSound synthSound, String string, int n) throws SynthException {
        super(synthSound, string);
        this.setSignalType(n);
    }

    public SynthDistributor(String string, int n) throws SynthException {
        this(null, string, n);
    }

    public SynthDistributor(SynthSound synthSound, String string) throws SynthException {
        this(synthSound, string, 7);
    }

    public SynthDistributor(String string) throws SynthException {
        this(null, string, 7);
    }

    public void connect(SynthInput synthInput, int n) throws SynthException {
        SDRec sDRec = null;
        Enumeration enumeration = this.connected.elements();
        while (enumeration.hasMoreElements()) {
            sDRec = (SDRec)enumeration.nextElement();
            if (sDRec.port == synthInput && sDRec.partNum == n) {
                System.err.println("SynthDistributor already connected!");
                break;
            }
            sDRec = null;
        }
        synthInput.setSignalType(this.signalType);
        synthInput.set(this.lastValue);
        if (this.driver != null) {
            synthInput.connect(n, this.driver, this.outIndex);
        }
        if (sDRec == null) {
            sDRec = new SDRec(synthInput, n);
            this.connected.addElement(sDRec);
        }
    }

    public void connect(int n, SynthInput synthInput, int n2) throws SynthException {
        if (n > 0) {
            throw new SynthException(-203, "SynthDistributor part = " + n);
        }
        this.connect(synthInput, n2);
    }

    public void connect(SynthOutput synthOutput, int n) throws SynthException {
        this.driver = synthOutput;
        this.outIndex = n;
        Enumeration enumeration = this.connected.elements();
        while (enumeration.hasMoreElements()) {
            SDRec sDRec = (SDRec)enumeration.nextElement();
            sDRec.port.connect(sDRec.partNum, this.driver, n);
        }
    }

    public void connect(int n, SynthOutput synthOutput, int n2) throws SynthException {
        if (n > 0) {
            throw new SynthException(-203, "SynthDistributor part = " + n);
        }
        this.connect(synthOutput, n2);
    }

    public void disconnect() throws SynthException {
        this.disconnect(0);
    }

    public void disconnect(int n) throws SynthException {
        Enumeration enumeration = this.connected.elements();
        while (enumeration.hasMoreElements()) {
            SDRec sDRec = (SDRec)enumeration.nextElement();
            sDRec.port.disconnect(sDRec.partNum);
        }
        this.driver = null;
        this.outIndex = 0;
    }

    public void disconnect(SynthInput synthInput, int n) throws SynthException {
        Enumeration enumeration = this.connected.elements();
        while (enumeration.hasMoreElements()) {
            SDRec sDRec = (SDRec)enumeration.nextElement();
            if (sDRec.port != synthInput || sDRec.partNum != n) continue;
            this.connected.removeElement(sDRec);
            if (this.driver == null) break;
            synthInput.disconnect(n);
            break;
        }
    }

    public void disconnect(SynthInput synthInput) throws SynthException {
        this.disconnect(synthInput, 0);
    }

    public void set(int n, double d, int n2) throws SynthException {
        this.lastValue = d;
        Enumeration enumeration = this.connected.elements();
        while (enumeration.hasMoreElements()) {
            SDRec sDRec = (SDRec)enumeration.nextElement();
            sDRec.port.set(n, d, n2);
        }
    }

    public void set(double d, int n) throws SynthException {
        this.lastValue = d;
        Enumeration enumeration = this.connected.elements();
        while (enumeration.hasMoreElements()) {
            SDRec sDRec = (SDRec)enumeration.nextElement();
            sDRec.port.set(d, n);
        }
    }

    public void setSignalType(int n, int n2) throws SynthException {
        this.signalType = n;
        this.setMinMaxByType(n);
        Enumeration enumeration = this.connected.elements();
        while (enumeration.hasMoreElements()) {
            SDRec sDRec = (SDRec)enumeration.nextElement();
            sDRec.port.setSignalType(n, n2);
        }
    }

    public int getSignalType(int n) throws SynthException {
        return this.signalType;
    }

    public double get(int n) throws SynthException {
        if (this.driver != null) {
            return this.driver.get(n);
        }
        return this.lastValue;
    }

    public double get() throws SynthException {
        return this.get(0);
    }

    public int getNumParts() throws SynthException {
        return 1;
    }

    class SDRec {
        SynthInput port;
        int partNum;

        SDRec(SynthInput synthInput, int n) {
            this.port = synthInput;
            this.partNum = n;
        }
    }
}

