/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthSound;

public class SynthPort {
    SynthSound sound;
    String name;
    String alias;
    int peerToken;
    int portHash;

    SynthPort(SynthSound synthSound, String string) throws SynthException {
        this.sound = synthSound;
        this.name = string;
        this.alias = string;
        this.portHash = Synth.hashName(string);
        if (synthSound != null) {
            this.peerToken = synthSound.peerToken;
            synthSound.addPort(this);
        } else {
            this.peerToken = 0;
        }
    }

    public String toString() {
        return this.alias;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getName() {
        return this.name;
    }

    public SynthSound getSound() {
        return this.sound;
    }

    public void setSignalType(int n, int n2) throws SynthException {
        int n3 = this.sound.context.setPortSignalType(this.peerToken, this.portHash, n2, n);
        if (n3 < 0) {
            throw new SynthException(n3, this.name, n2, n);
        }
    }

    public void setSignalType(int n) throws SynthException {
        this.setSignalType(n, 0);
    }

    public int getSignalType(int n) throws SynthException {
        int n2 = this.sound.context.getPortSignalType(this.peerToken, this.portHash, n);
        if (n2 < 0) {
            throw new SynthException(n2, this.name, n);
        }
        return n2;
    }

    public int getSignalType() throws SynthException {
        return this.getSignalType(0);
    }

    public void setSignalType(SynthPort synthPort) throws SynthException {
        this.setSignalType(synthPort.getSignalType());
    }

    public int getNumParts() throws SynthException {
        int n = this.sound.context.getNumParts(this.peerToken, this.portHash);
        if (n < 0) {
            throw new SynthException(n, this.name, this.portHash);
        }
        return n;
    }

    void addConnection(SynthPort synthPort) {
    }

    void removeConnection(SynthPort synthPort) {
    }

    static void connectUnits(SynthPort synthPort, int n, SynthPort synthPort2, int n2) throws SynthException {
        int n3;
        if (Synth.verbosity >= 1) {
            System.out.println("jsyn.SynthPort: connect( " + Integer.toHexString(synthPort.peerToken) + ", " + synthPort.name + ", " + n + ", " + Integer.toHexString(synthPort2.peerToken) + ", " + synthPort2.name + ", " + n2 + " )");
        }
        if ((n3 = synthPort.sound.context.connectUnits(synthPort.peerToken, synthPort.portHash, n, synthPort2.peerToken, synthPort2.portHash, n2)) < 0) {
            throw new SynthException(n3, synthPort.name, synthPort.peerToken, synthPort2.peerToken);
        }
    }

    static void disconnectUnits(SynthPort synthPort, int n) throws SynthException {
        int n2;
        if (Synth.verbosity >= 1) {
            System.out.println("jsyn.SynthPort: DISconnect( " + Integer.toHexString(synthPort.peerToken) + ", " + synthPort.name + ", " + n + " )");
        }
        if ((n2 = synthPort.sound.context.disconnectUnits(synthPort.peerToken, synthPort.portHash, n)) < 0) {
            throw new SynthException(n2, synthPort.name, synthPort.peerToken, n);
        }
    }
}

