/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthObject;
import com.softsynth.jsyn.SynthPort;
import java.util.Vector;

public class SynthSound
extends SynthObject {
    String name;
    Vector ports = new Vector();

    SynthSound() {
        this(Synth.getSharedContext());
    }

    SynthSound(SynthContext synthContext) {
        super(synthContext);
    }

    public void addPort(SynthPort synthPort, String string) {
        synthPort.setAlias(string);
        this.ports.addElement(synthPort);
    }

    public void addPort(SynthPort synthPort) {
        this.ports.addElement(synthPort);
    }

    public int getNumPorts() {
        return this.ports.size();
    }

    public SynthPort getPortAt(int n) {
        return (SynthPort)this.ports.elementAt(n);
    }

    public SynthPort findNamedPort(String string) {
        int n = this.getNumPorts();
        int n2 = 0;
        while (n2 < n) {
            SynthPort synthPort = this.getPortAt(n2);
            if (synthPort.getAlias().equals(string)) {
                return synthPort;
            }
            ++n2;
        }
        return null;
    }

    public void start(int n) throws SynthException {
        int n2;
        if (Synth.verbosity >= 1) {
            System.out.println("[" + Integer.toHexString(this.getPeer()) + "].start(" + n + ")");
        }
        if ((n2 = this.context.startUnitAt(n, this.getPeer())) < 0) {
            throw new SynthException(n2, this.peerToken);
        }
    }

    public void start() throws SynthException {
        int n;
        if (Synth.verbosity >= 1) {
            System.out.println("[" + Integer.toHexString(this.getPeer()) + "].start()" + " at " + this.context.getTickCount());
        }
        if ((n = this.context.startUnit(this.getPeer())) < 0) {
            throw new SynthException(n, this.peerToken);
        }
    }

    public void stop(int n) throws SynthException {
        int n2;
        if (Synth.verbosity >= 1) {
            System.out.println("[" + Integer.toHexString(this.getPeer()) + "].stop(" + n + ")");
        }
        if ((n2 = this.context.stopUnitAt(n, this.getPeer())) < 0) {
            throw new SynthException(n2, this.peerToken);
        }
    }

    public void stop() throws SynthException {
        int n;
        if (Synth.verbosity >= 1) {
            System.out.println("[" + Integer.toHexString(this.getPeer()) + "].stop()" + " at " + this.context.getTickCount());
        }
        if ((n = this.context.stopUnit(this.getPeer())) < 0) {
            throw new SynthException(n, this.peerToken);
        }
    }

    public void setPriority(int n) throws SynthException {
        int n2 = this.context.setPriority(this.getPeer(), n);
        if (n2 < 0) {
            throw new SynthException(n2, this.peerToken, n);
        }
    }

    public int getPriority() throws SynthException {
        int n = this.context.getPriority(this.getPeer());
        if (n < 0) {
            this.nativeError = n;
            throw new SynthException(this.nativeError, this.peerToken);
        }
        return n;
    }

    public void setStage(int n, int n2) throws SynthException {
    }

    public void setStage(int n) throws SynthException {
        this.setStage(this.context.getTickCount(), n);
    }

    public String getName() {
        return this.name;
    }
}

