/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.circuits;

import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.Filter_StateVariable;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.SawtoothOscillator;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;

public class PingSound
extends SynthCircuit {
    public SawtoothOscillator myOsc = new SawtoothOscillator();
    public Filter_StateVariable myFilter;
    public EnvelopePlayer myEnv;
    public MultiplyUnit freqScalar;
    public SynthEnvelope myEnvData;
    int numFrames;
    public SynthInput frequency;
    public SynthInput cutoff;
    public SynthInput resonance;
    public SynthInput amplitude;
    public SynthInput rate;

    public PingSound() throws SynthException {
        this.add(this.myOsc);
        this.myFilter = new Filter_StateVariable();
        this.add(this.myFilter);
        this.myEnv = new EnvelopePlayer();
        this.add(this.myEnv);
        this.freqScalar = new MultiplyUnit();
        this.add(this.freqScalar);
        double[] dArray = new double[]{0.01, 0.8, 0.1, 0.3, 0.14, 0.0};
        this.numFrames = dArray.length / 2;
        this.myEnvData = new SynthEnvelope(dArray);
        this.myEnv.output.connect(this.myFilter.amplitude);
        this.myEnv.output.connect(this.freqScalar.inputA);
        this.freqScalar.output.connect(this.myFilter.frequency);
        this.myOsc.output.connect(this.myFilter.input);
        this.frequency = this.myOsc.frequency;
        this.addPort(this.frequency);
        this.amplitude = this.myOsc.amplitude;
        this.addPort(this.amplitude);
        this.cutoff = this.freqScalar.inputB;
        this.addPort(this.cutoff, "Cutoff");
        this.resonance = this.myFilter.resonance;
        this.addPort(this.resonance);
        this.rate = this.myEnv.rate;
        this.addPort(this.rate);
        this.output = this.myFilter.output;
        this.addPort(this.output);
        this.frequency.setup(1.0, 100.0, 4000.0);
        this.cutoff.setup(30.0, 1000.0, 4000.0);
        this.resonance.setup(0.001, 0.4, 1.0);
        this.amplitude.setup(0.0, 0.2, 1.0);
        this.rate.setup(0.0, 1.0, 20.0);
    }

    public void trigger(int n, double d, double d2) throws SynthException {
        this.frequency.set(n, d);
        this.amplitude.set(n, d2);
        this.setStage(n, 0);
    }

    public void trigger() throws SynthException {
        this.trigger(this.getSynthContext().getTickCount(), 400.0, 0.5);
    }

    public void setStage(int n, int n2) throws SynthException {
        switch (n2) {
            case 0: {
                this.stop(n);
                this.myEnv.envelopePort.clear(n);
                this.myEnv.envelopePort.queue(n, this.myEnvData, 0, this.numFrames, 16);
                this.start(n);
                break;
            }
        }
    }
}

