/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.circuits;

import com.softsynth.jsyn.BusReader;
import com.softsynth.jsyn.BusWriter;
import com.softsynth.jsyn.ExponentialLag;
import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.SynthDistributor;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.TriangleOscillator;

public class Swarm
extends SynthNote {
    static final int NUM_ELEMENTS = 10;
    ExponentialLag[] lags = new ExponentialLag[10];
    TriangleOscillator[] oscillators = new TriangleOscillator[10];
    BusWriter[] mixers = new BusWriter[10];
    BusReader reader = new BusReader();
    MultiplyUnit myScalar;
    MultiplyAddUnit myOffsetter;
    MultiplyUnit amplPlug;

    public Swarm() throws SynthException {
        this.add(this.reader);
        this.amplPlug = new MultiplyUnit();
        this.add(this.amplPlug);
        this.frequency = new SynthDistributor(this, "frequency");
        int n = 0;
        while (n < 10) {
            this.oscillators[n] = new TriangleOscillator();
            this.add(this.oscillators[n]);
            this.lags[n] = new ExponentialLag();
            this.add(this.lags[n]);
            this.mixers[n] = new BusWriter();
            this.add(this.mixers[n]);
            this.lags[n].halfLife.set(0.1 + 0.02 * (double)n);
            this.frequency.connect(this.lags[n].input);
            this.amplPlug.output.connect(this.oscillators[n].amplitude);
            this.lags[n].output.connect(this.oscillators[n].frequency);
            this.oscillators[n].output.connect(this.mixers[n].input);
            this.mixers[n].busOutput.connect(this.reader.busInput);
            ++n;
        }
        this.amplitude = this.amplPlug.inputA;
        this.addPort(this.amplitude, "amplitude");
        this.output = this.reader.output;
        this.addPort(this.output);
        this.amplPlug.inputB.set(0.1);
        this.amplitude.setup(0.0, 0.3, 0.999);
        this.frequency.setup(0.0, 800.0, 3000.0);
    }

    public void setStage(int n, int n2) throws SynthException {
        switch (n2) {
            case 0: {
                this.stop(n);
                this.start(n);
            }
        }
    }
}

