/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view;

import com.softsynth.jsyn.view.WaveTrace;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;

public class WaveDisplay
extends Canvas {
    Vector traces = new Vector();
    int leftIndex = 0;
    int rightIndex = 512;
    int maxIndex;

    void calcMaxIndex() {
        this.maxIndex = 0;
        int n = 0;
        while (n < this.traces.size()) {
            WaveTrace waveTrace = (WaveTrace)this.traces.elementAt(n);
            short[] sArray = waveTrace.data;
            if (sArray.length - 1 > this.maxIndex) {
                this.maxIndex = sArray.length - 1;
            }
            ++n;
        }
    }

    public void setLeftIndex(int n) {
        this.leftIndex = n < 0 ? 0 : n;
    }

    public void setRightIndex(int n) {
        this.rightIndex = n > this.maxIndex ? this.maxIndex : n;
    }

    public void panLeft() {
        int n = (this.rightIndex - this.leftIndex) / 2;
        if (this.leftIndex - n < 0) {
            n = this.leftIndex;
        }
        this.leftIndex -= n;
        this.rightIndex -= n;
    }

    public void panRight() {
        int n = (this.rightIndex - this.leftIndex) / 2;
        if (this.rightIndex + n > this.maxIndex) {
            n = this.maxIndex - this.rightIndex;
        }
        this.leftIndex += n;
        this.rightIndex += n;
    }

    public void zoomIn() {
        int n = (this.rightIndex - this.leftIndex) / 4;
        this.leftIndex += n;
        this.rightIndex -= n;
    }

    void clipIndices() {
        if (this.leftIndex < 0) {
            this.leftIndex = 0;
        }
        if (this.rightIndex > this.maxIndex) {
            this.rightIndex = this.maxIndex;
        }
    }

    public void zoomOut() {
        int n = (this.rightIndex - this.leftIndex) / 2;
        this.leftIndex -= n;
        this.rightIndex += n;
        this.clipIndices();
    }

    public void addTrace(WaveTrace waveTrace) {
        this.traces.addElement(waveTrace);
        this.calcMaxIndex();
    }

    public void removeTrace(WaveTrace waveTrace) {
        this.traces.removeElement(waveTrace);
        this.calcMaxIndex();
    }

    private int shortToY(short s, int n, double d) {
        return n * (32768 - (int)(d * (double)s)) >> 16;
    }

    public void paint(Graphics graphics) {
        int n = this.size().width;
        int n2 = this.size().height;
        graphics.setColor(Color.white);
        graphics.drawLine(0, n2 / 2, n, n2 / 2);
        int n3 = 0;
        while (n3 < this.traces.size()) {
            WaveTrace waveTrace = (WaveTrace)this.traces.elementAt(n3);
            double d = waveTrace.scaleFactor;
            graphics.setColor(waveTrace.color);
            short[] sArray = waveTrace.data;
            if (sArray.length - 1 > this.leftIndex) {
                int n4 = 0;
                int n5 = this.shortToY(sArray[this.leftIndex], n2, d);
                int n6 = sArray.length - 1 < this.rightIndex ? sArray.length - 1 : this.rightIndex;
                int n7 = this.leftIndex + 1;
                while (n7 <= n6) {
                    int n8 = (n7 - this.leftIndex) * n / (n6 - this.leftIndex);
                    int n9 = this.shortToY(sArray[n7], n2, d);
                    graphics.drawLine(n4, n5, n8, n9);
                    n4 = n8;
                    n5 = n9;
                    ++n7;
                }
            }
            ++n3;
        }
        graphics.setColor(Color.white);
        graphics.drawString(Integer.toString(this.leftIndex), 5, n2 - 20);
        graphics.drawString(Integer.toString(this.rightIndex), n - 40, n2 - 20);
    }
}

