/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view102;

import com.softsynth.jsyn.view102.WaveTrace;
import java.awt.Canvas;
import java.awt.Graphics;
import java.util.Vector;

public class WaveDisplay
extends Canvas {
    Vector traces = new Vector();
    int leftIndex = 0;
    int rightIndex = 512;
    int maxIndex;

    void calcMaxIndex() {
        this.maxIndex = 0;
        int n = 0;
        while (n < this.traces.size()) {
            WaveTrace waveTrace = (WaveTrace)this.traces.elementAt(n);
            short[] sArray = waveTrace.data;
            if (sArray.length - 1 > this.maxIndex) {
                this.maxIndex = sArray.length - 1;
            }
            ++n;
        }
        this.clipIndices();
    }

    public void setLeftIndex(int n) {
        this.leftIndex = n < 0 ? 0 : n;
        this.repaint();
    }

    public int getLeftIndex() {
        return this.leftIndex;
    }

    public void setRightIndex(int n) {
        this.rightIndex = n > this.maxIndex ? this.maxIndex : n;
        this.repaint();
    }

    public int getRightIndex() {
        return this.leftIndex;
    }

    public void panLeft(int n) {
        if (this.leftIndex - n < 0) {
            n = this.leftIndex;
        }
        this.leftIndex -= n;
        this.rightIndex -= n;
        this.repaint();
    }

    public void panLeft() {
        int n = (this.rightIndex - this.leftIndex) / 2;
        this.panLeft(n);
    }

    public void panRight(int n) {
        if (this.rightIndex + n > this.maxIndex) {
            n = this.maxIndex - this.rightIndex;
        }
        this.leftIndex += n;
        this.rightIndex += n;
        this.repaint();
    }

    public void panRight() {
        int n = (this.rightIndex - this.leftIndex) / 2;
        this.panRight(n);
    }

    public void zoomIn() {
        int n = (this.rightIndex - this.leftIndex) / 4;
        this.leftIndex += n;
        this.rightIndex -= n;
        this.repaint();
    }

    void clipIndices() {
        if (this.rightIndex > this.maxIndex) {
            this.rightIndex = this.maxIndex;
        }
        if (this.leftIndex > this.rightIndex) {
            this.leftIndex = this.rightIndex - 1;
        }
        if (this.leftIndex < 0) {
            this.leftIndex = 0;
        }
    }

    public void zoomOut() {
        int n = (this.rightIndex - this.leftIndex) / 2;
        if (n < 1) {
            n = 1;
        }
        this.leftIndex -= n;
        this.rightIndex += n;
        this.clipIndices();
        this.repaint();
    }

    public synchronized void addTrace(WaveTrace waveTrace) {
        if (this.traces.size() == 0) {
            this.leftIndex = 0;
            this.rightIndex = 512;
        }
        this.traces.addElement(waveTrace);
        this.calcMaxIndex();
    }

    public synchronized void removeTrace(WaveTrace waveTrace) {
        this.traces.removeElement(waveTrace);
        this.calcMaxIndex();
    }

    private int shortToY(short s, int n, double d) {
        return n * (32768 - (int)(d * (double)s)) >> 16;
    }

    public void paint(Graphics graphics) {
        int n = this.size().width;
        int n2 = this.size().height;
        graphics.setColor(this.getForeground());
        graphics.drawLine(0, n2 / 2, n, n2 / 2);
        graphics.drawRect(0, 0, n - 1, n2 - 1);
        int n3 = 0;
        while (n3 < this.traces.size()) {
            WaveTrace waveTrace = (WaveTrace)this.traces.elementAt(n3);
            double d = waveTrace.scaleFactor;
            graphics.setColor(waveTrace.color);
            short[] sArray = waveTrace.data;
            if (sArray.length - 1 > this.leftIndex) {
                int n4 = 0;
                int n5 = this.shortToY(sArray[this.leftIndex], n2, d);
                int n6 = sArray.length - 1 < this.rightIndex ? sArray.length - 1 : this.rightIndex;
                int n7 = this.leftIndex + 1;
                while (n7 <= n6) {
                    int n8 = (n7 - this.leftIndex) * n / (n6 - this.leftIndex);
                    int n9 = this.shortToY(sArray[n7], n2, d);
                    graphics.drawLine(n4, n5, n8, n9);
                    n4 = n8;
                    n5 = n9;
                    ++n7;
                }
            }
            ++n3;
        }
        graphics.setColor(this.getForeground());
        graphics.drawString(Integer.toString(this.leftIndex), 5, n2 - 20);
        graphics.drawString(Integer.toString(this.rightIndex), n - 40, n2 - 20);
    }
}

