/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.view;

import com.softsynth.view.CustomFader;
import com.softsynth.view.ValueController;
import com.softsynth.view.ValueEvent;
import com.softsynth.view.ValueListener;
import java.util.Enumeration;
import java.util.Vector;

public class CustomFaderDouble
extends CustomFader
implements ValueController {
    public static final int LINEAR = 0;
    public static final int EXPONENTIAL = 1;
    int taper = 0;
    double logMax;
    double logMin;
    double min;
    double max;
    protected static final int RANGE = 2000;
    Vector valueListeners = new Vector();
    ValueEvent event = new ValueEvent(this);

    public CustomFaderDouble(int n, double d, double d2, double d3) {
        super(n, 0, 100, 0, 2000);
        this.setMinimum(d2);
        this.setMaximum(d3);
        this.setValue(d);
        this.setUnitIncrement(20);
    }

    void tellListeners() {
        super.tellListeners();
        if (this.valueListeners == null) {
            return;
        }
        Enumeration enumeration = this.valueListeners.elements();
        this.event.setValue(this.getDoubleValue());
        while (enumeration.hasMoreElements()) {
            ValueListener valueListener = (ValueListener)enumeration.nextElement();
            valueListener.valueChanged(this.event);
        }
    }

    public void addValueListener(ValueListener valueListener) {
        this.valueListeners.addElement(valueListener);
    }

    public void removeValueListener(ValueListener valueListener) {
        this.valueListeners.removeElement(valueListener);
    }

    public void setTaper(int n) {
        double d = this.faderToDouble(this.value);
        this.taper = n;
        this.setMinimum(this.min);
        this.setMaximum(this.max);
        this.setValue(d);
    }

    public int getTaper() {
        return this.taper;
    }

    public double faderToDouble(int n) {
        double d = 0.0;
        double d2 = (double)n / 2000.0;
        switch (this.taper) {
            case 0: {
                d = d2 * (this.max - this.min) + this.min;
                break;
            }
            case 1: {
                double d3 = d2 * (this.logMax - this.logMin);
                d = this.min * Math.exp(d3);
            }
        }
        return d;
    }

    public int doubleToFader(double d) {
        double d2 = 0.0;
        switch (this.taper) {
            case 0: {
                d2 = (d - this.min) / (this.max - this.min);
                break;
            }
            case 1: {
                d2 = (Math.log(d) - this.logMin) / (this.logMax - this.logMin);
            }
        }
        int n = (int)(d2 * 2000.0);
        return n;
    }

    public double getMinimum() {
        return this.min;
    }

    public double getMaximum() {
        return this.max;
    }

    public void setMinimum(double d) {
        if (this.taper == 1 && d < 1.0E-7) {
            d = 1.0E-7;
        }
        this.min = d;
        this.logMin = Math.log(d);
    }

    public void setMaximum(double d) {
        this.max = d;
        this.logMax = Math.log(d);
    }

    public void setValue(double d) {
        int n = this.doubleToFader(d);
        super.setValue(n);
    }

    public double getDoubleValue() {
        return this.faderToDouble(this.getValue());
    }
}

