/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import sun.audio.AudioPlayer;

public class BSonic
extends InputStream
implements Runnable {
    private static boolean DEBUG = false;
    public static final int SAMPLE_MAX = 127;
    public static final int SAMPLE_MIN = -127;
    public static final int SAMPLE_AMPLITUDE = 255;
    public static final int SAMPLING_RATE = 8000;
    public static final int DEFAULT_BUFFER_SIZE = 6000;
    public static final int MAX_SOUNDS = 24;
    public static float volume = 1.0f;
    private static final short BIAS = 132;
    private static final int CLIP = 32635;
    private static final int[] law_lut = new int[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final int[] linear_lut = new int[]{0, 132, 396, 924, 1980, 4092, 8316, 16764};
    public boolean started = false;
    public boolean run = false;
    private BSonic stream;
    private BApplet owner;
    Thread soundThread;
    public BSound[] sounds;
    public int scount = 0;
    public int[] samples;
    public int length;
    public byte[] buf;
    public int pos;
    public int mark = 0;
    public int count;
    public int delay;
    public int posc;
    public int block;
    public boolean full = false;
    public final int AU_FILE;
    public final int WAV_FILE;
    public final int MP3_FILE;
    public int format = 0;

    public void start(BApplet bApplet) {
        this.owner = bApplet;
        if (this.started) {
            return;
        }
        int n = 0;
        while (n < this.count) {
            this.buf[n] = -1;
            ++n;
        }
        if (this.soundThread == null) {
            this.soundThread = new Thread((Runnable)this, "BSonic Thread");
            this.run = true;
        }
        if (DEBUG) {
            System.out.println("starting audio player");
        }
        AudioPlayer.player.start((InputStream)this);
        if (DEBUG) {
            System.out.println("audio player started");
        }
        this.soundThread.start();
        this.started = true;
    }

    public void stop() {
        if (DEBUG) {
            System.out.println("stoping audio player");
        }
        AudioPlayer.player.stop();
        try {
            if (DEBUG) {
                System.out.println("waiting to stop...");
            }
            AudioPlayer.player.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (DEBUG) {
            System.out.println("audio player stopped");
        }
    }

    public void run() {
        while (this.run) {
            this.mixing();
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                if (!DEBUG) continue;
                System.out.println("sleep interrupted");
            }
        }
    }

    public synchronized void mixing() {
        if (this.full) {
            ++this.delay;
            if (DEBUG) {
                System.out.println("\n+delay: " + this.delay);
            }
            return;
        }
        int n = 0;
        while (n < this.scount) {
            int n2 = 0;
            while (n2 < this.length) {
                if (n == 0) {
                    this.samples[n2] = 0;
                }
                if (this.sounds[n].play) {
                    int n3 = n2;
                    this.samples[n3] = this.samples[n3] + this.sounds[n].readSample();
                }
                ++n2;
            }
            ++n;
        }
        if (DEBUG) {
            System.out.print(" P:" + this.posc + "");
        }
        this.owner.soundEvent();
        this.clip();
        n = 0;
        while (n < this.length) {
            if (this.posc > this.block) {
                if (DEBUG) {
                    System.out.print("-" + this.block);
                }
                this.posc = 0;
                this.full = true;
                return;
            }
            if (this.posc < this.count) {
                this.buf[this.posc] = volume == 1.0f ? BSonic.linear2ulaw(this.samples[n] << 8) : (byte)((float)BSonic.linear2ulaw(this.samples[n] << 8) * volume);
            }
            ++this.posc;
            ++n;
        }
        if (DEBUG) {
            System.out.print("-" + this.posc + "");
        }
    }

    public void clip() {
        int n = 0;
        while (n < this.length) {
            if (this.samples[n] > 127) {
                this.samples[n] = 127;
            }
            if (this.samples[n] < -127) {
                this.samples[n] = -127;
            }
            ++n;
        }
    }

    public void add(BSound bSound) {
        if (this.scount < 23) {
            if (DEBUG) {
                System.out.println("Sound Added: " + this.scount);
            }
            this.sounds[this.scount] = bSound;
            ++this.scount;
        }
    }

    public static void volume(float f) {
        volume = f;
    }

    public static void balance(float f) {
    }

    public static void frequency(float f) {
    }

    public synchronized int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        if (DEBUG) {
            System.out.println("\n========================");
        }
        if (DEBUG) {
            System.out.println("PRE len: " + n2 + " count: " + this.count + " pos: " + this.pos + " b.length " + byArray.length + " block " + this.block);
        }
        int n3 = this.block = this.block > n2 ? this.block : n2;
        if (!this.full) {
            this.delay -= 10;
            if (this.delay < 0) {
                this.delay = 10;
            }
            if (DEBUG) {
                System.out.println("\n-delay: " + this.delay);
            }
        }
        if (n2 > this.count) {
            return 0;
        }
        System.arraycopy(this.buf, 0, byArray, n, n2);
        if (DEBUG) {
            System.out.println("POS len: " + n2 + " count: " + this.count + " pos: " + this.pos + " b.length " + byArray.length + " block " + this.block);
        }
        if (DEBUG) {
            System.out.println("\n========================");
        }
        this.posc = 0;
        this.full = false;
        return n2;
    }

    public synchronized long skip(long l) {
        if ((long)this.pos + l > (long)this.count) {
            l = this.count - this.pos;
        }
        if (l < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l);
        return l;
    }

    public synchronized int available() {
        return this.count - this.pos;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) {
    }

    public synchronized void reset() {
        this.pos = 0;
    }

    public BSound loadSound(String string) {
        BSound bSound = null;
        DataInputStream dataInputStream = null;
        InputStream inputStream = null;
        int[] nArray = null;
        if (string.startsWith("http://")) {
            try {
                URL uRL = new URL(string);
                dataInputStream = new DataInputStream(uRL.openStream());
            }
            catch (IOException iOException) {
                System.err.println("error loading sound from " + string);
                iOException.printStackTrace();
                return null;
            }
        } else {
            inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                inputStream = this.getClass().getResourceAsStream("data/" + string);
            }
            if (inputStream != null) {
                dataInputStream = new DataInputStream(inputStream);
            }
        }
        if (dataInputStream == null) {
            System.err.println("could not load sound file " + string);
            return null;
        }
        if (string.toLowerCase().endsWith(".au")) {
            this.format = 1;
            nArray = this.loadAU(dataInputStream);
        }
        if (string.toLowerCase().endsWith(".wav")) {
            this.format = 2;
            nArray = this.loadWAV(dataInputStream);
        }
        if (string.toLowerCase().endsWith(".mp3")) {
            this.format = 3;
            nArray = this.loadMP3(dataInputStream);
        }
        if (this.format == 0) {
            System.err.println("could not load sound file " + string + " - format unkown");
            return null;
        }
        if (nArray == null) {
            System.err.println("could not load sound file " + string + " - error in file");
            return null;
        }
        bSound = new BSound(nArray);
        this.add(bSound);
        return bSound;
    }

    public int[] loadAU(DataInputStream dataInputStream) {
        int n = 779316836;
        int n2 = 779314176;
        int n3 = 24;
        int n4 = 1;
        int n5 = 2;
        int n6 = 3;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int[] nArray = null;
        int n13 = 0;
        boolean bl = false;
        try {
            n7 = dataInputStream.readInt();
            if (n7 != n && n7 != n2) {
                throw new Exception();
            }
            n8 = dataInputStream.readInt();
            if (n8 < n3) {
                throw new Exception();
            }
            n9 = dataInputStream.readInt();
            n10 = dataInputStream.readInt();
            if (n10 != n4 && n10 != n5 && n10 != n6) {
                throw new Exception();
            }
            n11 = dataInputStream.readInt();
            if (n11 != 8000) {
                bl = true;
            }
            if ((n12 = dataInputStream.readInt()) != 1 && n12 != 2) {
                throw new Exception();
            }
            dataInputStream.skipBytes(n8 - n3);
        }
        catch (Exception exception) {
            return null;
        }
        if (DEBUG) {
            System.out.println("skip " + (n8 - n3) + " magic: " + n7 + " dataLocation: " + n8 + " dataSize: " + n9 + " dataFormat: " + n10 + " samplingRate: " + n11 + " channelCount: " + n12);
        }
        n13 = n9 / n12;
        if (n10 == n6) {
            n13 /= 2;
        }
        nArray = new int[n13];
        if (DEBUG) {
            System.out.println("new thesamples " + nArray.length);
        }
        int n14 = 0;
        while (n14 < n13) {
            try {
                if (n10 == n4) {
                    nArray[n14] = BSonic.ulaw2linear(dataInputStream.read()) >> 8;
                    if (n12 == 2) {
                        dataInputStream.read();
                    }
                } else if (n10 == n5) {
                    nArray[n14] = dataInputStream.readByte();
                    if (n12 == 2) {
                        dataInputStream.readByte();
                    }
                } else if (n10 == n6) {
                    nArray[n14] = dataInputStream.readShort() >> 8;
                    if (n7 == n2) {
                        nArray[n14] = BSonic.reverseShort(nArray[n14]);
                    }
                    if (n12 == 2) {
                        dataInputStream.readShort();
                    }
                }
            }
            catch (Exception exception) {
                return null;
            }
            ++n14;
        }
        if (bl) {
            return BSonic.resample(nArray, n11, 8000);
        }
        return nArray;
    }

    public int[] loadWAV(DataInputStream dataInputStream) {
        int n = 1380533830;
        int n2 = 1463899717;
        int n3 = 1718449184;
        int n4 = 1684108385;
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int[] nArray = null;
        int n12 = 0;
        boolean bl = true;
        boolean bl2 = false;
        try {
            n6 = dataInputStream.readInt();
            if (n6 != n) {
                throw new Exception();
            }
            dataInputStream.readInt();
            n6 = dataInputStream.readInt();
            if (n6 != n2) {
                throw new Exception();
            }
            n6 = dataInputStream.readInt();
            if (n6 != n3) {
                throw new Exception();
            }
            dataInputStream.readInt();
            n7 = BSonic.reverseShort(dataInputStream.readUnsignedShort());
            if (n7 != n5) {
                throw new Exception();
            }
            n8 = BSonic.reverseShort(dataInputStream.readUnsignedShort());
            if (n8 != 1 && n8 != 2) {
                throw new Exception();
            }
            n9 = BSonic.reverseInt(dataInputStream.readInt());
            if (n9 != 8000) {
                bl2 = true;
            }
            dataInputStream.readInt();
            dataInputStream.readUnsignedShort();
            n10 = BSonic.reverseShort(dataInputStream.readUnsignedShort());
            if (n10 != 8 && n10 != 16) {
                throw new Exception();
            }
            n6 = dataInputStream.readInt();
            if (n6 != n4) {
                throw new Exception();
            }
            n11 = BSonic.reverseInt(dataInputStream.readInt());
        }
        catch (Exception exception) {
            return null;
        }
        if (DEBUG) {
            System.out.println(" magic: " + n6 + " dataFormat: " + n7 + " dataSize: " + n11 + " samplingRate: " + n9 + " channelCount: " + n8 + " bitDepth: " + n10);
        }
        n12 = n11 / n8;
        if (n10 == 16) {
            n12 /= 2;
        }
        nArray = new int[n12];
        if (DEBUG) {
            System.out.println("new thesamples " + nArray.length);
        }
        int n13 = 0;
        while (n13 < n12) {
            try {
                if (n7 == n5) {
                    if (n10 == 8) {
                        nArray[n13] = dataInputStream.readUnsignedByte() - 128;
                        if (n8 == 2) {
                            dataInputStream.readUnsignedByte();
                        }
                    } else if (n10 == 16) {
                        nArray[n13] = BSonic.reverseInt(dataInputStream.readUnsignedShort()) >> 24;
                        if (n8 == 2) {
                            dataInputStream.readUnsignedShort();
                        }
                    }
                }
            }
            catch (Exception exception) {
                return null;
            }
            ++n13;
        }
        if (bl2) {
            return BSonic.resample(nArray, n9, 8000);
        }
        return nArray;
    }

    public int[] loadMP3(DataInputStream dataInputStream) {
        int[] nArray = null;
        boolean bl = false;
        return nArray;
    }

    public static byte linear2ulaw(int n) {
        int n2;
        int n3;
        byte by;
        if (n > Short.MAX_VALUE) {
            n = Short.MAX_VALUE;
        } else if (n < Short.MIN_VALUE) {
            n = Short.MIN_VALUE;
        }
        int n4 = n >> 8 & 0x80;
        if (n4 != 0) {
            n = -n;
        }
        if (n > 32635) {
            n = 32635;
        }
        if ((by = (byte)(~(n4 | (n3 = law_lut[(n += 132) >> 7 & 0xFF]) << 4 | (n2 = n >> n3 + 3 & 0xF)))) == 0) {
            by = 2;
        }
        return (byte)by;
    }

    public static int ulaw2linear(int n) {
        int n2 = (n ^= 0xFFFFFFFF) & 0x80;
        int n3 = n >> 4 & 7;
        int n4 = n & 0xF;
        int n5 = linear_lut[n3] + (n4 << n3 + 3);
        if (n2 != 0) {
            n5 = -n5;
        }
        return (short)n5;
    }

    private static int reverseShort(int n) {
        return n >>> 8 & 0xFF | n << 8 & 0xFF00;
    }

    private static int reverseInt(int n) {
        return n >> 24 & 0xFF | n >> 8 & 0xFF00 | n << 8 & 0xFF0000 | n << 24 & 0xFF000000;
    }

    private static int[] resample(int[] nArray, int n, int n2) {
        int[] nArray2 = null;
        float f = 0.0f;
        if (n > n2) {
            f = (float)n / (float)n2;
            int n3 = (int)((float)nArray.length / f);
            nArray2 = new int[n3];
            int n4 = 0;
            while (n4 < n3) {
                nArray2[n4] = nArray[(int)((float)n4 * f)];
                ++n4;
            }
            nArray = null;
            return nArray2;
        }
        if (n > n2) {
            f = (float)n2 / (float)n;
            int n5 = (int)((float)nArray.length * f);
            nArray2 = new int[n5];
            int n6 = 0;
            while (n6 < n5) {
                nArray2[n6] = nArray[(int)((float)n6 * f)];
                ++n6;
            }
            return nArray2;
        }
        System.out.println("Done...");
        return nArray;
    }

    public BSonic(int[] nArray) {
        this.AU_FILE = 1;
        this.WAV_FILE = 2;
        this.MP3_FILE = 3;
        if (DEBUG) {
            System.out.println("sonic constructor");
        }
        this.samples = nArray;
        this.length = this.samples.length;
        this.delay = this.length * 1000 / 16000;
        this.posc = 0;
        this.block = this.length;
        this.buf = new byte[6000];
        this.pos = 0;
        this.count = this.buf.length;
        this.sounds = new BSound[24];
        if (DEBUG) {
            System.out.println("length: " + this.length + " delay: " + this.delay);
        }
    }
}

