/*
 * Decompiled with CFR 0.152.
 */
public class articulate
extends BApplet {
    int numCells;
    StemCell[] stemcells;
    BImage instructions;
    float max_distance;
    int count;
    int mode;
    boolean accumulate;
    boolean clearBuffer;
    int red;
    int green;
    int blue;

    void setup() {
        this.size(600, 600);
        this.noBackground();
        this.ellipseMode(3);
        int n = 0;
        while (n < this.numCells) {
            float f = this.random((float)Math.PI * 2);
            float f2 = this.cos(f) * (float)this.width / 5.0f;
            float f3 = this.sin(f) * (float)this.width / 5.0f;
            this.stemcells[n] = new StemCell((float)(this.width / 2) + f2, (float)(this.height / 2) + f3, 10 + n / 15, n, this.stemcells);
            ++n;
        }
        this.max_distance = this.sqrt(this.sq(this.width) + this.sq(this.height));
        this.accumulate = true;
        this.count = 0;
        this.mode = 0;
    }

    void loop() {
        ++this.count;
        int n = 0;
        while (n < this.numCells) {
            this.stemcells[n].check();
            this.stemcells[n].display();
            ++n;
        }
        if (this.count > 1800) {
            this.clearBuffer = true;
            this.beginAgain();
            this.count = 0;
        }
        if (this.clearBuffer) {
            this.clearMe();
            this.count = 0;
        }
    }

    void keyPressed() {
        if (this.key == 32) {
            this.clearBuffer = true;
            this.accumulate ^= true;
        }
        this.count = 0;
    }

    void beginAgain() {
        ++this.mode;
        if (this.mode == 0) {
            int n = 0;
            while (n < this.numCells) {
                float f = this.random((float)Math.PI * 2);
                float f2 = this.cos(f) * (float)this.width / 5.0f;
                float f3 = this.sin(f) * (float)this.width / 5.0f;
                this.stemcells[n].newx = this.stemcells[n].x = (float)(this.width / 2) + f2;
                this.stemcells[n].newy = this.stemcells[n].y = (float)(this.height / 2) + f3;
                ++n;
            }
            return;
        }
        if (this.mode == 1) {
            int n = 0;
            while (n < this.numCells) {
                this.stemcells[n].newx = this.stemcells[n].x = (float)(this.width / 2);
                this.stemcells[n].newy = this.stemcells[n].y = 75.0f + this.random(this.height - 150);
                ++n;
            }
            return;
        }
        if (this.mode == 2) {
            int n = 0;
            while (n < this.numCells) {
                this.stemcells[n].newx = this.stemcells[n].x = this.random(0.0f, this.width);
                int n2 = n % 2 == 0 ? 0 : this.height;
                this.stemcells[n].newy = this.stemcells[n].y = (float)n2;
                ++n;
            }
            return;
        }
        if (this.mode == 3) {
            int n = 0;
            while (n < this.numCells) {
                this.stemcells[n].newx = this.stemcells[n].x = this.random(this.width);
                this.stemcells[n].newy = this.stemcells[n].y = this.random(this.height);
                ++n;
            }
            this.mode = -1;
        }
    }

    void mousePressed() {
        this.beginAgain();
        this.clearBuffer = true;
        this.count = 0;
    }

    void clearMe() {
        if (this.clearBuffer) {
            int n = 0;
            while (n < this.width * this.height) {
                this.pixels[n] = 0xFFFFFF;
                ++n;
            }
            this.clearBuffer = false;
        }
    }

    void crosscross(float f, float f2) {
        this.stroke(49.0f, 11.0f, 16.0f);
        this.beginShape(16);
        this.vertex(f - 1.0f, f2);
        this.vertex(f + 1.0f, f2);
        this.vertex(f, f2 - 1.0f);
        this.vertex(f, f2 + 1.0f);
        this.endShape();
    }

    float distance(float f, float f2, float f3, float f4) {
        return this.sqrt(this.sq(f - f3) + this.sq(f2 - f4));
    }

    void flat_circle(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = n3;
        int n7 = 1;
        int n8 = 2 * n3 - 1;
        int n9 = 0;
        while (n5 < n6) {
            this.thin_point(n + n5, n2 + n6, n4);
            this.thin_point(n + n6, n2 - n5, n4);
            this.thin_point(n - n5, n2 - n6, n4);
            this.thin_point(n - n6, n2 + n5, n4);
            ++n5;
            if (n8 < 2 * (n9 += (n7 += 2))) {
                --n6;
                n9 -= n8;
                n8 -= 2;
            }
            if (n5 > n6) {
                return;
            }
            this.thin_point(n + n6, n2 + n5, n4);
            this.thin_point(n + n5, n2 - n6, n4);
            this.thin_point(n - n6, n2 - n5, n4);
            this.thin_point(n - n5, n2 + n6, n4);
        }
    }

    void thin_point(int n, int n2, int n3) {
        int n4 = n2 * this.width + n;
        if (n4 < 0 || n4 > this.width * this.height - 1) {
            return;
        }
        this.pixels[n4] = n3;
    }

    void putPixel(int n, int n2) {
        this.fill(this.red, this.green, this.blue, 26.0f);
        this.rect(n, n2, 1.0f, 1.0f);
    }

    void drawLine(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        int n7 = 0;
        int n8 = n3 - n;
        int n9 = n4 - n2;
        int n10 = 1;
        int n11 = 1;
        if (n8 < 0) {
            n10 = -1;
            n8 = -n8;
        }
        if (n9 < 0) {
            n11 = -1;
            n9 = -n9;
        }
        if (n9 <= n8) {
            int n12 = 2 * n8;
            int n13 = 2 * n9;
            while (true) {
                this.putPixel(n5, n6);
                if (n5 != n3) {
                    n5 += n10;
                    if ((n7 += n13) <= n8) continue;
                    n6 += n11;
                    n7 -= n12;
                    continue;
                }
                break;
            }
        } else {
            int n14 = 2 * n9;
            int n15 = 2 * n8;
            while (true) {
                this.putPixel(n5, n6);
                if (n6 == n4) {
                    return;
                }
                n6 += n11;
                if ((n7 += n15) <= n9) continue;
                n5 += n10;
                n7 -= n14;
            }
        }
    }

    public articulate() {
        this.Block$();
    }

    private void Block$() {
        this.numCells = 200;
        this.stemcells = new StemCell[this.numCells];
    }

    class StemCell {
        float x;
        float y;
        float newx;
        float newy;
        float cellwidth;
        float cellheight;
        float r;
        float inc;
        int id;
        float angle;
        float moveangle;
        int over;
        boolean hasOverlap;
        int selCell;
        int off;
        int speed;
        int ds;
        StemCell[] others;

        StemCell(float f, float f2, float f3, int n, StemCell[] stemCellArray) {
            this.Block$();
            this.x = this.newx = f;
            this.y = this.newy = f2;
            this.r = f3;
            this.id = n;
            this.setRadius();
            this.setAngle();
            this.others = stemCellArray;
        }

        void setAngle() {
            this.moveangle = (float)Math.PI * 2 / (float)articulate.this.numCells * (float)this.id - (float)Math.PI;
        }

        void setRadius() {
            this.cellwidth = this.r * 2.0f;
            this.cellheight = this.r * 2.0f;
        }

        float getCenterX() {
            return this.newx;
        }

        float getCenterY() {
            return this.newy;
        }

        void move(float f, float f2) {
            this.newx += articulate.this.cos(f) * f2;
            this.newy += articulate.this.sin(f) * f2;
            this.hasOverlap = true;
        }

        void check() {
            float f;
            float f2;
            this.newx += articulate.this.cos(this.angle);
            this.newy += articulate.this.sin(this.angle);
            if (!(this.newx >= -this.r)) {
                this.newx = -this.r;
            }
            if (this.newx > (float)articulate.this.width + this.r) {
                this.newx = (float)articulate.this.width + this.r;
            }
            if (!(this.newy >= -this.r)) {
                this.newy = -this.r;
            }
            if (this.newy > (float)articulate.this.height + this.r) {
                this.newy = (float)articulate.this.height + this.r;
            }
            if (articulate.this.abs(f2 = this.newx - this.x) > 0.1f) {
                this.x += f2 / 4.0f;
            }
            if (articulate.this.abs(f = this.newy - this.y) > 0.1f) {
                this.y += f / 4.0f;
            }
            this.over = 0;
            int n = 0;
            while (n < articulate.this.numCells) {
                if (n != this.id) {
                    float f3 = this.others[n].getCenterX() - this.getCenterX();
                    float f4 = this.others[n].getCenterY() - this.getCenterY();
                    float f5 = this.others[n].cellwidth / 2.0f + this.cellwidth / 2.0f + 1.0f;
                    float f6 = f3 * f3 + f4 * f4;
                    float f7 = this.others[n].cellwidth / 2.0f + this.cellwidth / 2.0f;
                    if (!(f6 >= f7 * f7)) {
                        float f8 = articulate.this.atan2(f4, f3);
                        if (f8 == 0.0f) {
                            f8 = articulate.this.random(1.0f);
                        }
                        this.others[n].move(f8, this.inc);
                        this.move(f8 + (float)Math.PI, this.inc);
                        if (articulate.this.accumulate) {
                            float f9 = articulate.this.distance(this.x, this.y, this.others[n].x, this.others[n].y);
                            if (f9 > 35.0f) {
                                articulate.this.red = 255;
                                articulate.this.green = 102;
                                articulate.this.blue = 204;
                            } else if (f9 > 20.0f) {
                                articulate.this.red = 204;
                                articulate.this.green = 102;
                                articulate.this.blue = 0;
                            } else {
                                articulate.this.red = 10;
                                articulate.this.green = 91;
                                articulate.this.blue = 124;
                            }
                            articulate.this.noStroke();
                            articulate.this.drawLine((int)this.x, (int)this.y, (int)this.others[n].x, (int)this.others[n].y);
                        }
                        articulate.this.noStroke();
                    } else {
                        this.hasOverlap = false;
                    }
                    if (!(f6 >= f5 * f5)) {
                        ++this.over;
                    }
                }
                ++n;
            }
            if (this.over > 0) {
                this.angle += (float)this.over * ((29.0f - this.r) / 100.0f);
            }
        }

        void display() {
            articulate.this.noFill();
            if (!articulate.this.accumulate) {
                articulate.this.flat_circle((int)this.x, (int)this.y, (int)this.cellwidth / 2, articulate.this.color(255.0f, 255.0f, 255.0f));
                articulate.this.stroke(153);
                articulate.this.point(this.x, this.y);
                articulate.this.noStroke();
                articulate.this.fill(255.0f, 204.0f, 0.0f);
                articulate.this.crosscross(this.x + articulate.this.cos(this.angle) * (this.r - (float)(this.ds / 2)), this.y + articulate.this.sin(this.angle) * (this.r - (float)(this.ds / 2)));
            }
        }

        private void Block$() {
            this.inc = 1.0f;
            this.angle = 0.0f;
            this.moveangle = 0.0f;
            this.selCell = -1;
            this.ds = 6;
        }
    }
}

