/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;

public class Bagel
implements BagelConstants {
    static Applet applet;
    static final int MATRIX_STACK_DEPTH = 32;
    static final int CVERTEX_ALLOC = 128;
    static final int circleAccuracy = 30;
    static final int textureOrientation = 1;
    static final int sphereAccuracy = 30;
    int width;
    int height;
    int width1;
    int height1;
    int pixelCount;
    public int[] pixels;
    boolean depthTest;
    float[] zbuffer;
    int frameCount;
    int _colorMode;
    boolean colorScale;
    float colorMaxX;
    float colorMaxY;
    float colorMaxZ;
    float colorMaxA;
    boolean _fill;
    boolean fillAlpha;
    float fillR;
    float fillG;
    float fillB;
    float fillA;
    int fillRi;
    int fillGi;
    int fillBi;
    int fillAi;
    int filli;
    boolean _stroke;
    boolean strokeAlpha;
    float strokeR;
    float strokeG;
    float strokeB;
    float strokeA;
    int strokeRi;
    int strokeGi;
    int strokeBi;
    int strokeAi;
    int strokei;
    float _strokeWidth;
    boolean _background;
    float backR;
    float backG;
    float backB;
    int backRi;
    int backGi;
    int backBi;
    int backi;
    float calcR;
    float calcG;
    float calcB;
    float calcA;
    int calcRi;
    int calcGi;
    int calcBi;
    int calcAi;
    int calci;
    boolean calcAlpha;
    boolean lighting;
    BagelLight[] _lights;
    float projX;
    float projY;
    float projZ;
    float m00;
    float m01;
    float m02;
    float m03;
    float m10;
    float m11;
    float m12;
    float m13;
    float m20;
    float m21;
    float m22;
    float m23;
    float m30;
    float m31;
    float m32;
    float m33;
    float[][] matrixStack = new float[32][16];
    int matrixStackDepth;
    int projection;
    int dimensions;
    float fov;
    float eyeX;
    float eyeY;
    float eyeDist;
    float nearDist;
    float farDist;
    float aspect;
    float p00;
    float p01;
    float p02;
    float p03;
    float p10;
    float p11;
    float p12;
    float p13;
    float p20;
    float p21;
    float p22;
    float p23;
    float p30;
    float p31;
    float p32;
    float p33;
    boolean shape;
    int shapeKind;
    BagelPolygon polygon;
    BagelPolygon fpolygon;
    BagelPolygon spolygon;
    float[][] svertices;
    boolean texture;
    float textureU;
    float textureV;
    float normalX;
    float normalY;
    float normalZ;
    boolean unchangedZ;
    boolean strokeChanged;
    boolean fillChanged;
    boolean normalChanged;
    float[][] cvertex = new float[128][19];
    int cvertexIndex;
    float[] circleX;
    float[] circleY;
    int image_mode = 0;
    int rect_mode = 0;
    int ellipse_mode = 0;
    float[][] sphereX;
    float[] sphereY;
    float[][] sphereZ;
    BagelFont currentFont;
    boolean[] hints;

    public void beginFrame() {
        if (this._background) {
            this.clear();
        }
        this.identity_matrix();
        this.normalX = 0.0f;
        this.normalY = 0.0f;
        this.normalZ = 1.0f;
    }

    public void clear() {
        int n = 0;
        while (n < this.pixelCount) {
            this.pixels[n] = this.backi;
            this.zbuffer[n] = Float.MAX_VALUE;
            ++n;
        }
    }

    public void endFrame() {
        ++this.frameCount;
    }

    private void calc_color(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float[] fArray, int n) {
        if (!this.lighting) {
            fArray[n] = f;
            fArray[n + 1] = f2;
            fArray[n + 2] = f3;
            return;
        }
        float f10 = this.mag(f7, f8, f9);
        if (f10 != 0.0f) {
            f7 /= f10;
            f8 /= f10;
            f9 /= f10;
        }
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        int n2 = 1;
        while (n2 < 10) {
            float f14;
            if (this._lights[n2] == null) break;
            float f15 = this._lights[n2].x - f4;
            float f16 = this._lights[n2].y - f5;
            float f17 = this._lights[n2].z - f6;
            float f18 = this.mag(f15, f16, f17);
            if (f18 != 0.0f) {
                f15 /= f18;
                f16 /= f18;
                f17 /= f18;
            }
            if ((f14 = f7 * f15 + f8 * f16 + f9 * f17) > 0.0f) {
                f11 += this._lights[n2].r * f14;
                f12 += this._lights[n2].g * f14;
                f13 += this._lights[n2].b * f14;
            }
            ++n2;
        }
        fArray[n] = this._lights[0].r + f * f11;
        fArray[n + 1] = this._lights[0].g + f2 * f12;
        fArray[n + 2] = this._lights[0].b + f3 * f13;
        if (fArray[n] > 1.0f) {
            fArray[n] = 1.0f;
        }
        if (fArray[n + 1] > 1.0f) {
            fArray[n + 1] = 1.0f;
        }
        if (fArray[n + 2] > 1.0f) {
            fArray[n + 2] = 1.0f;
        }
    }

    public void beginShape() {
        this.beginShape(50);
    }

    public void beginShape(int n) {
        this.shape = true;
        this.shapeKind = n;
        this.cvertexIndex = 0;
        this.polygon.reset(0);
        this.fpolygon.reset(4);
        this.spolygon.reset(4);
        this.texture = false;
        this.polygon.interpUV = false;
        this.unchangedZ = true;
        this.strokeChanged = false;
        this.fillChanged = false;
        this.normalChanged = false;
    }

    public void textureImage(BagelImage bagelImage) {
        this.texture = true;
        this.polygon.texture(bagelImage);
    }

    public void vertexTexture(float f, float f2) {
        if (!this.texture) {
            this.message(2, "gotta use textureImage() after beginShape() and before vertexTexture()");
            return;
        }
        float f3 = this.textureU = f < (float)this.polygon.twidth ? f : (float)this.polygon.twidth;
        if (this.textureU < 0.0f) {
            this.textureU = 0.0f;
        }
        float f4 = this.textureV = f2 < (float)this.polygon.theight ? f2 : (float)this.polygon.theight;
        if (this.textureV < 0.0f) {
            this.textureV = 0.0f;
        }
    }

    public void vertexNormal(float f, float f2, float f3) {
        if (!this.normalChanged) {
            int n = 0;
            while (n < this.polygon.vertexCount) {
                this.polygon.vertices[n][16] = this.normalX;
                this.polygon.vertices[n][17] = this.normalY;
                this.polygon.vertices[n][18] = this.normalZ;
                ++n;
            }
            this.normalChanged = true;
        }
        this.normalChanged = true;
        this.normalX = f;
        this.normalY = f2;
        this.normalZ = f3;
    }

    public void vertex(float f, float f2) {
        this.setup_vertex(this.polygon.nextVertex(), f, f2, 0.0f);
    }

    public void vertex(float f, float f2, float f3) {
        this.unchangedZ = false;
        this.dimensions = 3;
        this.setup_vertex(this.polygon.nextVertex(), f, f2, f3);
    }

    private void setup_vertex(float[] fArray, float f, float f2, float f3) {
        fArray[9] = f;
        fArray[10] = f2;
        fArray[11] = f3;
        if (this._stroke) {
            fArray[12] = this.strokeR;
            fArray[13] = this.strokeG;
            fArray[14] = this.strokeB;
            fArray[15] = this.strokeA;
        }
        if (this._fill) {
            fArray[3] = this.fillR;
            fArray[4] = this.fillG;
            fArray[5] = this.fillB;
            fArray[6] = this.fillA;
        }
        if (this.texture) {
            fArray[7] = this.textureU;
            fArray[8] = this.textureV;
        }
        if (this.normalChanged) {
            fArray[16] = this.normalX;
            fArray[17] = this.normalY;
            fArray[18] = this.normalZ;
        }
    }

    public void bezierVertex(float f, float f2) {
        if (this.polygon.vertexCount == 0) {
            this.vertex(f, f2);
        } else {
            this.setup_vertex(this.cvertex[this.cvertexIndex++], f, f2, 0.0f);
            if (this.cvertexIndex == 3) {
                float[] fArray = this.polygon.vertices[this.polygon.vertexCount - 1];
                this.bezier_segment(fArray[9], fArray[10], this.cvertex[0][9], this.cvertex[0][10], this.cvertex[1][9], this.cvertex[1][10], this.cvertex[2][9], this.cvertex[2][10]);
                this.cvertexIndex = 0;
            }
        }
    }

    public void curveVertex(float f, float f2) {
        if (this.cvertexIndex == 128) {
            System.arraycopy(this.cvertex[125], 0, this.cvertex[0], 0, 19);
            System.arraycopy(this.cvertex[126], 0, this.cvertex[1], 0, 19);
            System.arraycopy(this.cvertex[127], 0, this.cvertex[2], 0, 19);
            this.cvertexIndex = 3;
        }
        this.setup_vertex(this.cvertex[this.cvertexIndex++], f, f2, 0.0f);
        if (this.cvertexIndex > 3) {
            this.catmullrom_segment(this.cvertex[this.cvertexIndex - 4][9], this.cvertex[this.cvertexIndex - 4][10], this.cvertex[this.cvertexIndex - 3][9], this.cvertex[this.cvertexIndex - 3][10], this.cvertex[this.cvertexIndex - 2][9], this.cvertex[this.cvertexIndex - 2][10], this.cvertex[this.cvertexIndex - 1][9], this.cvertex[this.cvertexIndex - 1][10]);
        }
    }

    public void endShape() {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float[] fArray;
        int n;
        float[][] fArray2;
        int n2;
        block57: {
            block56: {
                n2 = this.polygon.vertexCount;
                fArray2 = this.polygon.vertices;
                if (this.projection != 3) break block56;
                switch (this.dimensions) {
                    case 0: {
                        this.polygon.interpZ = false;
                        this.spolygon.interpZ = false;
                        n = 0;
                        while (n < n2) {
                            fArray2[n][0] = fArray2[n][9];
                            fArray2[n][1] = fArray2[n][10];
                            ++n;
                        }
                        break block57;
                    }
                    case 2: {
                        this.polygon.interpZ = false;
                        this.spolygon.interpZ = false;
                        n = 0;
                        while (n < n2) {
                            fArray2[n][0] = this.m00 * fArray2[n][9] + this.m01 * fArray2[n][10] + this.m03;
                            fArray2[n][1] = this.m10 * fArray2[n][9] + this.m11 * fArray2[n][10] + this.m13;
                            ++n;
                        }
                        break block57;
                    }
                    case 3: {
                        this.polygon.interpZ = true;
                        this.spolygon.interpZ = true;
                        n = 0;
                        while (n < n2) {
                            fArray = fArray2[n];
                            f5 = this.m00 * fArray[9] + this.m01 * fArray[10] + this.m02 * fArray[11] + this.m03;
                            f4 = this.m10 * fArray[9] + this.m11 * fArray[10] + this.m12 * fArray[11] + this.m13;
                            f3 = this.m20 * fArray[9] + this.m21 * fArray[10] + this.m22 * fArray[11] + this.m23;
                            f2 = this.m30 * fArray[9] + this.m31 * fArray[10] + this.m32 * fArray[11] + this.m33;
                            f = this.p00 * f5 + this.p01 * f4 + this.p02 * f3 + this.p03 * f2;
                            float f6 = this.p10 * f5 + this.p11 * f4 + this.p12 * f3 + this.p13 * f2;
                            float f7 = this.p20 * f5 + this.p21 * f4 + this.p22 * f3 + this.p23 * f2;
                            float f8 = this.p30 * f5 + this.p31 * f4 + this.p32 * f3 + this.p33 * f2;
                            if (f8 != 0.0f) {
                                f /= f8;
                                f6 /= f8;
                                f7 /= f8;
                            }
                            fArray[0] = (float)this.width * (1.0f + f) / 2.0f;
                            fArray[1] = (float)this.height * (1.0f + f6) / 2.0f;
                            fArray[2] = (f7 + 1.0f) / 2.0f;
                            ++n;
                        }
                        break block57;
                    }
                }
                break block57;
            }
            if (this.projection == 2) {
                n = 0;
                while (n < n2) {
                    fArray = fArray2[n];
                    fArray[0] = fArray[9] - fArray[11];
                    fArray[1] = -fArray[9] / 2.0f + fArray[10] - fArray[11] / 2.0f;
                    fArray[2] = fArray[11];
                    ++n;
                }
            }
        }
        if (!this.normalChanged) {
            fArray2[0][16] = this.normalX;
            fArray2[0][17] = this.normalY;
            fArray2[0][18] = this.normalZ;
        }
        n = 0;
        while (n < (this.normalChanged ? n2 : 1)) {
            fArray = fArray2[n];
            f5 = this.m00 * fArray[16] + this.m01 * fArray[17] + this.m02 * fArray[18] + this.m03;
            f4 = this.m10 * fArray[16] + this.m11 * fArray[17] + this.m12 * fArray[18] + this.m13;
            f3 = this.m20 * fArray[16] + this.m21 * fArray[17] + this.m22 * fArray[18] + this.m23;
            f2 = this.m30 * fArray[16] + this.m31 * fArray[17] + this.m32 * fArray[18] + this.m33;
            if (f2 != 0.0f) {
                fArray[16] = f5 / f2;
                fArray[17] = f4 / f2;
                fArray[18] = f3 / f2;
            } else {
                fArray[16] = f5;
                fArray[17] = f4;
                fArray[18] = f3;
            }
            f = this.mag(fArray[16], fArray[17], fArray[18]);
            if (f != 0.0f) {
                fArray[16] = fArray[16] / f;
                fArray[17] = fArray[17] / f;
                fArray[18] = fArray[18] / f;
            }
            ++n;
        }
        if (this.polygon.interpUV) {
            this.fpolygon.texture(this.polygon.timage);
        }
        if (!this.lighting) {
            this.spolygon.interpRGB = this.strokeChanged;
            this.fpolygon.interpRGB = this.fillChanged;
        } else {
            this.spolygon.interpRGB = true;
            this.fpolygon.interpRGB = true;
            float[] fArray3 = this.polygon.vertices[0];
            int n3 = 0;
            while (n3 < n2) {
                float[] fArray4 = this.polygon.vertices[n3];
                if (this.normalChanged) {
                    if (this._fill) {
                        this.calc_color(fArray4[3], fArray4[4], fArray4[5], fArray4[9], fArray4[10], fArray4[11], fArray4[16], fArray4[17], fArray4[18], fArray4, 3);
                    }
                    if (this._stroke) {
                        this.calc_color(fArray4[12], fArray4[13], fArray4[14], fArray4[9], fArray4[10], fArray4[11], fArray4[16], fArray4[17], fArray4[18], fArray4, 12);
                    }
                } else {
                    if (this._fill) {
                        this.calc_color(fArray4[3], fArray4[4], fArray4[5], fArray4[9], fArray4[10], fArray4[11], fArray3[16], fArray3[17], fArray3[18], fArray4, 3);
                    }
                    if (this._stroke) {
                        this.calc_color(fArray4[12], fArray4[13], fArray4[14], fArray4[9], fArray4[10], fArray4[11], fArray3[16], fArray3[17], fArray3[18], fArray4, 12);
                    }
                }
                ++n3;
            }
        }
        this.shape = false;
        switch (this.shapeKind) {
            case 10: {
                if (this.dimensions == 0 && this.unchangedZ && this._strokeWidth == 1.0f && !this.lighting) {
                    if (!this.strokeChanged) {
                        int n4 = 0;
                        while (n4 < n2) {
                            this.thin_point((int)fArray2[n4][0], (int)fArray2[n4][1], 0.0f, this.strokei);
                            ++n4;
                        }
                    } else {
                        int n5 = 0;
                        while (n5 < n2) {
                            this.thin_point((int)fArray2[n5][0], (int)fArray2[n5][1], 0.0f, Bagel.pack_color(fArray2[n5][12], fArray2[n5][13], fArray2[n5][14]));
                            ++n5;
                        }
                    }
                } else {
                    float[] fArray5 = fArray2[0];
                    int n6 = 0;
                    while (n6 < n2) {
                        float[] fArray6 = fArray2[n6];
                        if (n6 == 0 || this.lighting || this.strokeChanged) {
                            this.calc_color(fArray6[12], fArray6[13], fArray6[14], fArray6[0], fArray6[1], fArray6[2], fArray6[16], fArray6[17], fArray6[18], fArray5, 3);
                        }
                        this.thick_point(fArray6[0], fArray6[1], fArray6[2], fArray5[3], fArray5[4], fArray5[5]);
                        ++n6;
                    }
                }
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                if (!this._stroke) {
                    return;
                }
                if (this.shapeKind == 22) {
                    float[] fArray7 = this.polygon.vertices[0];
                    float[] fArray8 = this.polygon.nextVertex();
                    ++n2;
                    fArray8[0] = fArray7[0];
                    fArray8[1] = fArray7[1];
                    fArray8[2] = fArray7[2];
                    fArray8[12] = fArray7[12];
                    fArray8[13] = fArray7[13];
                    fArray8[14] = fArray7[14];
                }
                int n7 = this.shapeKind == 20 ? 2 : 1;
                this.draw_lines(fArray2, n2 - 1, 1, n7, 0);
                break;
            }
            case 30: 
            case 31: {
                int n8;
                int n9 = n8 = this.shapeKind == 30 ? 3 : 1;
                if (this._fill) {
                    this.fpolygon.vertexCount = 3;
                    int n10 = 0;
                    while (n10 < n2 - 2) {
                        int n11 = 0;
                        while (n11 < 3) {
                            this.fpolygon.vertices[n11][3] = fArray2[n10 + n11][3];
                            this.fpolygon.vertices[n11][4] = fArray2[n10 + n11][4];
                            this.fpolygon.vertices[n11][5] = fArray2[n10 + n11][5];
                            this.fpolygon.vertices[n11][0] = fArray2[n10 + n11][0];
                            this.fpolygon.vertices[n11][1] = fArray2[n10 + n11][1];
                            this.fpolygon.vertices[n11][2] = fArray2[n10 + n11][2];
                            if (this.polygon.interpUV) {
                                this.fpolygon.vertices[n11][7] = fArray2[n10 + n11][7];
                                this.fpolygon.vertices[n11][8] = fArray2[n10 + n11][8];
                            }
                            ++n11;
                        }
                        this.fpolygon.render();
                        n10 += n8;
                    }
                }
                if (!this._stroke) break;
                if (this.shapeKind == 31) {
                    this.draw_lines(fArray2, n2 - 1, 1, 1, 0);
                } else {
                    this.draw_lines(fArray2, n2 - 1, 1, 1, 3);
                }
                this.draw_lines(fArray2, n2 - 2, 2, n8, 0);
                break;
            }
            case 40: 
            case 41: {
                int n12;
                int n13 = n12 = this.shapeKind == 40 ? 4 : 2;
                if (this._fill) {
                    this.fpolygon.vertexCount = 4;
                    int n14 = 0;
                    while (n14 < n2 - 3) {
                        int n15 = 0;
                        while (n15 < 4) {
                            this.fpolygon.vertices[n15][3] = fArray2[n14 + n15][3];
                            this.fpolygon.vertices[n15][4] = fArray2[n14 + n15][4];
                            this.fpolygon.vertices[n15][5] = fArray2[n14 + n15][5];
                            this.fpolygon.vertices[n15][0] = fArray2[n14 + n15][0];
                            this.fpolygon.vertices[n15][1] = fArray2[n14 + n15][1];
                            this.fpolygon.vertices[n15][2] = fArray2[n14 + n15][2];
                            if (this.polygon.interpUV) {
                                this.fpolygon.vertices[n15][7] = fArray2[n14 + n15][7];
                                this.fpolygon.vertices[n15][8] = fArray2[n14 + n15][8];
                            }
                            ++n15;
                        }
                        this.fpolygon.render();
                        n14 += n12;
                    }
                }
                if (!this._stroke) break;
                if (this.shapeKind == 41) {
                    this.draw_lines(fArray2, n2 - 1, 1, 1, 0);
                } else {
                    this.draw_lines(fArray2, n2, 1, 1, 4);
                }
                this.draw_lines(fArray2, n2 - 2, 3, n12, 0);
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                if (this._fill) {
                    this.polygon.render();
                }
                if (!this._stroke) break;
                this.draw_lines(fArray2, n2 - 1, 1, 1, 0);
                this.svertices[0] = fArray2[n2 - 1];
                this.svertices[1] = fArray2[0];
                this.draw_lines(this.svertices, 1, 1, 1, 0);
                break;
            }
        }
    }

    private void thin_point(int n, int n2, float f, int n3) {
        if (n < 0 || n > this.width1 || n2 < 0 || n2 > this.height1) {
            return;
        }
        int n4 = n2 * this.width + n;
        this.pixels[n4] = n3;
        this.zbuffer[n4] = f;
    }

    private void thick_point(float f, float f2, float f3, float f4, float f5, float f6) {
        this.spolygon.reset(4);
        this.spolygon.interpRGB = false;
        float f7 = this._strokeWidth / 2.0f;
        float[] fArray = this.spolygon.vertices[0];
        fArray[0] = f - f7;
        fArray[1] = f2 - f7;
        fArray[2] = f3;
        fArray[3] = f4;
        fArray[4] = f5;
        fArray[5] = f6;
        fArray = this.spolygon.vertices[1];
        fArray[0] = f + f7;
        fArray[1] = f2 - f7;
        fArray[2] = f3;
        fArray = this.spolygon.vertices[2];
        fArray[0] = f + f7;
        fArray[1] = f2 + f7;
        fArray[2] = f3;
        fArray = this.spolygon.vertices[3];
        fArray[0] = f - f7;
        fArray[1] = f2 + f7;
        fArray[2] = f3;
        this.spolygon.render();
    }

    private void thin_flat_line(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        if (n < 0 || n2 < 0 || n3 > this.width1 || n4 > this.height1) {
            float f = n;
            float f2 = n2;
            float f3 = n3;
            float f4 = n4;
            n12 = this.thin_flat_lineClipCode(n, n2);
            n11 = this.thin_flat_lineClipCode(n3, n4);
            while ((n12 | n11) != 0) {
                if ((n12 & n11) != 0) {
                    return;
                }
                float f5 = f3 - f;
                float f6 = f4 - f2;
                if (n12 != 0) {
                    if ((n12 & 8) == 8) {
                        f2 += (0.0f - f) * f6 / f5;
                        f = 0.0f;
                    } else if ((n12 & 4) == 4) {
                        f2 += ((float)this.width1 - f) * f6 / f5;
                        f = this.width1;
                    } else if ((n12 & 2) == 2) {
                        f += (0.0f - f2) * f5 / f6;
                        f2 = 0.0f;
                    } else if ((n12 & 1) == 1) {
                        f += ((float)this.height1 - f2) * f5 / f6;
                        f2 = this.height1;
                    }
                    n12 = this.thin_flat_lineClipCode(f, f2);
                    continue;
                }
                if (n11 == 0) continue;
                if ((n11 & 8) == 8) {
                    f4 += (0.0f - f3) * f6 / f5;
                    f3 = 0.0f;
                } else if ((n11 & 4) == 4) {
                    f4 += ((float)this.width1 - f3) * f6 / f5;
                    f3 = this.width1;
                } else if ((n11 & 2) == 2) {
                    f3 += (0.0f - f4) * f5 / f6;
                    f4 = 0.0f;
                } else if ((n11 & 1) == 1) {
                    f3 += ((float)this.height1 - f4) * f5 / f6;
                    f4 = this.height1;
                }
                n11 = this.thin_flat_lineClipCode(f3, f4);
            }
            n = (int)f;
            n2 = (int)f2;
            n3 = (int)f3;
            n4 = (int)f4;
        }
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == n3) {
            int n17;
            int n18;
            n11 = n;
            if (n2 < n4) {
                n18 = n2;
                n17 = n4;
            } else {
                n18 = n4;
                n17 = n2;
            }
            int n19 = n18;
            while (n19 <= n17) {
                this.thin_point(n11, n19, 0.0f, this.strokei);
                ++n19;
            }
            return;
        }
        float f = (float)(n4 - n2) / (float)(n3 - n);
        int n20 = f >= 0.0f && f <= 1.0f ? 1 : (f > 1.0f ? 2 : (f < -1.0f ? 3 : 4));
        if ((n20 == 1 || n20 == 2 || n20 == 4) && n > n3 || n20 == 3 && n < n3) {
            n10 = n3;
            n9 = n;
            n8 = n4;
            n7 = n2;
        } else {
            n10 = n;
            n8 = n2;
            n9 = n3;
            n7 = n4;
        }
        int n21 = n9 - n10;
        int n22 = n7 - n8;
        if (n20 == 1) {
            n13 = n21;
            n12 = 2 * n22 - n21;
            n15 = 1;
            n6 = 2 * n22;
            n5 = 2 * (n22 - n21);
        } else if (n20 == 2) {
            n14 = n22;
            n12 = 2 * n21 - n22;
            n16 = 1;
            n6 = 2 * n21;
            n5 = 2 * (n21 - n22);
        } else if (n20 == 3) {
            n14 = -n22;
            n12 = -2 * n21 - n22;
            n16 = -1;
            n6 = -2 * n21;
            n5 = -2 * (n21 + n22);
        } else {
            n13 = -n21;
            n12 = -2 * n22 - n21;
            n15 = -1;
            n6 = -2 * n22;
            n5 = -2 * (n22 + n21);
        }
        if (n20 == 1 || n20 == 4) {
            int n23 = 0;
            float f7 = 1.0f / (2.0f * this.sqrt(n21 * n21 + n22 * n22));
            float f8 = (float)(2 * n13) * f7;
            n11 = n10;
            int n24 = n8;
            this.thin_point(n11, n24, 0.0f, this.strokei);
            while (n11 < n9) {
                if (n12 < 0) {
                    n23 = n12 + n21;
                    n12 += n6;
                    ++n11;
                } else {
                    n23 = n12 - n21;
                    n12 += n5;
                    ++n11;
                    n24 += n15;
                }
                float f9 = (float)n23 * f7;
                this.thin_point(n11, n24, 0.0f, this.strokei);
            }
        } else {
            int n25 = 0;
            float f10 = 1.0f / (2.0f * this.sqrt(n21 * n21 + n22 * n22));
            float f11 = (float)(2 * n14) * f10;
            n11 = n10;
            int n26 = n8;
            this.thin_point(n11, n26, 0.0f, this.strokei);
            while (n26 < n7) {
                if (n12 < 0) {
                    n25 = n12 + n22;
                    n12 += n6;
                    ++n26;
                } else {
                    n25 = n12 - n22;
                    n12 += n5;
                    ++n26;
                    n11 += n16;
                }
                float f12 = (float)n25 * f10;
                this.thin_point(n11, n26, 0.0f, this.strokei);
            }
        }
    }

    private int thin_flat_lineClipCode(float f, float f2) {
        return (f < 0.0f ? 8 : 0) | (f > (float)this.width1 ? 4 : 0) | (f2 < 0.0f ? 2 : 0) | (f2 > (float)this.height1 ? 1 : 0);
    }

    private boolean flat_line_retribution(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = this.m00 * this._strokeWidth + this.m01 * this._strokeWidth;
        if (this._strokeWidth < 2.0f && !this.hints[1]) {
            int n = this.strokei;
            this.strokei = Bagel.pack_color(f5, f6, f7);
            this.thin_flat_line((int)f, (int)f2, (int)f3, (int)f4);
            this.strokei = n;
            return true;
        }
        return false;
    }

    private void thick_flat_line(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        this.spolygon.interpRGB = f3 != f8 || f4 != f9 || f5 != f10;
        this.spolygon.interpZ = false;
        if (!this.spolygon.interpRGB && this.flat_line_retribution(f, f2, f6, f7, f3, f4, f5)) {
            return;
        }
        float f11 = f6 - f + 1.0E-4f;
        float f12 = f7 - f2 + 1.0E-4f;
        float f13 = this.sqrt(f11 * f11 + f12 * f12);
        float f14 = this._strokeWidth / f13;
        float f15 = f14 * f12;
        float f16 = f14 * f11;
        float f17 = f14 * f12;
        float f18 = f14 * f11;
        this.spolygon.reset(4);
        float[] fArray = this.spolygon.vertices[0];
        fArray[0] = f + f15;
        fArray[1] = f2 - f16;
        fArray[3] = f3;
        fArray[4] = f4;
        fArray[5] = f5;
        fArray = this.spolygon.vertices[1];
        fArray[0] = f - f15;
        fArray[1] = f2 + f16;
        fArray[3] = f3;
        fArray[4] = f4;
        fArray[5] = f5;
        fArray = this.spolygon.vertices[2];
        fArray[0] = f6 - f17;
        fArray[1] = f7 + f18;
        fArray[3] = f8;
        fArray[4] = f9;
        fArray[5] = f10;
        fArray = this.spolygon.vertices[3];
        fArray[0] = f6 + f17;
        fArray[1] = f7 - f18;
        fArray[3] = f8;
        fArray[4] = f9;
        fArray[5] = f10;
        this.spolygon.render();
    }

    private void spatial_line(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        this.spatial_line(f, f2, 0.0f, f3, f4, f5, f6, f7, 0.0f, f8, f9, f10);
    }

    private void spatial_line(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        boolean bl = this.spolygon.interpRGB = f4 != f10 || f5 != f11 || f6 != f12;
        if (!this.spolygon.interpRGB && this.flat_line_retribution(f, f2, f7, f8, f4, f5, f6)) {
            return;
        }
        this.spolygon.interpZ = true;
        float f13 = f;
        float f14 = f2;
        float f15 = f3;
        float f16 = f7;
        float f17 = f8;
        float f18 = f9;
        float f19 = f16 - f13 + 1.0E-4f;
        float f20 = f17 - f14 + 1.0E-4f;
        float f21 = this.sqrt(f19 * f19 + f20 * f20);
        float f22 = this._strokeWidth / f21;
        float f23 = f22 * f20;
        float f24 = f22 * f19;
        float f25 = f22 * f20;
        float f26 = f22 * f19;
        this.spolygon.reset(4);
        float[] fArray = this.spolygon.vertices[0];
        fArray[0] = f13 + f23;
        fArray[1] = f14 - f24;
        fArray[2] = f15;
        fArray[3] = f4;
        fArray[4] = f5;
        fArray[5] = f6;
        fArray = this.spolygon.vertices[1];
        fArray[0] = f13 - f23;
        fArray[1] = f14 + f24;
        fArray[2] = f15;
        fArray[3] = f4;
        fArray[4] = f5;
        fArray[5] = f6;
        fArray = this.spolygon.vertices[2];
        fArray[0] = f16 - f25;
        fArray[1] = f17 + f26;
        fArray[2] = f18;
        fArray[3] = f10;
        fArray[4] = f11;
        fArray[5] = f12;
        fArray = this.spolygon.vertices[3];
        fArray[0] = f16 + f25;
        fArray[1] = f17 - f26;
        fArray[2] = f18;
        fArray[3] = f10;
        fArray[4] = f11;
        fArray[5] = f12;
        this.spolygon.render();
    }

    private void draw_lines(float[][] fArray, int n, int n2, int n3, int n4) {
        if (this.dimensions == 0 && this.unchangedZ) {
            if (this._strokeWidth < 2.0f && !this.lighting && !this.strokeChanged) {
                int n5 = 0;
                while (n5 < n) {
                    if (n4 == 0 || (n5 + n2) % n4 != 0) {
                        this.thin_flat_line((int)fArray[n5][0], (int)fArray[n5][1], (int)fArray[n5 + n2][0], (int)fArray[n5 + n2][1]);
                    }
                    n5 += n3;
                }
            } else {
                int n6 = 0;
                while (n6 < n) {
                    if (n4 == 0 || (n6 + n2) % n4 != 0) {
                        float[] fArray2 = fArray[n6];
                        float[] fArray3 = fArray[n6 + n2];
                        this.thick_flat_line(fArray2[0], fArray2[1], fArray2[12], fArray2[13], fArray2[14], fArray3[0], fArray3[1], fArray3[12], fArray3[13], fArray3[14]);
                    }
                    n6 += n3;
                }
            }
        } else {
            int n7 = 0;
            while (n7 < n) {
                if (n4 == 0 || (n7 + n2) % n4 != 0) {
                    float[] fArray4 = fArray[n7];
                    float[] fArray5 = fArray[n7 + n2];
                    this.spatial_line(fArray4[0], fArray4[1], fArray4[2], fArray4[12], fArray4[13], fArray4[14], fArray5[0], fArray5[1], fArray5[2], fArray5[12], fArray5[13], fArray5[14]);
                }
                n7 += n3;
            }
        }
    }

    private void flat_rect(int n, int n2, int n3, int n4) {
        int n5;
        if (n4 < n2) {
            n5 = n2;
            n2 = n4;
            n4 = n5;
        }
        if (n3 < n) {
            n5 = n;
            n = n3;
            n3 = n5;
        }
        if (n > this.width1 || n3 < 0 || n2 > this.height1 || n4 < 0) {
            return;
        }
        if (this._fill) {
            n5 = n;
            int n6 = n2;
            int n7 = n3;
            int n8 = n4;
            if (n5 < 0) {
                n5 = 0;
            }
            if (n7 > this.width1) {
                n7 = this.width1;
            }
            if (n6 < 0) {
                n6 = 0;
            }
            if (n8 > this.height1) {
                n8 = this.height1;
            }
            int n9 = n6 * this.width;
            int n10 = n6;
            while (n10 <= n8) {
                int n11 = n5;
                while (n11 <= n7) {
                    this.pixels[n9 + n11] = this.filli;
                    ++n11;
                }
                n9 += this.width;
                ++n10;
            }
        }
        if (this._stroke) {
            if (this._strokeWidth == 1.0f) {
                this.thin_flat_line(n, n2, n3, n2);
                this.thin_flat_line(n3, n2, n3, n4);
                this.thin_flat_line(n3, n4, n, n4);
                this.thin_flat_line(n, n4, n, n2);
            } else {
                this.thick_flat_line(n, n2, this.fillR, this.fillG, this.fillB, n3, n2, this.fillR, this.fillG, this.fillB);
                this.thick_flat_line(n3, n2, this.fillR, this.fillG, this.fillB, n3, n4, this.fillR, this.fillG, this.fillB);
                this.thick_flat_line(n3, n4, this.fillR, this.fillG, this.fillB, n, n4, this.fillR, this.fillG, this.fillB);
                this.thick_flat_line(n, n4, this.fillR, this.fillG, this.fillB, n, n2, this.fillR, this.fillG, this.fillB);
            }
        }
    }

    private void flat_ellipse(int n, int n2, int n3, int n4) {
    }

    private void bezier_segment(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = -0.142625f * f + 0.135375f * f3 + 0.007125f * f5 + 1.25E-4f * f7;
        float f10 = 0.01425f * f - 0.02775f * f3 + 0.01275f * f5 + 7.5E-4f * f7;
        float f11 = -7.5E-4f * f + 0.00225f * f3 - 0.00225f * f5 + 7.5E-4f * f7;
        float f12 = -0.142625f * f2 + 0.135375f * f4 + 0.007125f * f6 + 1.25E-4f * f8;
        float f13 = 0.01425f * f2 - 0.02775f * f4 + 0.01275f * f6 + 7.5E-4f * f8;
        float f14 = -7.5E-4f * f2 + 0.00225f * f4 - 0.00225f * f6 + 7.5E-4f * f8;
        this.vertex(f, f2);
        int n = 0;
        while (n < 20) {
            f9 += f10;
            f10 += f11;
            f13 += f14;
            this.vertex(f += f9, f2 += (f12 += f13));
            ++n;
        }
    }

    private void catmullrom_segment(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = -0.022562502f * f + -0.006062496f * f3 + 0.029812502f * f5 + -0.0011875001f * f7;
        float f10 = 0.0046250005f * f + -0.011375001f * f3 + 0.008874999f * f5 + -0.002125f * f7;
        float f11 = -3.7500003E-4f * f + 0.001125f * f3 + -0.001125f * f5 + 3.7500003E-4f * f7;
        float f12 = -0.022562502f * f2 + -0.006062496f * f4 + 0.029812502f * f6 + -0.0011875001f * f8;
        float f13 = 0.0046250005f * f2 + -0.011375001f * f4 + 0.008874999f * f6 + -0.002125f * f8;
        float f14 = -3.7500003E-4f * f2 + 0.001125f * f4 + -0.001125f * f6 + 3.7500003E-4f * f8;
        this.vertex(f3, f4);
        int n = 0;
        while (n < 20) {
            f9 += f10;
            f10 += f11;
            f13 += f14;
            this.vertex(f3 += f9, f4 += (f12 += f13));
            ++n;
        }
    }

    private void unwarped_image(BagelImage bagelImage, int n, int n2) {
        block8: {
            int n3;
            int n4;
            int n5;
            int n6;
            block7: {
                int n7 = 0;
                int n8 = 0;
                int n9 = bagelImage.width;
                int n10 = bagelImage.height;
                n6 = n + bagelImage.width;
                n5 = n2 + bagelImage.height;
                if (n < 0) {
                    n7 -= n;
                    n = 0;
                }
                if (n2 < 0) {
                    n8 -= n2;
                    n2 = 0;
                }
                if (n6 > this.width) {
                    n9 -= n6 - this.width;
                    n6 = this.width;
                }
                if (n5 > this.height) {
                    n10 -= n5 - this.height;
                    n5 = this.height;
                }
                n4 = n8 * bagelImage.width + n7;
                n3 = n2 * this.width;
                if (bagelImage.format != 2) break block7;
                int n11 = n2;
                while (n11 < n5) {
                    int n12 = n;
                    while (n12 < n6) {
                        this.pixels[n3 + n12] = this.blend_color(this.pixels[n3 + n12], this.filli, bagelImage.pixels[n4 + (n12 - n)]);
                        ++n12;
                    }
                    n4 += bagelImage.width;
                    n3 += this.width;
                    ++n11;
                }
                break block8;
            }
            if (bagelImage.format != 1) break block8;
            int n13 = n2;
            while (n13 < n5) {
                System.arraycopy(bagelImage.pixels, n4, this.pixels, n3 + n, n6 - n);
                n4 += bagelImage.width;
                n3 += this.width;
                ++n13;
            }
        }
    }

    private final int blend_color(int n, int n2, int n3) {
        n3 = n3 * (n2 >> 24 & 0xFF) >> 8;
        int n4 = 255 - n3;
        int n5 = n4 * (n >> 16 & 0xFF) + n3 * (n2 >> 16 & 0xFF) >> 8;
        int n6 = n4 * (n >> 8 & 0xFF) + n3 * (n2 >> 8 & 0xFF) >> 8;
        int n7 = n4 * (n & 0xFF) + n3 * (n2 & 0xFF) >> 8;
        return 0xFF000000 | n5 << 16 | n6 << 8 | n7;
    }

    static final int pack_color(float f, float f2, float f3) {
        return 0xFF000000 | (int)(255.0f * f) << 16 | (int)(255.0f * f2) << 8 | (int)(255.0f * f3);
    }

    public void point(float f, float f2) {
        this.beginShape(10);
        this.vertex(f, f2);
        this.endShape();
    }

    public void point(float f, float f2, float f3) {
        this.beginShape(10);
        this.vertex(f, f2, f3);
        this.endShape();
    }

    public void line(float f, float f2, float f3, float f4) {
        this.beginShape(20);
        this.vertex(f, f2);
        this.vertex(f3, f4);
        this.endShape();
    }

    public void line(float f, float f2, float f3, float f4, float f5, float f6) {
        this.beginShape(20);
        this.vertex(f, f2, f3);
        this.vertex(f4, f5, f6);
        this.endShape();
    }

    public void rectMode(int n) {
        this.rect_mode = n;
    }

    public void rect(float f, float f2, float f3, float f4) {
        switch (this.rect_mode) {
            case 1: {
                break;
            }
            case 0: {
                f3 += f;
                f4 += f2;
                break;
            }
            case 2: {
                float f5 = f3;
                float f6 = f4;
                f3 = f + f5;
                f4 = f2 + f6;
                f -= f5;
                f2 -= f6;
                break;
            }
            case 3: {
                float f7 = f3 / 2.0f;
                float f8 = f4 / 2.0f;
                f3 = f + f7;
                f4 = f2 + f8;
                f -= f7;
                f2 -= f8;
            }
        }
        if (this.dimensions == 0 && !this.lighting) {
            this.flat_rect((int)f, (int)f2, (int)f3, (int)f4);
        } else {
            this.beginShape(40);
            this.vertex(f, f2);
            this.vertex(f3, f2);
            this.vertex(f3, f4);
            this.vertex(f, f4);
            this.endShape();
        }
    }

    public void ellipseMode(int n) {
        this.ellipse_mode = n;
    }

    public void ellipse(float f, float f2, float f3, float f4) {
        switch (this.ellipse_mode) {
            case 2: {
                break;
            }
            case 3: {
                f3 /= 2.0f;
                f4 /= 2.0f;
                break;
            }
            case 0: {
                f += (f3 /= 2.0f);
                f2 += (f4 /= 2.0f);
                break;
            }
            case 1: {
                f3 -= f;
                f4 -= f2;
                break;
            }
        }
        if (this.dimensions != 0 || !this.lighting) {
            // empty if block
        }
        if (this.circleX == null) {
            this.circleX = new float[30];
            this.circleY = new float[30];
            float f5 = 0.033333335f;
            float f6 = 0.0f;
            int n = 0;
            while (n < 30) {
                this.circleX[n] = this.cos((float)Math.PI * 2 * f6);
                this.circleY[n] = this.sin((float)Math.PI * 2 * f6);
                f6 += f5;
                ++n;
            }
        }
        this.beginShape(50);
        int n = 0;
        while (n < 30) {
            this.vertex(f + this.circleX[n] * f3, f2 + this.circleY[n] * f4);
            ++n;
        }
        this.vertex(f + this.circleX[0] * f3, f2 + this.circleY[0] * f4);
        this.endShape();
    }

    public void box(float f) {
        this.box(f, f, f);
    }

    public void box(float f, float f2, float f3) {
        float f4 = -f / 2.0f;
        float f5 = f / 2.0f;
        float f6 = -f2 / 2.0f;
        float f7 = f2 / 2.0f;
        float f8 = -f3 / 2.0f;
        float f9 = f3 / 2.0f;
        this.beginShape(41);
        this.vertex(f4, f6, f9);
        this.vertex(f4, f6, f8);
        this.vertex(f5, f6, f8);
        this.vertex(f5, f6, f9);
        this.vertex(f5, f7, f9);
        this.vertex(f5, f7, f8);
        this.vertex(f4, f7, f8);
        this.vertex(f4, f7, f9);
        this.vertex(f4, f6, f9);
        this.vertex(f4, f6, f8);
        this.endShape();
        this.beginShape(40);
        this.vertex(f5, f6, f8);
        this.vertex(f4, f6, f8);
        this.vertex(f4, f7, f8);
        this.vertex(f5, f7, f8);
        this.vertex(f4, f6, f9);
        this.vertex(f5, f6, f9);
        this.vertex(f5, f7, f9);
        this.vertex(f4, f7, f9);
        this.endShape();
    }

    public void sphere(float f) {
        if (this.sphereX == null) {
            float[] fArray = new float[30];
            float[] fArray2 = new float[30];
            float f2 = 0.03448276f;
            float f3 = 0.0f;
            int n = 0;
            while (n < 30) {
                fArray[n] = this.cos((float)Math.PI * 2 * f3);
                fArray2[n] = this.sin((float)Math.PI * 2 * f3);
                f3 += f2;
                ++n;
            }
            this.sphereX = new float[30][30];
            this.sphereY = new float[30];
            this.sphereZ = new float[30][30];
            float f4 = 0.0f;
            float f5 = 0.03448276f;
            int n2 = 0;
            while (n2 < 30) {
                this.sphereY[n2] = this.sin((float)Math.PI * 2 * f4);
                float f6 = this.cos((float)Math.PI * 2 * f4);
                int n3 = 0;
                while (n3 < 30) {
                    this.sphereX[n2][n3] = fArray[n3] * f6;
                    this.sphereZ[n2][n3] = fArray2[n3] * f6;
                    ++n3;
                }
                f4 += f5;
                ++n2;
            }
        }
        int n = 1;
        while (n < 29) {
            this.beginShape(31);
            int n4 = 0;
            while (n4 < 30) {
                this.vertex(this.sphereX[n][n4] * f, this.sphereY[n] * f, this.sphereZ[n][n4] * f);
                this.vertex(this.sphereX[n + 1][n4] * f, this.sphereY[n + 1] * f, this.sphereZ[n + 1][n4] * f);
                ++n4;
            }
            this.vertex(this.sphereX[n][0] * f, this.sphereY[n] * f, this.sphereZ[n][0] * f);
            this.vertex(this.sphereX[n + 1][0] * f, this.sphereY[n + 1] * f, this.sphereZ[n + 1][0] * f);
            this.endShape();
            ++n;
        }
    }

    public void potato() {
    }

    public void bezier(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.beginShape(21);
        this.bezierVertex(f, f2);
        this.bezierVertex(f3, f4);
        this.bezierVertex(f5, f6);
        this.bezierVertex(f7, f8);
        this.endShape();
    }

    public void curve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.beginShape(21);
        this.curveVertex(f, f2);
        this.curveVertex(f3, f4);
        this.curveVertex(f5, f6);
        this.curveVertex(f7, f8);
        this.endShape();
    }

    public BagelImage loadImage(String string) {
        Container container;
        Image image = null;
        if (applet != null) {
            try {
                image = applet.getImage(applet.getDocumentBase(), string);
            }
            catch (NullPointerException nullPointerException) {
                applet = null;
            }
        }
        if (applet == null) {
            image = Toolkit.getDefaultToolkit().getImage(string);
        }
        if ((container = applet) == null) {
            container = new Frame();
            ((Frame)container).pack();
        }
        MediaTracker mediaTracker = new MediaTracker(container);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return new BagelImage(nArray, n, n2, 1);
    }

    public void image(BagelImage bagelImage, float f, float f2) {
        if (this.dimensions == 0 && !this.lighting) {
            this.unwarped_image(bagelImage, (int)f, (int)f2);
        } else {
            this.image(bagelImage, f, f2, bagelImage.width, bagelImage.height, 0.0f, 0.0f, bagelImage.width, bagelImage.height);
        }
    }

    public void image(BagelImage bagelImage, float f, float f2, float f3, float f4) {
        this.image(bagelImage, f, f2, f3, f4, 0.0f, 0.0f, bagelImage.width, bagelImage.height);
    }

    public void image(BagelImage bagelImage, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        switch (this.image_mode) {
            case 1: {
                break;
            }
            case 0: {
                f3 += f;
                f4 += f2;
                break;
            }
            case 3: {
                f3 /= 2.0f;
                f4 /= 2.0f;
            }
            case 2: {
                float f9 = f3;
                float f10 = f4;
                f3 = f + f9;
                f4 = f2 + f10;
                f -= f9;
                f2 -= f10;
                break;
            }
        }
        boolean bl = this._stroke;
        boolean bl2 = this._fill;
        this._stroke = false;
        this._fill = true;
        this.beginShape(40);
        this.textureImage(bagelImage);
        this.vertexTexture(f5, f6);
        this.vertex(f, f2);
        this.vertexTexture(f5, f8);
        this.vertex(f, f4);
        this.vertexTexture(f7, f8);
        this.vertex(f3, f4);
        this.vertexTexture(f7, f6);
        this.vertex(f3, f2);
        this.endShape();
        this._stroke = bl;
        this._fill = bl2;
    }

    public BagelFont loadFont(String string) {
        BagelFont bagelFont = new BagelFont(string, this);
        if (!bagelFont.valid) {
            return null;
        }
        return bagelFont;
    }

    public void setFont(BagelFont bagelFont) {
        this.currentFont = bagelFont;
        this.currentFont.resetSize();
    }

    public void setFont(BagelFont bagelFont, float f) {
        this.currentFont = bagelFont;
        this.currentFont.setSize(f);
    }

    public void text(char c, float f, float f2) {
        if (this.currentFont == null) {
            System.err.println("text(): first set a font before drawing text");
        }
        this.currentFont.drawChar(c, f, f2);
    }

    public void text(String string, float f, float f2) {
        if (this.currentFont == null) {
            System.err.println("text(): first set a font before drawing text");
        }
        this.currentFont.drawString(string, f, f2);
    }

    public void push() {
        if (this.matrixStackDepth + 1 == 32) {
            this.message(1, "matrix stack overflow, to much pushmatrix");
            return;
        }
        float[] fArray = this.matrixStack[this.matrixStackDepth];
        fArray[0] = this.m00;
        fArray[1] = this.m01;
        fArray[2] = this.m02;
        fArray[3] = this.m03;
        fArray[4] = this.m10;
        fArray[5] = this.m11;
        fArray[6] = this.m12;
        fArray[7] = this.m13;
        fArray[8] = this.m20;
        fArray[9] = this.m21;
        fArray[10] = this.m22;
        fArray[11] = this.m23;
        fArray[12] = this.m30;
        fArray[13] = this.m31;
        fArray[14] = this.m32;
        fArray[15] = this.m33;
        ++this.matrixStackDepth;
    }

    public void pop() {
        if (this.matrixStackDepth == 0) {
            this.message(1, "matrix stack underflow, to many popmatrix");
            return;
        }
        --this.matrixStackDepth;
        float[] fArray = this.matrixStack[this.matrixStackDepth];
        this.m00 = fArray[0];
        this.m01 = fArray[1];
        this.m02 = fArray[2];
        this.m03 = fArray[3];
        this.m10 = fArray[4];
        this.m11 = fArray[5];
        this.m12 = fArray[6];
        this.m13 = fArray[7];
        this.m20 = fArray[8];
        this.m21 = fArray[9];
        this.m22 = fArray[10];
        this.m23 = fArray[11];
        this.m30 = fArray[12];
        this.m31 = fArray[13];
        this.m32 = fArray[14];
        this.m33 = fArray[15];
        if (this.matrixStackDepth == 0 && this.m00 == 1.0f && this.m01 == 0.0f && this.m02 == 0.0f && this.m03 == 0.0f && this.m10 == 0.0f && this.m11 == 1.0f && this.m12 == 0.0f && this.m13 == 0.0f && this.m20 == 0.0f && this.m21 == 0.0f && this.m22 == 1.0f && this.m23 == 0.0f && this.m30 == 0.0f && this.m31 == 0.0f && this.m32 == 0.0f && this.m33 == 1.0f) {
            this.dimensions = 0;
        }
    }

    private void identity_matrix() {
        this.dimensions = 0;
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public void mult_matrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        float f17 = this.m00 * f + this.m01 * f5 + this.m02 * f9 + this.m03 * f13;
        float f18 = this.m00 * f2 + this.m01 * f6 + this.m02 * f10 + this.m03 * f14;
        float f19 = this.m00 * f3 + this.m01 * f7 + this.m02 * f11 + this.m03 * f15;
        float f20 = this.m00 * f4 + this.m01 * f8 + this.m02 * f12 + this.m03 * f16;
        float f21 = this.m10 * f + this.m11 * f5 + this.m12 * f9 + this.m13 * f13;
        float f22 = this.m10 * f2 + this.m11 * f6 + this.m12 * f10 + this.m13 * f14;
        float f23 = this.m10 * f3 + this.m11 * f7 + this.m12 * f11 + this.m13 * f15;
        float f24 = this.m10 * f4 + this.m11 * f8 + this.m12 * f12 + this.m13 * f16;
        float f25 = this.m20 * f + this.m21 * f5 + this.m22 * f9 + this.m23 * f13;
        float f26 = this.m20 * f2 + this.m21 * f6 + this.m22 * f10 + this.m23 * f14;
        float f27 = this.m20 * f3 + this.m21 * f7 + this.m22 * f11 + this.m23 * f15;
        float f28 = this.m20 * f4 + this.m21 * f8 + this.m22 * f12 + this.m23 * f16;
        float f29 = this.m30 * f + this.m31 * f5 + this.m32 * f9 + this.m33 * f13;
        float f30 = this.m30 * f2 + this.m31 * f6 + this.m32 * f10 + this.m33 * f14;
        float f31 = this.m30 * f3 + this.m31 * f7 + this.m32 * f11 + this.m33 * f15;
        float f32 = this.m30 * f4 + this.m31 * f8 + this.m32 * f12 + this.m33 * f16;
        this.m00 = f17;
        this.m01 = f18;
        this.m02 = f19;
        this.m03 = f20;
        this.m10 = f21;
        this.m11 = f22;
        this.m12 = f23;
        this.m13 = f24;
        this.m20 = f25;
        this.m21 = f26;
        this.m22 = f27;
        this.m23 = f28;
        this.m30 = f29;
        this.m31 = f30;
        this.m32 = f31;
        this.m33 = f32;
    }

    public void setupProjection(int n) {
        this.projection = n;
        this.fov = 60.0f;
        this.eyeX = (float)this.width / 2.0f;
        this.eyeY = (float)this.height / 2.0f;
        this.eyeDist = this.eyeY / this.tan((float)Math.PI * this.fov / 360.0f);
        this.nearDist = this.eyeDist / 10.0f;
        this.farDist = this.eyeDist * 10.0f;
        this.aspect = (float)this.width / (float)this.height;
        this.identity_matrix();
        if (n == 3) {
            this.perspective(this.fov, this.aspect, this.nearDist, this.farDist);
            this.lookAt(this.eyeX, this.eyeY, this.eyeDist, this.eyeX, this.eyeY, 0.0f, 0.0f, 1.0f, 0.0f);
            this.p00 = this.m00;
            this.p01 = this.m01;
            this.p02 = this.m02;
            this.p03 = this.m03;
            this.p10 = this.m10;
            this.p11 = this.m11;
            this.p12 = this.m12;
            this.p13 = this.m13;
            this.p20 = this.m20;
            this.p21 = this.m21;
            this.p22 = this.m22;
            this.p23 = this.m23;
            this.p30 = this.m30;
            this.p31 = this.m31;
            this.p32 = this.m32;
            this.p33 = this.m33;
        } else if (n == 2) {
            // empty if block
        }
        this.identity_matrix();
        if (this.matrixStackDepth != 0) {
            this.message(1, "missing " + this.matrixStackDepth + " call(s) to pop()");
            this.matrixStackDepth = 0;
        }
    }

    public void projectPoint(float f, float f2, float f3) {
        if (this.projection == 3) {
            switch (this.dimensions) {
                case 0: {
                    this.projX = f;
                    this.projY = f2;
                    this.projZ = 0.0f;
                    break;
                }
                case 2: {
                    this.projX = this.m00 * f + this.m01 * f2 + this.m03;
                    this.projY = this.m10 * f + this.m11 * f2 + this.m13;
                    this.projZ = 0.0f;
                    break;
                }
                case 3: {
                    float f4 = this.m00 * f + this.m01 * f2 + this.m02 * f3 + this.m03;
                    float f5 = this.m10 * f + this.m11 * f2 + this.m12 * f3 + this.m13;
                    float f6 = this.m20 * f + this.m21 * f2 + this.m22 * f3 + this.m23;
                    float f7 = this.m30 * f + this.m31 * f2 + this.m32 * f3 + this.m33;
                    float f8 = this.p00 * f4 + this.p01 * f5 + this.p02 * f6 + this.p03 * f7;
                    float f9 = this.p10 * f4 + this.p11 * f5 + this.p12 * f6 + this.p13 * f7;
                    float f10 = this.p20 * f4 + this.p21 * f5 + this.p22 * f6 + this.p23 * f7;
                    float f11 = this.p30 * f4 + this.p31 * f5 + this.p32 * f6 + this.p33 * f7;
                    if (f11 != 0.0f) {
                        f8 /= f11;
                        f9 /= f11;
                        f10 /= f11;
                    }
                    this.projX = (float)this.width * (1.0f + f8) / 2.0f;
                    this.projY = (float)this.height * (1.0f + f9) / 2.0f;
                    this.projZ = (f10 + 1.0f) / 2.0f;
                    break;
                }
            }
        } else if (this.projection == 2) {
            this.projX = f - f3;
            this.projY = -f / 2.0f + f2 - f3 / 2.0f;
            this.projZ = f3;
        }
    }

    public void projectSize(float f, float f2, float f3, float f4, float f5, float f6) {
        this.projectPoint(f, f2, f3);
        float f7 = this.projX;
        float f8 = this.projY;
        float f9 = this.projZ;
        this.projectPoint(f + f4, f2 + f5, f3 + f6);
        this.projX = this.abs(this.projX - f7);
        this.projY = this.abs(this.projY - f8);
        this.projZ = this.abs(this.projZ - f9);
    }

    private void perspective(float f, float f2, float f3, float f4) {
        float f5 = f3 * this.tan(f * (float)Math.PI / 360.0f);
        float f6 = -f5;
        float f7 = f6 * f2;
        float f8 = f5 * f2;
        this.frustum(f7, f8, f6, f5, f3, f4);
    }

    private void frustum(float f, float f2, float f3, float f4, float f5, float f6) {
        this.mult_matrix(2.0f * f5 / (f2 - f), 0.0f, (f2 + f) / (f2 - f), 0.0f, 0.0f, 2.0f * f5 / (f4 - f3), (f4 + f3) / (f4 - f3), 0.0f, 0.0f, 0.0f, -(f6 + f5) / (f6 - f5), -(2.0f * f6 * f5) / (f6 - f5), 0.0f, 0.0f, -1.0f, 0.0f);
    }

    private void lookAt(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f - f4;
        float f11 = f2 - f5;
        float f12 = f3 - f6;
        float f13 = this.sqrt(f10 * f10 + f11 * f11 + f12 * f12);
        if (f13 != 0.0f) {
            f10 /= f13;
            f11 /= f13;
            f12 /= f13;
        }
        float f14 = f7;
        float f15 = f8;
        float f16 = f9;
        float f17 = f15 * f12 - f16 * f11;
        float f18 = -f14 * f12 + f16 * f10;
        float f19 = f14 * f11 - f15 * f10;
        f14 = f11 * f19 - f12 * f18;
        f15 = -f10 * f19 + f12 * f17;
        f16 = f10 * f18 - f11 * f17;
        f13 = this.sqrt(f17 * f17 + f18 * f18 + f19 * f19);
        if (f13 != 0.0f) {
            f17 /= f13;
            f18 /= f13;
            f19 /= f13;
        }
        if ((f13 = this.sqrt(f14 * f14 + f15 * f15 + f16 * f16)) != 0.0f) {
            f14 /= f13;
            f15 /= f13;
            f16 /= f13;
        }
        this.mult_matrix(f17, f18, f19, 0.0f, f14, f15, f16, 0.0f, f10, f11, f12, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        this.translate(-f, -f2, -f3);
    }

    public void translate(float f, float f2) {
        if (this.dimensions == 3) {
            this.translate(f, f2, 0.0f);
        } else {
            if (this.dimensions == 0) {
                this.dimensions = 2;
            }
            this.m03 += f * this.m00 + f2 * this.m01 + this.m02;
            this.m13 += f * this.m10 + f2 * this.m11 + this.m12;
            this.m23 += f * this.m20 + f2 * this.m21 + this.m22;
            this.m33 += f * this.m30 + f2 * this.m31 + this.m32;
        }
    }

    public void translate(float f, float f2, float f3) {
        this.dimensions = 3;
        this.m03 += f * this.m00 + f2 * this.m01 + f3 * this.m02;
        this.m13 += f * this.m10 + f2 * this.m11 + f3 * this.m12;
        this.m23 += f * this.m20 + f2 * this.m21 + f3 * this.m22;
        this.m33 += f * this.m30 + f2 * this.m31 + f3 * this.m32;
    }

    public void shearX(float f) {
        this.message(1, "shear not implemented");
    }

    public void shearY(float f) {
        this.message(1, "shear not implemented");
    }

    public void rotate(float f) {
        this.rotateZ(f);
    }

    public void rotateX(float f) {
        this.dimensions = 3;
        float f2 = this.cos(f);
        float f3 = this.sin(f);
        this.mult_matrix(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, f2, -f3, 0.0f, 0.0f, f3, f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void rotateY(float f) {
        this.dimensions = 3;
        float f2 = this.cos(f);
        float f3 = this.sin(f);
        this.mult_matrix(f2, 0.0f, f3, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -f3, 0.0f, f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void rotateZ(float f) {
        if (this.dimensions == 0) {
            this.dimensions = 2;
        }
        float f2 = this.cos(f);
        float f3 = this.sin(f);
        this.mult_matrix(f2, -f3, 0.0f, 0.0f, f3, f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void rotate(float f, float f2, float f3, float f4) {
        this.dimensions = 3;
        float f5 = this.cos(f);
        float f6 = this.sin(f);
        float f7 = 1.0f - f5;
        this.mult_matrix(f7 * f2 * f2 + f5, f7 * f2 * f3 - f6 * f4, f7 * f2 * f4 + f6 * f3, 0.0f, f7 * f2 * f3 + f6 * f4, f7 * f3 * f3 + f5, f7 * f3 * f4 - f6 * f2, 0.0f, f7 * f2 * f4 - f6 * f3, f7 * f3 * f4 + f6 * f2, f7 * f4 * f4 + f5, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void scale(float f) {
        if (this.dimensions == 3) {
            this.mult_matrix(f, 0.0f, 0.0f, 0.0f, 0.0f, f, 0.0f, 0.0f, 0.0f, 0.0f, f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        } else {
            this.dimensions = 2;
            this.mult_matrix(f, 0.0f, 0.0f, 0.0f, 0.0f, f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }
    }

    public void scale(float f, float f2) {
        if (this.dimensions == 0) {
            this.dimensions = 2;
        }
        this.mult_matrix(f, 0.0f, 0.0f, 0.0f, 0.0f, f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void scale(float f, float f2, float f3) {
        this.dimensions = 3;
        this.mult_matrix(f, 0.0f, 0.0f, 0.0f, 0.0f, f2, 0.0f, 0.0f, 0.0f, 0.0f, f3, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void transform(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.dimensions = 3;
        this.mult_matrix(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    public void colorMode(int n) {
        this._colorMode = n;
    }

    public void colorMode(int n, float f) {
        this.colorMode(n, f, f, f, f);
    }

    public void colorMode(int n, float f, float f2, float f3) {
        this.colorMode(n, f, f2, f3, 1.0f);
    }

    public void colorMode(int n, float f, float f2, float f3, float f4) {
        this._colorMode = n;
        this.colorMaxX = f;
        this.colorMaxY = f2;
        this.colorMaxZ = f3;
        this.colorMaxA = f4;
        this.colorScale = f != f2 || f2 != f3 || f3 != f4 || f4 != 1.0f;
    }

    private void calc_color(float f) {
        this.calc_color(f, this.colorMaxA);
    }

    private void calc_color(float f, float f2) {
        if (f > this.colorMaxX) {
            f = this.colorMaxX;
        }
        if (f2 > this.colorMaxA) {
            f2 = this.colorMaxA;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        this.calcG = this.calcR = this.colorScale ? f / this.colorMaxX : f;
        this.calcB = this.calcR;
        this.calcA = this.colorScale ? f2 / this.colorMaxA : f2;
        this.calcRi = (int)(this.calcR * 255.0f);
        this.calcGi = (int)(this.calcG * 255.0f);
        this.calcBi = (int)(this.calcB * 255.0f);
        this.calcAi = (int)(this.calcA * 255.0f);
        this.calci = this.calcAi << 24 | this.calcRi << 16 | this.calcGi << 8 | this.calcBi;
        this.calcAlpha = this.calcAi != 255;
    }

    private void calc_color(float f, float f2, float f3) {
        this.calc_color(f, f2, f3, this.colorMaxA);
    }

    private void calc_color(float f, float f2, float f3, float f4) {
        if (f > this.colorMaxX) {
            f = this.colorMaxX;
        }
        if (f2 > this.colorMaxY) {
            f2 = this.colorMaxY;
        }
        if (f3 > this.colorMaxZ) {
            f3 = this.colorMaxZ;
        }
        if (f4 > this.colorMaxA) {
            f4 = this.colorMaxA;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        block0 : switch (this._colorMode) {
            case 0: {
                if (this.colorScale) {
                    this.calcR = f / this.colorMaxX;
                    this.calcG = f2 / this.colorMaxY;
                    this.calcB = f3 / this.colorMaxZ;
                    this.calcA = f4 / this.colorMaxA;
                    break;
                }
                this.calcR = f;
                this.calcG = f2;
                this.calcB = f3;
                this.calcA = f4;
                break;
            }
            case 1: {
                f /= this.colorMaxX;
                f3 /= this.colorMaxZ;
                float f5 = this.calcA = this.colorScale ? f4 / this.colorMaxA : f4;
                if ((f2 /= this.colorMaxY) == 0.0f) {
                    this.calcG = this.calcB = f3;
                    this.calcR = this.calcB;
                    break;
                }
                float f6 = (f - (float)((int)f)) * 6.0f;
                float f7 = f6 - (float)((int)f6);
                float f8 = f3 * (1.0f - f2);
                float f9 = f3 * (1.0f - f2 * f7);
                float f10 = f3 * (1.0f - f2 * (1.0f - f7));
                switch ((int)f6) {
                    case 0: {
                        this.calcR = f3;
                        this.calcG = f10;
                        this.calcB = f8;
                        break block0;
                    }
                    case 1: {
                        this.calcR = f9;
                        this.calcG = f3;
                        this.calcB = f8;
                        break block0;
                    }
                    case 2: {
                        this.calcR = f8;
                        this.calcG = f3;
                        this.calcB = f10;
                        break block0;
                    }
                    case 3: {
                        this.calcR = f8;
                        this.calcG = f9;
                        this.calcB = f3;
                        break block0;
                    }
                    case 4: {
                        this.calcR = f10;
                        this.calcG = f8;
                        this.calcB = f3;
                        break block0;
                    }
                    case 5: {
                        this.calcR = f3;
                        this.calcG = f8;
                        this.calcB = f9;
                        break block0;
                    }
                }
                break;
            }
        }
        this.calcRi = (int)(255.0f * this.calcR);
        this.calcGi = (int)(255.0f * this.calcG);
        this.calcBi = (int)(255.0f * this.calcB);
        this.calcAi = (int)(255.0f * this.calcA);
        this.calci = this.calcAi << 24 | this.calcRi << 16 | this.calcGi << 8 | this.calcBi;
        this.calcAlpha = this.calcAi != 255;
    }

    private void calc_fill() {
        this._fill = true;
        this.fillChanged = true;
        this.fillR = this.calcR;
        this.fillG = this.calcG;
        this.fillB = this.calcB;
        this.fillA = this.calcA;
        this.fillRi = this.calcRi;
        this.fillGi = this.calcGi;
        this.fillBi = this.calcBi;
        this.fillAi = this.calcAi;
        this.filli = this.calci;
        this.fillAlpha = this.calcAlpha;
    }

    private void calc_stroke() {
        this._stroke = true;
        this.strokeChanged = true;
        this.strokeR = this.calcR;
        this.strokeG = this.calcG;
        this.strokeB = this.calcB;
        this.strokeA = this.calcA;
        this.strokeRi = this.calcRi;
        this.strokeGi = this.calcGi;
        this.strokeBi = this.calcBi;
        this.strokeAi = this.calcAi;
        this.strokei = this.calci;
        this.strokeAlpha = this.calcAlpha;
    }

    private void calc_background() {
        this._background = true;
        this.backR = this.calcR;
        this.backG = this.calcG;
        this.backB = this.calcB;
        this.backRi = this.calcRi;
        this.backGi = this.calcGi;
        this.backBi = this.calcBi;
        this.backi = this.calci;
    }

    public void noFill() {
        this._fill = false;
    }

    public void fill(float f) {
        this.calc_color(f);
        this.calc_fill();
    }

    public void fill(float f, float f2) {
        this.calc_color(f, f2);
        this.calc_fill();
    }

    public void fill(float f, float f2, float f3) {
        this.calc_color(f, f2, f3);
        this.calc_fill();
    }

    public void fill(float f, float f2, float f3, float f4) {
        this.calc_color(f, f2, f3, f4);
        this.calc_fill();
    }

    public void strokeWidth(float f) {
        this._strokeWidth = f;
    }

    public void noStroke() {
        this._stroke = false;
    }

    public void stroke(float f) {
        this.calc_color(f);
        this.calc_stroke();
    }

    public void stroke(float f, float f2) {
        this.calc_color(f, f2);
        this.calc_stroke();
    }

    public void stroke(float f, float f2, float f3) {
        this.calc_color(f, f2, f3);
        this.calc_stroke();
    }

    public void stroke(float f, float f2, float f3, float f4) {
        this.calc_color(f, f2, f3, f4);
        this.calc_stroke();
    }

    public void noBackground() {
        this._background = false;
        this.backi = -1;
    }

    public void background(float f) {
        this.calc_color(f);
        this.calc_background();
    }

    public void background(float f, float f2, float f3) {
        this.calc_color(f, f2, f3);
        this.calc_background();
    }

    public void lights() {
        this.lighting = true;
    }

    public void noLights() {
        this.lighting = false;
    }

    public void hint(int n) {
        this.hints[n] = true;
    }

    public void unhint(int n) {
        this.hints[n] = false;
    }

    public void message(int n, String string) {
        switch (n) {
            case 0: {
                System.err.println("bagel chatter: " + string);
                break;
            }
            case 1: {
                System.err.println("bagel complaint: " + string);
                break;
            }
            case 2: {
                System.err.println("bagel problem: " + string);
                break;
            }
        }
    }

    public void message(int n, String string, Exception exception) {
        this.message(n, string);
        exception.printStackTrace();
    }

    public InputStream getStream(String string) throws IOException {
        InputStream inputStream = null;
        if (applet != null) {
            try {
                URL uRL = new URL(applet.getDocumentBase(), string);
                inputStream = uRL.openStream();
            }
            catch (NullPointerException nullPointerException) {
                applet = null;
            }
        }
        if (applet == null && new File(string).exists()) {
            inputStream = new FileInputStream(string);
        }
        if (inputStream == null) {
            throw new IOException("could not find file " + string + " to open as stream");
        }
        if (string.toLowerCase().endsWith(".gz")) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public final float mag(float f, float f2) {
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public final float mag(float f, float f2, float f3) {
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public final float sq(float f) {
        return f * f;
    }

    public final float sqrt(float f) {
        return (float)Math.sqrt(f);
    }

    public final float pow(float f, float f2) {
        return (float)Math.pow(f, f2);
    }

    public final int min(int n, int n2) {
        return Math.min(n, n2);
    }

    public final int max(int n, int n2) {
        return Math.max(n, n2);
    }

    public final float abs(float f) {
        return f < 0.0f ? -f : f;
    }

    public final float sin(float f) {
        return (float)Math.sin(f);
    }

    public final float cos(float f) {
        return (float)Math.cos(f);
    }

    public final float tan(float f) {
        return (float)Math.tan(f);
    }

    public Bagel(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        this.pixelCount = this.width * this.height;
        this.pixels = new int[this.pixelCount];
        this.depthTest = true;
        this.zbuffer = new float[this.pixelCount];
        this.frameCount = 0;
        this.colorMode(0, 255.0f);
        this.fill(255.0f);
        this.stroke(0.0f);
        this.strokeWidth(1.0f);
        this.background(204.0f);
        this.matrixStackDepth = 0;
        this.setupProjection(3);
        this.lighting = true;
        this._lights = new BagelLight[10];
        this._lights[0] = new BagelLight(0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this._lights[1] = new BagelLight(1, this.eyeX, this.eyeY, this.eyeDist, 1.0f, 1.0f, 1.0f);
        int n3 = 2;
        while (n3 < 10) {
            this._lights[n3] = null;
            ++n3;
        }
        this.shape = false;
        this.shapeKind = 0;
        this.polygon = new BagelPolygon(this);
        this.fpolygon = new BagelPolygon(this);
        this.spolygon = new BagelPolygon(this);
        this.spolygon.vertexCount = 4;
        this.svertices = new float[2][];
        this.circleX = null;
        this.sphereX = null;
        this.currentFont = null;
        this.hints = new boolean[3];
        n3 = 0;
        while (n3 < 3) {
            this.hints[n3] = false;
            ++n3;
        }
    }
}

