/*
 * Decompiled with CFR 0.152.
 */
public class BagelPolygon
implements BagelConstants {
    static final int DEFAULT_SIZE = 64;
    float[][] vertices = new float[64][19];
    int vertexCount;
    float[] r = new float[64];
    float[] dr = new float[64];
    float[] l = new float[64];
    float[] dl = new float[64];
    float[] sp = new float[64];
    float[] sdp = new float[64];
    boolean interpX;
    boolean interpZ;
    boolean interpUV;
    boolean interpRGB;
    int rgba;
    int r2;
    int g2;
    int b2;
    Bagel parent;
    int[] pixels;
    float[] zbuffer;
    boolean noDepthTest;
    BagelImage timage;
    int[] tpixels;
    int theight;
    int twidth;
    int theight1;
    int twidth1;
    int tformat;

    public void reset(int n) {
        this.vertexCount = n;
        this.interpX = true;
        this.interpZ = true;
        this.interpUV = false;
        this.interpRGB = true;
    }

    public float[] nextVertex() {
        if (this.vertexCount == this.vertices.length) {
            this.parent.message(0, "re-allocating for " + this.vertexCount * 2 + " vertices");
            float[][] fArray = new float[this.vertexCount << 1][19];
            System.arraycopy(this.vertices, 0, fArray, 0, this.vertexCount);
            this.vertices = fArray;
            this.r = new float[this.vertices.length];
            this.dr = new float[this.vertices.length];
            this.l = new float[this.vertices.length];
            this.dl = new float[this.vertices.length];
            this.sp = new float[this.vertices.length];
            this.sdp = new float[this.vertices.length];
        }
        return this.vertices[this.vertexCount++];
    }

    public void texture(BagelImage bagelImage) {
        this.timage = bagelImage;
        this.tpixels = bagelImage.pixels;
        this.twidth = bagelImage.width;
        this.theight = bagelImage.height;
        this.tformat = bagelImage.format;
        this.twidth1 = this.twidth - 1;
        this.theight1 = this.theight - 1;
        this.interpUV = true;
    }

    /*
     * Unable to fully structure code
     */
    public void render() {
        if (this.vertexCount < 3) {
            return;
        }
        v0 = this.noDepthTest = this.parent.depthTest == false;
        if (!this.interpRGB) {
            this.r2 = (int)(this.vertices[0][3] * 255.0f);
            this.g2 = (int)(this.vertices[0][4] * 255.0f);
            this.b2 = (int)(this.vertices[0][5] * 255.0f);
            this.rgba = -16777216 | this.r2 << 16 | this.g2 << 8 | this.b2;
        }
        var1_1 = 0;
        while (var1_1 < this.vertexCount) {
            this.r[var1_1] = 0.0f;
            this.dr[var1_1] = 0.0f;
            this.l[var1_1] = 0.0f;
            this.dl[var1_1] = 0.0f;
            ++var1_1;
        }
        var1_1 = 0;
        var2_2 = this.vertices[0][1];
        var3_3 = 1;
        while (var3_3 < this.vertexCount) {
            if (this.vertices[var3_3][1] < var2_2) {
                var2_2 = this.vertices[var3_3][1];
                var1_1 = var3_3;
            }
            ++var3_3;
        }
        var3_3 = var1_1;
        var4_4 = var1_1;
        var5_5 = (int)(var2_2 + 0.5f);
        var6_6 = var5_5 - 1;
        var7_7 = var5_5 - 1;
        this.interpX = true;
        var8_8 = this.vertexCount;
        ** GOTO lbl62
        {
            --var8_8;
            var9_9 = var3_3 != 0 ? var3_3 - 1 : this.vertexCount - 1;
            this.incrementalize_y(this.vertices[var3_3], this.vertices[var9_9], this.l, this.dl, var5_5);
            var6_6 = (int)(this.vertices[var9_9][1] + 0.5f);
            var3_3 = var9_9;
            do {
                if (var6_6 <= var5_5 && var8_8 > 0) continue block4;
                while (var7_7 <= var5_5 && var8_8 > 0) {
                    --var8_8;
                    var9_9 = var4_4 != this.vertexCount - 1 ? var4_4 + 1 : 0;
                    this.incrementalize_y(this.vertices[var4_4], this.vertices[var9_9], this.r, this.dr, var5_5);
                    var7_7 = (int)(this.vertices[var9_9][1] + 0.5f);
                    var4_4 = var9_9;
                }
                while (var5_5 < var6_6 && var5_5 < var7_7) {
                    if (var5_5 >= 0 && var5_5 < this.parent.height) {
                        try {
                            if (this.l[0] <= this.r[0]) {
                                this.scanline(var5_5, this.l, this.r);
                            } else {
                                this.scanline(var5_5, this.r, this.l);
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException var9_10) {
                            var9_10.printStackTrace();
                        }
                    }
                    ++var5_5;
                    this.increment(this.l, this.dl);
                    this.increment(this.r, this.dr);
                }
lbl62:
                // 2 sources

            } while (var8_8 > 0);
        }
    }

    private void scanline(int n, float[] fArray, float[] fArray2) {
        int n2;
        int n3 = 0;
        while (n3 < this.vertexCount) {
            this.sp[n3] = 0.0f;
            this.sdp[n3] = 0.0f;
            ++n3;
        }
        n3 = (int)(fArray[0] + 0.5f);
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = (int)(fArray2[0] - 0.5f)) > this.parent.width1) {
            n2 = this.parent.width1;
        }
        if (n3 > n2) {
            return;
        }
        this.incrementalize_x(fArray, fArray2, this.sp, this.sdp, n3);
        this.interpX = false;
        int n4 = this.parent.width * n;
        int n5 = n3;
        while (n5 <= n2) {
            if (this.noDepthTest || this.sp[2] <= this.zbuffer[n4 + n5]) {
                if (this.interpUV) {
                    int n6 = (int)this.sp[8] * this.twidth + (int)this.sp[7];
                    if (this.sp[8] < 0.0f) {
                        n6 = (int)this.sp[7];
                    }
                    switch (this.tformat) {
                        case 1: {
                            int n7;
                            int n8;
                            int n9;
                            int n10;
                            int n11;
                            int n12;
                            int n13;
                            int n14;
                            int n15;
                            int n16;
                            int n17;
                            int n18;
                            int n19;
                            int n20;
                            int n21;
                            int n22;
                            int n23;
                            if (this.parent.hints[0]) {
                                n23 = (int)this.sp[7];
                                n22 = (int)this.sp[8];
                                n21 = (int)(255.0f * (this.sp[7] - (float)n23));
                                n20 = (int)(255.0f * (this.sp[8] - (float)n22));
                                n19 = 255 - n21;
                                n18 = 255 - n20;
                                n17 = this.tpixels[n6];
                                n16 = n22 != this.theight - 1 ? this.tpixels[n6 + this.twidth] : this.tpixels[n6];
                                n15 = n23 != this.twidth - 1 ? this.tpixels[n6 + 1] : this.tpixels[n6];
                                n14 = n23 != this.theight - 1 && n22 != this.twidth - 1 ? this.tpixels[n6 + this.twidth + 1] : this.tpixels[n6];
                                n13 = n17 >> 16 & 0xFF;
                                n12 = n16 >> 16 & 0xFF;
                                n11 = n15 >> 16 & 0xFF;
                                n10 = n14 >> 16 & 0xFF;
                                n9 = n13 * n19 + n11 * n21 >> 8;
                                n8 = n12 * n19 + n10 * n21 >> 8;
                                n7 = n9 * n18 + n8 * n20 >> 8 << 16;
                                n13 = n17 >> 8 & 0xFF;
                                n12 = n16 >> 8 & 0xFF;
                                n11 = n15 >> 8 & 0xFF;
                                n10 = n14 >> 8 & 0xFF;
                                n9 = n13 * n19 + n11 * n21 >> 8;
                                n8 = n12 * n19 + n10 * n21 >> 8;
                                n7 |= n9 * n18 + n8 * n20 >> 8 << 8;
                                n13 = n17 & 0xFF;
                                n12 = n16 & 0xFF;
                                n11 = n15 & 0xFF;
                                n10 = n14 & 0xFF;
                                n9 = n13 * n19 + n11 * n21 >> 8;
                                n8 = n12 * n19 + n10 * n21 >> 8;
                                this.pixels[n4 + n5] = 0xFF000000 | n7 | n9 * n18 + n8 * n20 >> 8;
                                this.zbuffer[n4 + n5] = this.sp[2];
                                break;
                            }
                            this.pixels[n4 + n5] = this.tpixels[n6];
                            this.zbuffer[n4 + n5] = this.sp[2];
                            break;
                        }
                        case 2: {
                            int n7;
                            int n8;
                            int n9;
                            int n10;
                            int n11;
                            int n12;
                            int n13;
                            int n14;
                            int n15;
                            int n16;
                            int n17;
                            int n18;
                            int n19;
                            int n23 = this.pixels[n4 + n5] >> 16 & 0xFF;
                            int n22 = this.pixels[n4 + n5] >> 8 & 0xFF;
                            int n21 = this.pixels[n4 + n5] & 0xFF;
                            if (this.interpRGB) {
                                this.r2 = (int)(this.sp[3] * 255.0f);
                                this.g2 = (int)(this.sp[4] * 255.0f);
                                this.b2 = (int)(this.sp[5] * 255.0f);
                            }
                            int n20 = this.tpixels[n6];
                            if (this.parent.hints[0]) {
                                n19 = (int)this.sp[7];
                                n18 = (int)this.sp[8];
                                n17 = (int)(255.0f * (this.sp[7] - (float)n19));
                                n16 = (int)(255.0f * (this.sp[8] - (float)n18));
                                n15 = 255 - n17;
                                n14 = 255 - n16;
                                n13 = this.tpixels[n6];
                                n12 = n18 != this.theight - 1 ? this.tpixels[n6 + this.twidth] : this.tpixels[n6];
                                n11 = n19 != this.twidth - 1 ? this.tpixels[n6 + 1] : this.tpixels[n6];
                                n10 = n19 != this.theight - 1 && n18 != this.twidth - 1 ? this.tpixels[n6 + this.twidth + 1] : this.tpixels[n6];
                                n9 = n13 & 0xFF;
                                n8 = n12 & 0xFF;
                                n7 = n11 & 0xFF;
                                int n24 = n10 & 0xFF;
                                int n25 = n9 * n15 + n7 * n17 >> 8;
                                int n26 = n8 * n15 + n24 * n17 >> 8;
                                n20 = n25 * n14 + n26 * n16 >> 8;
                            }
                            n19 = 255 - n20;
                            this.pixels[n4 + n5] = 0xFF000000 | n23 * n19 + this.r2 * n20 >> 8 << 16 | n22 * n19 + this.g2 * n20 >> 8 << 8 | n21 * n19 + this.b2 * n20 >> 8;
                            if (n20 <= 127) break;
                            this.zbuffer[n4 + n5] = this.sp[2];
                        }
                    }
                } else {
                    this.zbuffer[n4 + n5] = this.sp[2];
                    this.pixels[n4 + n5] = this.interpRGB ? 0xFF000000 | (int)(this.sp[3] * 255.0f) << 16 | (int)(this.sp[4] * 255.0f) << 8 | (int)(this.sp[5] * 255.0f) : this.rgba;
                }
            }
            this.increment(this.sp, this.sdp);
            ++n5;
        }
        this.interpX = true;
    }

    private void incrementalize_y(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int n) {
        float f = fArray2[1] - fArray[1];
        if (f == 0.0f) {
            f = 1.0f;
        }
        float f2 = (float)n + 0.5f - fArray[1];
        if (this.interpX) {
            fArray4[0] = (fArray2[0] - fArray[0]) / f;
            fArray3[0] = fArray[0] + fArray4[0] * f2;
        }
        if (this.interpZ) {
            fArray4[2] = (fArray2[2] - fArray[2]) / f;
            fArray3[2] = fArray[2] + fArray4[2] * f2;
        }
        if (this.interpRGB) {
            fArray4[3] = (fArray2[3] - fArray[3]) / f;
            fArray4[4] = (fArray2[4] - fArray[4]) / f;
            fArray4[5] = (fArray2[5] - fArray[5]) / f;
            fArray3[3] = fArray[3] + fArray4[3] * f2;
            fArray3[4] = fArray[4] + fArray4[4] * f2;
            fArray3[5] = fArray[5] + fArray4[5] * f2;
        }
        if (this.interpUV) {
            fArray4[7] = (fArray2[7] - fArray[7]) / f;
            fArray4[8] = (fArray2[8] - fArray[8]) / f;
            fArray3[7] = fArray[7] + fArray4[7] * f2;
            fArray3[8] = fArray[8] + fArray4[8] * f2;
        }
    }

    private void incrementalize_x(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int n) {
        float f = fArray2[0] - fArray[0];
        if (f == 0.0f) {
            f = 1.0f;
        }
        float f2 = (float)n + 0.5f - fArray[0];
        if (this.interpX) {
            fArray4[0] = (fArray2[0] - fArray[0]) / f;
            fArray3[0] = fArray[0] + fArray4[0] * f2;
        }
        if (this.interpZ) {
            fArray4[2] = (fArray2[2] - fArray[2]) / f;
            fArray3[2] = fArray[2] + fArray4[2] * f2;
        }
        if (this.interpRGB) {
            fArray4[3] = (fArray2[3] - fArray[3]) / f;
            fArray4[4] = (fArray2[4] - fArray[4]) / f;
            fArray4[5] = (fArray2[5] - fArray[5]) / f;
            fArray3[3] = fArray[3] + fArray4[3] * f2;
            fArray3[4] = fArray[4] + fArray4[4] * f2;
            fArray3[5] = fArray[5] + fArray4[5] * f2;
        }
        if (this.interpUV) {
            fArray4[7] = (fArray2[7] - fArray[7]) / f;
            fArray4[8] = (fArray2[8] - fArray[8]) / f;
            fArray3[7] = fArray[7] + fArray4[7] * f2;
            fArray3[8] = fArray[8] + fArray4[8] * f2;
        }
    }

    private void increment(float[] fArray, float[] fArray2) {
        if (this.interpX) {
            fArray[0] = fArray[0] + fArray2[0];
        }
        if (this.interpZ) {
            fArray[2] = fArray[2] + fArray2[2];
        }
        if (this.interpRGB) {
            fArray[3] = fArray[3] + fArray2[3];
            fArray[4] = fArray[4] + fArray2[4];
            fArray[5] = fArray[5] + fArray2[5];
        }
        if (this.interpUV) {
            fArray[7] = fArray[7] + fArray2[7];
            fArray[8] = fArray[8] + fArray2[8];
        }
    }

    public BagelPolygon(Bagel bagel) {
        this.parent = bagel;
        this.pixels = this.parent.pixels;
        this.zbuffer = this.parent.zbuffer;
        this.reset(0);
    }
}

