/*
 * Decompiled with CFR 0.152.
 */
class Edge
implements BagelConstants {
    static int maxCount = 300;
    static int likeMax = 2;
    static int drawingMode = 3;
    static final int EDGE_STEP_COUNT = 50;
    static final float EDGE_STEPS = 50.0f;
    static final float EDGE_STEP_SIZE = 0.02f;
    static float lineWidth = 1.0f;
    static float x0;
    static float y0;
    static float z0;
    static float x1;
    static float y1;
    static float z1;
    Valence parent;
    Node from;
    Node to;
    int visitTime;
    Edge like;
    int likeCount;
    Edge prev;
    Edge next;
    int width1;
    int height1;
    float strokeR;
    float strokeG;
    float strokeB;
    float strokeA;
    int strokeRi;
    int strokeGi;
    int strokeBi;
    int strokeAi;
    int strokei;

    public void draw(Bagel bagel) {
        if (this.likeCount != 1) {
            return;
        }
        bagel.strokeWidth(lineWidth);
        switch (drawingMode) {
            case 1: {
                this.drawSpikey(bagel);
                break;
            }
            case 2: {
                this.drawSpherey(bagel);
                break;
            }
            case 3: {
                this.drawSaveMyAss(bagel);
                break;
            }
        }
    }

    static final float cos(float f) {
        return (float)Math.cos(f);
    }

    static final float sin(float f) {
        return (float)Math.sin(f);
    }

    static final float log(float f) {
        return (float)Math.log(f);
    }

    static final float sqrt(float f) {
        return (float)Math.sqrt(f);
    }

    static final float LEN(float f, float f2, float f3) {
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    static final float abs(float f) {
        return Math.abs(f);
    }

    static final float min(float f, float f2) {
        return Math.min(f, f2);
    }

    static final float max(float f, float f2) {
        return Math.max(f, f2);
    }

    static void transformCoords(float f, float f2, float f3, boolean bl) {
        float f4 = f * ((float)Math.PI * 2);
        float f5 = f2 * (float)Math.PI;
        float f6 = f3 * ((float)Math.PI * 2);
        if (bl) {
            x0 = f6 * Edge.cos(f4) * Edge.sin(f5);
            y0 = f6 * Edge.sin(f4) * Edge.sin(f5);
            z0 = f6 * Edge.cos(f5);
        } else {
            x1 = f6 * Edge.cos(f4) * Edge.sin(f5);
            y1 = f6 * Edge.sin(f4) * Edge.sin(f5);
            z1 = f6 * Edge.cos(f5);
        }
    }

    void drawSpikey(Bagel bagel) {
        float f;
        float f2;
        float f3;
        bagel.colorMode(1);
        bagel.noFill();
        Edge.transformCoords(this.from.x, this.from.y, this.from.z, true);
        float f4 = Edge.LEN(x0, y0, z0);
        float f5 = Edge.log(this.from.totalVisitCount) / Edge.log(this.parent.edgeCount);
        float f6 = Edge.LEN(this.from.vx, this.from.vy, this.from.vz) * 1.5f;
        Edge.transformCoords(this.to.x, this.to.y, this.to.z, false);
        float f7 = Edge.LEN(x1, y1, z1);
        float f8 = Edge.log(this.to.totalVisitCount) / Edge.log(this.parent.edgeCount);
        float f9 = Edge.LEN(this.to.vx, this.to.vy, this.to.vz) * 1.5f;
        float f10 = (x0 + x1) / 2.0f;
        float f11 = (y0 + y1) / 2.0f;
        float f12 = (z0 + z1) / 2.0f;
        float f13 = (f5 + f8) / 2.0f;
        float f14 = (f6 + f9) / 2.0f;
        float f15 = f5 * 8.0f;
        float f16 = f8 * 8.0f;
        float f17 = (f15 + f16) / 2.0f;
        float f18 = Edge.LEN(f10, f11, f12);
        float f19 = f17 / f18;
        f10 *= f19;
        f11 *= f19;
        f12 *= f19;
        f18 = f17;
        float f20 = 0.0f;
        float f21 = 0.0f;
        float f22 = 0.0f;
        float f23 = 0.0f;
        float f24 = (f10 - x0) / 50.0f;
        float f25 = (f11 - y0) / 50.0f;
        float f26 = (f12 - z0) / 50.0f;
        float f27 = (f13 - f5) / 50.0f;
        float f28 = (f14 - f6) / 50.0f;
        float f29 = (f18 - f4) / 50.0f;
        float f30 = 1.0f;
        int n = 0;
        while (n <= 50) {
            if (n != 0) {
                f30 = f4 / Edge.LEN(x0, y0, z0);
                bagel.stroke(0.8f + f6, 0.5f, 1.0f, f5);
                bagel.line(f20 * f23, f21 * f23, f22 * f23, x0 * f30, y0 * f30, z0 * f30);
            }
            f20 = x0;
            f21 = y0;
            f22 = z0;
            f3 = f5;
            f2 = f6;
            f = f4;
            f23 = f30;
            x0 += f24;
            y0 += f25;
            z0 += f26;
            f5 += f27;
            f6 += f28;
            f4 += f29;
            ++n;
        }
        f24 = (x1 - f10) / 50.0f;
        f25 = (y1 - f11) / 50.0f;
        f26 = (z1 - f12) / 50.0f;
        f27 = (f8 - f13) / 50.0f;
        f28 = (f9 - f14) / 50.0f;
        f29 = (f7 - f18) / 50.0f;
        x0 = f10;
        y0 = f11;
        z0 = f12;
        f5 = f13;
        f6 = f14;
        f4 = f18;
        f30 = 1.0f;
        n = 0;
        while (n <= 50) {
            if (n != 0) {
                f30 = f4 / Edge.LEN(x0, y0, z0);
                bagel.stroke(0.8f + f6, 0.5f, 1.0f, f5);
                bagel.line(f20 * f23, f21 * f23, f22 * f23, x0 * f30, y0 * f30, z0 * f30);
            }
            f20 = x0;
            f21 = y0;
            f22 = z0;
            f3 = f5;
            f2 = f6;
            f = f4;
            f23 = f30;
            x0 += f24;
            y0 += f25;
            z0 += f26;
            f5 += f27;
            f6 += f28;
            f4 += f29;
            ++n;
        }
    }

    void drawSpherey(Bagel bagel) {
        bagel.colorMode(0, 1.0f);
        bagel.noFill();
        Edge.transformCoords(this.from.x, this.from.y, this.from.z, true);
        float f = Edge.log(this.from.totalVisitCount) / Edge.log(this.parent.edgeCount);
        Edge.transformCoords(this.to.x, this.to.y, this.to.z, false);
        float f2 = Edge.log(this.to.totalVisitCount) / Edge.log(this.parent.edgeCount);
        float f3 = Edge.sqrt(x0 * x0 + y0 * y0 + z0 * z0);
        float f4 = Edge.sqrt(x1 * x1 + y1 * y1 + z1 * z1);
        float f5 = (x0 + x1) / 2.0f;
        float f6 = (y0 + y1) / 2.0f;
        float f7 = (z0 + z1) / 2.0f;
        float f8 = Edge.LEN(f5, f6, f7);
        if (f8 != 0.0f) {
            f5 /= f8;
            f6 /= f8;
            f7 /= f8;
        }
        float f9 = Edge.abs(-f4 - f3);
        float f10 = 1.0f - f9 / 2.0f;
        f5 *= f10;
        float f11 = (f2 + f) / 2.0f;
        float f12 = 0.0f;
        float f13 = 0.1f;
        float f14 = 0.0f;
        this.interpSpherey(bagel, x0, y0, z0, f, f12, f5, f6 *= f10, f7 *= f10, f11, f13, 4);
        this.interpSpherey(bagel, f5, f6, f7, f11, f13, x1, y1, z1, f2, f14, 4);
    }

    void interpSpherey(Bagel bagel, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, int n) {
        if (n == 0) {
            bagel.stroke(0.0f, 0.5f, 1.0f, f4);
            bagel.line(f, f2, f3, f6, f7, f8);
            return;
        }
        float f11 = (Edge.LEN(f, f2, f3) + Edge.LEN(f6, f7, f8)) / 2.0f;
        float f12 = (f + f6) / 2.0f;
        float f13 = (f2 + f7) / 2.0f;
        float f14 = (f3 + f8) / 2.0f;
        float f15 = Edge.LEN(f12, f13, f14);
        if (f15 != 0.0f) {
            f12 /= f15;
            f13 /= f15;
            f14 /= f15;
        }
        float f16 = (f4 + f9) / 2.0f;
        float f17 = (f5 + f10) / 2.0f;
        this.interpSpherey(bagel, f, f2, f3, f4, f5, f12 *= f11, f13 *= f11, f14 *= f11, f16, f17, n - 1);
        this.interpSpherey(bagel, f12, f13, f14, f16, f17, f6, f7, f8, f9, f17, n - 1);
    }

    void drawSaveMyAss(Bagel bagel) {
        Edge.transformCoords(this.from.x, this.from.y, this.from.z, true);
        float f = Edge.LEN(x0, y0, z0);
        float f2 = Edge.log(this.from.totalVisitCount) / Edge.log(this.parent.edgeCount);
        float f3 = Edge.LEN(this.from.vx, this.from.vy, this.from.vz) * 1.5f;
        Edge.transformCoords(this.to.x, this.to.y, this.to.z, false);
        float f4 = Edge.LEN(x1, y1, z1);
        float f5 = Edge.log(this.to.totalVisitCount) / Edge.log(this.parent.edgeCount);
        float f6 = Edge.LEN(this.to.vx, this.to.vy, this.to.vz) * 1.5f;
        int n = 0;
        int n2 = 0;
        float f7 = (x1 - x0) / 50.0f;
        float f8 = (y1 - y0) / 50.0f;
        float f9 = (z1 - z0) / 50.0f;
        float f10 = (f4 - f) / 50.0f;
        float f11 = (f5 - f2) / 50.0f;
        float f12 = (f6 - f3) / 50.0f;
        int n3 = 0;
        while (n3 <= 50) {
            float f13 = f / Edge.LEN(x0, y0, z0);
            if (this.parent.whoami == 0) {
                this.hsb(0.4f + f3 * 3.0f, 0.8f, 1.0f, f2 * 1.5f);
            } else {
                this.hsb(0.8f + f3, 0.5f, 1.0f, f2);
            }
            float f14 = x0 * f13;
            float f15 = y0 * f13;
            float f16 = z0 * f13;
            bagel.projectPoint(f14, f15, f16);
            int n4 = (int)bagel.projX;
            int n5 = (int)bagel.projY;
            if (n3 != 0) {
                this.thin_flat_line(n4, n5, n, n2);
            }
            n = n4;
            n2 = n5;
            x0 += f7;
            y0 += f8;
            z0 += f9;
            f2 += f11;
            f3 += f12;
            f += f10;
            ++n3;
        }
    }

    private void thin_flat_line(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        if (n < 0 || n2 < 0 || n3 > this.width1 || n4 > this.height1) {
            float f = n;
            float f2 = n2;
            float f3 = n3;
            float f4 = n4;
            n12 = this.thin_flat_lineClipCode(n, n2);
            n11 = this.thin_flat_lineClipCode(n3, n4);
            while ((n12 | n11) != 0) {
                if ((n12 & n11) != 0) {
                    return;
                }
                float f5 = f3 - f;
                float f6 = f4 - f2;
                if (n12 != 0) {
                    if ((n12 & 8) == 8) {
                        f2 += (0.0f - f) * f6 / f5;
                        f = 0.0f;
                    } else if ((n12 & 4) == 4) {
                        f2 += ((float)this.width1 - f) * f6 / f5;
                        f = this.width1;
                    } else if ((n12 & 2) == 2) {
                        f += (0.0f - f2) * f5 / f6;
                        f2 = 0.0f;
                    } else if ((n12 & 1) == 1) {
                        f += ((float)this.height1 - f2) * f5 / f6;
                        f2 = this.height1;
                    }
                    n12 = this.thin_flat_lineClipCode(f, f2);
                    continue;
                }
                if (n11 == 0) continue;
                if ((n11 & 8) == 8) {
                    f4 += (0.0f - f3) * f6 / f5;
                    f3 = 0.0f;
                } else if ((n11 & 4) == 4) {
                    f4 += ((float)this.width1 - f3) * f6 / f5;
                    f3 = this.width1;
                } else if ((n11 & 2) == 2) {
                    f3 += (0.0f - f4) * f5 / f6;
                    f4 = 0.0f;
                } else if ((n11 & 1) == 1) {
                    f3 += ((float)this.height1 - f4) * f5 / f6;
                    f4 = this.height1;
                }
                n11 = this.thin_flat_lineClipCode(f3, f4);
            }
            n = (int)f;
            n2 = (int)f2;
            n3 = (int)f3;
            n4 = (int)f4;
        }
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == n3) {
            int n17;
            int n18;
            n11 = n;
            if (n2 < n4) {
                n18 = n2;
                n17 = n4;
            } else {
                n18 = n4;
                n17 = n2;
            }
            int n19 = n18;
            while (n19 <= n17) {
                this.thin_point(n11, n19);
                ++n19;
            }
            return;
        }
        float f = (float)(n4 - n2) / (float)(n3 - n);
        int n20 = f >= 0.0f && f <= 1.0f ? 1 : (f > 1.0f ? 2 : (f < -1.0f ? 3 : 4));
        if ((n20 == 1 || n20 == 2 || n20 == 4) && n > n3 || n20 == 3 && n < n3) {
            n10 = n3;
            n9 = n;
            n8 = n4;
            n7 = n2;
        } else {
            n10 = n;
            n8 = n2;
            n9 = n3;
            n7 = n4;
        }
        int n21 = n9 - n10;
        int n22 = n7 - n8;
        if (n20 == 1) {
            n13 = n21;
            n12 = 2 * n22 - n21;
            n15 = 1;
            n6 = 2 * n22;
            n5 = 2 * (n22 - n21);
        } else if (n20 == 2) {
            n14 = n22;
            n12 = 2 * n21 - n22;
            n16 = 1;
            n6 = 2 * n21;
            n5 = 2 * (n21 - n22);
        } else if (n20 == 3) {
            n14 = -n22;
            n12 = -2 * n21 - n22;
            n16 = -1;
            n6 = -2 * n21;
            n5 = -2 * (n21 + n22);
        } else {
            n13 = -n21;
            n12 = -2 * n22 - n21;
            n15 = -1;
            n6 = -2 * n22;
            n5 = -2 * (n22 + n21);
        }
        if (n20 == 1 || n20 == 4) {
            int n23 = 0;
            float f7 = 1.0f / (2.0f * Edge.sqrt(n21 * n21 + n22 * n22));
            float f8 = (float)(2 * n13) * f7;
            n11 = n10;
            int n24 = n8;
            this.thin_point(n11, n24);
            while (n11 < n9) {
                if (n12 < 0) {
                    n23 = n12 + n21;
                    n12 += n6;
                    ++n11;
                } else {
                    n23 = n12 - n21;
                    n12 += n5;
                    ++n11;
                    n24 += n15;
                }
                float f9 = (float)n23 * f7;
                this.thin_point(n11, n24);
            }
        } else {
            int n25 = 0;
            float f10 = 1.0f / (2.0f * Edge.sqrt(n21 * n21 + n22 * n22));
            float f11 = (float)(2 * n14) * f10;
            n11 = n10;
            int n26 = n8;
            this.thin_point(n11, n26);
            while (n26 < n7) {
                if (n12 < 0) {
                    n25 = n12 + n22;
                    n12 += n6;
                    ++n26;
                } else {
                    n25 = n12 - n22;
                    n12 += n5;
                    ++n26;
                    n11 += n16;
                }
                float f12 = (float)n25 * f10;
                this.thin_point(n11, n26);
            }
        }
    }

    private int thin_flat_lineClipCode(float f, float f2) {
        return (f < 0.0f ? 8 : 0) | (f > (float)this.width1 ? 4 : 0) | (f2 < 0.0f ? 2 : 0) | (f2 > (float)this.height1 ? 1 : 0);
    }

    private void thin_point(int n, int n2) {
        if (n < 0 || n > this.width1 || n2 < 0 || n2 > this.height1) {
            return;
        }
        int n3 = n2 * this.parent.width + n;
        int n4 = this.parent.pixels[n3];
        int n5 = this.strokei;
        int n6 = this.strokeAi;
        n6 = n6 * (n5 >> 24 & 0xFF) >> 8;
        int n7 = 255 - n6;
        int n8 = n7 * (n4 >> 16 & 0xFF) + n6 * (n5 >> 16 & 0xFF) >> 8;
        int n9 = n7 * (n4 >> 8 & 0xFF) + n6 * (n5 >> 8 & 0xFF) >> 8;
        int n10 = n7 * (n4 & 0xFF) + n6 * (n5 & 0xFF) >> 8;
        this.parent.pixels[n3] = 0xFF000000 | n8 << 16 | n9 << 8 | n10;
    }

    public void hsb(float f, float f2, float f3, float f4) {
        float f5 = f4 > 1.0f ? 1.0f : (this.strokeA = f4 < 0.0f ? 0.0f : f4);
        if (f2 == 0.0f) {
            this.strokeG = this.strokeB = f3;
            this.strokeR = this.strokeB;
        } else {
            float f6 = (f - (float)((int)f)) * 6.0f;
            float f7 = f6 - (float)((int)f6);
            float f8 = f3 * (1.0f - f2);
            float f9 = f3 * (1.0f - f2 * f7);
            float f10 = f3 * (1.0f - f2 * (1.0f - f7));
            switch ((int)f6) {
                case 0: {
                    this.strokeR = f3;
                    this.strokeG = f10;
                    this.strokeB = f8;
                    break;
                }
                case 1: {
                    this.strokeR = f9;
                    this.strokeG = f3;
                    this.strokeB = f8;
                    break;
                }
                case 2: {
                    this.strokeR = f8;
                    this.strokeG = f3;
                    this.strokeB = f10;
                    break;
                }
                case 3: {
                    this.strokeR = f8;
                    this.strokeG = f9;
                    this.strokeB = f3;
                    break;
                }
                case 4: {
                    this.strokeR = f10;
                    this.strokeG = f8;
                    this.strokeB = f3;
                    break;
                }
                case 5: {
                    this.strokeR = f3;
                    this.strokeG = f8;
                    this.strokeB = f9;
                    break;
                }
            }
        }
        this.strokeRi = (int)(255.0f * this.strokeR);
        this.strokeGi = (int)(255.0f * this.strokeG);
        this.strokeBi = (int)(255.0f * this.strokeB);
        this.strokeAi = (int)(255.0f * this.strokeA);
        this.strokei = this.strokeAi << 24 | this.strokeRi << 16 | this.strokeGi << 8 | this.strokeBi;
    }

    void applyNodeAttraction(float f) {
        float f2 = this.to.x - this.from.x;
        float f3 = this.to.y - this.from.y;
        float f4 = this.to.z - this.from.z;
        float f5 = Edge.max(Edge.LEN(f2, f3, f4) - 0.05f, 0.0f);
        this.to.fx -= f2 * (f5 *= 1.0f);
        this.to.fy -= f3 * f5;
        this.to.fz -= f4 * f5;
        this.from.fx += f2 * f5;
        this.from.fy += f3 * f5;
        this.from.fz += f4 * f5;
    }

    public Edge(Valence valence, Node node, Node node2) {
        this.parent = valence;
        this.from = node;
        this.to = node2;
        this.visitTime = valence.newestNodeTime;
        this.like = null;
        this.likeCount = 1;
        this.next = null;
        this.prev = null;
        this.width1 = valence.width - 1;
        this.height1 = valence.height - 1;
    }
}

