/*
 * Decompiled with CFR 0.152.
 */
class Node
implements BagelConstants {
    static final int maxCount = 150;
    static final float BETWEEN = 0.05f;
    static final float ATTRACTION = 1.0f;
    static final float FORCE_FRACTION = 0.01f;
    static final float VEL_FRACTION = 0.8f;
    static final float VEL_DAMP = 0.8f;
    static final int FTABLE_MAX = 1024;
    static int ftableCount = 0;
    static String[] ftableWord = new String[1024];
    static float[] ftableWeight = new float[1024];
    static boolean usingTwain = true;
    static boolean usingText = true;
    Valence parent;
    int incomingVisitCount;
    int outgoingVisitCount;
    int totalVisitCount;
    int lastVisitTime;
    float x;
    float y;
    float z;
    float vx;
    float vy;
    float vz;
    float fx;
    float fy;
    float fz;
    float width;
    float handicap;
    int lit;
    String label;
    Node prev;
    Node next;
    float cx;
    float cy;
    float cz;

    void draw(Bagel bagel) {
        if (usingText) {
            Edge.transformCoords(this.x, this.y, this.z, true);
            if (Edge.z0 > 0.3f || Edge.z0 < -0.3f) {
                float f = Edge.x0;
                float f2 = Edge.y0;
                float f3 = Edge.z0;
                bagel.push();
                float f4 = 0.3f;
                bagel.translate(f - f4 * this.width / 2.0f, f2, f3);
                bagel.scale(f4);
                bagel.colorMode(0);
                float f5 = (Math.abs(f3) < 1.0f ? Math.abs(f3) : 1.0f) * 0.8f;
                bagel.fill(f5, 0.9f * f5, 0.6f * f5);
                if (usingTwain) {
                    bagel.rotateY((float)Math.atan2(f, f3));
                }
                bagel.text(this.label, 0.0f, 0.0f);
                bagel.pop();
            }
        }
    }

    void calc() {
        float f = (float)this.totalVisitCount * this.handicap;
        Node node = this.parent.headNode;
        while (node != null) {
            float f2 = (float)node.totalVisitCount * node.handicap;
            if (f2 < f && node.z > this.z) {
                float f3 = node.z - this.z;
                node.fz -= f3 * 0.6f;
                this.fz += f3 * 0.6f;
            }
            node = node.next;
        }
    }

    void move() {
        this.vx += this.fx * 0.01f;
        this.vy += this.fy * 0.01f;
        this.vz += this.fz * 0.01f;
        this.x += this.vx * 0.8f;
        this.y += this.vy * 0.8f;
        this.z += this.vz * 0.8f;
        this.vx *= 0.8f;
        this.vy *= 0.8f;
        this.vz *= 0.8f;
        this.fx = 0.0f;
        this.fy = 0.0f;
        this.fz = 0.0f;
    }

    public Node(Valence valence, String string, int n, float f, float f2, float f3) {
        this.parent = valence;
        this.label = string;
        this.width = this.parent.wordFont.stringWidth(string);
        this.lastVisitTime = n;
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.vz = 0.0f;
        this.vy = 0.0f;
        this.vx = 0.0f;
        this.fz = 0.0f;
        this.fy = 0.0f;
        this.fx = 0.0f;
        this.incomingVisitCount = 0;
        this.outgoingVisitCount = 0;
        this.totalVisitCount = 0;
        this.handicap = 1.0f;
        if (usingTwain) {
            int n2 = 0;
            while (n2 < ftableCount) {
                if (string.equals(ftableWord[n2])) {
                    this.handicap = ftableWeight[n2];
                    this.handicap *= this.handicap;
                }
                ++n2;
            }
        }
        this.lit = 0;
        this.next = null;
        this.prev = null;
    }
}

