/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;

public class ProcessingApplet
extends Applet
implements BagelConstants,
Runnable,
MouseListener,
MouseMotionListener,
KeyListener {
    static byte[] tiffHeader = new byte[]{77, 77, 0, 42, 0, 0, 0, 8, 0, 9, 0, -2, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 3, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 3, 0, 0, 0, 1, 0, 0, 0, 0, 1, 2, 0, 3, 0, 0, 0, 3, 0, 0, 0, 122, 1, 6, 0, 3, 0, 0, 0, 1, 0, 2, 0, 0, 1, 17, 0, 4, 0, 0, 0, 1, 0, 0, 3, 0, 1, 21, 0, 3, 0, 0, 0, 1, 0, 3, 0, 0, 1, 22, 0, 3, 0, 0, 0, 1, 0, 0, 0, 0, 1, 23, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 8, 0, 8};
    public Bagel g;
    public int[] pixels;
    MemoryImageSource mis;
    Image image;
    public int mouseX;
    public int mouseY;
    public boolean mousePressed;
    boolean mousePressedBriefly;
    public int key;
    public boolean keyPressed;
    boolean keyPressedBriefly;
    boolean timing;
    public int millis;
    long actualMillis;
    long millisOffset;
    Calendar calendar;
    boolean drawMethod;
    boolean loopMethod;
    boolean finished;
    boolean drawn;
    Thread thread;
    int width;
    int height;
    DirectColorModel cm = new DirectColorModel(32, 0xFF0000, 65280, 255);
    int screenGrabCount = -1;
    boolean isMacintosh;

    public void init() {
        this.checkParams();
        this.addMouse();
        this.addKeyboard();
        this.addTime();
        this.finished = false;
        this.drawn = false;
        this.drawMethod = true;
        this.loopMethod = true;
        this.setup();
        if (this.g == null) {
            this.size(100, 100);
        }
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
        }
        Thread[] threadArray = new Thread[Thread.activeCount()];
        Thread.enumerate(threadArray);
        int n = 0;
        while (n < threadArray.length) {
            if (threadArray[n].getName().indexOf("Thread-") == 0) {
                threadArray[n].stop();
            }
            ++n;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    void setup() {
    }

    void draw() {
        this.drawMethod = false;
    }

    void loop() {
        this.loopMethod = false;
    }

    public void update() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paint(graphics);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.mis.newPixels(this.pixels, (ColorModel)this.cm, 0, this.width);
        graphics.drawImage(this.image, 0, 0, null);
    }

    public void run() {
        while (Thread.currentThread() == this.thread && !this.finished) {
            if (this.timing) {
                this.actualMillis = System.currentTimeMillis();
                this.millis = (int)(this.actualMillis - this.millisOffset);
                this.calendar = null;
            }
            if (!this.drawn) {
                this.g.beginFrame();
                this.draw();
                if (!this.drawMethod) {
                    // empty if block
                }
                if (this.drawMethod) {
                    this.g.endFrame();
                    this.update();
                    if (this.isMacintosh) {
                        this.getToolkit().sync();
                    }
                    this.finished = true;
                }
                this.drawn = true;
            }
            if (!this.drawMethod) {
                this.g.beginFrame();
                this.loop();
                this.g.endFrame();
                this.update();
                if (this.isMacintosh) {
                    this.getToolkit().sync();
                }
            }
            if (!this.loopMethod) {
                this.finished = true;
            }
            if (this.mousePressedBriefly) {
                this.mousePressedBriefly = false;
                this.mousePressed = false;
            }
            if (this.keyPressedBriefly) {
                this.keyPressedBriefly = false;
                this.keyPressed = false;
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void size(int n, int n2) {
        if (this.g != null) {
            return;
        }
        this.width = n;
        this.height = n2;
        this.g = new Bagel(n, n2);
        this.pixels = this.g.pixels;
        int n3 = 0;
        while (n3 < this.pixels.length) {
            this.pixels[n3] = -1;
            ++n3;
        }
        this.mis = new MemoryImageSource(n, n2, this.pixels, 0, n);
        this.mis.setFullBufferUpdates(true);
        this.mis.setAnimated(true);
        this.image = Toolkit.getDefaultToolkit().createImage(this.mis);
        Bagel.applet = this;
        this.g.lighting = false;
    }

    public void addMouse() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.mousePressedBriefly = true;
        this.mousePressed = true;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mousePressedBriefly = false;
        this.mousePressed = true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mousePressed = false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        this.mousePressed = true;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        this.mousePressed = false;
    }

    public void addKeyboard() {
        this.addKeyListener(this);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.keyPressed = true;
        this.keyPressedBriefly = true;
        this.key = keyEvent.getKeyChar();
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.keyPressed = true;
        this.keyPressedBriefly = false;
        this.key = keyEvent.getKeyChar();
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.keyPressed = false;
        this.key = keyEvent.getKeyChar();
    }

    public void addTime() {
        this.timing = true;
        this.millisOffset = System.currentTimeMillis();
    }

    public int getMillis() {
        return (int)(this.actualMillis - this.millisOffset);
    }

    public int getSecond() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        return this.calendar.get(13);
    }

    public int getMinute() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        return this.calendar.get(12);
    }

    public int getHour() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        return this.calendar.get(11);
    }

    public int getDay() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        return this.calendar.get(5);
    }

    public int getMonth() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        return this.calendar.get(2) + 1;
    }

    public int getYear() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        return this.calendar.get(1);
    }

    public void delay(int n) {
        long l = System.currentTimeMillis() + (long)n;
        while (System.currentTimeMillis() < l) {
        }
    }

    static byte[] makeTiffData(int[] nArray, int n, int n2) {
        byte[] byArray = new byte[768 + n * n2 * 3];
        System.arraycopy(tiffHeader, 0, byArray, 0, tiffHeader.length);
        byArray[30] = (byte)(n >> 8 & 0xFF);
        byArray[31] = (byte)(n & 0xFF);
        byArray[42] = byArray[102] = (byte)(n2 >> 8 & 0xFF);
        byArray[43] = byArray[103] = (byte)(n2 & 0xFF);
        int n3 = n * n2 * 3;
        byArray[114] = (byte)(n3 >> 24 & 0xFF);
        byArray[115] = (byte)(n3 >> 16 & 0xFF);
        byArray[116] = (byte)(n3 >> 8 & 0xFF);
        byArray[117] = (byte)(n3 & 0xFF);
        int n4 = 768;
        int n5 = 0;
        while (n5 < nArray.length) {
            byArray[n4++] = (byte)(nArray[n5] >> 16 & 0xFF);
            byArray[n4++] = (byte)(nArray[n5] >> 8 & 0xFF);
            byArray[n4++] = (byte)(nArray[n5] & 0xFF);
            ++n5;
        }
        return byArray;
    }

    static String pad4(int n) {
        if (n < 10) {
            return "000" + n;
        }
        if (n < 100) {
            return "00" + n;
        }
        if (n < 1000) {
            return "0" + n;
        }
        return String.valueOf(n);
    }

    public void screenGrab() {
        Object object;
        if (this.screenGrabCount == -1) {
            object = null;
            do {
                ++this.screenGrabCount;
            } while (((File)(object = new File("screen-" + ProcessingApplet.pad4(this.screenGrabCount) + ".tif"))).exists());
        }
        try {
            object = new FileOutputStream("screen-" + ProcessingApplet.pad4(this.screenGrabCount++) + ".tif");
            ((FileOutputStream)object).write(ProcessingApplet.makeTiffData(this.pixels, this.width, this.height));
            ((OutputStream)object).flush();
            ((FileOutputStream)object).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void print(boolean bl) {
        System.out.print(bl);
    }

    public void print(int n) {
        System.out.print(n);
    }

    public void print(float f) {
        System.out.print(f);
    }

    public void print(String string) {
        System.out.print(string);
    }

    public void print(Object object) {
        System.out.print(object.toString());
    }

    public void println(boolean bl) {
        this.print(bl);
        System.out.println();
    }

    public void println(int n) {
        this.print(n);
        System.out.println();
    }

    public void println(float f) {
        this.print(f);
        System.out.println();
    }

    public void println(String string) {
        this.print(string);
        System.out.println();
    }

    public void println(Object object) {
        System.out.println(object.toString());
    }

    public void println() {
        System.out.println();
    }

    public int getPixel(int n, int n2) {
        return this.pixels[n2 * this.width + n];
    }

    public void setPixel(int n, int n2, int n3) {
        this.pixels[n2 * this.width + n] = n3;
    }

    public final int red(int n) {
        return n >> 16 & 0xFF;
    }

    public final int green(int n) {
        return n >> 8 & 0xFF;
    }

    public final int blue(int n) {
        return n & 0xFF;
    }

    public final float abs(float f) {
        return f < 0.0f ? -f : f;
    }

    public final float sq(float f) {
        return f * f;
    }

    public final float sqrt(float f) {
        return (float)Math.sqrt(f);
    }

    public final float pow(float f, float f2) {
        return (float)Math.pow(f, f2);
    }

    public final float max(float f, float f2) {
        return Math.max(f, f2);
    }

    public final float max(float f, float f2, float f3) {
        return Math.max(f, Math.max(f2, f3));
    }

    public final float min(float f, float f2) {
        return Math.min(f, f2);
    }

    public final float min(float f, float f2, float f3) {
        return Math.min(f, Math.min(f2, f3));
    }

    public final int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public final int max(int n, int n2, int n3) {
        return n > n2 ? (n > n3 ? n : n3) : n2;
    }

    public final int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public final int min(int n, int n2, int n3) {
        return n < n2 ? (n < n3 ? n : n3) : n2;
    }

    public final float sin(float f) {
        return (float)Math.sin(f);
    }

    public final float cos(float f) {
        return (float)Math.cos(f);
    }

    public final float tan(float f) {
        return (float)Math.tan(f);
    }

    public final float atan2(float f, float f2) {
        return (float)Math.atan2(f, f2);
    }

    public final float random(float f) {
        return (float)Math.random() * f;
    }

    public final float random(float f, float f2) {
        float f3 = f2 - f;
        return f + (float)Math.random() * f3;
    }

    void checkParams() {
        this.isMacintosh = System.getProperty("os.name").toLowerCase().indexOf("mac") != -1;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("error: ProcessingApplet <appletname>");
            System.exit(1);
        }
        try {
            Frame frame = new Frame();
            Class<?> clazz = Class.forName(stringArray[0]);
            ProcessingApplet processingApplet = (ProcessingApplet)clazz.newInstance();
            processingApplet.init();
            processingApplet.start();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            frame.add(processingApplet);
            frame.pack();
            ((Component)frame).setLocation((dimension.width - processingApplet.g.width) / 2, (dimension.height - processingApplet.g.height) / 2);
            frame.show();
            processingApplet.requestFocus();
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void beginFrame() {
        this.g.beginFrame();
    }

    public void clear() {
        this.g.clear();
    }

    public void endFrame() {
        this.g.endFrame();
    }

    public void beginShape() {
        this.g.beginShape();
    }

    public void beginShape(int n) {
        this.g.beginShape(n);
    }

    public void textureImage(BagelImage bagelImage) {
        this.g.textureImage(bagelImage);
    }

    public void vertexTexture(float f, float f2) {
        this.g.vertexTexture(f, f2);
    }

    public void vertexNormal(float f, float f2, float f3) {
        this.g.vertexNormal(f, f2, f3);
    }

    public void vertex(float f, float f2) {
        this.g.vertex(f, f2);
    }

    public void vertex(float f, float f2, float f3) {
        this.g.vertex(f, f2, f3);
    }

    public void bezierVertex(float f, float f2) {
        this.g.bezierVertex(f, f2);
    }

    public void curveVertex(float f, float f2) {
        this.g.curveVertex(f, f2);
    }

    public void endShape() {
        this.g.endShape();
    }

    public void point(float f, float f2) {
        this.g.point(f, f2);
    }

    public void point(float f, float f2, float f3) {
        this.g.point(f, f2, f3);
    }

    public void line(float f, float f2, float f3, float f4) {
        this.g.line(f, f2, f3, f4);
    }

    public void line(float f, float f2, float f3, float f4, float f5, float f6) {
        this.g.line(f, f2, f3, f4, f5, f6);
    }

    public void rectMode(int n) {
        this.g.rectMode(n);
    }

    public void rect(float f, float f2, float f3, float f4) {
        this.g.rect(f, f2, f3, f4);
    }

    public void ellipseMode(int n) {
        this.g.ellipseMode(n);
    }

    public void ellipse(float f, float f2, float f3, float f4) {
        this.g.ellipse(f, f2, f3, f4);
    }

    public void box(float f) {
        this.g.box(f);
    }

    public void box(float f, float f2, float f3) {
        this.g.box(f, f2, f3);
    }

    public void sphere(float f) {
        this.g.sphere(f);
    }

    public void potato() {
        this.g.potato();
    }

    public void bezier(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.g.bezier(f, f2, f3, f4, f5, f6, f7, f8);
    }

    public void curve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.g.curve(f, f2, f3, f4, f5, f6, f7, f8);
    }

    public BagelImage loadImage(String string) {
        return this.g.loadImage(string);
    }

    public void image(BagelImage bagelImage, float f, float f2) {
        this.g.image(bagelImage, f, f2);
    }

    public void image(BagelImage bagelImage, float f, float f2, float f3, float f4) {
        this.g.image(bagelImage, f, f2, f3, f4);
    }

    public void image(BagelImage bagelImage, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.g.image(bagelImage, f, f2, f3, f4, f5, f6, f7, f8);
    }

    public BagelFont loadFont(String string) {
        return this.g.loadFont(string);
    }

    public void setFont(BagelFont bagelFont) {
        this.g.setFont(bagelFont);
    }

    public void setFont(BagelFont bagelFont, float f) {
        this.g.setFont(bagelFont, f);
    }

    public void text(char c, float f, float f2) {
        this.g.text(c, f, f2);
    }

    public void text(String string, float f, float f2) {
        this.g.text(string, f, f2);
    }

    public void push() {
        this.g.push();
    }

    public void pop() {
        this.g.pop();
    }

    public void mult_matrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.g.mult_matrix(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    public void setupProjection(int n) {
        this.g.setupProjection(n);
    }

    public void projectPoint(float f, float f2, float f3) {
        this.g.projectPoint(f, f2, f3);
    }

    public void projectSize(float f, float f2, float f3, float f4, float f5, float f6) {
        this.g.projectSize(f, f2, f3, f4, f5, f6);
    }

    public void translate(float f, float f2) {
        this.g.translate(f, f2);
    }

    public void translate(float f, float f2, float f3) {
        this.g.translate(f, f2, f3);
    }

    public void shearX(float f) {
        this.g.shearX(f);
    }

    public void shearY(float f) {
        this.g.shearY(f);
    }

    public void rotate(float f) {
        this.g.rotate(f);
    }

    public void rotateX(float f) {
        this.g.rotateX(f);
    }

    public void rotateY(float f) {
        this.g.rotateY(f);
    }

    public void rotateZ(float f) {
        this.g.rotateZ(f);
    }

    public void rotate(float f, float f2, float f3, float f4) {
        this.g.rotate(f, f2, f3, f4);
    }

    public void scale(float f) {
        this.g.scale(f);
    }

    public void scale(float f, float f2) {
        this.g.scale(f, f2);
    }

    public void scale(float f, float f2, float f3) {
        this.g.scale(f, f2, f3);
    }

    public void transform(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.g.transform(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    public void colorMode(int n) {
        this.g.colorMode(n);
    }

    public void colorMode(int n, float f) {
        this.g.colorMode(n, f);
    }

    public void colorMode(int n, float f, float f2, float f3) {
        this.g.colorMode(n, f, f2, f3);
    }

    public void colorMode(int n, float f, float f2, float f3, float f4) {
        this.g.colorMode(n, f, f2, f3, f4);
    }

    public void noFill() {
        this.g.noFill();
    }

    public void fill(float f) {
        this.g.fill(f);
    }

    public void fill(float f, float f2) {
        this.g.fill(f, f2);
    }

    public void fill(float f, float f2, float f3) {
        this.g.fill(f, f2, f3);
    }

    public void fill(float f, float f2, float f3, float f4) {
        this.g.fill(f, f2, f3, f4);
    }

    public void strokeWidth(float f) {
        this.g.strokeWidth(f);
    }

    public void noStroke() {
        this.g.noStroke();
    }

    public void stroke(float f) {
        this.g.stroke(f);
    }

    public void stroke(float f, float f2) {
        this.g.stroke(f, f2);
    }

    public void stroke(float f, float f2, float f3) {
        this.g.stroke(f, f2, f3);
    }

    public void stroke(float f, float f2, float f3, float f4) {
        this.g.stroke(f, f2, f3, f4);
    }

    public void noBackground() {
        this.g.noBackground();
    }

    public void background(float f) {
        this.g.background(f);
    }

    public void background(float f, float f2, float f3) {
        this.g.background(f, f2, f3);
    }

    public void lights() {
        this.g.lights();
    }

    public void noLights() {
        this.g.noLights();
    }

    public void hint(int n) {
        this.g.hint(n);
    }

    public void unhint(int n) {
        this.g.unhint(n);
    }

    public void message(int n, String string) {
        this.g.message(n, string);
    }

    public void message(int n, String string, Exception exception) {
        this.g.message(n, string, exception);
    }

    public InputStream getStream(String string) throws IOException {
        return this.g.getStream(string);
    }
}

