/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;

public class Valence
extends ProcessingApplet {
    static final String WORD_FONT = "parts/Univers-BlackOblique-8bit.vlw.gz";
    static final String SUPPORT_FONT = "parts/Univers-Bold-8bit.vlw.gz";
    static final String WEB_FONT = "parts/Univers-CondensedOblique.vlw.gz";
    static final String EN_FREQUENCY_FILE = "parts/frequency.english.gz";
    static final String DE_FREQUENCY_FILE = "parts/frequency.german.gz";
    static final String WEB_DATA_FILE = "parts/valence.web.data.gz";
    static final int LEFT_BUTTON = 0;
    static final int RIGHT_BUTTON = 1;
    static final int TWAIN = 0;
    static final int WEB = 1;
    static final int ARS = 2;
    static final int version = 0;
    static boolean showHelp = false;
    static boolean makingMovie = false;
    static boolean usingReadout = false;
    static boolean usingBook = true;
    BagelFont wordFont;
    BagelFont supportFont;
    BufferedReader reader;
    String address;
    String url;
    String temp;
    int timestamp;
    Node headNode;
    Node tailNode;
    int nodeCount;
    int nodeCountOffset;
    int oldestNodeTime;
    int newestNodeTime;
    Edge headEdge;
    Edge tailEdge;
    int edgeCount;
    int edgeCountOffset;
    float leftRightAngle;
    float fwdBackTrans;
    float lastMouseX;
    float lastMouseY;
    int lastMouseButton;
    float nodeX;
    float nodeY;
    float nodeZ;
    int lastTime;
    int frameTime;
    int whoami;
    String prevLine = "";
    String currentLine = "";
    boolean broken = false;
    String line;
    String[] pieces;
    int pieceIndex;
    boolean[] breakAfter;
    Node prevnode;
    float floater;

    public void setup() {
        this.size(640, 480);
        this.colorMode(0, 1.0f);
        this.background(0.05f, 0.02f, 0.15f);
        this.build("parts/innocents.gz", "", "", "", 0);
    }

    public void build(String string, String string2, String string3, String string4, int n) {
        this.whoami = n;
        this.lastTime = 0;
        this.frameTime = 250;
        this.headNode = null;
        this.tailNode = null;
        this.nodeCount = 0;
        this.nodeCountOffset = 0;
        this.oldestNodeTime = 0;
        this.newestNodeTime = 0;
        this.headEdge = null;
        this.tailEdge = null;
        this.edgeCount = 0;
        this.edgeCountOffset = 0;
        if (this.supportFont == null) {
            this.supportFont = this.loadFont(SUPPORT_FONT);
        }
        if (this.wordFont == null) {
            this.wordFont = this.loadFont(WORD_FONT);
        }
        switch (0) {
            case 0: {
                try {
                    this.reader = new BufferedReader(new InputStreamReader(this.getStream(string)));
                }
                catch (Exception exception) {
                    System.err.println("could not read text data file");
                    exception.printStackTrace();
                    this.broken = true;
                }
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                try {
                    this.reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string))));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.exit(1);
                }
                break;
            }
        }
        this.fwdBackTrans = 0.0f;
        this.leftRightAngle = -7.0f;
        this.lastMouseButton = -1;
        String[] stringArray = null;
        try {
            stringArray = Valence.readStreamLines(this.getStream(EN_FREQUENCY_FILE));
        }
        catch (Exception exception) {
            System.err.println("could not read word frequency file");
            exception.printStackTrace();
            this.broken = true;
            return;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            String[] stringArray2 = Valence.split(stringArray[n3], '\t');
            try {
                Node.ftableWord[n2] = stringArray2[0];
                Node.ftableWeight[n2] = new Float(stringArray2[1]).floatValue();
                ++n2;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n3;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (c) {
            case '?': {
                showHelp = !showHelp;
                break;
            }
            case 'g': {
                this.screenGrab();
                break;
            }
            case 'l': {
                Edge.lineWidth += 0.5f;
                break;
            }
            case 'L': {
                Edge.lineWidth -= 0.5f;
                break;
            }
            case 'r': {
                usingReadout = !usingReadout;
                break;
            }
            case 't': {
                Node.usingText = !Node.usingText;
                break;
            }
            case 'f': {
                this.frameTime += 25;
                break;
            }
            case 'F': {
                this.frameTime -= 25;
                break;
            }
            case '1': {
                Edge.drawingMode = 1;
                break;
            }
            case '2': {
                Edge.drawingMode = 2;
                break;
            }
            case '3': {
                Edge.drawingMode = 3;
                break;
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        float f = mouseEvent.getX();
        float f2 = mouseEvent.getY();
        int n = 0;
        this.lastMouseX = f;
        this.lastMouseY = f2;
        this.lastMouseButton = n;
        if (f > 585.0f && f2 > 450.0f) {
            this.headNode = null;
            this.tailNode = null;
            this.nodeCount = 0;
            this.nodeCountOffset = 0;
            this.oldestNodeTime = 0;
            this.newestNodeTime = 0;
            this.headEdge = null;
            this.tailEdge = null;
            this.edgeCount = 0;
            this.edgeCountOffset = 0;
            this.prevnode = null;
            this.pieces = null;
            this.line = null;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        float f = mouseEvent.getX();
        float f2 = mouseEvent.getY();
        if (this.lastMouseButton == 0) {
            float f3 = this.lastMouseX - f;
            this.leftRightAngle = (float)((double)this.leftRightAngle - (double)f3 * 0.2);
            float f4 = -(this.lastMouseY - f2);
            this.fwdBackTrans = (float)((double)this.fwdBackTrans - 0.1 * (double)f4 * 0.2);
            if (this.fwdBackTrans < -15.0f) {
                this.fwdBackTrans = -15.0f;
            }
            if (this.fwdBackTrans > 3.0f) {
                this.fwdBackTrans = 3.0f;
            }
        }
        this.lastMouseX = f;
        this.lastMouseY = f2;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.lastMouseButton = -1;
    }

    void parseTwain() {
        if (this.line == null) {
            this.nextTwainLine();
        }
        if (this.pieces == null || this.pieceIndex == this.pieces.length) {
            this.line = null;
            return;
        }
        if (this.pieces[this.pieceIndex].equals("")) {
            ++this.pieceIndex;
            return;
        }
        Node node = this.handleNode(this.pieces[this.pieceIndex], this.getMillis(), this.random(1.0f), this.random(1.0f), this.random(1.0f));
        if (this.prevnode != null) {
            this.handleEdge(this.prevnode, node);
        }
        this.prevnode = this.breakAfter[this.pieceIndex] ? null : node;
        ++this.pieceIndex;
    }

    void nextTwainLine() {
        this.pieces = null;
        try {
            this.line = this.reader.readLine();
        }
        catch (IOException iOException) {
            System.err.println("error while reading lines");
            iOException.printStackTrace();
            this.broken = true;
            return;
        }
        if (this.line == null) {
            return;
        }
        this.line = this.line.trim();
        if (this.line.length() == 0) {
            return;
        }
        this.prevLine = this.currentLine;
        this.currentLine = this.line;
        this.floater = 1.0f;
        this.line = this.line.toLowerCase();
        this.pieces = Valence.split(this.line, ' ');
        this.breakAfter = new boolean[this.pieces.length];
        int n = 0;
        while (n < this.pieces.length) {
            int n2 = 0;
            while (true) {
                if (this.pieces[n].indexOf(39) == n2) {
                    ++n2;
                    continue;
                }
                if (this.pieces[n].indexOf(34) == n2) {
                    ++n2;
                    continue;
                }
                if (this.pieces[n].indexOf(40) == n2) {
                    ++n2;
                    continue;
                }
                if (this.pieces[n].indexOf(91) != n2) break;
                ++n2;
            }
            int n3 = this.pieces[n].length() - 1;
            while (true) {
                if (this.pieces[n].indexOf(34) == n3) {
                    --n3;
                    continue;
                }
                if (this.pieces[n].indexOf(44) == n3) {
                    --n3;
                    continue;
                }
                if (this.pieces[n].indexOf(59) == n3) {
                    --n3;
                    continue;
                }
                if (this.pieces[n].indexOf(58) == n3) {
                    --n3;
                    continue;
                }
                if (this.pieces[n].indexOf(41) == n3) {
                    --n3;
                    continue;
                }
                if (this.pieces[n].indexOf(93) == n3) {
                    --n3;
                    continue;
                }
                if (this.pieces[n].indexOf(46) != n3 && this.pieces[n].indexOf(33) != n3 && this.pieces[n].indexOf(63) != n3) break;
                this.breakAfter[n] = true;
                --n3;
            }
            this.pieces[n] = this.pieces[n].substring(n2, n3 + 1);
            if (this.pieces[n].equals("-")) {
                this.pieces[n] = "";
            }
            ++n;
        }
        this.pieceIndex = 0;
    }

    void parseLine() {
        String string = null;
        try {
            string = this.reader.readLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        String[] stringArray = Valence.split(string, ' ');
        switch (string.charAt(0)) {
            case 'T': {
                if (stringArray.length >= 2) break;
                this.println("hack: T has nothing");
                break;
            }
            case 't': {
                break;
            }
            case 'W': 
            case 'w': {
                this.handleNode(stringArray[1], this.getMillis(), this.random(1.0f), this.random(1.0f), this.random(1.0f));
                break;
            }
            case 'r': {
                Node node = this.headNode;
                while (node != null) {
                    if (node.label.equals(stringArray[1])) {
                        node.label = stringArray[2];
                    }
                    node = node.next;
                }
                break;
            }
            case 'A': 
            case 'a': {
                Node node = this.handleNode(stringArray[1], this.getMillis(), this.random(1.0f), this.random(1.0f), this.random(1.0f));
                Node node2 = this.handleNode(stringArray[2], this.getMillis(), this.random(1.0f), this.random(1.0f), this.random(1.0f));
                this.handleEdge(node, node2);
                break;
            }
            case 's': {
                break;
            }
            case 'p': {
                break;
            }
            default: {
                this.println("not handled: " + string);
                break;
            }
        }
    }

    void loop() {
        if (this.broken) {
            this.colorMode(0, 1.0f);
            this.background(0.5f, 0.0f, 0.0f);
            return;
        }
        if (this.getMillis() - this.lastTime >= this.frameTime) {
            this.lastTime = this.getMillis();
            switch (0) {
                case 0: {
                    this.parseTwain();
                    break;
                }
                case 2: {
                    this.parseLine();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
        Node node = this.headNode;
        while (node != null) {
            node.calc();
            node = node.next;
        }
        node = this.headNode;
        while (node != null) {
            node.move();
            node = node.next;
        }
        this.weedNodes();
        this.setFont(this.supportFont, 16.0f);
        this.floater *= 0.96f;
        float f = this.sin(this.floater * (float)Math.PI);
        float f2 = 0.2f;
        float f3 = 0.23f;
        float f4 = 0.099999994f;
        this.g.fill(0.05f + f2 * f, 0.02f + f3 * f, 0.15f + f4 * f);
        this.text(this.currentLine, 20.0f, 465.0f);
        this.g.fill(0.3f);
        this.text("clear", 590.0f, 465.0f);
        this.setFont(this.wordFont, 1.0f);
        this.push();
        this.translate(this.width / 2, this.height / 2);
        this.scale(70.0f);
        this.noLights();
        this.push();
        if (this.lastMouseButton == -1) {
            this.fwdBackTrans = -0.024f + this.fwdBackTrans * 0.99f;
        }
        this.translate(0.0f, 0.0f, this.fwdBackTrans * 100.0f);
        this.rotateY(this.leftRightAngle * ((float)Math.PI / 180));
        BagelConstants bagelConstants = this.headEdge;
        while (bagelConstants != null) {
            ((Edge)bagelConstants).draw(this.g);
            bagelConstants = ((Edge)bagelConstants).next;
        }
        this.setFont(this.wordFont, 1.0f);
        bagelConstants = this.headNode;
        while (bagelConstants != null) {
            ((Node)bagelConstants).draw(this.g);
            bagelConstants = ((Node)bagelConstants).next;
        }
        this.pop();
        this.pop();
        if (makingMovie) {
            this.screenGrab();
        }
    }

    Node findNode(String string) {
        Node node = this.headNode;
        while (node != null) {
            if (string.equals(node.label)) {
                return node;
            }
            node = node.next;
        }
        return null;
    }

    Node handleNode(String string, int n, float f, float f2, float f3) {
        Node node = this.headNode;
        while (node != null) {
            if (node.label.equals(string)) {
                node.lastVisitTime = n;
                return node;
            }
            node = node.next;
        }
        return this.addNode(string, n, f, f2, f3);
    }

    Node addNode(String string, int n, float f, float f2, float f3) {
        Node node = new Node(this, string, n, f, f2, f3);
        if (this.headNode == null) {
            this.headNode = node;
            this.tailNode = node;
            this.oldestNodeTime = n;
            this.nodeCount = 1;
        } else {
            this.tailNode.next = node;
            node.prev = this.tailNode;
            this.tailNode = node;
            this.newestNodeTime = n;
            ++this.nodeCount;
        }
        return node;
    }

    void weedNodes() {
        while (this.nodeCount > 150) {
            Node node = this.headNode;
            int n = node.lastVisitTime;
            Node node2 = node;
            node = node.next;
            while (node != null) {
                if (node.lastVisitTime < this.oldestNodeTime) {
                    n = node.lastVisitTime;
                    node2 = node;
                }
                node = node.next;
            }
            Node node3 = node2;
            if (node3.prev != null) {
                node3.prev.next = node3.next;
            }
            if (node3.next != null) {
                node3.next.prev = node3.prev;
            }
            if (node3 == this.headNode) {
                this.headNode = node3.next;
            }
            if (node3 == this.tailNode) {
                this.tailNode = node3.prev;
            }
            this.oldestNodeTime = n;
            this.weedAttachedEdges(node2);
            ++this.nodeCountOffset;
            --this.nodeCount;
        }
    }

    void handleEdge(Node node, Node node2) {
        if (node2 != null) {
            ++node.outgoingVisitCount;
            ++node.totalVisitCount;
            ++node2.incomingVisitCount;
            ++node2.totalVisitCount;
            Edge edge = new Edge(this, node, node2);
            edge.applyNodeAttraction(0.5f);
            Edge edge2 = this.headEdge;
            while (edge2 != null) {
                if (edge2.from == node && edge2.to == node2) {
                    edge.like = edge2;
                    edge.likeCount = edge2.likeCount + 1;
                    if (edge.likeCount > Edge.likeMax) {
                        Edge.likeMax = edge.likeCount;
                    }
                    edge2 = null;
                    continue;
                }
                edge2 = edge2.next;
            }
            if (this.headEdge != null) {
                edge.next = this.headEdge;
                this.headEdge.prev = edge;
            } else {
                edge.next = null;
            }
            this.headEdge = edge;
            ++this.edgeCount;
        }
    }

    void weedAttachedEdges(Node node) {
        Edge edge = this.headEdge;
        while (edge != null) {
            if (edge.from == node || edge.to == node) {
                Edge edge2 = edge;
                if (edge2.prev != null) {
                    edge2.prev.next = edge2.next;
                }
                if (edge2.next != null) {
                    edge2.next.prev = edge2.prev;
                }
                if (edge2 == this.headEdge) {
                    this.headEdge = edge2.next;
                }
                if (edge2 == this.tailEdge) {
                    this.tailEdge = edge2.prev;
                }
                edge = edge.next;
                ++this.edgeCountOffset;
                --this.edgeCount;
                continue;
            }
            edge = edge.next;
        }
    }

    public static String[] readFileLinesOrDie(String string) {
        try {
            return Valence.readFileLines(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    public static String[] readFileLines(String string) throws IOException {
        InputStream inputStream = string.endsWith(".gz") ? new GZIPInputStream(new FileInputStream(string)) : new FileInputStream(string);
        return Valence.readStreamLines(inputStream);
    }

    public static String[] readStreamLines(InputStream inputStream) throws IOException {
        String[] stringArray;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String[] stringArray2 = new String[100];
        int n = 0;
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (n == stringArray2.length) {
                stringArray = new String[n * 2];
                System.arraycopy(stringArray2, 0, stringArray, 0, n);
                stringArray2 = stringArray;
            }
            stringArray2[n++] = string;
        }
        if (n != stringArray2.length) {
            stringArray = new String[n];
            System.arraycopy(stringArray2, 0, stringArray, 0, n);
            stringArray2 = stringArray;
        }
        return stringArray2;
    }

    public static String[] split(String string, char c) {
        char[] cArray = string.toCharArray();
        int n = 1;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == c) {
                ++n;
            }
            ++n2;
        }
        if (cArray[cArray.length - 1] == c) {
            --n;
        }
        if (n == 0) {
            String[] stringArray = new String[]{new String(string)};
            return stringArray;
        }
        String[] stringArray = new String[n];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < cArray.length) {
            if (cArray[n5] == c) {
                stringArray[n3++] = new String(cArray, n4, n5 - n4);
                n4 = n5 + 1;
            }
            ++n5;
        }
        if (n4 != cArray.length) {
            stringArray[n3] = new String(cArray, n4, cArray.length - n4);
        }
        return stringArray;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        Valence valence = new Valence();
        valence.init();
        valence.start();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLayout(new BorderLayout());
        frame.add((Component)valence, "Center");
        frame.pack();
        ((Component)frame).setLocation((dimension.width - valence.g.width) / 2, (dimension.height - valence.g.height) / 2);
        frame.show();
        valence.requestFocus();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
    }
}

