/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PImage;
import processing.core.PMatrix;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PGraphics
extends PImage
implements PConstants {
    static final int MATRIX_STACK_DEPTH = 32;
    static final int DEFAULT_VERTICES = 512;
    static final int DEFAULT_SPLINE_VERTICES = 128;
    static final float[] sinLUT = new float[720];
    static final float[] cosLUT = new float[720];
    static final float SINCOS_PRECISION = 0.5f;
    static final int SINCOS_LENGTH = 720;
    public int width1;
    public int height1;
    public int pixelCount;
    DirectColorModel cm;
    MemoryImageSource mis;
    public Image image;
    protected boolean[] hints;
    public int colorMode;
    public float colorModeX;
    public float colorModeY;
    public float colorModeZ;
    public float colorModeA;
    boolean colorScale;
    boolean colorRgb255;
    public boolean tint;
    public int tintColor;
    boolean tintAlpha;
    float tintR;
    float tintG;
    float tintB;
    float tintA;
    int tintRi;
    int tintGi;
    int tintBi;
    int tintAi;
    public boolean fill;
    public int fillColor;
    boolean fillAlpha;
    float fillR;
    float fillG;
    float fillB;
    float fillA;
    int fillRi;
    int fillGi;
    int fillBi;
    int fillAi;
    public boolean stroke;
    public int strokeColor;
    boolean strokeAlpha;
    float strokeR;
    float strokeG;
    float strokeB;
    float strokeA;
    int strokeRi;
    int strokeGi;
    int strokeBi;
    int strokeAi;
    public int backgroundColor;
    float backgroundR;
    float backgroundG;
    float backgroundB;
    int backgroundRi;
    int backgroundGi;
    int backgroundBi;
    protected float calcR;
    protected float calcG;
    protected float calcB;
    protected float calcA;
    int calcRi;
    int calcGi;
    int calcBi;
    int calcAi;
    int calcColor;
    boolean calcAlpha;
    int cacheHsbKey;
    float[] cacheHsbValue;
    public float strokeWeight;
    public int strokeJoin;
    public int strokeCap;
    public float m00;
    public float m01;
    public float m02;
    public float m10;
    public float m11;
    public float m12;
    float[][] matrixStack;
    int matrixStackDepth;
    Path path;
    protected int shape;
    public float[][] vertices;
    int vertexCount;
    protected boolean bezier_inited;
    protected int bezier_detail;
    protected float[][] bezier_basis;
    protected PMatrix bezierBasis;
    protected float[][] bezier_forward;
    protected float[][] bezier_draw;
    protected boolean curve_inited;
    protected int curve_detail;
    protected float curve_tightness;
    protected float[][] curve_basis;
    protected float[][] curve_forward;
    protected float[][] curve_draw;
    protected PMatrix bezierBasisInverse;
    protected PMatrix curveToBezierMatrix;
    protected float[][] splineVertices;
    protected int splineVertexCount;
    public int rectMode;
    public int ellipseMode;
    public PFont textFont;
    public int textAlign;
    public int textMode;
    public float textSize;
    public float textLeading;

    public void resize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        this.allocate();
    }

    public void requestDisplay(PApplet pApplet) {
        pApplet.display();
    }

    protected void allocate() {
        this.pixelCount = this.width * this.height;
        this.pixels = new int[this.pixelCount];
        this.backgroundColor |= 0xFF000000;
        int n = 0;
        while (n < this.pixelCount) {
            this.pixels[n] = this.backgroundColor;
            ++n;
        }
        this.cm = new DirectColorModel(32, 0xFF0000, 65280, 255);
        this.mis = new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width);
        this.mis.setFullBufferUpdates(true);
        this.mis.setAnimated(true);
        this.image = Toolkit.getDefaultToolkit().createImage(this.mis);
    }

    public void beginFrame() {
        this.resetMatrix();
        this.vertexCount = 0;
    }

    public void endFrame() {
        this.mis.newPixels(this.pixels, (ColorModel)this.cm, 0, this.width);
    }

    public void defaults() {
        this.colorMode(1, 255.0f);
        this.fill(255.0f);
        this.stroke(0);
        this.strokeWeight(1.0f);
        this.strokeCap(2);
        this.strokeJoin(8);
        this.background(204);
        this.shape = 0;
        this.matrixStackDepth = 0;
        this.rectMode(0);
        this.ellipseMode(3);
        this.textFont = null;
        this.textSize = 12.0f;
        this.textLeading = 14.0f;
        this.textAlign = 37;
        this.textMode = 3;
    }

    public void hint(int n) {
        this.hints[n] = true;
    }

    public void unhint(int n) {
        this.hints[n] = false;
    }

    public void beginShape() {
        this.beginShape(256);
    }

    public void beginShape(int n) {
        this.shape = n;
        this.vertexCount = 0;
        this.splineVertexCount = 0;
    }

    public void normal(float f, float f2, float f3) {
        this.depthError("normal");
    }

    public void textureMode(int n) {
        this.depthError("textureMode");
    }

    public void texture(PImage pImage) {
        this.depthError("texture");
    }

    public void vertex(float f, float f2) {
        this.splineVertexCount = 0;
        if (this.vertexCount == this.vertices.length) {
            float[][] fArray = new float[this.vertexCount << 1][36];
            System.arraycopy(this.vertices, 0, fArray, 0, this.vertexCount);
            this.vertices = fArray;
        }
        this.vertices[this.vertexCount][9] = f;
        this.vertices[this.vertexCount][10] = f;
        ++this.vertexCount;
        switch (this.shape) {
            case 16: {
                this.point(f, f2);
                break;
            }
            case 32: {
                if (this.vertexCount % 2 != 0) break;
                this.line(this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10], f, f2);
                break;
            }
            case 33: 
            case 34: {
                if (this.vertexCount == 1) {
                    this.path = new Path();
                    this.path.moveTo(f, f2);
                    break;
                }
                this.path.lineTo(f, f2);
                break;
            }
            case 64: {
                if (this.vertexCount % 3 != 0) break;
                this.triangle(this.vertices[this.vertexCount - 3][9], this.vertices[this.vertexCount - 3][10], this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10], f, f2);
                break;
            }
            case 65: {
                if (this.vertexCount == 3) {
                    this.triangle(this.vertices[0][9], this.vertices[0][10], this.vertices[1][9], this.vertices[1][10], f, f2);
                    break;
                }
                if (this.vertexCount <= 3) break;
                this.path = new Path();
                this.path.moveTo(this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10]);
                this.path.lineTo(this.vertices[this.vertexCount - 1][9], this.vertices[this.vertexCount - 1][10]);
                this.path.lineTo(this.vertices[this.vertexCount - 3][9], this.vertices[this.vertexCount - 3][10]);
                this.draw_shape(this.path);
                break;
            }
            case 66: {
                if (this.vertexCount == 3) {
                    this.triangle(this.vertices[0][9], this.vertices[0][10], this.vertices[1][9], this.vertices[1][10], f, f2);
                    break;
                }
                if (this.vertexCount <= 3) break;
                this.path = new Path();
                this.path.moveTo(this.vertices[0][9], this.vertices[0][10]);
                this.path.lineTo(this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10]);
                this.path.lineTo(f, f2);
                this.draw_shape(this.path);
                break;
            }
            case 128: {
                if (this.vertexCount % 4 != 0) break;
                this.quad(this.vertices[this.vertexCount - 4][9], this.vertices[this.vertexCount - 4][10], this.vertices[this.vertexCount - 3][9], this.vertices[this.vertexCount - 3][10], this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10], f, f2);
                break;
            }
            case 129: {
                if (this.vertexCount == 4) {
                    this.quad(this.vertices[0][9], this.vertices[0][10], this.vertices[2][9], this.vertices[2][10], f, f2, this.vertices[1][9], this.vertices[1][10]);
                    break;
                }
                if (this.vertexCount <= 4) break;
                this.path = new Path();
                this.path.moveTo(this.vertices[this.vertexCount - 3][9], this.vertices[this.vertexCount - 3][10]);
                this.path.lineTo(this.vertices[this.vertexCount - 1][9], this.vertices[this.vertexCount - 1][10]);
                this.path.lineTo(f, f2);
                this.path.lineTo(this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10]);
                this.draw_shape(this.path);
                break;
            }
            case 256: {
                if (this.vertexCount == 1) {
                    this.path = new Path();
                    this.path.moveTo(f, f2);
                    break;
                }
                this.path.lineTo(f, f2);
                break;
            }
        }
    }

    public void vertex(float f, float f2, float f3) {
        this.depthErrorXYZ("vertex");
    }

    public void vertex(float f, float f2, float f3, float f4) {
        throw new RuntimeException("vertex() with u, v coordinates can only be used with OPENGL or P3D");
    }

    public void vertex(float f, float f2, float f3, float f4, float f5) {
        throw new RuntimeException("vertex() with u, v coordinates can only be used with OPENGL or P3D");
    }

    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6) {
    }

    protected void bezier_vertex(float f, float f2) {
        this.vertexCount = 0;
        if (this.splineVertices == null) {
            this.splineVertices = new float[128][36];
        }
        if (this.splineVertexCount == 128) {
            System.arraycopy(this.splineVertices[125], 0, this.splineVertices[0], 0, 36);
            System.arraycopy(this.splineVertices[126], 0, this.splineVertices[1], 0, 36);
            this.splineVertexCount = 3;
        }
        this.splineVertices[this.splineVertexCount][9] = f;
        this.splineVertices[this.splineVertexCount][10] = f2;
        ++this.splineVertexCount;
        switch (this.shape) {
            case 33: 
            case 34: 
            case 256: {
                if (this.splineVertexCount == 1) {
                    this.path.moveTo(f, f2);
                    break;
                }
                if (this.splineVertexCount < 4) break;
                this.path.curveTo(this.splineVertices[this.splineVertexCount - 3][9], this.splineVertices[this.splineVertexCount - 3][10], this.splineVertices[this.splineVertexCount - 2][9], this.splineVertices[this.splineVertexCount - 2][10], f, f2);
                break;
            }
            default: {
                throw new RuntimeException("bezierVertex() can only be used with LINE_LOOP and POLYGON shapes");
            }
        }
    }

    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.depthErrorXYZ("bezierVertex");
    }

    public void curveVertex(float f, float f2) {
    }

    public void curveVertex(float f, float f2, float f3) {
        this.depthErrorXYZ("curveVertex");
    }

    public void endShape() {
        this.shape = 0;
        switch (this.shape) {
            case 33: {
                this.stroke_shape(this.path);
                break;
            }
            case 34: {
                this.path.closePath();
                this.stroke_shape(this.path);
                break;
            }
            case 256: {
                this.path.closePath();
                this.draw_shape(this.path);
                break;
            }
        }
    }

    protected void fill_shape(Path path) {
    }

    protected void stroke_shape(Path path) {
    }

    protected void draw_shape(Path path) {
    }

    public void point(float f, float f2) {
    }

    public void point(float f, float f2, float f3) {
        this.depthErrorXYZ("point");
    }

    public void line(float f, float f2, float f3, float f4) {
    }

    public void line(float f, float f2, float f3, float f4, float f5, float f6) {
        this.depthErrorXYZ("line");
    }

    public void triangle(float f, float f2, float f3, float f4, float f5, float f6) {
    }

    public void quad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
    }

    public void rectMode(int n) {
        this.rectMode = n;
    }

    public void rect(float f, float f2, float f3, float f4) {
        float f5;
        switch (this.rectMode) {
            case 1: {
                break;
            }
            case 0: {
                f3 += f;
                f4 += f2;
                break;
            }
            case 2: {
                float f6 = f3;
                float f7 = f4;
                f3 = f + f6;
                f4 = f2 + f7;
                f -= f6;
                f2 -= f7;
                break;
            }
            case 3: {
                float f8 = f3 / 2.0f;
                float f9 = f4 / 2.0f;
                f3 = f + f8;
                f4 = f2 + f9;
                f -= f8;
                f2 -= f9;
            }
        }
        if (f > f3) {
            f5 = f;
            f = f3;
            f3 = f5;
        }
        if (f2 > f4) {
            f5 = f2;
            f2 = f4;
            f4 = f5;
        }
        this.rectImpl(f, f2, f3, f4);
    }

    protected void rectImpl(float f, float f2, float f3, float f4) {
    }

    public void ellipseMode(int n) {
        this.ellipseMode = n;
    }

    public void ellipse(float f, float f2, float f3, float f4) {
        float f5 = f;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        if (this.ellipseMode == 1) {
            f7 = f3 - f;
            f8 = f4 - f2;
        } else if (this.ellipseMode == 2) {
            f5 = f - f3;
            f6 = f2 - f4;
            f7 = f3 * 2.0f;
            f8 = f4 * 2.0f;
        } else if (this.ellipseMode == 3) {
            f5 = f - f3 / 2.0f;
            f6 = f2 - f4 / 2.0f;
        }
        if (f7 < 0.0f) {
            f5 += f7;
            f7 = -f7;
        }
        if (f8 < 0.0f) {
            f6 += f8;
            f8 = -f8;
        }
        this.ellipseImpl(f5, f6, f7, f8);
    }

    protected void ellipseImpl(float f, float f2, float f3, float f4) {
    }

    /*
     * Unable to fully structure code
     */
    public void arc(float var1_1, float var2_2, float var3_3, float var4_4, float var5_5, float var6_6) {
        var7_7 = var1_1;
        var8_8 = var2_2;
        var9_9 = var3_3;
        var10_10 = var4_4;
        if (this.ellipseMode == 1) {
            var9_9 = var3_3 - var1_1;
            var10_10 = var4_4 - var2_2;
        } else if (this.ellipseMode == 2) {
            var7_7 = var1_1 - var3_3;
            var8_8 = var2_2 - var4_4;
            var9_9 = var3_3 * 2.0f;
            var10_10 = var4_4 * 2.0f;
        } else if (this.ellipseMode == 3) {
            var7_7 = var1_1 - var3_3 / 2.0f;
            var8_8 = var2_2 - var4_4 / 2.0f;
        }
        if (!Float.isInfinite(var5_5) && !Float.isInfinite(var6_6)) ** GOTO lbl21
        return;
lbl-1000:
        // 1 sources

        {
            var6_6 += 6.2831855f;
lbl21:
            // 2 sources

            ** while (var6_6 < var5_5)
        }
lbl22:
        // 1 sources

        this.arcImpl(var7_7, var8_8, var9_9, var10_10, var5_5, var6_6);
    }

    protected void arcImpl(float f, float f2, float f3, float f4, float f5, float f6) {
    }

    public void box(float f) {
        this.depthError("box");
    }

    public void box(float f, float f2, float f3) {
        this.depthError("box");
    }

    public void sphereDetail(int n) {
        this.depthError("sphereDetail");
    }

    public void sphere(float f) {
        this.depthError("sphere");
    }

    public float bezierPoint(float f, float f2, float f3, float f4, float f5) {
        float f6 = 1.0f - f5;
        return f * f6 * f6 * f6 + (float)3 * f2 * f5 * f6 * f6 + (float)3 * f3 * f5 * f5 * f6 + f4 * f5 * f5 * f5;
    }

    public float bezierTangent(float f, float f2, float f3, float f4, float f5) {
        float f6 = 1.0f - f5;
        return f * (float)3 * f5 * f5 + f2 * (float)3 * f5 * (2.0f - (float)3 * f5) + f3 * (float)3 * ((float)3 * f5 * f5 - (float)4 * f5 + 1.0f) + f4 * -3.0f * f6 * f6;
    }

    public void bezier(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.beginShape(33);
        this.vertex(f, f2);
        this.bezierVertex(f3, f4, f5, f6, f7, f8);
        this.endShape();
    }

    public void bezier(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.depthErrorXYZ("bezier");
    }

    protected void bezier_init() {
        this.bezierDetail(this.bezier_detail);
    }

    public void bezierDetail(int n) {
        if (this.bezier_forward == null) {
            this.bezier_forward = new float[4][4];
            this.bezier_draw = new float[4][4];
        }
        this.bezier_detail = n;
        this.bezier_inited = true;
        this.setup_spline_forward(n, this.bezier_forward);
        this.mult_spline_matrix(this.bezier_forward, this.bezier_basis, this.bezier_draw, 4);
    }

    protected void curve_init() {
        this.curve_mode(this.curve_detail, this.curve_tightness);
    }

    public void curveDetail(int n) {
        this.curve_mode(n, this.curve_tightness);
    }

    public void curveTightness(float f) {
        this.curve_mode(this.curve_detail, f);
    }

    protected void curve_mode(int n, float f) {
        this.curve_detail = n;
        if (this.curve_basis == null) {
            this.curve_basis = new float[4][4];
            this.curve_forward = new float[4][4];
            this.curve_draw = new float[4][4];
            this.curve_inited = true;
        }
        float[][] fArray = this.curve_basis;
        fArray[0][0] = f - 1.0f;
        fArray[0][1] = f + (float)3;
        fArray[0][2] = -3.0f - f;
        fArray[0][3] = 1.0f - f;
        fArray[1][0] = 2.0f * (1.0f - f);
        fArray[1][1] = -5.0f - f;
        fArray[1][2] = 2.0f * (f + 2.0f);
        fArray[1][3] = f - 1.0f;
        fArray[2][0] = f - 1.0f;
        fArray[2][1] = 0.0f;
        fArray[2][2] = 1.0f - f;
        fArray[2][3] = 0.0f;
        fArray[3][0] = 0.0f;
        fArray[3][1] = 2.0f;
        fArray[3][2] = 0.0f;
        fArray[3][3] = 0.0f;
        int n2 = 0;
        while (n2 < 4) {
            int n3 = 0;
            while (n3 < 4) {
                float[] fArray2 = fArray[n2];
                int n4 = n3++;
                fArray2[n4] = fArray2[n4] / 2.0f;
            }
            ++n2;
        }
        this.setup_spline_forward(n, this.curve_forward);
        if (this.bezierBasisInverse == null) {
            this.bezierBasisInverse = new PMatrix(this.bezierBasis).invert();
        }
        this.curveToBezierMatrix = new PMatrix(fArray[0][0], fArray[0][1], fArray[0][2], fArray[0][3], fArray[1][0], fArray[1][1], fArray[1][2], fArray[1][3], fArray[2][0], fArray[2][1], fArray[2][2], fArray[2][3], fArray[3][0], fArray[3][1], fArray[3][2], fArray[3][3]);
        this.curveToBezierMatrix.preApply(this.bezierBasisInverse);
        this.mult_spline_matrix(this.curve_forward, this.curve_basis, this.curve_draw, 4);
    }

    public float curvePoint(float f, float f2, float f3, float f4, float f5) {
        if (!this.curve_inited) {
            this.curve_init();
        }
        float f6 = f5 * f5;
        float f7 = f5 * f6;
        float[][] fArray = this.curve_basis;
        return f * (f7 * fArray[0][0] + f6 * fArray[1][0] + f5 * fArray[2][0] + fArray[3][0]) + f2 * (f7 * fArray[0][1] + f6 * fArray[1][1] + f5 * fArray[2][1] + fArray[3][1]) + f3 * (f7 * fArray[0][2] + f6 * fArray[1][2] + f5 * fArray[2][2] + fArray[3][2]) + f4 * (f7 * fArray[0][3] + f6 * fArray[1][3] + f5 * fArray[2][3] + fArray[3][3]);
    }

    public float curveTangent(float f, float f2, float f3, float f4, float f5) {
        System.err.println("curveTangent not yet implemented");
        return 0.0f;
    }

    public void curve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.beginShape(33);
        this.curveVertex(f, f2);
        this.curveVertex(f3, f4);
        this.curveVertex(f5, f6);
        this.curveVertex(f7, f8);
        this.endShape();
    }

    public void curve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.depthErrorXYZ("curve");
    }

    protected void setup_spline_forward(int n, float[][] fArray) {
        float f = 1.0f / (float)n;
        float f2 = f * f;
        float f3 = f2 * f;
        fArray[0][0] = 0.0f;
        fArray[0][1] = 0.0f;
        fArray[0][2] = 0.0f;
        fArray[0][3] = 1.0f;
        fArray[1][0] = f3;
        fArray[1][1] = f2;
        fArray[1][2] = f;
        fArray[1][3] = 0.0f;
        fArray[2][0] = 6.0f * f3;
        fArray[2][1] = 2.0f * f2;
        fArray[2][2] = 0.0f;
        fArray[2][3] = 0.0f;
        fArray[3][0] = 6.0f * f3;
        fArray[3][1] = 0.0f;
        fArray[3][2] = 0.0f;
        fArray[3][3] = 0.0f;
    }

    protected void mult_spline_matrix(float[][] fArray, float[][] fArray2, float[][] fArray3, int n) {
        int n2;
        int n3 = 0;
        while (n3 < 4) {
            n2 = 0;
            while (n2 < n) {
                fArray3[n3][n2] = 0.0f;
                ++n2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < 4) {
            n2 = 0;
            while (n2 < n) {
                int n4 = 0;
                while (n4 < 4) {
                    fArray3[n3][n2] = fArray3[n3][n2] + fArray[n3][n4] * fArray2[n4][n2];
                    ++n4;
                }
                ++n2;
            }
            ++n3;
        }
    }

    protected void spline2_segment(int n, int n2, float[][] fArray, int n3) {
        float f = this.splineVertices[n][9];
        float f2 = this.splineVertices[n][10];
        float f3 = this.splineVertices[n + 1][9];
        float f4 = this.splineVertices[n + 1][10];
        float f5 = this.splineVertices[n + 2][9];
        float f6 = this.splineVertices[n + 2][10];
        float f7 = this.splineVertices[n + 3][9];
        float f8 = this.splineVertices[n + 3][10];
        float f9 = this.splineVertices[n2][9];
        float f10 = this.splineVertices[n2][10];
        float f11 = fArray[1][0] * f + fArray[1][1] * f3 + fArray[1][2] * f5 + fArray[1][3] * f7;
        float f12 = fArray[2][0] * f + fArray[2][1] * f3 + fArray[2][2] * f5 + fArray[2][3] * f7;
        float f13 = fArray[3][0] * f + fArray[3][1] * f3 + fArray[3][2] * f5 + fArray[3][3] * f7;
        float f14 = fArray[1][0] * f2 + fArray[1][1] * f4 + fArray[1][2] * f6 + fArray[1][3] * f8;
        float f15 = fArray[2][0] * f2 + fArray[2][1] * f4 + fArray[2][2] * f6 + fArray[2][3] * f8;
        float f16 = fArray[3][0] * f2 + fArray[3][1] * f4 + fArray[3][2] * f6 + fArray[3][3] * f8;
        int n4 = this.splineVertexCount;
        this.vertex(f9, f10);
        int n5 = 0;
        while (n5 < n3) {
            f11 += f12;
            f12 += f13;
            f15 += f16;
            this.vertex(f9 += f11, f10 += (f14 += f15));
            ++n5;
        }
        this.splineVertexCount = n4;
    }

    protected void spline3_segment(int n, int n2, float[][] fArray, int n3) {
        float f = this.splineVertices[n][9];
        float f2 = this.splineVertices[n][10];
        float f3 = this.splineVertices[n][11];
        float f4 = this.splineVertices[n + 1][9];
        float f5 = this.splineVertices[n + 1][10];
        float f6 = this.splineVertices[n + 1][11];
        float f7 = this.splineVertices[n + 2][9];
        float f8 = this.splineVertices[n + 2][10];
        float f9 = this.splineVertices[n + 2][11];
        float f10 = this.splineVertices[n + 3][9];
        float f11 = this.splineVertices[n + 3][10];
        float f12 = this.splineVertices[n + 3][11];
        float f13 = this.splineVertices[n2][9];
        float f14 = this.splineVertices[n2][10];
        float f15 = this.splineVertices[n2][11];
        float f16 = fArray[1][0] * f + fArray[1][1] * f4 + fArray[1][2] * f7 + fArray[1][3] * f10;
        float f17 = fArray[2][0] * f + fArray[2][1] * f4 + fArray[2][2] * f7 + fArray[2][3] * f10;
        float f18 = fArray[3][0] * f + fArray[3][1] * f4 + fArray[3][2] * f7 + fArray[3][3] * f10;
        float f19 = fArray[1][0] * f2 + fArray[1][1] * f5 + fArray[1][2] * f8 + fArray[1][3] * f11;
        float f20 = fArray[2][0] * f2 + fArray[2][1] * f5 + fArray[2][2] * f8 + fArray[2][3] * f11;
        float f21 = fArray[3][0] * f2 + fArray[3][1] * f5 + fArray[3][2] * f8 + fArray[3][3] * f11;
        float f22 = fArray[1][0] * f3 + fArray[1][1] * f6 + fArray[1][2] * f9 + fArray[1][3] * f12;
        float f23 = fArray[2][0] * f3 + fArray[2][1] * f6 + fArray[2][2] * f9 + fArray[2][3] * f12;
        float f24 = fArray[3][0] * f3 + fArray[3][1] * f6 + fArray[3][2] * f9 + fArray[3][3] * f12;
        int n4 = this.splineVertexCount;
        this.vertex(f13, f14, f15);
        int n5 = 0;
        while (n5 < n3) {
            f13 += f16;
            f16 += f17;
            f17 += f18;
            f19 += f20;
            f20 += f21;
            f23 += f24;
            this.vertex(f13, f14 += f19, f15 += (f22 += f23));
            ++n5;
        }
        this.splineVertexCount = n4;
    }

    public void image(PImage pImage, float f, float f2) {
        this.imageImpl(pImage, f, f2, f + (float)pImage.width, f2 + (float)pImage.height, 0, 0, pImage.width, pImage.height);
    }

    public void image(PImage pImage, float f, float f2, float f3, float f4) {
        this.image(pImage, f, f2, f3, f4, 0, 0, pImage.width, pImage.height);
    }

    public void image(PImage pImage, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        if (this.imageMode == 0) {
            if (f3 < 0.0f) {
                f += f3;
                f3 = -f3;
            }
            if (f4 < 0.0f) {
                f2 += f4;
                f4 = -f4;
            }
            this.imageImpl(pImage, f, f2, f + f3, f2 + f4, n, n2, n3, n4);
        } else if (this.imageMode == 1) {
            float f5;
            if (f3 < f) {
                f5 = f;
                f = f3;
                f3 = f5;
            }
            if (f4 < f2) {
                f5 = f2;
                f2 = f4;
                f4 = f5;
            }
            this.imageImpl(pImage, f, f2, f3, f4, n, n2, n3, n4);
        }
    }

    protected void imageImpl(PImage pImage, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        System.err.println("unimplemented imageImpl() in PGraphics");
    }

    public void textFont(PFont pFont, float f) {
        this.textFont(pFont);
        this.textSize(f);
    }

    public void textFont(PFont pFont) {
        if (pFont == null) {
            throw new RuntimeException("a null PFont was passed to textFont()");
        }
        this.textFont = pFont;
        this.textSize(this.textFont.size);
    }

    public void textSize(float f) {
        if (this.textFont != null) {
            if (this.textMode == 128 && f != (float)this.textFont.size) {
                throw new RuntimeException("can't use textSize() with textMode(SCREEN)");
            }
        } else {
            throw new RuntimeException("use textFont() before textSize()");
        }
        this.textSize = f;
        this.textLeading = this.textSize * ((this.textFont.ascent() + this.textFont.descent()) * 1.275f);
    }

    public void textLeading(float f) {
        this.textLeading = f;
    }

    public void textAlign(int n) {
        this.textAlign = n;
    }

    public void textMode(int n) {
        if (this.textFont != null) {
            this.textMode = n;
            if (this.textMode == 128) {
                this.textSize(this.textFont.size);
            }
        } else {
            throw new RuntimeException("use textFont() before textMode()");
        }
    }

    public float textAscent() {
        if (this.textFont != null) {
            return this.textFont.ascent() * this.textSize;
        }
        throw new RuntimeException("use textFont() before textAscent()");
    }

    public float textDescent() {
        if (this.textFont != null) {
            return this.textFont.descent() * this.textSize;
        }
        throw new RuntimeException("use textFont() before textDescent()");
    }

    public float textWidth(char c) {
        if (this.textFont != null) {
            return this.textFont.width(c) * this.textSize;
        }
        throw new RuntimeException("use textFont() before textWidth()");
    }

    public float textWidth(String string) {
        if (this.textFont != null) {
            return this.textFont.width(string) * this.textSize;
        }
        throw new RuntimeException("use textFont() before textWidth()");
    }

    public void text(char c, float f, float f2) {
        this.text(c, f, f2, 0.0f);
    }

    public void text(char c, float f, float f2, float f3) {
        if (f3 != 0.0f && this.textMode == 128) {
            String string = "textMode(SCREEN) cannot have a z coordinate";
            throw new RuntimeException(string);
        }
        if (this.textFont != null) {
            if (this.textMode == 128) {
                this.loadPixels();
            }
            this.textFont.text(c, f, f2, f3, this);
            if (this.textMode == 128) {
                this.updatePixels();
            }
        } else {
            throw new RuntimeException("use textFont() before text()");
        }
    }

    public void text(String string, float f, float f2) {
        this.text(string, f, f2, 0.0f);
    }

    public void text(String string, float f, float f2, float f3) {
        if (f3 != 0.0f && this.textMode == 128) {
            String string2 = "textMode(SCREEN) cannot have a z coordinate";
            throw new RuntimeException(string2);
        }
        if (this.textFont != null) {
            if (this.textMode == 128) {
                this.loadPixels();
            }
            this.textFont.text(string, f, f2, f3, this);
            if (this.textMode == 128) {
                this.updatePixels();
            }
        } else {
            throw new RuntimeException("use textFont() before text()");
        }
    }

    public void text(String string, float f, float f2, float f3, float f4) {
        this.text(string, f, f2, f3, f4, 0.0f);
    }

    public void text(String string, float f, float f2, float f3, float f4, float f5) {
        if (this.textFont != null) {
            float f6;
            switch (this.rectMode) {
                case 0: {
                    f3 += f;
                    f4 += f2;
                    break;
                }
                case 2: {
                    float f7 = f3;
                    float f8 = f4;
                    f3 = f + f7;
                    f4 = f2 + f8;
                    f -= f7;
                    f2 -= f8;
                    break;
                }
                case 3: {
                    float f9 = f3 / 2.0f;
                    float f10 = f4 / 2.0f;
                    f3 = f + f9;
                    f4 = f2 + f10;
                    f -= f9;
                    f2 -= f10;
                }
            }
            if (f3 < f) {
                f6 = f;
                f = f3;
                f3 = f6;
            }
            if (f4 < f2) {
                f6 = f2;
                f2 = f4;
                f4 = f6;
            }
            if (this.textMode == 128) {
                this.loadPixels();
            }
            this.textFont.text(string, f, f2, f3, f4, f5, this);
            if (this.textMode == 128) {
                this.updatePixels();
            }
        } else {
            throw new RuntimeException("use textFont() before text()");
        }
    }

    public void text(int n, float f, float f2) {
        this.text(String.valueOf(n), f, f2);
    }

    public void text(int n, float f, float f2, float f3) {
        this.text(String.valueOf(n), f, f2, f3);
    }

    public void text(float f, float f2, float f3) {
        this.text(PApplet.nfs(f, 0, 3), f2, f3);
    }

    public void text(float f, float f2, float f3, float f4) {
    }

    protected void textImpl(char c, float f, float f2, float f3) {
        int n = this.textFont.index(c);
        if (n == -1) {
            return;
        }
        PImage pImage = this.textFont.images[n];
        if (this.textMode == 3) {
            float f4 = (float)this.textFont.height[n] / this.textFont.fheight;
            float f5 = (float)this.textFont.width[n] / this.textFont.fwidth;
            float f6 = (float)this.textFont.leftExtent[n] / this.textFont.fwidth;
            float f7 = (float)this.textFont.topExtent[n] / this.textFont.fheight;
            float f8 = f + f6 * this.textSize;
            float f9 = f2 - f7 * this.textSize;
            float f10 = f8 + f5 * this.textSize;
            float f11 = f9 + f4 * this.textSize;
            this.textImplObject(pImage, f8, f9, f3, f10, f11, f3, this.textFont.width[n], this.textFont.height[n]);
        } else if (this.textMode == 128) {
            int n2 = (int)f + this.textFont.leftExtent[n];
            int n3 = (int)f2 - this.textFont.topExtent[n];
            int n4 = this.textFont.width[n];
            int n5 = this.textFont.height[n];
            this.textImplScreen(pImage, n2, n3, n4, n5);
        }
    }

    protected void textImplObject(PImage pImage, float f, float f2, float f3, float f4, float f5, float f6, int n, int n2) {
        boolean bl = this.tint;
        int n3 = this.tintColor;
        float f7 = this.tintR;
        float f8 = this.tintG;
        float f9 = this.tintB;
        float f10 = this.tintA;
        boolean bl2 = this.tintAlpha;
        this.tint = true;
        this.tintColor = this.fillColor;
        this.tintR = this.fillR;
        this.tintG = this.fillG;
        this.tintB = this.fillB;
        this.tintA = this.fillA;
        this.tintAlpha = this.fillAlpha;
        this.imageImpl(pImage, f, f2, f4, f5, 0, 0, n, n2);
        this.tint = bl;
        this.tintColor = n3;
        this.tintR = f7;
        this.tintG = f8;
        this.tintB = f9;
        this.tintA = f10;
        this.tintAlpha = bl2;
    }

    protected void textImplScreen(PImage pImage, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        if (n >= this.width || n2 >= this.height || n + n3 < 0 || n2 + n4 < 0) {
            return;
        }
        if (n < 0) {
            n5 -= n;
            n3 += n;
            n = 0;
        }
        if (n2 < 0) {
            n6 -= n2;
            n4 += n2;
            n2 = 0;
        }
        if (n + n3 > this.width) {
            n3 -= n + n3 - this.width;
        }
        if (n2 + n4 > this.height) {
            n4 -= n2 + n4 - this.height;
        }
        int n7 = this.fillRi;
        int n8 = this.fillGi;
        int n9 = this.fillBi;
        int n10 = this.fillAi;
        int[] nArray = pImage.pixels;
        int n11 = n6;
        while (n11 < n6 + n4) {
            int n12 = n5;
            while (n12 < n5 + n3) {
                int n13 = n10 * nArray[n11 * this.textFont.twidth + n12] >> 8;
                int n14 = n13 ^ 0xFF;
                int n15 = nArray[n11 * pImage.width + n12];
                int n16 = this.pixels[(n2 + n11 - n6) * this.width + (n + n12 - n5)];
                this.pixels[(n2 + n11 - n6) * this.width + n + n12 - n5] = 0xFF000000 | (n13 * n7 + n14 * (n16 >> 16 & 0xFF) & 0xFF00) << 8 | n13 * n8 + n14 * (n16 >> 8 & 0xFF) & 0xFF00 | n13 * n9 + n14 * (n16 & 0xFF) >> 8;
                ++n12;
            }
            ++n11;
        }
    }

    public void translate(float f, float f2) {
        this.m02 += f * this.m00 + f2 * this.m01 + this.m02;
        this.m12 += f * this.m10 + f2 * this.m11 + this.m12;
    }

    public void translate(float f, float f2, float f3) {
        this.depthErrorXYZ("translate");
    }

    public void rotate(float f) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        this.applyMatrix(f2, -f3, 0.0f, f3, f2, 0.0f);
    }

    public void rotateX(float f) {
        this.depthError("rotateX");
    }

    public void rotateY(float f) {
        this.depthError("rotateY");
    }

    public void rotateZ(float f) {
        this.depthError("rotateZ");
    }

    public void rotate(float f, float f2, float f3, float f4) {
        throw new RuntimeException("rotate(angle, x, y, z) can only be used with P3D or OPENGL");
    }

    public void scale(float f) {
        this.applyMatrix(f, 0.0f, 0.0f, 0.0f, f, 0.0f);
    }

    public void scale(float f, float f2) {
        this.applyMatrix(f, 0.0f, 0.0f, 0.0f, f2, 0.0f);
    }

    public void scale(float f, float f2, float f3) {
        this.depthErrorXYZ("scale");
    }

    public void pushMatrix() {
        if (this.matrixStackDepth + 1 == 32) {
            throw new RuntimeException("too many calls to pushMatrix()");
        }
        float[] fArray = this.matrixStack[this.matrixStackDepth];
        fArray[0] = this.m00;
        fArray[1] = this.m01;
        fArray[2] = this.m02;
        fArray[3] = this.m10;
        fArray[4] = this.m11;
        fArray[5] = this.m12;
        ++this.matrixStackDepth;
    }

    public void popMatrix() {
        if (this.matrixStackDepth == 0) {
            throw new RuntimeException("too many calls to popMatrix() (and not enough to pushMatrix)");
        }
        --this.matrixStackDepth;
        float[] fArray = this.matrixStack[this.matrixStackDepth];
        this.m00 = fArray[0];
        this.m01 = fArray[1];
        this.m02 = fArray[2];
        this.m10 = fArray[3];
        this.m11 = fArray[4];
        this.m12 = fArray[5];
    }

    public void resetMatrix() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = this.m00 * f + this.m01 * f4;
        float f8 = this.m00 * f2 + this.m01 * f5;
        float f9 = this.m00 * f3 + this.m01 * f6 + this.m02;
        float f10 = this.m10 * f + this.m11 * f4;
        float f11 = this.m10 * f2 + this.m11 * f5;
        float f12 = this.m10 * f3 + this.m11 * f6 + this.m12;
        this.m00 = f7;
        this.m01 = f8;
        this.m02 = f9;
        this.m10 = f10;
        this.m11 = f11;
        this.m12 = f12;
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        throw new RuntimeException("applyMatrix() with a 4x4 matrix can only be used with OPENGL or P3D");
    }

    public void printMatrix() {
        float f = Math.abs(this.m00);
        if (Math.abs(this.m01) > f) {
            f = Math.abs(this.m01);
        }
        if (Math.abs(this.m02) > f) {
            f = Math.abs(this.m02);
        }
        if (Math.abs(this.m10) > f) {
            f = Math.abs(this.m10);
        }
        if (Math.abs(this.m11) > f) {
            f = Math.abs(this.m11);
        }
        if (Math.abs(this.m12) > f) {
            f = Math.abs(this.m12);
        }
        if (Float.isNaN(f) || Float.isInfinite(f)) {
            f = 1000000.0f;
        }
        int n = 1;
        int n2 = (int)f;
        while ((n2 /= 10) != 0) {
            ++n;
        }
        System.out.println(PApplet.nfs(this.m00, n, 4) + ' ' + PApplet.nfs(this.m01, n, 4) + ' ' + PApplet.nfs(this.m02, n, 4));
        System.out.println(PApplet.nfs(this.m10, n, 4) + ' ' + PApplet.nfs(this.m11, n, 4) + ' ' + PApplet.nfs(this.m12, n, 4));
        System.out.println();
    }

    public void cameraMode(int n) {
        this.depthError("cameraMode");
    }

    public void beginCamera() {
        this.depthError("beginCamera");
    }

    public void endCamera() {
        this.depthError("endCamera");
    }

    public void camera() {
        this.depthError("camera");
    }

    public void camera(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.depthError("camera");
    }

    public void ortho() {
        this.depthError("ortho");
    }

    public void ortho(float f, float f2, float f3, float f4, float f5, float f6) {
        this.depthError("ortho");
    }

    public void perspective() {
        this.depthError("perspective");
    }

    public void perspective(float f, float f2, float f3, float f4) {
        this.depthError("perspective");
    }

    public void frustum(float f, float f2, float f3, float f4, float f5, float f6) {
        this.depthError("frustum");
    }

    public void lookat(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.depthError("lookat");
    }

    public void printCamera() {
        this.depthError("printCamera");
    }

    public void printProjection() {
        this.depthError("printCamera");
    }

    public float screenX(float f, float f2) {
        return this.m00 * f + this.m01 * f2 + this.m02;
    }

    public float screenY(float f, float f2) {
        return this.m10 * f + this.m11 * f2 + this.m12;
    }

    public float screenX(float f, float f2, float f3) {
        this.depthErrorXYZ("screenX");
        return 0.0f;
    }

    public float screenY(float f, float f2, float f3) {
        this.depthErrorXYZ("screenY");
        return 0.0f;
    }

    public float screenZ(float f, float f2, float f3) {
        this.depthErrorXYZ("screenZ");
        return 0.0f;
    }

    public float modelX(float f, float f2, float f3) {
        this.depthErrorXYZ("modelX");
        return 0.0f;
    }

    public float modelY(float f, float f2, float f3) {
        this.depthErrorXYZ("modelY");
        return 0.0f;
    }

    public float modelZ(float f, float f2, float f3) {
        this.depthErrorXYZ("modelZ");
        return 0.0f;
    }

    public void colorMode(int n) {
        this.colorMode = n;
    }

    public void colorMode(int n, float f) {
        this.colorMode(n, f, f, f, f);
    }

    public void colorMode(int n, float f, float f2, float f3) {
        this.colorMode(n, f, f2, f3, this.colorModeA);
    }

    public void colorMode(int n, float f, float f2, float f3, float f4) {
        this.colorMode = n;
        this.colorModeX = f;
        this.colorModeY = f2;
        this.colorModeZ = f3;
        this.colorModeA = f4;
        boolean bl = false;
        if (f4 != 1.0f || f != f2 || f2 != f3 || f3 != f4) {
            bl = true;
        }
        this.colorScale = bl;
        boolean bl2 = false;
        if (this.colorMode == 1 && this.colorModeA == 255.0f && this.colorModeX == 255.0f && this.colorModeY == 255.0f && this.colorModeZ == 255.0f) {
            bl2 = true;
        }
        this.colorRgb255 = bl2;
    }

    protected void colorCalc(float f) {
        this.colorCalc(f, this.colorModeA);
    }

    protected void colorCalc(float f, float f2) {
        if (f > this.colorModeX) {
            f = this.colorModeX;
        }
        if (f2 > this.colorModeA) {
            f2 = this.colorModeA;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        this.calcG = this.calcR = this.colorScale ? f / this.colorModeX : f;
        this.calcB = this.calcR;
        this.calcA = this.colorScale ? f2 / this.colorModeA : f2;
        this.calcRi = (int)(this.calcR * 255.0f);
        this.calcGi = (int)(this.calcG * 255.0f);
        this.calcBi = (int)(this.calcB * 255.0f);
        this.calcAi = (int)(this.calcA * 255.0f);
        this.calcColor = this.calcAi << 24 | this.calcRi << 16 | this.calcGi << 8 | this.calcBi;
        boolean bl = false;
        if (this.calcAi != 255) {
            bl = true;
        }
        this.calcAlpha = bl;
    }

    protected void colorCalc(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3, this.colorModeA);
    }

    protected void colorCalc(float f, float f2, float f3, float f4) {
        if (f > this.colorModeX) {
            f = this.colorModeX;
        }
        if (f2 > this.colorModeY) {
            f2 = this.colorModeY;
        }
        if (f3 > this.colorModeZ) {
            f3 = this.colorModeZ;
        }
        if (f4 > this.colorModeA) {
            f4 = this.colorModeA;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        block0 : switch (this.colorMode) {
            case 1: {
                if (this.colorScale) {
                    this.calcR = f / this.colorModeX;
                    this.calcG = f2 / this.colorModeY;
                    this.calcB = f3 / this.colorModeZ;
                    this.calcA = f4 / this.colorModeA;
                    break;
                }
                this.calcR = f;
                this.calcG = f2;
                this.calcB = f3;
                this.calcA = f4;
                break;
            }
            case 3: {
                f /= this.colorModeX;
                f3 /= this.colorModeZ;
                float f5 = this.calcA = this.colorScale ? f4 / this.colorModeA : f4;
                if ((f2 /= this.colorModeY) == 0.0f) {
                    this.calcG = this.calcB = f3;
                    this.calcR = this.calcB;
                    break;
                }
                float f6 = (f - (float)((int)f)) * 6.0f;
                float f7 = f6 - (float)((int)f6);
                float f8 = f3 * (1.0f - f2);
                float f9 = f3 * (1.0f - f2 * f7);
                float f10 = f3 * (1.0f - f2 * (1.0f - f7));
                switch ((int)f6) {
                    case 0: {
                        this.calcR = f3;
                        this.calcG = f10;
                        this.calcB = f8;
                        break block0;
                    }
                    case 1: {
                        this.calcR = f9;
                        this.calcG = f3;
                        this.calcB = f8;
                        break block0;
                    }
                    case 2: {
                        this.calcR = f8;
                        this.calcG = f3;
                        this.calcB = f10;
                        break block0;
                    }
                    case 3: {
                        this.calcR = f8;
                        this.calcG = f9;
                        this.calcB = f3;
                        break block0;
                    }
                    case 4: {
                        this.calcR = f10;
                        this.calcG = f8;
                        this.calcB = f3;
                        break block0;
                    }
                    case 5: {
                        this.calcR = f3;
                        this.calcG = f8;
                        this.calcB = f9;
                        break block0;
                    }
                }
                break;
            }
        }
        this.calcRi = (int)(255.0f * this.calcR);
        this.calcGi = (int)(255.0f * this.calcG);
        this.calcBi = (int)(255.0f * this.calcB);
        this.calcAi = (int)(255.0f * this.calcA);
        this.calcColor = this.calcAi << 24 | this.calcRi << 16 | this.calcGi << 8 | this.calcBi;
        boolean bl = false;
        if (this.calcAi != 255) {
            bl = true;
        }
        this.calcAlpha = bl;
    }

    protected void colorFrom(int n) {
        this.calcColor = n;
        this.calcAi = n >> 24 & 0xFF;
        this.calcRi = n >> 16 & 0xFF;
        this.calcGi = n >> 8 & 0xFF;
        this.calcBi = n & 0xFF;
        this.calcA = (float)this.calcAi / 255.0f;
        this.calcR = (float)this.calcRi / 255.0f;
        this.calcG = (float)this.calcGi / 255.0f;
        this.calcB = (float)this.calcBi / 255.0f;
        boolean bl = false;
        if (this.calcAi != 255) {
            bl = true;
        }
        this.calcAlpha = bl;
    }

    protected void colorTint() {
        this.tint = true;
        this.tintR = this.calcR;
        this.tintG = this.calcG;
        this.tintB = this.calcB;
        this.tintA = this.calcA;
        this.tintRi = this.calcRi;
        this.tintGi = this.calcGi;
        this.tintBi = this.calcBi;
        this.tintAi = this.calcAi;
        this.tintColor = this.calcColor;
        this.tintAlpha = this.calcAlpha;
    }

    protected void colorFill() {
        this.fill = true;
        this.fillR = this.calcR;
        this.fillG = this.calcG;
        this.fillB = this.calcB;
        this.fillA = this.calcA;
        this.fillRi = this.calcRi;
        this.fillGi = this.calcGi;
        this.fillBi = this.calcBi;
        this.fillAi = this.calcAi;
        this.fillColor = this.calcColor;
        this.fillAlpha = this.calcAlpha;
    }

    protected void colorStroke() {
        this.stroke = true;
        this.strokeR = this.calcR;
        this.strokeG = this.calcG;
        this.strokeB = this.calcB;
        this.strokeA = this.calcA;
        this.strokeRi = this.calcRi;
        this.strokeGi = this.calcGi;
        this.strokeBi = this.calcBi;
        this.strokeAi = this.calcAi;
        this.strokeColor = this.calcColor;
        this.strokeAlpha = this.calcAlpha;
    }

    protected void colorBackground() {
        this.backgroundR = this.calcR;
        this.backgroundG = this.calcG;
        this.backgroundB = this.calcB;
        this.backgroundRi = this.calcRi;
        this.backgroundGi = this.calcGi;
        this.backgroundBi = this.calcBi;
        this.backgroundColor = this.calcColor;
    }

    public void noTint() {
        this.tint = false;
    }

    public void tint(int n) {
        if ((n & 0xFF000000) == 0 && (float)n <= this.colorModeX) {
            this.tint((float)n);
        } else {
            this.colorFrom(n);
            this.colorTint();
        }
    }

    public void tint(float f) {
        this.colorCalc(f);
        this.colorTint();
    }

    public void tint(float f, float f2) {
        this.colorCalc(f, f2);
        this.colorTint();
    }

    public void tint(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.colorTint();
    }

    public void tint(float f, float f2, float f3, float f4) {
        this.colorCalc(f, f2, f3, f4);
        this.colorTint();
    }

    public void noFill() {
        this.fill = false;
    }

    public void fill(int n) {
        if ((n & 0xFF000000) == 0 && (float)n <= this.colorModeX) {
            this.fill((float)n);
        } else {
            this.colorFrom(n);
            this.colorFill();
        }
    }

    public void fill(float f) {
        this.colorCalc(f);
        this.colorFill();
    }

    public void fill(float f, float f2) {
        this.colorCalc(f, f2);
        this.colorFill();
    }

    public void fill(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.colorFill();
    }

    public void fill(float f, float f2, float f3, float f4) {
        this.colorCalc(f, f2, f3, f4);
        this.colorFill();
    }

    public void ambient(int n) {
        this.depthError("ambient");
    }

    public void ambient(float f) {
        this.depthError("ambient");
    }

    public void ambient(float f, float f2, float f3) {
        this.depthError("ambient");
    }

    public void specular(int n) {
        this.depthError("specular");
    }

    public void specular(float f) {
        this.depthError("specular");
    }

    public void specular(float f, float f2) {
        this.depthError("specular");
    }

    public void specular(float f, float f2, float f3) {
        this.depthError("specular");
    }

    public void specular(float f, float f2, float f3, float f4) {
        this.depthError("specular");
    }

    public void shininess(float f) {
        this.depthError("shininess");
    }

    public void emissive(int n) {
        this.depthError("emissive");
    }

    public void emissive(float f) {
        this.depthError("emissive");
    }

    public void emissive(float f, float f2, float f3) {
        this.depthError("emissive");
    }

    public void lights() {
        this.depthError("lights");
    }

    public void ambientLight(float f, float f2, float f3) {
        this.depthError("ambientLight");
    }

    public void ambientLight(float f, float f2, float f3, float f4, float f5, float f6) {
        this.depthError("ambientLight");
    }

    public void directionalLight(float f, float f2, float f3, float f4, float f5, float f6) {
        this.depthError("directionalLight");
    }

    public void pointLight(float f, float f2, float f3, float f4, float f5, float f6) {
        this.depthError("pointLight");
    }

    public void spotLight(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        this.depthError("spotLight");
    }

    public void lightFalloff(float f, float f2, float f3) {
        this.depthError("lightFalloff");
    }

    public void lightSpecular(float f, float f2, float f3) {
        this.depthError("lightSpecular");
    }

    public void strokeWeight(float f) {
        this.strokeWeight = f;
    }

    public void strokeJoin(int n) {
        this.strokeJoin = n;
    }

    public void strokeCap(int n) {
        this.strokeCap = n;
    }

    public void noStroke() {
        this.stroke = false;
    }

    public void stroke(int n) {
        if ((n & 0xFF000000) == 0 && (float)n <= this.colorModeX) {
            this.stroke((float)n);
        } else {
            this.colorFrom(n);
            this.colorStroke();
        }
    }

    public void stroke(float f) {
        this.colorCalc(f);
        this.colorStroke();
    }

    public void stroke(float f, float f2) {
        this.colorCalc(f, f2);
        this.colorStroke();
    }

    public void stroke(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.colorStroke();
    }

    public void stroke(float f, float f2, float f3, float f4) {
        this.colorCalc(f, f2, f3, f4);
        this.colorStroke();
    }

    public void background(int n) {
        if ((n & 0xFF000000) == 0 && (float)n <= this.colorModeX) {
            this.background((float)n);
        } else {
            this.colorFrom(n);
            this.colorBackground();
        }
        this.clear();
    }

    public void background(float f) {
        this.colorCalc(f);
        this.colorBackground();
        this.clear();
    }

    public void background(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.colorBackground();
        this.clear();
    }

    public void background(PImage pImage) {
        if (pImage.width != this.width || pImage.height != this.height) {
            throw new RuntimeException("background image must be the same size as your application");
        }
        if (pImage.format != 1 && pImage.format != 2) {
            throw new RuntimeException("background images should be RGB or ARGB");
        }
        this.backgroundColor = 0;
        System.arraycopy(pImage.pixels, 0, this.pixels, 0, this.pixels.length);
    }

    protected void clear() {
        int n = 0;
        while (n < this.pixelCount) {
            this.pixels[n] = this.backgroundColor;
            ++n;
        }
    }

    protected void depthError(String string) {
        throw new RuntimeException(string + "() can only be used with P3D or OPENGL.");
    }

    protected void depthErrorXYZ(String string) {
        throw new RuntimeException(string + "(x, y, z) can only be used with OPENGL or P3D, use " + string + "(x, y) instead.");
    }

    public final int color(int n) {
        if (this.colorRgb255) {
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            return 0xFF000000 | n << 16 | n << 8 | n;
        }
        this.colorCalc(n);
        return this.calcColor;
    }

    public final int color(float f) {
        this.colorCalc(f);
        return this.calcColor;
    }

    public final int color(int n, int n2) {
        if (this.colorRgb255) {
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            } else if (n2 < 0) {
                n2 = 0;
            }
            return (n2 & 0xFF) << 24 | n << 16 | n << 8 | n;
        }
        this.colorCalc(n, n2);
        return this.calcColor;
    }

    public final int color(float f, float f2) {
        this.colorCalc(f, f2);
        return this.calcColor;
    }

    public final int color(int n, int n2, int n3) {
        if (this.colorRgb255) {
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            } else if (n2 < 0) {
                n2 = 0;
            }
            if (n3 > 255) {
                n3 = 255;
            } else if (n3 < 0) {
                n3 = 0;
            }
            return 0xFF000000 | n << 16 | n2 << 8 | n3;
        }
        this.colorCalc(n, n2, n3);
        return this.calcColor;
    }

    public final int color(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        return this.calcColor;
    }

    public final int color(int n, int n2, int n3, int n4) {
        if (this.colorRgb255) {
            if (n4 > 255) {
                n4 = 255;
            } else if (n4 < 0) {
                n4 = 0;
            }
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            } else if (n2 < 0) {
                n2 = 0;
            }
            if (n3 > 255) {
                n3 = 255;
            } else if (n3 < 0) {
                n3 = 0;
            }
            return n4 << 24 | n << 16 | n2 << 8 | n3;
        }
        this.colorCalc(n, n2, n3, n4);
        return this.calcColor;
    }

    public final int color(float f, float f2, float f3, float f4) {
        this.colorCalc(f, f2, f3, f4);
        return this.calcColor;
    }

    public final float alpha(int n) {
        float f = n >> 24 & 0xFF;
        if (this.colorModeA == 255.0f) {
            return f;
        }
        return f / 255.0f * this.colorModeA;
    }

    public final float red(int n) {
        float f = n >> 16 & 0xFF;
        if (this.colorRgb255) {
            return f;
        }
        return f / 255.0f * this.colorModeX;
    }

    public final float green(int n) {
        float f = n >> 8 & 0xFF;
        if (this.colorRgb255) {
            return f;
        }
        return f / 255.0f * this.colorModeY;
    }

    public final float blue(int n) {
        float f = n & 0xFF;
        if (this.colorRgb255) {
            return f;
        }
        return f / 255.0f * this.colorModeZ;
    }

    public final float hue(int n) {
        if (n != this.cacheHsbKey) {
            Color.RGBtoHSB(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, this.cacheHsbValue);
            this.cacheHsbKey = n;
        }
        return this.cacheHsbValue[0] * this.colorModeX;
    }

    public final float saturation(int n) {
        if (n != this.cacheHsbKey) {
            Color.RGBtoHSB(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, this.cacheHsbValue);
            this.cacheHsbKey = n;
        }
        return this.cacheHsbValue[1] * this.colorModeY;
    }

    public final float brightness(int n) {
        if (n != this.cacheHsbKey) {
            Color.RGBtoHSB(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, this.cacheHsbValue);
            this.cacheHsbKey = n;
        }
        return this.cacheHsbValue[2] * this.colorModeZ;
    }

    public void mask(int[] nArray) {
        super.mask(nArray);
    }

    public void mask(PImage pImage) {
        super.mask(pImage);
    }

    private final /* synthetic */ void this() {
        this.hints = new boolean[8];
        this.cacheHsbValue = new float[3];
        this.matrixStack = new float[32][16];
        this.vertices = new float[512][36];
        this.bezier_inited = false;
        this.bezier_detail = 20;
        float[][] fArrayArray = new float[4][];
        fArrayArray[0] = new float[]{-1.0f, 3, -3.0f, 1.0f};
        float[] fArray = new float[4];
        fArray[0] = 3;
        fArray[1] = -6.0f;
        fArray[2] = 3;
        fArrayArray[1] = fArray;
        float[] fArray2 = new float[4];
        fArray2[0] = -3.0f;
        fArray2[1] = 3;
        fArrayArray[2] = fArray2;
        float[] fArray3 = new float[4];
        fArray3[0] = 1.0f;
        fArrayArray[3] = fArray3;
        this.bezier_basis = fArrayArray;
        this.bezierBasis = new PMatrix(-1.0f, 3, -3.0f, 1.0f, 3, -6.0f, 3, 0.0f, -3.0f, 3, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.curve_inited = false;
        this.curve_detail = 20;
        this.curve_tightness = 0.0f;
    }

    public PGraphics() {
        this.this();
    }

    public PGraphics(int n, int n2, PApplet pApplet) {
        this.this();
        if (pApplet != null) {
            pApplet.addListeners();
        }
        this.resize(n, n2);
    }

    static {
        int n = 0;
        while (n < 720) {
            PGraphics.sinLUT[n] = (float)Math.sin((float)n * ((float)Math.PI / 180) * 0.5f);
            PGraphics.cosLUT[n] = (float)Math.cos((float)n * ((float)Math.PI / 180) * 0.5f);
            ++n;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Path {
        public void moveTo(float f, float f2) {
        }

        public void lineTo(float f, float f2) {
        }

        public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
        }

        public void closePath() {
        }

        Path() {
        }
    }
}

