/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PGraphics2
extends PGraphics {
    public Graphics2D g2;
    GeneralPath gpath;
    int transformCount;
    AffineTransform[] transformStack;
    double[] transform;
    Line2D.Float line;
    Ellipse2D.Float ellipse;
    Rectangle2D.Float rect;
    Arc2D.Float arc;
    protected Color tintColorObject;
    protected Color fillColorObject;
    protected Color strokeColorObject;
    float[] curveX;
    float[] curveY;

    public void resize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        this.allocate();
        this.background(this.backgroundColor);
    }

    protected void allocate() {
        this.image = new BufferedImage(this.width, this.height, 2);
        this.g2 = (Graphics2D)this.image.getGraphics();
    }

    public void endFrame() {
    }

    public void vertex(float f, float f2) {
        this.splineVertexCount = 0;
        if (this.vertexCount == this.vertices.length) {
            float[][] fArray = new float[this.vertexCount << 1][36];
            System.arraycopy(this.vertices, 0, fArray, 0, this.vertexCount);
            this.vertices = fArray;
        }
        this.vertices[this.vertexCount][9] = f;
        this.vertices[this.vertexCount][10] = f2;
        ++this.vertexCount;
        switch (this.shape) {
            case 16: {
                this.point(f, f2);
                break;
            }
            case 32: {
                if (this.vertexCount % 2 != 0) break;
                this.line(this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10], f, f2);
                break;
            }
            case 33: 
            case 34: {
                if (this.gpath == null) {
                    this.gpath = new GeneralPath();
                    this.gpath.moveTo(f, f2);
                    break;
                }
                this.gpath.lineTo(f, f2);
                break;
            }
            case 64: {
                if (this.vertexCount % 3 != 0) break;
                this.triangle(this.vertices[this.vertexCount - 3][9], this.vertices[this.vertexCount - 3][10], this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10], f, f2);
                break;
            }
            case 65: {
                if (this.vertexCount < 3) break;
                this.triangle(this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10], this.vertices[this.vertexCount - 1][9], this.vertices[this.vertexCount - 1][10], this.vertices[this.vertexCount - 3][9], this.vertices[this.vertexCount - 3][10]);
                break;
            }
            case 66: {
                if (this.vertexCount == 3) {
                    this.triangle(this.vertices[0][9], this.vertices[0][10], this.vertices[1][9], this.vertices[1][10], f, f2);
                    break;
                }
                if (this.vertexCount <= 3) break;
                this.gpath = new GeneralPath();
                this.gpath.moveTo(this.vertices[0][9], this.vertices[0][10]);
                this.gpath.lineTo(this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10]);
                this.gpath.lineTo(f, f2);
                this.draw_shape(this.gpath);
                break;
            }
            case 128: {
                if (this.vertexCount % 4 != 0) break;
                this.quad(this.vertices[this.vertexCount - 4][9], this.vertices[this.vertexCount - 4][10], this.vertices[this.vertexCount - 3][9], this.vertices[this.vertexCount - 3][10], this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10], f, f2);
                break;
            }
            case 129: {
                if (this.vertexCount < 4 || this.vertexCount % 2 != 0) break;
                this.quad(this.vertices[this.vertexCount - 4][9], this.vertices[this.vertexCount - 4][10], this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10], f, f2, this.vertices[this.vertexCount - 3][9], this.vertices[this.vertexCount - 3][10]);
                break;
            }
            case 256: {
                if (this.gpath == null) {
                    this.gpath = new GeneralPath();
                    this.gpath.moveTo(f, f2);
                    break;
                }
                this.gpath.lineTo(f, f2);
                break;
            }
        }
    }

    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.gpath == null) {
            throw new RuntimeException("Must call vertex() at least once before using bezierVertex()");
        }
        switch (this.shape) {
            case 33: 
            case 34: 
            case 256: {
                this.gpath.curveTo(f, f2, f3, f4, f5, f6);
                break;
            }
            default: {
                throw new RuntimeException("bezierVertex() can only be used with LINE_STRIP, LINE_LOOP, or POLYGON");
            }
        }
    }

    public void curveVertex(float f, float f2) {
        if (this.shape != 34 && this.shape != 33 && this.shape != 256) {
            throw new RuntimeException("curveVertex() can only be used with LINE_LOOP, LINE_STRIP, and POLYGON shapes");
        }
        if (!this.curve_inited) {
            this.curve_init();
        }
        this.vertexCount = 0;
        if (this.splineVertices == null) {
            this.splineVertices = new float[128][36];
        }
        if (this.splineVertexCount == 128) {
            System.arraycopy(this.splineVertices[125], 0, this.splineVertices[0], 0, 36);
            System.arraycopy(this.splineVertices[126], 0, this.splineVertices[1], 0, 36);
            this.splineVertexCount = 3;
        }
        if (this.splineVertexCount >= 3) {
            this.curveX[0] = this.splineVertices[this.splineVertexCount - 3][9];
            this.curveY[0] = this.splineVertices[this.splineVertexCount - 3][10];
            this.curveX[1] = this.splineVertices[this.splineVertexCount - 2][9];
            this.curveY[1] = this.splineVertices[this.splineVertexCount - 2][10];
            this.curveX[2] = this.splineVertices[this.splineVertexCount - 1][9];
            this.curveY[2] = this.splineVertices[this.splineVertexCount - 1][10];
            this.curveX[3] = f;
            this.curveY[3] = f2;
            this.curveToBezierMatrix.mult(this.curveX, this.curveX);
            this.curveToBezierMatrix.mult(this.curveY, this.curveY);
            if (this.gpath == null) {
                this.gpath = new GeneralPath();
                this.gpath.moveTo(this.curveX[0], this.curveY[0]);
            }
            this.gpath.curveTo(this.curveX[1], this.curveY[1], this.curveX[2], this.curveY[2], this.curveX[3], this.curveY[3]);
        }
        this.splineVertices[this.splineVertexCount][9] = f;
        this.splineVertices[this.splineVertexCount][10] = f2;
        ++this.splineVertexCount;
    }

    public void beginShape(int n) {
        super.beginShape(n);
        this.gpath = null;
    }

    public void endShape() {
        switch (this.shape) {
            case 33: {
                this.stroke_shape(this.gpath);
                break;
            }
            case 34: {
                this.gpath.closePath();
                this.stroke_shape(this.gpath);
                break;
            }
            case 256: {
                this.gpath.closePath();
                this.draw_shape(this.gpath);
                break;
            }
        }
        this.shape = 0;
    }

    protected void fill_shape(Shape shape) {
        if (this.fill) {
            this.g2.setColor(this.fillColorObject);
            this.g2.fill(shape);
        }
    }

    protected void stroke_shape(Shape shape) {
        if (this.stroke) {
            this.g2.setColor(this.strokeColorObject);
            this.g2.draw(shape);
        }
    }

    protected void draw_shape(Shape shape) {
        if (this.fill) {
            this.g2.setColor(this.fillColorObject);
            this.g2.fill(shape);
        }
        if (this.stroke) {
            this.g2.setColor(this.strokeColorObject);
            this.g2.draw(shape);
        }
    }

    public void point(float f, float f2) {
        this.line(f, f2, f, f2);
    }

    public void line(float f, float f2, float f3, float f4) {
        this.line.setLine(f, f2, f3, f4);
        this.stroke_shape(this.line);
    }

    public void triangle(float f, float f2, float f3, float f4, float f5, float f6) {
        this.gpath = new GeneralPath();
        this.gpath.moveTo(f, f2);
        this.gpath.lineTo(f3, f4);
        this.gpath.lineTo(f5, f6);
        this.gpath.closePath();
        this.draw_shape(this.gpath);
    }

    public void quad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f3, f4);
        generalPath.lineTo(f5, f6);
        generalPath.lineTo(f7, f8);
        generalPath.closePath();
        this.draw_shape(generalPath);
    }

    protected void rectImpl(float f, float f2, float f3, float f4) {
        this.rect.setFrame(f, f2, f3 - f, f4 - f2);
        this.draw_shape(this.rect);
    }

    protected void ellipseImpl(float f, float f2, float f3, float f4) {
        this.ellipse.setFrame(f, f2, f3, f4);
        this.draw_shape(this.ellipse);
    }

    protected void arcImpl(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7;
        if (f6 - f5 >= (float)Math.PI * 2) {
            f5 = 0.0f;
            f6 = 360.0f;
        } else {
            f5 = -f5 * 57.295776f;
            f6 = -f6 * 57.295776f;
            while (f5 < 0.0f) {
                f5 += 360.0f;
                f6 += 360.0f;
            }
            if (f5 > f6) {
                f7 = f5;
                f5 = f6;
                f6 = f7;
            }
        }
        f7 = f6 - f5;
        if (this.fill) {
            this.arc.setArc(f, f2, f3, f4, f5, f7, 2);
            this.fill_shape(this.arc);
        }
        if (this.stroke) {
            this.arc.setArc(f, f2, f3, f4, f5, f7, 0);
            this.stroke_shape(this.arc);
        }
    }

    public void bezierDetail(int n) {
    }

    public void curveDetail(int n) {
    }

    protected void imageImpl(PImage pImage, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        if (pImage.cache == null) {
            pImage.cache = new ImageCache(pImage);
            pImage.updatePixels();
        }
        ImageCache imageCache = (ImageCache)pImage.cache;
        if (this.tint && !imageCache.tinted || this.tint && imageCache.tintedColor != this.tintColor || !this.tint && imageCache.tinted) {
            pImage.updatePixels();
        }
        if (pImage.modified) {
            imageCache.update();
            pImage.modified = false;
        }
        this.g2.drawImage(((ImageCache)pImage.cache).image, (int)f, (int)f2, (int)f3, (int)f4, n, n2, n3, n4, null);
    }

    public void translate(float f, float f2) {
        this.g2.translate(f, f2);
    }

    public void rotate(float f) {
        this.g2.rotate(f);
    }

    public void scale(float f) {
        this.g2.scale(f, f);
    }

    public void scale(float f, float f2) {
        this.g2.scale(f, f2);
    }

    public void pushMatrix() {
        if (this.transformCount == this.transformStack.length) {
            throw new RuntimeException("pushMatrix() cannot use push more than " + this.transformStack.length + " times");
        }
        this.transformStack[this.transformCount] = this.g2.getTransform();
        ++this.transformCount;
    }

    public void popMatrix() {
        if (this.transformCount == 0) {
            throw new RuntimeException("missing a popMatrix() to go with that pushMatrix()");
        }
        --this.transformCount;
        this.g2.setTransform(this.transformStack[this.transformCount]);
    }

    public void resetMatrix() {
        this.g2.setTransform(new AffineTransform());
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        this.g2.transform(new AffineTransform(f, f4, f2, f5, f3, f6));
    }

    public void printMatrix() {
        this.g2.getTransform().getMatrix(this.transform);
        this.m00 = (float)this.transform[0];
        this.m01 = (float)this.transform[2];
        this.m02 = (float)this.transform[4];
        this.m10 = (float)this.transform[1];
        this.m11 = (float)this.transform[3];
        this.m12 = (float)this.transform[5];
        super.printMatrix();
    }

    public float screenX(float f, float f2) {
        this.g2.getTransform().getMatrix(this.transform);
        return (float)this.transform[0] * f + (float)this.transform[2] * f2 + (float)this.transform[4];
    }

    public float screenY(float f, float f2) {
        this.g2.getTransform().getMatrix(this.transform);
        return (float)this.transform[1] * f + (float)this.transform[3] * f2 + (float)this.transform[5];
    }

    protected void colorTint() {
        super.colorTint();
        this.tintColorObject = new Color(this.tintColor, true);
    }

    protected void colorFill() {
        super.colorFill();
        this.fillColorObject = new Color(this.fillColor, true);
    }

    protected void colorStroke() {
        super.colorStroke();
        this.strokeColorObject = new Color(this.strokeColor, true);
    }

    public void strokeWeight(float f) {
        super.strokeWeight(f);
        this.set_stroke();
    }

    public void strokeJoin(int n) {
        super.strokeJoin(n);
        this.set_stroke();
    }

    public void strokeCap(int n) {
        super.strokeCap(n);
        this.set_stroke();
    }

    protected void set_stroke() {
        int n = 0;
        if (this.strokeCap == 2) {
            n = 1;
        } else if (this.strokeCap == 4) {
            n = 2;
        }
        int n2 = 2;
        if (this.strokeJoin == 8) {
            n2 = 0;
        } else if (this.strokeJoin == 2) {
            n2 = 1;
        }
        this.g2.setStroke(new BasicStroke(this.strokeWeight, n, n2));
    }

    public void background(PImage pImage) {
        if (pImage.width != this.width || pImage.height != this.height) {
            throw new RuntimeException("background image must be the same size as your application");
        }
        if (pImage.format != 1 && pImage.format != 2) {
            throw new RuntimeException("background images should be RGB or ARGB");
        }
        this.set(0, 0, pImage);
    }

    public void clear() {
        this.g2.setColor(new Color(this.backgroundColor));
        this.g2.fillRect(0, 0, this.width, this.height);
    }

    public void smooth() {
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public void noSmooth() {
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public void loadPixels() {
        if (this.pixels == null || this.pixels.length != this.width * this.height) {
            this.pixels = new int[this.width * this.height];
        }
        ((BufferedImage)this.image).getRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
    }

    public void updatePixels() {
        this.updatePixels(0, 0, this.width, this.height);
    }

    public void updatePixels(int n, int n2, int n3, int n4) {
        ((BufferedImage)this.image).setRGB(n, n2, this.imageMode == 0 ? n3 : n3 - n, this.imageMode == 0 ? n4 : n4 - n2, this.pixels, 0, this.width);
    }

    public int get(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return 0;
        }
        return ((BufferedImage)this.image).getRGB(n, n2);
    }

    public PImage get(int n, int n2, int n3, int n4) {
        if (this.imageMode == 1) {
            n3 -= n;
            n4 -= n;
        }
        if (n < 0) {
            n3 += n;
            n = 0;
        }
        if (n2 < 0) {
            n4 += n2;
            n2 = 0;
        }
        if (n + n3 > this.width) {
            n3 = this.width - n;
        }
        if (n2 + n4 > this.height) {
            n4 = this.height - n2;
        }
        PImage pImage = new PImage(n3, n4);
        ((BufferedImage)this.image).getRGB(n, n2, n3, n4, pImage.pixels, 0, n3);
        return pImage;
    }

    public PImage get() {
        PImage pImage = new PImage(this.width, this.height);
        ((BufferedImage)this.image).getRGB(0, 0, this.width, this.height, pImage.pixels, 0, this.width);
        return pImage;
    }

    public void set(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return;
        }
        ((BufferedImage)this.image).setRGB(n, n2, n3);
    }

    protected void setImpl(int n, int n2, int n3, int n4, int n5, int n6, PImage pImage) {
        BufferedImage bufferedImage = (BufferedImage)this.image;
        bufferedImage.setRGB(n, n2, n5, n6, pImage.pixels, n4 * pImage.width + n3, pImage.width);
    }

    public void filter(int n) {
        this.loadPixels();
        super.filter(n);
        this.updatePixels();
    }

    public void filter(int n, float f) {
        this.loadPixels();
        super.filter(n, f);
        this.updatePixels();
    }

    public void copy(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.loadPixels();
        super.copy(pImage, n, n2, n3, n4, n5, n6, n7, n8);
        this.updatePixels();
    }

    public void blend(PImage pImage, int n, int n2, int n3, int n4, int n5) {
        this.loadPixels();
        super.blend(pImage, n, n2, n3, n4, n5);
        this.updatePixels();
    }

    public void blend(int n, int n2, int n3, int n4, int n5) {
        this.loadPixels();
        super.blend(n, n2, n3, n4, n5);
        this.updatePixels();
    }

    public void blend(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.loadPixels();
        super.blend(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.updatePixels();
    }

    public void blend(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.loadPixels();
        super.blend(pImage, n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.updatePixels();
    }

    public void save(String string) {
        this.loadPixels();
        super.save(string);
    }

    private final /* synthetic */ void this() {
        this.transformStack = new AffineTransform[32];
        this.transform = new double[6];
        this.line = new Line2D.Float();
        this.ellipse = new Ellipse2D.Float();
        this.rect = new Rectangle2D.Float();
        this.arc = new Arc2D.Float();
        this.curveX = new float[4];
        this.curveY = new float[4];
    }

    public PGraphics2() {
        this.this();
    }

    public PGraphics2(int n, int n2, PApplet pApplet) {
        super(n, n2, pApplet);
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ImageCache {
        PImage source;
        boolean tinted;
        int tintedColor;
        int[] tintedPixels;
        BufferedImage image;

        public void update() {
            if (this.source.format == 2 || this.source.format == 1) {
                if (PGraphics2.this.tint) {
                    if (this.tintedPixels == null) {
                        this.tintedPixels = new int[this.source.width * this.source.height];
                    }
                    int n = PGraphics2.this.tintColor;
                    int n2 = PGraphics2.this.tintColor >> 24 & 0xFF;
                    int n3 = PGraphics2.this.tintColor >> 16 & 0xFF;
                    int n4 = PGraphics2.this.tintColor >> 8 & 0xFF;
                    int n5 = PGraphics2.this.tintColor & 0xFF;
                    if (this.source.format == 1) {
                        int n6 = n2 << 24;
                        int n7 = 0;
                        while (n7 < this.tintedPixels.length) {
                            int n8 = this.source.pixels[n7];
                            int n9 = n8 >> 16 & 0xFF;
                            int n10 = n8 >> 8 & 0xFF;
                            int n11 = n8 & 0xFF;
                            this.tintedPixels[n7] = n6 | (n3 * n9 & 0xFF00) << 8 | n4 * n10 & 0xFF00 | (n5 * n11 & 0xFF00) >> 8;
                            ++n7;
                        }
                    } else {
                        int n12 = 0;
                        while (n12 < this.tintedPixels.length) {
                            int n13 = this.source.pixels[n12];
                            int n14 = n13 >> 24 & 0xFF;
                            int n15 = n13 >> 16 & 0xFF;
                            int n16 = n13 >> 8 & 0xFF;
                            int n17 = n13 & 0xFF;
                            this.tintedPixels[n12] = (n2 * n14 & 0xFF00) << 16 | (n3 * n15 & 0xFF00) << 8 | n4 * n16 & 0xFF00 | (n5 * n17 & 0xFF00) >> 8;
                            ++n12;
                        }
                    }
                    this.tinted = true;
                    this.tintedColor = PGraphics2.this.tintColor;
                    this.image.setRGB(0, 0, this.source.width, this.source.height, this.tintedPixels, 0, this.source.width);
                } else {
                    this.image.setRGB(0, 0, this.source.width, this.source.height, this.source.pixels, 0, this.source.width);
                }
            } else if (this.source.format == 4) {
                if (this.tintedPixels == null) {
                    this.tintedPixels = new int[this.source.width * this.source.height];
                }
                int n = PGraphics2.this.tintColor & 0xFFFFFF;
                if ((PGraphics2.this.tintColor >> 24 & 0xFF) >= 254) {
                    int n18 = 0;
                    while (n18 < this.tintedPixels.length) {
                        int n19 = 0;
                        if (this.source.pixels[n18] != 0) {
                            n19 = this.source.pixels[n18] << 24 | n;
                        }
                        this.tintedPixels[n18] = n19;
                        ++n18;
                    }
                } else {
                    int n20 = PGraphics2.this.tintColor >> 24 & 0xFF;
                    int n21 = 0;
                    while (n21 < this.tintedPixels.length) {
                        int n22 = 0;
                        if (this.source.pixels[n21] != 0) {
                            n22 = (n20 * this.source.pixels[n21] & 0xFF00) << 16 | n;
                        }
                        this.tintedPixels[n21] = n22;
                        ++n21;
                    }
                }
                this.tinted = true;
                this.tintedColor = PGraphics2.this.tintColor;
                this.image.setRGB(0, 0, this.source.width, this.source.height, this.tintedPixels, 0, this.source.width);
            }
        }

        public ImageCache(PImage pImage) {
            this.source = pImage;
            int n = 2;
            this.image = new BufferedImage(pImage.width, pImage.height, n);
        }
    }
}

