/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PImage;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PPolygon
implements PConstants {
    static final int DEFAULT_SIZE = 64;
    static final boolean FRY = false;
    static final int SUBXRES = 8;
    static final int SUBXRES1 = 7;
    static final int SUBYRES = 8;
    static final int SUBYRES1 = 7;
    static final int MAX_COVERAGE = 64;
    float[][] vertices;
    int vertexCount;
    float[] r;
    float[] dr;
    float[] l;
    float[] dl;
    float[] sp;
    float[] sdp;
    boolean interpX;
    boolean interpZ;
    boolean interpUV;
    boolean interpARGB;
    int rgba;
    int r2;
    int g2;
    int b2;
    int a2;
    int a2orig;
    boolean noDepthTest;
    PGraphics parent;
    int[] pixels;
    int width;
    int height;
    int width1;
    int height1;
    PImage timage;
    int[] tpixels;
    int theight;
    int twidth;
    int theight1;
    int twidth1;
    int tformat;
    boolean texture_smooth;
    boolean smoothing;
    int firstModY;
    int lastModY;
    int lastY;
    int[] aaleft;
    int[] aaright;
    int aaleftmin;
    int aarightmin;
    int aaleftmax;
    int aarightmax;
    int aaleftfull;
    int aarightfull;

    private final int MODYRES(int n) {
        return n & 7;
    }

    public void reset(int n) {
        this.vertexCount = n;
        this.interpX = true;
        this.interpZ = true;
        this.interpUV = false;
        this.interpARGB = true;
        this.timage = null;
    }

    public float[] nextVertex() {
        if (this.vertexCount == this.vertices.length) {
            float[][] fArray = new float[this.vertexCount << 1][36];
            System.arraycopy(this.vertices, 0, fArray, 0, this.vertexCount);
            this.vertices = fArray;
            this.r = new float[this.vertices.length];
            this.dr = new float[this.vertices.length];
            this.l = new float[this.vertices.length];
            this.dl = new float[this.vertices.length];
            this.sp = new float[this.vertices.length];
            this.sdp = new float[this.vertices.length];
        }
        return this.vertices[this.vertexCount++];
    }

    public void texture(PImage pImage) {
        this.timage = pImage;
        this.tpixels = pImage.pixels;
        this.twidth = pImage.width;
        this.theight = pImage.height;
        this.tformat = pImage.format;
        this.twidth1 = this.twidth - 1;
        this.theight1 = this.theight - 1;
        this.interpUV = true;
    }

    /*
     * Unable to fully structure code
     */
    public void render() {
        if (this.vertexCount < 3) {
            return;
        }
        this.pixels = this.parent.pixels;
        this.noDepthTest = this.parent.hints[5];
        this.smoothing = this.parent.smooth;
        this.texture_smooth = this.parent.hints[3] ^ true;
        this.width = this.smoothing != false ? this.parent.width * 8 : this.parent.width;
        this.height = this.smoothing != false ? this.parent.height * 8 : this.parent.height;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        if (!this.interpARGB) {
            this.r2 = (int)(this.vertices[0][3] * 255.0f);
            this.g2 = (int)(this.vertices[0][4] * 255.0f);
            this.b2 = (int)(this.vertices[0][5] * 255.0f);
            this.a2orig = this.a2 = (int)(this.vertices[0][6] * 255.0f);
            this.rgba = -16777216 | this.r2 << 16 | this.g2 << 8 | this.b2;
        }
        var1_1 = 0;
        while (var1_1 < this.vertexCount) {
            this.r[var1_1] = 0.0f;
            this.dr[var1_1] = 0.0f;
            this.l[var1_1] = 0.0f;
            this.dl[var1_1] = 0.0f;
            ++var1_1;
        }
        if (this.parent.hints[6]) {
            var1_2 = -this.width * 2;
            var2_5 = -this.height * 2;
            var3_6 = this.width * 2;
            var4_7 = this.height * 2;
            var5_9 = 0;
            while (var5_9 < this.vertexCount) {
                if (this.vertices[var5_9][0] < var1_2 || this.vertices[var5_9][0] > var3_6 || this.vertices[var5_9][1] < var2_5 || this.vertices[var5_9][1] > var4_7) {
                    return;
                }
                ++var5_9;
            }
        }
        if (this.smoothing) {
            var1_3 = 0;
            while (var1_3 < this.vertexCount) {
                v0 = this.vertices[var1_3];
                v0[0] = v0[0] * 8.0f;
                v1 = this.vertices[var1_3];
                v1[1] = v1[1] * 8.0f;
                ++var1_3;
            }
            this.firstModY = -1;
        }
        var1_4 = 0;
        var2_5 = this.vertices[0][1];
        var3_6 = this.vertices[0][1];
        var4_8 = 1;
        while (var4_8 < this.vertexCount) {
            if (this.vertices[var4_8][1] < var2_5) {
                var2_5 = this.vertices[var4_8][1];
                var1_4 = var4_8;
            }
            if (this.vertices[var4_8][1] > var3_6) {
                var3_6 = this.vertices[var4_8][1];
            }
            ++var4_8;
        }
        this.lastY = (int)(var3_6 - 0.5f);
        var4_8 = var1_4;
        var5_9 = var1_4;
        var6_10 = (int)(var2_5 + 0.5f);
        var7_11 = var6_10 - 1;
        var8_12 = var6_10 - 1;
        this.interpX = true;
        var9_13 = this.vertexCount;
        ** GOTO lbl94
        {
            --var9_13;
            var10_14 = var4_8 != 0 ? var4_8 - 1 : this.vertexCount - 1;
            this.incrementalize_y(this.vertices[var4_8], this.vertices[var10_14], this.l, this.dl, var6_10);
            var7_11 = (int)(this.vertices[var10_14][1] + 0.5f);
            var4_8 = var10_14;
            do {
                if (var7_11 <= var6_10 && var9_13 > 0) continue block4;
                while (var8_12 <= var6_10 && var9_13 > 0) {
                    --var9_13;
                    v2 = 0;
                    if (var5_9 != this.vertexCount - 1) {
                        v2 = var5_9 + 1;
                    }
                    var10_14 = v2;
                    this.incrementalize_y(this.vertices[var5_9], this.vertices[var10_14], this.r, this.dr, var6_10);
                    var8_12 = (int)(this.vertices[var10_14][1] + 0.5f);
                    var5_9 = var10_14;
                }
                while (var6_10 < var7_11 && var6_10 < var8_12) {
                    if (var6_10 >= 0 && var6_10 < this.height) {
                        if (this.l[0] <= this.r[0]) {
                            this.scanline(var6_10, this.l, this.r);
                        } else {
                            this.scanline(var6_10, this.r, this.l);
                        }
                    }
                    ++var6_10;
                    this.increment(this.l, this.dl);
                    this.increment(this.r, this.dr);
                }
lbl94:
                // 2 sources

            } while (var9_13 > 0);
        }
    }

    public void unexpand() {
        if (this.smoothing) {
            int n = 0;
            while (n < this.vertexCount) {
                float[] fArray = this.vertices[n];
                fArray[0] = fArray[0] / 8.0f;
                float[] fArray2 = this.vertices[n];
                fArray2[1] = fArray2[1] / 8.0f;
                ++n;
            }
        }
    }

    private final void scanline(int n, float[] fArray, float[] fArray2) {
        int n2;
        int n3;
        int n4 = 0;
        while (n4 < this.vertexCount) {
            this.sp[n4] = 0.0f;
            this.sdp[n4] = 0.0f;
            ++n4;
        }
        n4 = (int)(fArray[0] + 0.49999f);
        if (n4 < 0) {
            n4 = 0;
        }
        if ((n3 = (int)(fArray2[0] - 0.5f)) > this.width1) {
            n3 = this.width1;
        }
        if (n4 > n3) {
            return;
        }
        if (this.smoothing) {
            n2 = this.MODYRES(n);
            this.aaleft[n2] = n4;
            this.aaright[n2] = n3;
            if (this.firstModY == -1) {
                this.firstModY = n2;
                this.aaleftmin = n4;
                this.aaleftmax = n4;
                this.aarightmin = n3;
                this.aarightmax = n3;
            } else {
                if (this.aaleftmin > this.aaleft[n2]) {
                    this.aaleftmin = this.aaleft[n2];
                }
                if (this.aaleftmax < this.aaleft[n2]) {
                    this.aaleftmax = this.aaleft[n2];
                }
                if (this.aarightmin > this.aaright[n2]) {
                    this.aarightmin = this.aaright[n2];
                }
                if (this.aarightmax < this.aaright[n2]) {
                    this.aarightmax = this.aaright[n2];
                }
            }
            this.lastModY = n2;
            if (n2 != 7 && n != this.lastY) {
                return;
            }
            this.aaleftfull = this.aaleftmax / 8 + 1;
            this.aarightfull = this.aarightmin / 8 - 1;
        }
        this.incrementalize_x(fArray, fArray2, this.sp, this.sdp, n4);
        n2 = this.smoothing ? this.parent.width * (n / 8) : this.parent.width * n;
        int n5 = 0;
        int n6 = 0;
        if (this.smoothing) {
            n5 = n4 / 8;
            n6 = (n3 + 7) / 8;
            n4 = this.aaleftmin / 8;
            n3 = (this.aarightmax + 7) / 8;
            if (n4 < 0) {
                n4 = 0;
            }
            if (n3 > this.parent.width1) {
                n3 = this.parent.width1;
            }
        }
        this.interpX = false;
        int n7 = n4;
        while (n7 <= n3) {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            if (this.interpUV) {
                int n13;
                int n14;
                int n15;
                int n16;
                int n17;
                int n18;
                n12 = (int)this.sp[7];
                n11 = (int)this.sp[8];
                if (n12 > this.twidth1) {
                    n12 = this.twidth1;
                }
                if (n11 > this.theight1) {
                    n11 = this.theight1;
                }
                if (n12 < 0) {
                    n12 = 0;
                }
                if (n11 < 0) {
                    n11 = 0;
                }
                n10 = n11 * this.twidth + n12;
                if (this.smoothing || this.texture_smooth) {
                    int n19;
                    int n20;
                    int n21;
                    int n22;
                    int n23;
                    int n24;
                    int n25;
                    int n26;
                    n9 = (int)(255.0f * (this.sp[7] - (float)n12));
                    n8 = (int)(255.0f * (this.sp[8] - (float)n11));
                    n18 = 255 - n9;
                    n17 = 255 - n8;
                    int n27 = this.tpixels[n10];
                    int n28 = n11 < this.theight1 ? this.tpixels[n10 + this.twidth] : this.tpixels[n10];
                    int n29 = n12 < this.twidth1 ? this.tpixels[n10 + 1] : this.tpixels[n10];
                    int n30 = n26 = n11 < this.theight1 && n12 < this.twidth1 ? this.tpixels[n10 + this.twidth + 1] : this.tpixels[n10];
                    if (this.tformat == 4) {
                        n25 = n27 * n18 + n29 * n9 >> 8;
                        n24 = n28 * n18 + n26 * n9 >> 8;
                        n16 = (n25 * n17 + n24 * n8 >> 8) * (this.interpARGB ? (int)(this.sp[6] * 255.0f) : this.a2orig) >> 8;
                    } else if (this.tformat == 2) {
                        n23 = n27 >> 24 & 0xFF;
                        n22 = n28 >> 24 & 0xFF;
                        n21 = n29 >> 24 & 0xFF;
                        n20 = n26 >> 24 & 0xFF;
                        n25 = n23 * n18 + n21 * n9 >> 8;
                        n24 = n22 * n18 + n20 * n9 >> 8;
                        n16 = (n25 * n17 + n24 * n8 >> 8) * (this.interpARGB ? (int)(this.sp[6] * 255.0f) : this.a2orig) >> 8;
                    } else {
                        int n31 = n16 = this.interpARGB ? (int)(this.sp[6] * 255.0f) : this.a2orig;
                    }
                    if (this.tformat == 1 || this.tformat == 2) {
                        n23 = n27 >> 16 & 0xFF;
                        n22 = n28 >> 16 & 0xFF;
                        n21 = n29 >> 16 & 0xFF;
                        n20 = n26 >> 16 & 0xFF;
                        n25 = n23 * n18 + n21 * n9 >> 8;
                        n24 = n22 * n18 + n20 * n9 >> 8;
                        n15 = (n25 * n17 + n24 * n8 >> 8) * (this.interpARGB ? (int)this.sp[3] * 255 : this.r2) >> 8;
                        n23 = n27 >> 8 & 0xFF;
                        n22 = n28 >> 8 & 0xFF;
                        n21 = n29 >> 8 & 0xFF;
                        n20 = n26 >> 8 & 0xFF;
                        n25 = n23 * n18 + n21 * n9 >> 8;
                        n24 = n22 * n18 + n20 * n9 >> 8;
                        n14 = (n25 * n17 + n24 * n8 >> 8) * (this.interpARGB ? (int)this.sp[4] * 255 : this.g2) >> 8;
                        n23 = n27 & 0xFF;
                        n22 = n28 & 0xFF;
                        n21 = n29 & 0xFF;
                        n20 = n26 & 0xFF;
                        n25 = n23 * n18 + n21 * n9 >> 8;
                        n24 = n22 * n18 + n20 * n9 >> 8;
                        n13 = (n25 * n17 + n24 * n8 >> 8) * (this.interpARGB ? (int)this.sp[5] * 255 : this.b2) >> 8;
                    } else if (this.interpARGB) {
                        n15 = (int)(this.sp[3] * 255.0f);
                        n14 = (int)(this.sp[4] * 255.0f);
                        n13 = (int)(this.sp[5] * 255.0f);
                    } else {
                        n15 = this.r2;
                        n14 = this.g2;
                        n13 = this.b2;
                    }
                    int n32 = n19 = this.smoothing ? this.coverage(n7) : 255;
                    if (n19 != 255) {
                        n16 = n16 * n19 >> 8;
                    }
                } else {
                    n9 = this.tpixels[n10];
                    if (this.tformat == 4) {
                        n16 = n9;
                        if (this.interpARGB) {
                            n15 = (int)this.sp[3] * 255;
                            n14 = (int)this.sp[4] * 255;
                            n13 = (int)this.sp[5] * 255;
                            if (this.sp[6] != 1.0f) {
                                n16 = (int)this.sp[6] * 255 * n16 >> 8;
                            }
                        } else {
                            n15 = this.r2;
                            n14 = this.g2;
                            n13 = this.b2;
                            n16 = this.a2orig * n16 >> 8;
                        }
                    } else {
                        int n33 = n16 = this.tformat == 1 ? 255 : n9 >> 24 & 0xFF;
                        if (this.interpARGB) {
                            n15 = (int)this.sp[3] * 255 * (n9 >> 16 & 0xFF) >> 8;
                            n14 = (int)this.sp[4] * 255 * (n9 >> 8 & 0xFF) >> 8;
                            n13 = (int)this.sp[5] * 255 * (n9 & 0xFF) >> 8;
                            n16 = (int)this.sp[6] * 255 * n16 >> 8;
                        } else {
                            n15 = this.r2 * (n9 >> 16 & 0xFF) >> 8;
                            n14 = this.g2 * (n9 >> 8 & 0xFF) >> 8;
                            n13 = this.b2 * (n9 & 0xFF) >> 8;
                            n16 = this.a2orig * n16 >> 8;
                        }
                    }
                }
                if (n16 == 254 || n16 == 255) {
                    this.pixels[n2 + n7] = 0xFF000000 | n15 << 16 | n14 << 8 | n13;
                } else {
                    n9 = 255 - n16;
                    n8 = this.pixels[n2 + n7] >> 16 & 0xFF;
                    n18 = this.pixels[n2 + n7] >> 8 & 0xFF;
                    n17 = this.pixels[n2 + n7] & 0xFF;
                    this.pixels[n2 + n7] = 0xFF000000 | n15 * n16 + n8 * n9 >> 8 << 16 | n14 * n16 + n18 * n9 & 0xFF00 | n13 * n16 + n17 * n9 >> 8;
                }
            } else {
                int n34 = n12 = this.smoothing ? this.coverage(n7) : 255;
                if (this.interpARGB) {
                    this.r2 = (int)(this.sp[3] * 255.0f);
                    this.g2 = (int)(this.sp[4] * 255.0f);
                    this.b2 = (int)(this.sp[5] * 255.0f);
                    if (this.sp[6] != 1.0f) {
                        n12 = n12 * (int)(this.sp[6] * 255.0f) >> 8;
                    }
                    if (n12 == 255) {
                        this.rgba = 0xFF000000 | this.r2 << 16 | this.g2 << 8 | this.b2;
                    }
                } else if (this.a2orig != 255) {
                    n12 = n12 * this.a2orig >> 8;
                }
                if (n12 == 255) {
                    this.pixels[n2 + n7] = this.rgba;
                } else {
                    n11 = this.pixels[n2 + n7] >> 16 & 0xFF;
                    n10 = this.pixels[n2 + n7] >> 8 & 0xFF;
                    n9 = this.pixels[n2 + n7] & 0xFF;
                    this.a2 = n12;
                    n8 = 255 - this.a2;
                    this.pixels[n2 + n7] = 0xFF000000 | n11 * n8 + this.r2 * this.a2 >> 8 << 16 | n10 * n8 + this.g2 * this.a2 >> 8 << 8 | n9 * n8 + this.b2 * this.a2 >> 8;
                }
            }
            if (!this.smoothing || n7 >= n5 && n7 <= n6) {
                this.increment(this.sp, this.sdp);
            }
            ++n7;
        }
        this.firstModY = -1;
        this.interpX = true;
    }

    private final int coverage(int n) {
        if (n >= this.aaleftfull && n <= this.aarightfull && this.firstModY == 0 && this.lastModY == 7) {
            return 255;
        }
        int n2 = n * 8;
        int n3 = n2 + 8;
        int n4 = 0;
        int n5 = this.firstModY;
        while (n5 <= this.lastModY) {
            if (this.aaleft[n5] <= n3 && this.aaright[n5] >= n2) {
                n4 += (this.aaright[n5] < n3 ? this.aaright[n5] : n3) - (this.aaleft[n5] > n2 ? this.aaleft[n5] : n2);
            }
            ++n5;
        }
        return (n4 <<= 2) == 256 ? 255 : n4;
    }

    private final void incrementalize_y(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int n) {
        float f = fArray2[1] - fArray[1];
        if (f == 0.0f) {
            f = 1.0f;
        }
        float f2 = (float)n + 0.5f - fArray[1];
        if (this.interpX) {
            fArray4[0] = (fArray2[0] - fArray[0]) / f;
            fArray3[0] = fArray[0] + fArray4[0] * f2;
        }
        if (this.interpZ) {
            fArray4[2] = (fArray2[2] - fArray[2]) / f;
            fArray3[2] = fArray[2] + fArray4[2] * f2;
        }
        if (this.interpARGB) {
            fArray4[3] = (fArray2[3] - fArray[3]) / f;
            fArray4[4] = (fArray2[4] - fArray[4]) / f;
            fArray4[5] = (fArray2[5] - fArray[5]) / f;
            fArray4[6] = (fArray2[6] - fArray[6]) / f;
            fArray3[3] = fArray[3] + fArray4[3] * f2;
            fArray3[4] = fArray[4] + fArray4[4] * f2;
            fArray3[5] = fArray[5] + fArray4[5] * f2;
            fArray3[6] = fArray[6] + fArray4[6] * f2;
        }
        if (this.interpUV) {
            fArray4[7] = (fArray2[7] - fArray[7]) / f;
            fArray4[8] = (fArray2[8] - fArray[8]) / f;
            fArray3[7] = fArray[7] + fArray4[7] * f2;
            fArray3[8] = fArray[8] + fArray4[8] * f2;
        }
    }

    private final void incrementalize_x(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int n) {
        float f = fArray2[0] - fArray[0];
        if (f == 0.0f) {
            f = 1.0f;
        }
        float f2 = (float)n + 0.5f - fArray[0];
        if (this.smoothing) {
            f /= 8.0f;
            f2 /= 8.0f;
        }
        if (this.interpX) {
            fArray4[0] = (fArray2[0] - fArray[0]) / f;
            fArray3[0] = fArray[0] + fArray4[0] * f2;
        }
        if (this.interpZ) {
            fArray4[2] = (fArray2[2] - fArray[2]) / f;
            fArray3[2] = fArray[2] + fArray4[2] * f2;
        }
        if (this.interpARGB) {
            fArray4[3] = (fArray2[3] - fArray[3]) / f;
            fArray4[4] = (fArray2[4] - fArray[4]) / f;
            fArray4[5] = (fArray2[5] - fArray[5]) / f;
            fArray4[6] = (fArray2[6] - fArray[6]) / f;
            fArray3[3] = fArray[3] + fArray4[3] * f2;
            fArray3[4] = fArray[4] + fArray4[4] * f2;
            fArray3[5] = fArray[5] + fArray4[5] * f2;
            fArray3[6] = fArray[6] + fArray4[6] * f2;
        }
        if (this.interpUV) {
            fArray4[7] = (fArray2[7] - fArray[7]) / f;
            fArray4[8] = (fArray2[8] - fArray[8]) / f;
            fArray3[7] = fArray[7] + fArray4[7] * f2;
            fArray3[8] = fArray[8] + fArray4[8] * f2;
        }
    }

    private final void increment(float[] fArray, float[] fArray2) {
        if (this.interpX) {
            fArray[0] = fArray[0] + fArray2[0];
        }
        if (this.interpZ) {
            fArray[2] = fArray[2] + fArray2[2];
        }
        if (this.interpARGB) {
            fArray[3] = fArray[3] + fArray2[3];
            fArray[4] = fArray[4] + fArray2[4];
            fArray[5] = fArray[5] + fArray2[5];
            fArray[6] = fArray[6] + fArray2[6];
        }
        if (this.interpUV) {
            fArray[7] = fArray[7] + fArray2[7];
            fArray[8] = fArray[8] + fArray2[8];
        }
    }

    private final /* synthetic */ void this() {
        this.vertices = new float[64][36];
        this.r = new float[64];
        this.dr = new float[64];
        this.l = new float[64];
        this.dl = new float[64];
        this.sp = new float[64];
        this.sdp = new float[64];
        this.aaleft = new int[8];
        this.aaright = new int[8];
    }

    public PPolygon(PGraphics pGraphics) {
        this.this();
        this.parent = pGraphics;
        this.reset(0);
    }
}

