/*
 * Decompiled with CFR 0.152.
 */
public class LiquidWen
extends BApplet {
    BFont metaFont;
    boolean isTimerRun = false;
    timer timer;
    Scene[] scene;
    Scene currentScene;
    boolean isSmooth;
    boolean showMeTheUglyHiddenScreen = false;

    void setup() {
        this.size(300, 300);
        this.scene = new Scene[this.showMeTheUglyHiddenScreen ? 2 : 1];
        this.scene[0] = new SceneMetaText();
        this.scene[0].init();
        if (this.showMeTheUglyHiddenScreen) {
            this.scene[1] = new SceneCube();
            this.scene[1].init();
            this.currentScene = this.scene[1];
        } else {
            this.currentScene = this.scene[0];
        }
        this.metaFont = this.loadFont("Meta-Bold.vlw.gz");
        this.textFont(this.metaFont, 25.0f);
        this.isSmooth = false;
        this.noSmooth();
    }

    void loop() {
        if (!this.isTimerRun) {
            this.timer = new timer(this.millis());
            this.isTimerRun = true;
        }
        float dt = this.timer.M_getDelta(this.millis()) / 1000.0f;
        this.currentScene.run(dt);
    }

    void mousePressed() {
        this.currentScene.handleMousePressed();
    }

    void keyPressed() {
        this.currentScene.handleKeyPressed();
        if (this.key == 43) {
            boolean bl = this.isSmooth = !this.isSmooth;
            if (this.isSmooth) {
                this.smooth();
            } else {
                this.noSmooth();
            }
        }
    }

    void fastblur(BImage img, int radius) {
        int p2;
        int p1;
        int x;
        int rsum;
        int gsum;
        int bsum;
        if (radius < 1) {
            return;
        }
        int w = img.width;
        int h = img.height;
        int wm = w - 1;
        int hm = h - 1;
        int wh = w * h;
        int div = radius + radius + 1;
        int[] r = new int[wh];
        int[] g = new int[wh];
        int[] b = new int[wh];
        int[] vmin = new int[this.max(w, h)];
        int[] vmax = new int[this.max(w, h)];
        int[] pix = img.pixels;
        int[] dv = new int[256 * div];
        int i = 0;
        while (i < 256 * div) {
            dv[i] = i / div;
            ++i;
        }
        int yi = 0;
        int yw = 0;
        int y = 0;
        while (y < h) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            i = -radius;
            while (i <= radius) {
                int p = pix[yi + this.min(wm, this.max(i, 0))];
                rsum += (p & 0xFF0000) >> 16;
                gsum += (p & 0xFF00) >> 8;
                bsum += p & 0xFF;
                ++i;
            }
            x = 0;
            while (x < w) {
                r[yi] = dv[rsum];
                g[yi] = dv[gsum];
                b[yi] = dv[bsum];
                if (y == 0) {
                    vmin[x] = this.min(x + radius + 1, wm);
                    vmax[x] = this.max(x - radius, 0);
                }
                p1 = pix[yw + vmin[x]];
                p2 = pix[yw + vmax[x]];
                rsum += (p1 & 0xFF0000) - (p2 & 0xFF0000) >> 16;
                gsum += (p1 & 0xFF00) - (p2 & 0xFF00) >> 8;
                bsum += (p1 & 0xFF) - (p2 & 0xFF);
                ++yi;
                ++x;
            }
            yw += w;
            ++y;
        }
        x = 0;
        while (x < w) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            int yp = -radius * w;
            i = -radius;
            while (i <= radius) {
                yi = this.max(0, yp) + x;
                rsum += r[yi];
                gsum += g[yi];
                bsum += b[yi];
                yp += w;
                ++i;
            }
            yi = x;
            y = 0;
            while (y < h) {
                pix[yi] = 0xFF000000 | dv[rsum] << 16 | dv[gsum] << 8 | dv[bsum];
                if (x == 0) {
                    vmin[y] = this.min(y + radius + 1, hm) * w;
                    vmax[y] = this.max(y - radius, 0) * w;
                }
                p1 = x + vmin[y];
                p2 = x + vmax[y];
                rsum += r[p1] - r[p2];
                gsum += g[p1] - g[p2];
                bsum += b[p1] - b[p2];
                yi += w;
                ++y;
            }
            ++x;
        }
    }

    class EdgeVertex {
        float x;
        float y;

        EdgeVertex(float f, float f2) {
            this.x = f;
            this.y = f2;
        }
    }

    class Metaballs2D {
        float isovalue;
        int resx;
        int resy;
        float stepx;
        float stepy;
        float[] gridValue;
        int nbGridValue;
        int[] voxel;
        int nbVoxel;
        EdgeVertex[] edgeVrt;
        int nbEdgeVrt;
        int[] lineToDraw;
        int nbLineToDraw;

        Metaballs2D() {
        }

        void init(int resx, int resy) {
            this.resx = resx;
            this.resy = resy;
            this.stepx = 1.0f / (float)(resx - 1);
            this.stepy = 1.0f / (float)(resy - 1);
            this.nbGridValue = resx * resy;
            this.gridValue = new float[this.nbGridValue];
            this.nbVoxel = this.nbGridValue;
            this.voxel = new int[this.nbVoxel];
            this.edgeVrt = new EdgeVertex[2 * this.nbVoxel];
            this.nbEdgeVrt = 0;
            this.lineToDraw = new int[2 * this.nbVoxel];
            this.nbLineToDraw = 0;
            int n = 0;
            int x = 0;
            while (x < resx) {
                int y = 0;
                while (y < resy) {
                    int index;
                    this.voxel[x + resx * y] = index = 2 * n;
                    this.edgeVrt[index] = new EdgeVertex((float)x * this.stepx, (float)y * this.stepy);
                    this.edgeVrt[index + 1] = new EdgeVertex((float)x * this.stepx, (float)y * this.stepy);
                    this.gridValue[x + resx * y] = 0.0f;
                    ++n;
                    ++y;
                }
                ++x;
            }
        }

        void computeIsovalue(float dt) {
        }

        void computeMesh(float dt) {
            this.computeIsovalue(dt);
            this.nbLineToDraw = 0;
            float vx = 0.0f;
            int x = 0;
            while (x < this.resx - 1) {
                float vy = 0.0f;
                int y = 0;
                while (y < this.resy - 1) {
                    int iEdge;
                    int offset = x + this.resx * y;
                    int squareIndex = this.getSquareIndex(x, y);
                    int n = 0;
                    while ((iEdge = MetaballsTable.edgeCut[squareIndex][n++]) != -1) {
                        int[] edgeOffsetInfo = MetaballsTable.edgeOffsetInfo[iEdge];
                        int offx = edgeOffsetInfo[0];
                        int offy = edgeOffsetInfo[1];
                        int offAB = edgeOffsetInfo[2];
                        this.lineToDraw[this.nbLineToDraw++] = this.voxel[x + offx + this.resx * (y + offy)] + offAB;
                    }
                    int toCompute = MetaballsTable.edgeToCompute[squareIndex];
                    if (toCompute > 0) {
                        float t;
                        if ((toCompute & 1) > 0) {
                            t = (this.isovalue - this.gridValue[offset]) / (this.gridValue[offset + 1] - this.gridValue[offset] + 1.0E-5f);
                            this.edgeVrt[this.voxel[offset]].x = vx * (1.0f - t) + t * (vx + this.stepx);
                        }
                        if ((toCompute & 2) > 0) {
                            t = (this.isovalue - this.gridValue[offset]) / (this.gridValue[offset + this.resx] - this.gridValue[offset] + 1.0E-5f);
                            this.edgeVrt[this.voxel[offset] + 1].y = vy * (1.0f - t) + t * (vy + this.stepy);
                        }
                    }
                    vy += this.stepy;
                    ++y;
                }
                vx += this.stepx;
                ++x;
            }
            this.nbLineToDraw /= 2;
        }

        int getSquareIndex(int x, int y) {
            int squareIndex = 0;
            int offy = this.resx * y;
            int offy1 = this.resx * (y + 1);
            if (this.gridValue[x + offy] < this.isovalue) {
                squareIndex |= 1;
            }
            if (this.gridValue[x + 1 + offy] < this.isovalue) {
                squareIndex |= 2;
            }
            if (this.gridValue[x + 1 + offy1] < this.isovalue) {
                squareIndex |= 4;
            }
            if (this.gridValue[x + offy1] < this.isovalue) {
                squareIndex |= 8;
            }
            return squareIndex;
        }

        void setIsoValue(float newIso) {
            this.isovalue = newIso;
        }

        void draw() {
            int iLine = 0;
            while (iLine < this.nbLineToDraw) {
                int iA = this.lineToDraw[iLine * 2];
                int iB = this.lineToDraw[iLine * 2 + 1];
                LiquidWen.this.line(this.edgeVrt[iA].x * (float)LiquidWen.this.width, this.edgeVrt[iA].y * (float)LiquidWen.this.height, this.edgeVrt[iB].x * (float)LiquidWen.this.width, this.edgeVrt[iB].y * (float)LiquidWen.this.height);
                ++iLine;
            }
        }

        void drawGrid(int wx, int wy) {
            float sx = this.stepx * (float)wx;
            float sy = this.stepy * (float)wy;
            float vy = 0.0f;
            int x = 0;
            while (x < this.resx) {
                LiquidWen.this.line(0.0f, vy, wx, vy);
                vy += sy;
                ++x;
            }
            float vx = 0.0f;
            int y = 0;
            while (y < this.resy) {
                LiquidWen.this.line(vx, 0.0f, vx, wy);
                vx += sx;
                ++y;
            }
        }
    }

    class EdgeDetection
    extends Metaballs2D {
        BImage img;

        EdgeDetection(int imgWidth, int imgHeight) {
            this.img = new BImage(imgWidth, imgHeight);
            this.init(imgWidth, imgHeight);
        }

        void computeIsovalue(float dt) {
            int x;
            int y = 0;
            while (y < this.img.height) {
                x = 0;
                while (x < this.img.width) {
                    int offset = x + this.img.width * y;
                    int pixel = this.img.pixels[offset];
                    int R = (pixel & 0xFF0000) >> 16;
                    int G = (pixel & 0xFF00) >> 8;
                    int B = pixel & 0xFF;
                    this.gridValue[offset] = R + G + B;
                    ++x;
                }
                ++y;
            }
            float ballx = (float)LiquidWen.this.mouseX / (float)LiquidWen.this.width;
            float bally = (float)LiquidWen.this.mouseY / (float)LiquidWen.this.height;
            float vx = 0.0f;
            x = 0;
            while (x < this.resx) {
                float vy = 0.0f;
                y = 0;
                while (y < this.resy) {
                    float dist = LiquidWen.this.sqrt((vx - ballx) * (vx - ballx) + (vy - bally) * (vy - bally));
                    int n = x + this.resx * y;
                    this.gridValue[n] = this.gridValue[n] - 2.0f / (dist * dist + 0.001f);
                    vy += this.stepy;
                    ++y;
                }
                vx += this.stepx;
                ++x;
            }
        }

        int getSquareIndex(int x, int y) {
            int squareIndex = 0;
            int offy = this.resx * y;
            int offy1 = this.resx * (y + 1);
            if (this.gridValue[x + offy] < this.isovalue) {
                squareIndex |= 1;
            }
            if (this.gridValue[x + 1 + offy] < this.isovalue) {
                squareIndex |= 2;
            }
            if (this.gridValue[x + 1 + offy1] < this.isovalue) {
                squareIndex |= 4;
            }
            if (this.gridValue[x + offy1] < this.isovalue) {
                squareIndex |= 8;
            }
            return squareIndex;
        }

        void copyRenderTargetToImg(BImage imgToCopy) {
            System.arraycopy(imgToCopy.pixels, 0, this.img.pixels, 0, imgToCopy.width * imgToCopy.height);
        }

        void copyScreenToImg(BGraphics buffer) {
            int i = 0;
            while (i < this.img.height) {
                System.arraycopy(buffer.pixels, i * buffer.width, this.img.pixels, i * this.img.width, this.img.width);
                ++i;
            }
        }

        void blurImg(int radius) {
            LiquidWen.this.fastblur(this.img, radius);
        }

        void drawImageScreen() {
            LiquidWen.this.image(this.img, 0.0f, 0.0f, LiquidWen.this.width, LiquidWen.this.height);
        }
    }

    class EdgeDetectionEx
    extends EdgeDetection {
        EdgeDetectionEx(int imgWidth, int imgHeight) {
            super(imgWidth, imgHeight);
        }

        void computeIsovalue(float dt) {
            float ballx = (float)LiquidWen.this.mouseX / (float)LiquidWen.this.width;
            float bally = (float)LiquidWen.this.mouseY / (float)LiquidWen.this.height;
            float vy = 0.0f;
            int y = 0;
            while (y < this.img.height) {
                float vx = 0.0f;
                int x = 0;
                while (x < this.img.width) {
                    int offset = x + this.img.width * y;
                    int pixel = this.img.pixels[offset];
                    int R = (pixel & 0xFF0000) >> 16;
                    int G = (pixel & 0xFF00) >> 8;
                    int B = pixel & 0xFF;
                    float targetValue = R + G + B;
                    if (LiquidWen.this.mousePressed) {
                        float s = 5.0f;
                        float dist = LiquidWen.this.sqrt((vx - ballx) * (vx - ballx) + (vy - bally) * (vy - bally));
                        targetValue -= s / (dist * dist + 0.001f);
                        float ballx2 = -ballx + 1.0f;
                        float bally2 = -bally + 1.0f;
                        dist = LiquidWen.this.sqrt((vx - ballx2) * (vx - ballx2) + (vy - bally2) * (vy - bally2));
                        targetValue -= s / (dist * dist + 0.001f);
                    }
                    int n = offset;
                    this.gridValue[n] = this.gridValue[n] + (targetValue - this.gridValue[offset]) * 2.0f * dt;
                    vx += this.stepx;
                    ++x;
                }
                vy += this.stepy;
                ++y;
            }
        }
    }

    static class MetaballsTable {
        static int[][] edgeCut;
        static int[][] edgeOffsetInfo;
        static int[] edgeToCompute;

        static {
            int[][] nArrayArray = new int[16][];
            nArrayArray[0] = new int[]{-1, -1, -1, -1, -1};
            int[] nArray = new int[5];
            nArray[1] = 3;
            nArray[2] = -1;
            nArray[3] = -1;
            nArray[4] = -1;
            nArrayArray[1] = nArray;
            int[] nArray2 = new int[5];
            nArray2[1] = 1;
            nArray2[2] = -1;
            nArray2[3] = -1;
            nArray2[4] = -1;
            nArrayArray[2] = nArray2;
            nArrayArray[3] = new int[]{3, 1, -1, -1, -1};
            nArrayArray[4] = new int[]{1, 2, -1, -1, -1};
            int[] nArray3 = new int[5];
            nArray3[0] = 1;
            nArray3[1] = 2;
            nArray3[3] = 3;
            nArray3[4] = -1;
            nArrayArray[5] = nArray3;
            int[] nArray4 = new int[5];
            nArray4[1] = 2;
            nArray4[2] = -1;
            nArray4[3] = -1;
            nArray4[4] = -1;
            nArrayArray[6] = nArray4;
            nArrayArray[7] = new int[]{3, 2, -1, -1, -1};
            nArrayArray[8] = new int[]{3, 2, -1, -1, -1};
            int[] nArray5 = new int[5];
            nArray5[1] = 2;
            nArray5[2] = -1;
            nArray5[3] = -1;
            nArray5[4] = -1;
            nArrayArray[9] = nArray5;
            int[] nArray6 = new int[5];
            nArray6[0] = 1;
            nArray6[1] = 2;
            nArray6[3] = 3;
            nArray6[4] = -1;
            nArrayArray[10] = nArray6;
            nArrayArray[11] = new int[]{1, 2, -1, -1, -1};
            nArrayArray[12] = new int[]{3, 1, -1, -1, -1};
            int[] nArray7 = new int[5];
            nArray7[1] = 1;
            nArray7[2] = -1;
            nArray7[3] = -1;
            nArray7[4] = -1;
            nArrayArray[13] = nArray7;
            int[] nArray8 = new int[5];
            nArray8[1] = 3;
            nArray8[2] = -1;
            nArray8[3] = -1;
            nArray8[4] = -1;
            nArrayArray[14] = nArray8;
            nArrayArray[15] = new int[]{-1, -1, -1, -1, -1};
            edgeCut = nArrayArray;
            int[][] nArrayArray2 = new int[4][];
            nArrayArray2[0] = new int[3];
            int[] nArray9 = new int[3];
            nArray9[0] = 1;
            nArray9[2] = 1;
            nArrayArray2[1] = nArray9;
            int[] nArray10 = new int[3];
            nArray10[1] = 1;
            nArrayArray2[2] = nArray10;
            int[] nArray11 = new int[3];
            nArray11[2] = 1;
            nArrayArray2[3] = nArray11;
            edgeOffsetInfo = nArrayArray2;
            int[] nArray12 = new int[16];
            nArray12[1] = 3;
            nArray12[2] = 1;
            nArray12[3] = 2;
            nArray12[5] = 3;
            nArray12[6] = 1;
            nArray12[7] = 2;
            nArray12[8] = 2;
            nArray12[9] = 1;
            nArray12[10] = 3;
            nArray12[12] = 2;
            nArray12[13] = 1;
            nArray12[14] = 3;
            edgeToCompute = nArray12;
        }

        MetaballsTable() {
        }
    }

    class Scene {
        int renderTargetw = 100;
        int renderTargeth = 100;
        BGraphics buffer = new BGraphics(this.renderTargetw, this.renderTargeth);

        Scene() {
        }

        void init() {
        }

        void run(float dt) {
        }

        void handleKeyPressed() {
        }

        void handleMousePressed() {
        }
    }

    class SceneMetaText
    extends Scene {
        EdgeDetectionEx edgeDetection;
        float angleTexte;
        float angleTexteSpeed;
        String s;

        SceneMetaText() {
        }

        void init() {
            this.edgeDetection = new EdgeDetectionEx(this.renderTargetw, this.renderTargeth);
            LiquidWen.this.rectMode(3);
            this.angleTexte = 0.0f;
            this.angleTexteSpeed = 3.0f;
            this.s = "Processing";
        }

        void run(float dt) {
            LiquidWen.this.background(255);
            this.buffer.background(255);
            this.buffer.fill(0);
            this.buffer.push();
            this.buffer.translate(this.renderTargetw / 2, this.renderTargeth / 2);
            this.buffer.rotateZ(this.angleTexte * (float)Math.PI / 180.0f);
            this.buffer.textFont(LiquidWen.this.metaFont, 20.0f);
            this.buffer.text(this.s, -38.0f, 0.0f);
            this.buffer.pop();
            this.angleTexte += this.angleTexteSpeed * dt;
            if (this.angleTexte > 360.0f) {
                this.angleTexte -= 360.0f;
            }
            this.edgeDetection.copyScreenToImg(this.buffer);
            this.edgeDetection.setIsoValue(600.0f);
            this.edgeDetection.computeMesh(dt);
            LiquidWen.this.strokeWeight(1.5f);
            LiquidWen.this.stroke(0.0f, 0.0f, 0.0f);
            this.edgeDetection.draw();
        }

        void processString(int k) {
            char[] data = new char[this.s.length()];
            int l = this.s.length();
            data = this.s.toCharArray();
            int i = 0;
            while (i < l - 1) {
                data[i] = data[i + 1];
                ++i;
            }
            data[l - 1] = (char)k;
            this.s = String.copyValueOf(data);
        }

        void handleKeyPressed() {
            if (LiquidWen.this.key >= 97 && LiquidWen.this.key <= 122 || LiquidWen.this.key >= 65 && LiquidWen.this.key <= 90 || LiquidWen.this.key >= 48 && LiquidWen.this.key <= 57 || LiquidWen.this.key == 32) {
                this.processString(LiquidWen.this.key);
            }
        }

        void handleMousePressed() {
        }
    }

    class SceneCube
    extends Scene {
        EdgeDetectionEx edgeDetection;
        Cube cube;
        String cubeString;
        float angle;
        float angleSpeed;

        SceneCube() {
        }

        void init() {
            this.edgeDetection = new EdgeDetectionEx(this.renderTargetw, this.renderTargeth);
            this.cube = new Cube(3);
            this.cubeString = "CUBE";
            this.angle = 0.0f;
            this.angleSpeed = 10.0f;
        }

        void drawCube() {
        }

        void run(float dt) {
            this.buffer.background(255);
            this.buffer.fill(0);
            this.buffer.push();
            this.buffer.translate(this.renderTargetw / 2, this.renderTargeth / 2, 400.0f);
            this.buffer.rotateY(this.angle * (float)Math.PI / 180.0f);
            this.buffer.rotateZ(this.angle * (float)Math.PI / 180.0f);
            this.buffer.scale(180.0f);
            this.cube.computeProj(this.buffer);
            this.buffer.pop();
            this.buffer.textFont(LiquidWen.this.metaFont, 20.0f);
            int i = 0;
            int n = 0;
            while (n < this.cube.nbVertex) {
                this.buffer.text(this.cubeString.charAt(n % 4), this.cube.vertexProj[i], this.cube.vertexProj[i + 1]);
                i += 2;
                ++n;
            }
            LiquidWen.this.background(255);
            this.edgeDetection.setIsoValue(550.0f);
            this.edgeDetection.copyScreenToImg(this.buffer);
            this.edgeDetection.computeMesh(dt);
            LiquidWen.this.strokeWeight(1.0f);
            LiquidWen.this.stroke(0.0f, 0.0f, 0.0f);
            this.edgeDetection.draw();
            this.angle += this.angleSpeed * dt;
            if (this.angle > 360.0f) {
                this.angle -= 360.0f;
            }
        }

        void handleKeyPressed() {
        }

        void handleMousePressed() {
        }
    }

    class Cube {
        int dim;
        int nbVertex;
        float[] vertex;
        float[] vertexProj;

        Cube(int dim) {
            this.dim = dim;
            this.nbVertex = dim * dim * dim;
            this.vertex = new float[this.nbVertex * 3];
            this.vertexProj = new float[this.nbVertex * 2];
            float step = 1.0f / (float)(dim - 1);
            int n = 0;
            int z = 0;
            while (z < dim) {
                int y = 0;
                while (y < dim) {
                    int x = 0;
                    while (x < dim) {
                        this.vertex[n++] = (float)x * step - 0.5f;
                        this.vertex[n++] = (float)y * step - 0.5f;
                        this.vertex[n++] = (float)z * step - 0.5f;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }

        void computeProj(BGraphics b) {
            int n = 0;
            int i = 0;
            while (i < this.nbVertex) {
                float x = this.vertex[3 * i];
                float y = this.vertex[3 * i + 1];
                float z = this.vertex[3 * i + 2];
                this.vertexProj[n++] = b.screenX(x, y, z);
                this.vertexProj[n++] = b.screenY(x, y, z);
                ++i;
            }
        }
    }

    class timer {
        float t;

        float M_getDelta(float f) {
            float f2 = f - this.t;
            this.t = f;
            return f2;
        }

        timer(float f) {
            this.t = f;
        }
    }
}

