/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PFont;

public class GFont {
    private static final HashMap<GFontKey, PFont> fontmap = new HashMap();

    public static PFont getFont(PApplet theApplet, String fontname, int fsize) {
        fsize = PApplet.constrain((int)fsize, (int)8, (int)144);
        GFontKey fkey = new GFontKey(fontname, fsize);
        PFont pfont = null;
        if (fontmap.containsKey(fkey)) {
            pfont = fontmap.get(fkey);
        } else {
            pfont = theApplet.createFont(fontname, (float)fsize, true);
            if (pfont != null) {
                fontmap.put(fkey, pfont);
            } else {
                fkey = new GFontKey("SansSerif", fsize);
                if (fontmap.containsKey(fkey)) {
                    pfont = fontmap.get(fkey);
                } else {
                    pfont = theApplet.createFont("SansSerif", (float)fsize, true);
                    fontmap.put(fkey, pfont);
                }
            }
        }
        return pfont;
    }

    public static PFont getDefaultFont(PApplet theApplet) {
        return GFont.getFont(theApplet, "SansSerif", 11);
    }

    private static class GFontKey
    implements Comparable {
        private final String fontKey;

        public GFontKey(String fontname, int fontsize) {
            this.fontKey = String.valueOf(fontname) + "-" + fontsize;
        }

        public boolean equals(Object o) {
            GFontKey fkey = (GFontKey)o;
            if (fkey == null) {
                return false;
            }
            return this.fontKey.equals(fkey.fontKey);
        }

        public int hashCode() {
            return this.fontKey.hashCode();
        }

        public int compareTo(Object obj) {
            GFontKey fkey = (GFontKey)obj;
            if (fkey == null) {
                return 1;
            }
            return this.fontKey.compareTo(fkey.fontKey);
        }
    }
}

