/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GComponent;
import guicomponents.GSlider;
import java.awt.Point;
import java.awt.event.MouseEvent;
import processing.core.PApplet;

public class GVertSlider
extends GSlider {
    public GVertSlider(PApplet theApplet, int x, int y, int width, int height) {
        super(theApplet, x, y, width, height);
        this.initThumbDetails();
    }

    protected void initThumbDetails() {
        this.thumbSize = Math.max(20, this.height / 20);
        this.thumbMin = this.thumbSize / 2;
        this.thumbMax = this.height - this.thumbSize / 2;
        this.thumbTargetPos = this.thumbPos;
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        Point pos = new Point(0, 0);
        this.calcAbsPosition(pos);
        this.winApp.noStroke();
        this.winApp.fill(this.localColor.sdrTrack);
        this.winApp.rect((float)pos.x, (float)pos.y, (float)this.width, (float)this.height);
        this.winApp.fill(this.localColor.sdrThumb);
        this.winApp.rect((float)pos.x, (float)(pos.y + this.thumbPos - this.thumbSize / 2), (float)this.width, (float)this.thumbSize);
        if (this.border != 0) {
            this.winApp.strokeWeight((float)this.border);
            this.winApp.noFill();
            this.winApp.stroke(this.localColor.sdrBorder);
            this.winApp.rect((float)pos.x, (float)pos.y, (float)this.width, (float)this.height);
        }
        this.winApp.popStyle();
    }

    protected void looseFocus(GComponent grabber) {
        if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        String pname = this.parent == null ? "" : this.parent.getClass().getSimpleName();
        focusIsWith = pname.equalsIgnoreCase("GCombo") ? this.parent : null;
    }

    public void mouseEvent(MouseEvent event) {
        if (!this.visible || !this.enabled) {
            return;
        }
        boolean mouseOver = this.isOver(this.winApp.mouseX, this.winApp.mouseY);
        if (mouseOver || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (event.getID()) {
            case 501: {
                if (focusIsWith == this || !mouseOver) break;
                this.mdx = this.winApp.mouseX;
                this.mdy = this.winApp.mouseY;
                this.takeFocus();
                break;
            }
            case 500: {
                if (focusIsWith != this) break;
                this.looseFocus(null);
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
                break;
            }
            case 502: {
                if (focusIsWith != this || !this.mouseHasMoved(this.winApp.mouseX, this.winApp.mouseY)) break;
                this.looseFocus(null);
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
                break;
            }
            case 506: {
                if (focusIsWith != this) break;
                this.isValueChanging = true;
                Point p = new Point(0, 0);
                this.calcAbsPosition(p);
                this.thumbTargetPos = PApplet.constrain((int)(this.winApp.mouseY - this.offset - p.y), (int)this.thumbMin, (int)this.thumbMax);
            }
        }
    }

    public boolean isOver(int ax, int ay) {
        Point p = new Point(0, 0);
        this.calcAbsPosition(p);
        if (ax >= p.x && ax <= p.x + this.width && ay >= p.y + this.thumbPos - this.thumbSize / 2 && ay <= p.y + this.thumbPos + this.thumbSize / 2) {
            this.offset = ay - (p.y + this.thumbPos);
            return true;
        }
        return false;
    }
}

