/*
 * Decompiled with CFR 0.152.
 */
public class D5LV
extends BApplet {
    cubeDividor cubeThing;
    float side;
    float noise;
    float prob;
    int divisions;
    int maxCubes;
    palette[] pal;
    int currentPalette;
    panelledScreen screen;
    int border;
    int panelWidth;
    int panelHeight;
    int rows;
    int cols;
    ArcBall arcball;
    BufferedMouse bufferedMouse;
    boolean firstClick;
    boolean firstRun;
    int count;
    float[] clearZ;

    void setup() {
        int n = 20;
        int n2 = 200;
        int n3 = 200;
        int n4 = 4;
        int n5 = 3;
        this.screen = new panelledScreen(n4, n5, n2, n3, n);
        this.size(n + (n + n2) * n5, n + (n + n3) * n4);
        this.framerate(20.0f);
        this.arcball = new ArcBall((float)n2 / 2.0f, (float)n3 / 2.0f, (float)this.min(n2 - 10, n3 - 10) / 2.0f);
        this.bufferedMouse = new BufferedMouse(0.5f);
        this.firstClick = true;
        this.firstRun = true;
        this.count = 0;
        this.pal = new palette[3];
        this.pal[0] = new palette(256, 100, "color01.gif");
        this.pal[1] = new palette(256, 100, "color02.gif");
        this.pal[2] = new palette(256, 100, "color03.gif");
        this.currentPalette = (int)this.random(3);
        this.side = (float)this.min(n2, n3) / (float)4;
        this.noise = this.side * this.random(0.1f);
        this.prob = this.random(35.0f, 85.0f);
        this.maxCubes = 1024;
        this.divisions = 2;
        this.cubeThing = new cubeDividor(0.0f, 0.0f, 0.0f, this.side, this.divisions, this.maxCubes, this.prob, this.noise);
        this.clearZ = new float[this.width * this.height];
        System.arraycopy(this.g.zbuffer, 0, this.clearZ, 0, this.clearZ.length);
    }

    void loop() {
        if (this.firstRun) {
            this.background(255);
            this.firstRun = false;
        }
        if (this.count < this.screen.maxPanel + 1) {
            this.screen.currentPanel = this.count;
        }
        if (this.count == this.screen.maxPanel + 1) {
            this.screen.currentPanel = 0;
        }
        this.bufferedMouse.update();
        this.screen.clear();
        this.screen.center();
        this.arcball.center_x = this.screen.centerX();
        this.arcball.center_y = this.screen.centerY();
        this.arcball.run();
        this.cubeThing.draw();
        this.cubeThing.update();
        ++this.count;
    }

    void reset() {
        int n = this.cubeThing.mode;
        this.noise = this.random(0.15f * this.side);
        this.prob = this.random(10.0f, 100.0f);
        this.cubeThing = new cubeDividor(0.0f, 0.0f, 0.0f, this.side, this.divisions, this.maxCubes, this.prob, this.noise);
        this.cubeThing.mode = n;
    }

    void mousePressed() {
        this.screen.mousePressed();
        this.arcball.mousePressed();
    }

    void mouseDragged() {
        this.screen.mouseDragged();
        this.arcball.mouseDragged();
    }

    void mouseReleased() {
        this.screen.mouseReleased();
    }

    void keyPressed() {
        switch (this.key) {
            case 112: {
                this.currentPalette = (this.currentPalette + 1) % 3;
                this.cubeThing.changePalette();
                break;
            }
            case 80: {
                this.currentPalette = (this.currentPalette + 1) % 3;
                this.cubeThing.changePalette();
                break;
            }
            case 109: {
                this.cubeThing.mode = (this.cubeThing.mode + 1) % this.cubeThing.numModes;
                break;
            }
            case 77: {
                this.cubeThing.mode = (this.cubeThing.mode + 1) % this.cubeThing.numModes;
                break;
            }
            default: {
                this.reset();
            }
        }
    }

    class cubeDividor {
        int divisions;
        int div3;
        int numCubes;
        int count;
        cube[] cubes;
        float side;
        float prob;
        float noise;
        boolean active;
        int mode;
        int numModes;

        void update() {
            if (this.active && this.count < this.numCubes - this.div3 + 1) {
                cube[] cubeArray = new cube[this.div3];
                boolean[] blArray = new boolean[this.div3];
                int n = (int)D5LV.this.random(this.count - 1);
                float f = this.cubes[n].x;
                float f2 = this.cubes[n].y;
                float f3 = this.cubes[n].z;
                float f4 = this.cubes[n].a;
                float f5 = 2.0f * this.cubes[n].a / (float)this.divisions;
                int n2 = 0;
                while (n2 < this.divisions) {
                    int n3 = 0;
                    while (n3 < this.divisions) {
                        int n4 = 0;
                        while (n4 < this.divisions) {
                            cubeArray[n4 + n3 * this.divisions + n2 * this.divisions * this.divisions] = new cube(f - f4 + ((float)n2 + 0.5f) * f5 + D5LV.this.random(-this.noise, this.noise), f2 - f4 + ((float)n3 + 0.5f) * f5 + D5LV.this.random(-this.noise, this.noise), f3 - f4 + ((float)n4 + 0.5f) * f5 + D5LV.this.random(-this.noise, this.noise), f5 / 2.0f + D5LV.this.random(-this.noise, this.noise));
                            ++n4;
                        }
                        ++n3;
                    }
                    ++n2;
                }
                n2 = 0;
                while (n2 < this.div3) {
                    boolean bl = false;
                    if (D5LV.this.random(100.0f) < this.prob) {
                        bl = true;
                    }
                    blArray[n2] = bl;
                    ++n2;
                }
                int n5 = (int)D5LV.this.random(this.div3);
                this.cubes[n] = new cube(cubeArray[n5].x, cubeArray[n5].y, cubeArray[n5].z, cubeArray[n5].a);
                ++this.cubes[n].generation;
                blArray[n5] = false;
                n2 = 0;
                while (n2 < this.div3) {
                    if (blArray[n2] && cubeArray[n2].a > 0.1f) {
                        this.cubes[this.count] = new cube(cubeArray[n2].x, cubeArray[n2].y, cubeArray[n2].z, cubeArray[n2].a);
                        this.cubes[this.count].generation = this.cubes[n].generation + 1;
                        ++this.count;
                    }
                    ++n2;
                }
            }
        }

        void draw() {
            switch (this.mode) {
                case 0: {
                    int n = 0;
                    while (n < this.count) {
                        this.cubes[n].draw();
                        ++n;
                    }
                    break;
                }
                case 1: {
                    int n = 0;
                    while (n < this.count) {
                        this.cubes[n].drawSkew();
                        ++n;
                    }
                    break;
                }
                case 2: {
                    int n = 0;
                    while (n < this.count) {
                        this.cubes[n].drawTrunc();
                        ++n;
                    }
                    break;
                }
                case 3: {
                    int n = 0;
                    while (n < this.count) {
                        this.cubes[n].drawDistorted(this.side);
                        ++n;
                    }
                    break;
                }
                case 4: {
                    int n = 0;
                    while (n < this.count) {
                        this.cubes[n].drawDot();
                        ++n;
                    }
                    this.drawLines();
                    System.arraycopy(D5LV.this.clearZ, 0, D5LV.this.g.zbuffer, 0, D5LV.this.clearZ.length);
                    break;
                }
            }
        }

        void drawLines() {
            D5LV.this.beginShape(33);
            int n = 0;
            while (n < this.count - 1) {
                D5LV.this.stroke(this.cubes[n].c);
                D5LV.this.bezierVertex(this.cubes[n].x, this.cubes[n].y, this.cubes[n].z);
                D5LV.this.bezierVertex(this.cubes[n + 1].x, this.cubes[n + 1].y, this.cubes[n + 1].z);
                ++n;
            }
            D5LV.this.endShape();
        }

        void changePalette() {
            int n = 0;
            while (n < this.count - 1) {
                this.cubes[n].c = D5LV.this.pal[D5LV.this.currentPalette].getColor();
                ++n;
            }
        }

        cubeDividor(float f, float f2, float f3, float f4, int n, int n2, float f5, float f6) {
            this.numCubes = n2;
            this.count = 1;
            this.prob = f5;
            this.noise = f6;
            this.side = f4;
            this.cubes = new cube[this.numCubes];
            this.cubes[0] = new cube(f, f2, f3, f4);
            int n3 = 1;
            while (n3 < this.numCubes) {
                this.cubes[n3] = new cube(0.0f, 0.0f, 0.0f, 0.0f);
                ++n3;
            }
            this.divisions = n;
            this.div3 = n * n * n;
            this.active = true;
            this.numModes = 5;
            this.mode = 0;
        }
    }

    class cube {
        float x;
        float y;
        float z;
        float a;
        int generation;
        int c;
        float[][] randomOffset;

        void draw() {
            D5LV.this.stroke(60.0f, 100.0f);
            D5LV.this.fill(this.c);
            D5LV.this.push();
            D5LV.this.translate(this.x, this.y, this.z);
            D5LV.this.box(2.0f * this.a);
            D5LV.this.pop();
        }

        void drawSmall() {
            D5LV.this.stroke(60.0f, 100.0f);
            D5LV.this.fill(this.c);
            D5LV.this.push();
            D5LV.this.translate(this.x, this.y, this.z);
            D5LV.this.box(this.a);
            D5LV.this.pop();
        }

        void drawDot() {
            D5LV.this.stroke(60.0f, 100.0f);
            D5LV.this.fill(this.c);
            D5LV.this.push();
            D5LV.this.translate(this.x, this.y, this.z);
            D5LV.this.box(2.0f);
            D5LV.this.pop();
        }

        void drawSkew() {
            D5LV.this.stroke(60.0f, 100.0f);
            D5LV.this.fill(this.c);
            D5LV.this.beginShape(129);
            D5LV.this.vertex(this.x + this.a + this.randomOffset[7][0], this.y + this.a + this.randomOffset[7][1], this.z + this.a + this.randomOffset[7][2]);
            D5LV.this.vertex(this.x + this.a + this.randomOffset[6][0], this.y - this.a + this.randomOffset[6][1], this.z + this.a + this.randomOffset[6][2]);
            D5LV.this.vertex(this.x - this.a + this.randomOffset[5][0], this.y - this.a + this.randomOffset[5][1], this.z + this.a + this.randomOffset[5][2]);
            D5LV.this.vertex(this.x - this.a + this.randomOffset[4][0], this.y + this.a + this.randomOffset[4][1], this.z + this.a + this.randomOffset[4][2]);
            D5LV.this.vertex(this.x - this.a + this.randomOffset[3][0], this.y + this.a + this.randomOffset[3][1], this.z - this.a + this.randomOffset[3][2]);
            D5LV.this.vertex(this.x - this.a + this.randomOffset[2][0], this.y - this.a + this.randomOffset[2][1], this.z - this.a + this.randomOffset[2][2]);
            D5LV.this.vertex(this.x + this.a + this.randomOffset[1][0], this.y - this.a + this.randomOffset[1][1], this.z - this.a + this.randomOffset[1][2]);
            D5LV.this.vertex(this.x + this.a + this.randomOffset[0][0], this.y + this.a + this.randomOffset[0][1], this.z - this.a + this.randomOffset[0][2]);
            D5LV.this.vertex(this.x + this.a + this.randomOffset[7][0], this.y + this.a + this.randomOffset[7][1], this.z + this.a + this.randomOffset[7][2]);
            D5LV.this.vertex(this.x + this.a + this.randomOffset[6][0], this.y - this.a + this.randomOffset[6][1], this.z + this.a + this.randomOffset[6][2]);
            D5LV.this.endShape();
            D5LV.this.beginShape(128);
            D5LV.this.vertex(this.x + this.a + this.randomOffset[7][0], this.y + this.a + this.randomOffset[7][1], this.z + this.a + this.randomOffset[7][2]);
            D5LV.this.vertex(this.x + this.a + this.randomOffset[0][0], this.y + this.a + this.randomOffset[0][1], this.z - this.a + this.randomOffset[0][2]);
            D5LV.this.vertex(this.x - this.a + this.randomOffset[3][0], this.y + this.a + this.randomOffset[3][1], this.z - this.a + this.randomOffset[3][2]);
            D5LV.this.vertex(this.x - this.a + this.randomOffset[4][0], this.y + this.a + this.randomOffset[4][1], this.z + this.a + this.randomOffset[4][2]);
            D5LV.this.vertex(this.x + this.a + this.randomOffset[6][0], this.y - this.a + this.randomOffset[6][1], this.z + this.a + this.randomOffset[6][2]);
            D5LV.this.vertex(this.x + this.a + this.randomOffset[1][0], this.y - this.a + this.randomOffset[1][1], this.z - this.a + this.randomOffset[1][2]);
            D5LV.this.vertex(this.x - this.a + this.randomOffset[2][0], this.y - this.a + this.randomOffset[2][1], this.z - this.a + this.randomOffset[2][2]);
            D5LV.this.vertex(this.x - this.a + this.randomOffset[5][0], this.y - this.a + this.randomOffset[5][1], this.z + this.a + this.randomOffset[5][2]);
            D5LV.this.endShape();
        }

        void drawTrunc() {
            float f = this.a / 2.0f;
            D5LV.this.stroke(60.0f, 100.0f);
            D5LV.this.fill(this.c);
            D5LV.this.beginShape(128);
            D5LV.this.vertex(this.x, this.y + f, this.z + f);
            D5LV.this.vertex(this.x + f, this.y, this.z + f);
            D5LV.this.vertex(this.x, this.y - f, this.z + f);
            D5LV.this.vertex(this.x - f, this.y, this.z + f);
            D5LV.this.vertex(this.x, this.y + f, this.z - f);
            D5LV.this.vertex(this.x + f, this.y, this.z - f);
            D5LV.this.vertex(this.x, this.y - f, this.z - f);
            D5LV.this.vertex(this.x - f, this.y, this.z - f);
            D5LV.this.vertex(this.x + f, this.y, this.z + f);
            D5LV.this.vertex(this.x + f, this.y + f, this.z);
            D5LV.this.vertex(this.x + f, this.y, this.z - f);
            D5LV.this.vertex(this.x + f, this.y - f, this.z);
            D5LV.this.vertex(this.x - f, this.y, this.z + f);
            D5LV.this.vertex(this.x - f, this.y + f, this.z);
            D5LV.this.vertex(this.x - f, this.y, this.z - f);
            D5LV.this.vertex(this.x - f, this.y - f, this.z);
            D5LV.this.vertex(this.x, this.y + f, this.z + f);
            D5LV.this.vertex(this.x + f, this.y + f, this.z);
            D5LV.this.vertex(this.x, this.y + f, this.z - f);
            D5LV.this.vertex(this.x - f, this.y + f, this.z);
            D5LV.this.vertex(this.x, this.y - f, this.z + f);
            D5LV.this.vertex(this.x + f, this.y - f, this.z);
            D5LV.this.vertex(this.x, this.y - f, this.z - f);
            D5LV.this.vertex(this.x - f, this.y - f, this.z);
            D5LV.this.endShape();
            D5LV.this.noStroke();
            D5LV.this.beginShape(64);
            D5LV.this.vertex(this.x, this.y + f, this.z + f);
            D5LV.this.vertex(this.x - f, this.y, this.z + f);
            D5LV.this.vertex(this.x - f, this.y + f, this.z);
            D5LV.this.vertex(this.x, this.y + f, this.z + f);
            D5LV.this.vertex(this.x + f, this.y, this.z + f);
            D5LV.this.vertex(this.x + f, this.y + f, this.z);
            D5LV.this.vertex(this.x, this.y - f, this.z + f);
            D5LV.this.vertex(this.x - f, this.y, this.z + f);
            D5LV.this.vertex(this.x - f, this.y - f, this.z);
            D5LV.this.vertex(this.x, this.y - f, this.z + f);
            D5LV.this.vertex(this.x + f, this.y, this.z + f);
            D5LV.this.vertex(this.x + f, this.y - f, this.z);
            D5LV.this.vertex(this.x, this.y + f, this.z - f);
            D5LV.this.vertex(this.x - f, this.y, this.z - f);
            D5LV.this.vertex(this.x - f, this.y + f, this.z);
            D5LV.this.vertex(this.x, this.y + f, this.z - f);
            D5LV.this.vertex(this.x + f, this.y, this.z - f);
            D5LV.this.vertex(this.x + f, this.y + f, this.z);
            D5LV.this.vertex(this.x, this.y - f, this.z - f);
            D5LV.this.vertex(this.x - f, this.y, this.z - f);
            D5LV.this.vertex(this.x - f, this.y - f, this.z);
            D5LV.this.vertex(this.x, this.y - f, this.z - f);
            D5LV.this.vertex(this.x + f, this.y, this.z - f);
            D5LV.this.vertex(this.x + f, this.y - f, this.z);
            D5LV.this.endShape();
        }

        void drawChamfer() {
            float f = (float)4 * this.a / (float)5;
            D5LV.this.stroke(60.0f, 100.0f);
            D5LV.this.fill(this.c);
            D5LV.this.beginShape(128);
            D5LV.this.vertex(this.x + f, this.y + f, this.z + this.a);
            D5LV.this.vertex(this.x - f, this.y + f, this.z + this.a);
            D5LV.this.vertex(this.x - f, this.y - f, this.z + this.a);
            D5LV.this.vertex(this.x + f, this.y - f, this.z + this.a);
            D5LV.this.vertex(this.x + f, this.y + f, this.z - this.a);
            D5LV.this.vertex(this.x - f, this.y + f, this.z - this.a);
            D5LV.this.vertex(this.x - f, this.y - f, this.z - this.a);
            D5LV.this.vertex(this.x + f, this.y - f, this.z - this.a);
            D5LV.this.vertex(this.x + this.a, this.y + f, this.z + f);
            D5LV.this.vertex(this.x + this.a, this.y + f, this.z - f);
            D5LV.this.vertex(this.x + this.a, this.y - f, this.z - f);
            D5LV.this.vertex(this.x + this.a, this.y - f, this.z + f);
            D5LV.this.vertex(this.x - this.a, this.y + f, this.z + f);
            D5LV.this.vertex(this.x - this.a, this.y + f, this.z - f);
            D5LV.this.vertex(this.x - this.a, this.y - f, this.z - f);
            D5LV.this.vertex(this.x - this.a, this.y - f, this.z + f);
            D5LV.this.vertex(this.x + f, this.y + this.a, this.z + f);
            D5LV.this.vertex(this.x + f, this.y + this.a, this.z - f);
            D5LV.this.vertex(this.x - f, this.y + this.a, this.z - f);
            D5LV.this.vertex(this.x - f, this.y + this.a, this.z + f);
            D5LV.this.vertex(this.x + f, this.y - this.a, this.z + f);
            D5LV.this.vertex(this.x + f, this.y - this.a, this.z - f);
            D5LV.this.vertex(this.x - f, this.y - this.a, this.z - f);
            D5LV.this.vertex(this.x - f, this.y - this.a, this.z + f);
            D5LV.this.endShape();
            D5LV.this.beginShape(64);
            D5LV.this.vertex(this.x - f, this.y - f, this.z + this.a);
            D5LV.this.vertex(this.x - this.a, this.y - f, this.z + f);
            D5LV.this.vertex(this.x - f, this.y - this.a, this.z + f);
            D5LV.this.vertex(this.x + f, this.y - f, this.z + this.a);
            D5LV.this.vertex(this.x + this.a, this.y - f, this.z + f);
            D5LV.this.vertex(this.x + f, this.y - this.a, this.z + f);
            D5LV.this.vertex(this.x - f, this.y + f, this.z + this.a);
            D5LV.this.vertex(this.x - this.a, this.y + f, this.z + f);
            D5LV.this.vertex(this.x - f, this.y + this.a, this.z + f);
            D5LV.this.vertex(this.x + f, this.y + f, this.z + this.a);
            D5LV.this.vertex(this.x + this.a, this.y + f, this.z + f);
            D5LV.this.vertex(this.x + f, this.y + this.a, this.z + f);
            D5LV.this.vertex(this.x - f, this.y - f, this.z - this.a);
            D5LV.this.vertex(this.x - this.a, this.y - f, this.z - f);
            D5LV.this.vertex(this.x - f, this.y - this.a, this.z - f);
            D5LV.this.vertex(this.x + f, this.y - f, this.z - this.a);
            D5LV.this.vertex(this.x + this.a, this.y - f, this.z - f);
            D5LV.this.vertex(this.x + f, this.y - this.a, this.z - f);
            D5LV.this.vertex(this.x - f, this.y + f, this.z - this.a);
            D5LV.this.vertex(this.x - this.a, this.y + f, this.z - f);
            D5LV.this.vertex(this.x - f, this.y + this.a, this.z - f);
            D5LV.this.vertex(this.x + f, this.y + f, this.z - this.a);
            D5LV.this.vertex(this.x + this.a, this.y + f, this.z - f);
            D5LV.this.vertex(this.x + f, this.y + this.a, this.z - f);
            D5LV.this.endShape();
            D5LV.this.noStroke();
            D5LV.this.beginShape(128);
            D5LV.this.vertex(this.x - f, this.y - f, this.z + this.a);
            D5LV.this.vertex(this.x - f, this.y - this.a, this.z + f);
            D5LV.this.vertex(this.x + f, this.y - this.a, this.z + f);
            D5LV.this.vertex(this.x + f, this.y - f, this.z + this.a);
            D5LV.this.vertex(this.x - f, this.y - f, this.z - this.a);
            D5LV.this.vertex(this.x - f, this.y - this.a, this.z - f);
            D5LV.this.vertex(this.x + f, this.y - this.a, this.z - f);
            D5LV.this.vertex(this.x + f, this.y - f, this.z - this.a);
            D5LV.this.vertex(this.x - f, this.y + f, this.z + this.a);
            D5LV.this.vertex(this.x - f, this.y + this.a, this.z + f);
            D5LV.this.vertex(this.x + f, this.y + this.a, this.z + f);
            D5LV.this.vertex(this.x + f, this.y + f, this.z + this.a);
            D5LV.this.vertex(this.x - f, this.y + f, this.z - this.a);
            D5LV.this.vertex(this.x - f, this.y + this.a, this.z - f);
            D5LV.this.vertex(this.x + f, this.y + this.a, this.z - f);
            D5LV.this.vertex(this.x + f, this.y + f, this.z - this.a);
            D5LV.this.vertex(this.x - f, this.y - f, this.z + this.a);
            D5LV.this.vertex(this.x - this.a, this.y - f, this.z + f);
            D5LV.this.vertex(this.x - this.a, this.y + f, this.z + f);
            D5LV.this.vertex(this.x - f, this.y + f, this.z + this.a);
            D5LV.this.vertex(this.x - f, this.y - f, this.z - this.a);
            D5LV.this.vertex(this.x - this.a, this.y - f, this.z - f);
            D5LV.this.vertex(this.x - this.a, this.y + f, this.z - f);
            D5LV.this.vertex(this.x - f, this.y + f, this.z - this.a);
            D5LV.this.vertex(this.x + f, this.y - f, this.z + this.a);
            D5LV.this.vertex(this.x + this.a, this.y - f, this.z + f);
            D5LV.this.vertex(this.x + this.a, this.y + f, this.z + f);
            D5LV.this.vertex(this.x + f, this.y + f, this.z + this.a);
            D5LV.this.vertex(this.x + f, this.y - f, this.z - this.a);
            D5LV.this.vertex(this.x + this.a, this.y - f, this.z - f);
            D5LV.this.vertex(this.x + this.a, this.y + f, this.z - f);
            D5LV.this.vertex(this.x + f, this.y + f, this.z - this.a);
            D5LV.this.vertex(this.x - f, this.y - this.a, this.z + f);
            D5LV.this.vertex(this.x - this.a, this.y - f, this.z + f);
            D5LV.this.vertex(this.x - this.a, this.y - f, this.z - f);
            D5LV.this.vertex(this.x - f, this.y - this.a, this.z - f);
            D5LV.this.vertex(this.x + f, this.y - this.a, this.z + f);
            D5LV.this.vertex(this.x + this.a, this.y - f, this.z + f);
            D5LV.this.vertex(this.x + this.a, this.y - f, this.z - f);
            D5LV.this.vertex(this.x + f, this.y - this.a, this.z - f);
            D5LV.this.vertex(this.x - f, this.y + this.a, this.z + f);
            D5LV.this.vertex(this.x - this.a, this.y + f, this.z + f);
            D5LV.this.vertex(this.x - this.a, this.y + f, this.z - f);
            D5LV.this.vertex(this.x - f, this.y + this.a, this.z - f);
            D5LV.this.vertex(this.x + f, this.y + this.a, this.z + f);
            D5LV.this.vertex(this.x + this.a, this.y + f, this.z + f);
            D5LV.this.vertex(this.x + this.a, this.y + f, this.z - f);
            D5LV.this.vertex(this.x + f, this.y + this.a, this.z - f);
            D5LV.this.endShape();
        }

        void drawDistorted(float f) {
            float f2 = -1.0f + 2.0f * D5LV.this.sq(1.0f - this.a / f);
            D5LV.this.stroke(60.0f, 100.0f);
            D5LV.this.fill(this.c);
            D5LV.this.push();
            D5LV.this.translate(D5LV.this.constrain(this.x * f2, -f, f), D5LV.this.constrain(this.y * f2, -f, f), D5LV.this.constrain(this.z * f2, -f, f));
            D5LV.this.box(2.0f * this.a);
            D5LV.this.pop();
        }

        cube(float f, float f2, float f3, float f4) {
            this.x = f;
            this.y = f2;
            this.z = f3;
            this.a = f4;
            this.generation = 0;
            this.c = D5LV.this.pal[D5LV.this.currentPalette].getColor();
            this.randomOffset = new float[8][3];
            int n = 0;
            while (n < 8) {
                int n2 = 0;
                while (n2 < 3) {
                    this.randomOffset[n][n2] = D5LV.this.random(-0.5f * this.a, 0.5f * this.a);
                    ++n2;
                }
                ++n;
            }
        }
    }

    class palette {
        int numpal = 0;
        int maxpal;
        int alfa;
        int[] colors;
        String source;

        int getColor() {
            return this.colors[(int)D5LV.this.random(this.numpal)];
        }

        void putColor(String string) {
            BImage bImage = D5LV.this.loadImage(string);
            D5LV.this.image(bImage, 0.0f, 0.0f);
            int n = 0;
            while (n < bImage.width) {
                int n2 = 0;
                while (n2 < bImage.height) {
                    int n3 = D5LV.this.get(n, n2);
                    boolean bl = false;
                    int n4 = 0;
                    while (n4 < this.numpal) {
                        if (D5LV.this.color(D5LV.this.red(n3), D5LV.this.green(n3), D5LV.this.blue(n3), (float)this.alfa) == this.colors[n4]) {
                            bl = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!bl) {
                        if (this.numpal >= this.maxpal) break;
                        this.colors[this.numpal] = D5LV.this.color(D5LV.this.red(n3), D5LV.this.green(n3), D5LV.this.blue(n3), (float)this.alfa);
                        ++this.numpal;
                    }
                    ++n2;
                }
                ++n;
            }
        }

        palette(int n, int n2, String string) {
            this.maxpal = n;
            this.alfa = n2;
            this.colors = new int[this.maxpal];
            this.source = string;
            this.putColor(this.source);
        }
    }

    class panelledScreen {
        int rows;
        int cols;
        int w;
        int h;
        int d;
        int currentPanel;
        int maxPanel;
        boolean viewChanged;
        boolean panelChanged;

        void center() {
            int n = this.d + (this.w + this.d) * (this.currentPanel % this.cols) + this.w / 2;
            int n2 = (int)((float)this.d + (float)(this.h + this.d) * (D5LV.this.floor(this.currentPanel / this.cols) % (float)this.rows) + (float)(this.h / 2));
            D5LV.this.translate(n, n2);
        }

        int centerX() {
            return this.d + (this.w + this.d) * (this.currentPanel % this.cols) + this.w / 2;
        }

        int centerY() {
            return (int)((float)this.d + (float)(this.h + this.d) * (D5LV.this.floor(this.currentPanel / this.cols) % (float)this.rows) + (float)(this.h / 2));
        }

        void clear() {
            this.drawBorders();
            int n = this.d + (this.w + this.d) * (this.currentPanel % this.cols);
            int n2 = (int)((float)this.d + (float)(this.h + this.d) * (D5LV.this.floor(this.currentPanel / this.cols) % (float)this.rows));
            D5LV.this.noStroke();
            D5LV.this.fill(80);
            D5LV.this.ellipse(n - 6, n2 - 6, 4, 4);
            D5LV.this.fill(255);
            D5LV.this.rect(n, n2, this.w, this.h);
        }

        void drawBorders() {
            D5LV.this.noStroke();
            D5LV.this.fill(240);
            int n = 0;
            while (n < this.maxPanel + 1) {
                int n2 = this.d + (this.w + this.d) * (n % this.cols);
                int n3 = (int)((float)this.d + (float)(this.h + this.d) * (D5LV.this.floor(n / this.cols) % (float)this.rows));
                D5LV.this.rect(n2, n3 - this.d, -this.d, this.h + 2 * this.d);
                D5LV.this.rect(n2 + this.w, n3 - this.d, this.d, this.h + 2 * this.d);
                D5LV.this.rect(n2, n3, this.w, -this.d);
                D5LV.this.rect(n2, n3 + this.h, this.w, this.d);
                ++n;
            }
        }

        void mousePressed() {
            int n = (int)((float)(D5LV.this.mouseY - this.d) / (float)(this.h + this.d));
            int n2 = (int)((float)(D5LV.this.mouseX - this.d) / (float)(this.w + this.d));
            if (this.currentPanel != n * this.cols + n2) {
                this.panelChanged = true;
                this.currentPanel = n * this.cols + n2;
                System.arraycopy(D5LV.this.clearZ, 0, D5LV.this.g.zbuffer, 0, D5LV.this.clearZ.length);
            }
        }

        void mouseDragged() {
            this.viewChanged = true;
        }

        void mouseReleased() {
            if (this.panelChanged) {
                this.panelChanged = false;
                this.viewChanged = false;
                D5LV.this.cubeThing.active = true;
            } else if (this.viewChanged) {
                this.viewChanged = false;
            } else {
                D5LV.this.cubeThing.active ^= true;
            }
        }

        panelledScreen(int n, int n2, int n3, int n4, int n5) {
            this.rows = n;
            this.cols = n2;
            this.w = n3;
            this.h = n4;
            this.d = n5;
            this.currentPanel = 0;
            this.maxPanel = this.rows * this.cols - 1;
            this.viewChanged = false;
            this.panelChanged = false;
        }
    }

    class BufferedMouse {
        float stiffness;
        float currentX;
        float currentY;

        void update() {
            this.currentX = this.currentX * this.stiffness + (1.0f - this.stiffness) * (float)D5LV.this.mouseX;
            this.currentY = this.currentY * this.stiffness + (1.0f - this.stiffness) * (float)D5LV.this.mouseY;
        }

        void clear() {
            this.currentX = D5LV.this.mouseX;
            this.currentY = D5LV.this.mouseY;
        }

        BufferedMouse(float f) {
            this.stiffness = D5LV.this.constrain(f, 0.0f, 1.0f);
            this.currentX = D5LV.this.mouseX;
            this.currentY = D5LV.this.mouseY;
        }
    }

    class ArcBall {
        float center_x;
        float center_y;
        float radius;
        Vec3 v_down;
        Vec3 v_drag;
        Quat q_now;
        Quat q_down;
        Quat q_drag;
        Vec3[] axisSet;
        int axis;

        void mousePressed() {
            this.v_down = this.mouse_to_sphere(D5LV.this.bufferedMouse.currentX, D5LV.this.bufferedMouse.currentY);
            this.q_down.set(this.q_now);
            this.q_drag.reset();
        }

        void mouseDragged() {
            this.v_drag = this.mouse_to_sphere(D5LV.this.bufferedMouse.currentX, D5LV.this.bufferedMouse.currentY);
            this.q_drag.set(Vec3.dot(this.v_down, this.v_drag), Vec3.cross(this.v_down, this.v_drag));
        }

        void run() {
            this.q_now = Quat.mul(this.q_drag, this.q_down);
            this.applyQuat2Matrix(this.q_now);
        }

        Vec3 mouse_to_sphere(float f, float f2) {
            Vec3 vec3 = new Vec3();
            vec3.x = (f - this.center_x) / this.radius;
            vec3.y = (f2 - this.center_y) / this.radius;
            float f3 = vec3.x * vec3.x + vec3.y * vec3.y;
            if (f3 > 1.0f) {
                vec3.normalize();
            } else {
                vec3.z = D5LV.this.sqrt(1.0f - f3);
            }
            return this.axis == -1 ? vec3 : this.constrain_vector(vec3, this.axisSet[this.axis]);
        }

        Vec3 constrain_vector(Vec3 vec3, Vec3 vec32) {
            Vec3 vec33 = new Vec3();
            vec33.sub(vec3, Vec3.mul(vec32, Vec3.dot(vec32, vec3)));
            vec33.normalize();
            return vec33;
        }

        void applyQuat2Matrix(Quat quat) {
            float[] fArray = quat.getValue();
            D5LV.this.rotate(fArray[0], fArray[1], fArray[2], fArray[3]);
        }

        ArcBall(float f, float f2, float f3) {
            this.center_x = f;
            this.center_y = f2;
            this.radius = f3;
            this.v_down = new Vec3();
            this.v_drag = new Vec3();
            this.q_now = new Quat();
            this.q_down = new Quat();
            this.q_drag = new Quat();
            this.axisSet = new Vec3[]{new Vec3(1.0f, 0.0f, 0.0f), new Vec3(0.0f, 1.0f, 0.0f), new Vec3(0.0f, 0.0f, 1.0f)};
            this.axis = -1;
        }
    }

    static class Vec3 {
        float x;
        float y;
        float z;

        void normalize() {
            float f = this.length();
            this.x /= f;
            this.y /= f;
            this.z /= f;
        }

        float length() {
            return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        }

        static Vec3 cross(Vec3 vec3, Vec3 vec32) {
            Vec3 vec33 = new Vec3();
            vec33.x = vec3.y * vec32.z - vec3.z * vec32.y;
            vec33.y = vec3.z * vec32.x - vec3.x * vec32.z;
            vec33.z = vec3.x * vec32.y - vec3.y * vec32.x;
            return vec33;
        }

        static float dot(Vec3 vec3, Vec3 vec32) {
            return vec3.x * vec32.x + vec3.y * vec32.y + vec3.z * vec32.z;
        }

        static Vec3 mul(Vec3 vec3, float f) {
            Vec3 vec32 = new Vec3();
            vec32.x = vec3.x * f;
            vec32.y = vec3.y * f;
            vec32.z = vec3.z * f;
            return vec32;
        }

        void sub(Vec3 vec3, Vec3 vec32) {
            this.x = vec3.x - vec32.x;
            this.y = vec3.y - vec32.y;
            this.z = vec3.z - vec32.z;
        }

        void add(Vec3 vec3, Vec3 vec32) {
            this.x = vec3.x + vec32.x;
            this.y = vec3.y + vec32.y;
            this.z = vec3.z + vec32.z;
        }

        Vec3() {
        }

        Vec3(float f, float f2, float f3) {
            this.x = f;
            this.y = f2;
            this.z = f3;
        }
    }

    static class Quat {
        float w;
        float x;
        float y;
        float z;

        void reset() {
            this.w = 1.0f;
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 0.0f;
        }

        void set(float f, Vec3 vec3) {
            this.w = f;
            this.x = vec3.x;
            this.y = vec3.y;
            this.z = vec3.z;
        }

        void set(Quat quat) {
            this.w = quat.w;
            this.x = quat.x;
            this.y = quat.y;
            this.z = quat.z;
        }

        static Quat mul(Quat quat, Quat quat2) {
            Quat quat3 = new Quat();
            quat3.w = quat.w * quat2.w - quat.x * quat2.x - quat.y * quat2.y - quat.z * quat2.z;
            quat3.x = quat.w * quat2.x + quat.x * quat2.w + quat.y * quat2.z - quat.z * quat2.y;
            quat3.y = quat.w * quat2.y + quat.y * quat2.w + quat.z * quat2.x - quat.x * quat2.z;
            quat3.z = quat.w * quat2.z + quat.z * quat2.w + quat.x * quat2.y - quat.y * quat2.x;
            return quat3;
        }

        float[] getValue() {
            float[] fArray = new float[4];
            float f = (float)Math.sqrt(1.0f - this.w * this.w);
            if (f < 1.0E-4f) {
                f = 1.0f;
            }
            fArray[0] = (float)Math.acos(this.w) * 2.0f;
            fArray[1] = this.x / f;
            fArray[2] = this.y / f;
            fArray[3] = this.z / f;
            return fArray;
        }

        Quat() {
            this.reset();
        }

        Quat(float f, float f2, float f3, float f4) {
            this.w = f;
            this.x = f2;
            this.y = f3;
            this.z = f4;
        }
    }
}

