/*
 * Decompiled with CFR 0.152.
 */
public class liquidsky
extends BApplet {
    Particle[] dots;
    int count;
    int[] bright;
    int[] tmpBright;
    int iMax;
    int[] dx;
    int[] dy;
    Gradient grad;

    void setup() {
        this.size(200, 500);
        this.background(255);
        this.noStroke();
        this.framerate(30.0f);
        this.iMax = this.width * this.height;
        this.bright = new int[this.iMax];
        this.tmpBright = new int[this.iMax];
        int n = 0;
        while (n < this.iMax) {
            this.bright[n] = 0;
            ++n;
        }
        this.dx = new int[256];
        this.dy = new int[256];
        n = 0;
        while (n < 256) {
            float f = n;
            float f2 = 7.0f * (f / 255.0f * ((float)Math.PI * 2));
            this.dx[n] = (int)((float)4 * this.cos(f2));
            this.dy[n] = (int)((float)4 * this.sin(f2));
            ++n;
        }
        this.count = 600;
        this.grad = new Gradient(0xFFFFFF, 0xFFFFFF);
        this.grad.addMarker(0.25f, 0xFF8000);
        this.grad.addMarker(0.5f, 0x800000);
        this.grad.addMarker(0.65f, 0);
        this.grad.addMarker(0.75f, 0x800000);
        this.grad.addMarker(0.85f, 0xFF8000);
        this.dots = new Particle[this.count];
        n = 0;
        while (n < this.count) {
            this.dots[n] = new Particle(this.width, this.height);
            ++n;
        }
        n = 0;
        while (n < this.count) {
            int n2 = 0;
            while (n2 < (int)this.random(this.count)) {
                int n3 = (int)this.random(this.count);
                if (n3 != n) {
                    this.dots[n].addEnemy(this.dots[n3]);
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < (int)this.random(this.count)) {
                int n4 = (int)this.random(this.count);
                if (n4 != n) {
                    this.dots[n].addTarget(this.dots[n4]);
                }
                ++n2;
            }
            ++n;
        }
    }

    void loop() {
        int n = 0;
        while (n < this.count) {
            this.dots[n].move();
            ++n;
        }
        n = 0;
        while (n < this.count) {
            this.dots[n].apply();
            ++n;
        }
        n = 0;
        while (n < this.count) {
            this.dots[n].render();
            ++n;
        }
        this.diffuse();
        this.distort();
    }

    void diffuse() {
        int n = 0;
        while (n < this.iMax) {
            int n2;
            int n3 = 1;
            int n4 = this.bright[n];
            int n5 = n % this.width;
            if (n5 > 0) {
                n4 += this.bright[n - 1];
                ++n3;
            }
            if (n5 < this.width - 1) {
                n4 += this.bright[n + 1];
                ++n3;
            }
            if ((n2 = n / this.width) > 0) {
                n4 += this.bright[n - this.width];
                ++n3;
            }
            this.tmpBright[n] = n4 /= n3;
            ++n;
        }
        this.bright = this.tmpBright;
    }

    void distort() {
        int n = 0;
        while (n < this.iMax) {
            int n2 = this.bright[n];
            int n3 = n % this.width + this.dx[n2];
            int n4 = n / this.width + this.dy[n2];
            int n5 = n3 >= 0 && n4 >= 0 && n3 < this.width && n4 < this.height ? this.blend(this.bright[n3 + n4 * this.width], this.bright[n], 128) : this.bright[n];
            this.pixels[n] = this.grad.getColor(n5);
            ++n;
        }
    }

    void display() {
        int n = 0;
        while (n < this.iMax) {
            this.pixels[n] = this.grad.getColor(this.bright[n]);
            ++n;
        }
    }

    int blend(int n, int n2, int n3) {
        return (n * n3 + n2 * (255 - n3)) / 255;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Particle {
        float x;
        float y;
        float nx;
        float ny;
        int ix;
        int iy;
        int ip;
        float vx;
        float vy;
        float speed;
        float targetSpeed;
        float angle;
        float targetAngle;
        float cx;
        float cy;
        float MAXSPEED;
        float ENEMY_ZONE;
        float TARGET_ZONE;
        float AVOID_ZONE;
        float BORDER;
        float CONSTRAIN_RADIUS;
        float INNER_CONSTRAIN_RADIUS;
        boolean friendDetected;
        boolean enemyDetected;
        int fd;
        int ed;
        Particle[] targets;
        Particle[] enemies;

        void setXY(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        void addTarget(Particle particle) {
            int n = 0;
            while (n < this.targets.length) {
                if (this.targets[n] == particle) {
                    return;
                }
                ++n;
            }
            n = 0;
            while (n < this.enemies.length) {
                if (this.enemies[n] == particle) {
                    return;
                }
                ++n;
            }
            Particle[] particleArray = new Particle[this.targets.length + 1];
            System.arraycopy(this.targets, 0, particleArray, 0, this.targets.length);
            particleArray[this.targets.length] = particle;
            this.targets = particleArray;
        }

        void addEnemy(Particle particle) {
            int n = 0;
            while (n < this.enemies.length) {
                if (this.enemies[n] == particle) {
                    return;
                }
                ++n;
            }
            n = 0;
            while (n < this.targets.length) {
                if (this.targets[n] == particle) {
                    return;
                }
                ++n;
            }
            Particle[] particleArray = new Particle[this.enemies.length + 1];
            System.arraycopy(this.enemies, 0, particleArray, 0, this.enemies.length);
            particleArray[this.enemies.length] = particle;
            this.enemies = particleArray;
        }

        void move() {
            this.updateDirection();
            this.checkTargets();
            this.checkContraints();
            this.updateSpeed();
            this.nx = this.x + this.vx;
            this.ny = this.y + this.vy;
        }

        void checkContraints() {
            if (this.x < this.BORDER || this.y < this.BORDER || this.x > (float)liquidsky.this.width - this.BORDER || this.y > (float)liquidsky.this.height - this.BORDER) {
                float f = this.cx - this.x;
                float f2 = this.cy - this.y;
                this.angle = this.turn(this.angle, liquidsky.this.atan2(f2, f), 0.1f);
                this.speed *= 0.94f;
            }
        }

        void updateDirection() {
            this.targetAngle = liquidsky.this.random((float)Math.PI * 2);
            this.angle = this.turn(this.angle, this.targetAngle, 0.2f);
            this.targetSpeed = liquidsky.this.random(this.speed + this.MAXSPEED / 2.0f);
            this.speed = (15.0f * this.speed + this.targetSpeed) / 16.0f;
        }

        void checkTargets() {
            float f;
            float f2;
            float f3 = this.TARGET_ZONE + 1.0f;
            float f4 = this.angle;
            this.friendDetected = false;
            int n = 0;
            while (n < this.targets.length) {
                float f5 = this.targets[n].x - this.x;
                f2 = this.targets[n].y - this.y;
                f = f5 * f5 + f2 * f2;
                if (f <= this.TARGET_ZONE && f < f3) {
                    if (f > this.AVOID_ZONE) {
                        f3 = f;
                        f4 = liquidsky.this.atan2(f2, f5);
                    }
                    this.fd = n;
                    this.friendDetected = true;
                }
                ++n;
            }
            this.enemyDetected = false;
            f3 = this.TARGET_ZONE + 1.0f;
            float f6 = this.angle;
            int n2 = 0;
            while (n2 < this.enemies.length) {
                f2 = this.enemies[n2].x - this.x;
                f = this.enemies[n2].y - this.y;
                float f7 = f2 * f2 + f * f;
                if (f7 <= this.ENEMY_ZONE && f7 < f3) {
                    f3 = f7;
                    f6 = -liquidsky.this.atan2(f, f2);
                    this.enemyDetected = true;
                    this.ed = n2;
                }
                ++n2;
            }
            if (this.friendDetected) {
                this.angle = this.turn(this.angle, f4, 0.1f);
                this.speed *= 0.95f;
            }
            if (this.enemyDetected) {
                this.angle = this.turn(this.angle, f6, 0.1f);
                this.speed *= 1.05f;
            }
        }

        void updateSpeed() {
            this.speed = liquidsky.this.min(this.speed, this.MAXSPEED);
            this.vx = liquidsky.this.cos(this.angle) * this.speed;
            this.vy = liquidsky.this.sin(this.angle) * this.speed;
        }

        void apply() {
            this.x = this.nx;
            this.y = this.ny;
            this.ix = (int)this.x;
            this.iy = (int)this.y;
            this.ip = this.ix + this.iy * liquidsky.this.width;
        }

        float turn(float f, float f2, float f3) {
            float f4 = f2 - f;
            if (f4 > (float)Math.PI) {
                f4 = -((float)Math.PI * 2 - f4);
            } else if (f4 < (float)(-Math.PI)) {
                f4 = (float)Math.PI * 2 + f4;
            }
            return f + f4 * f3;
        }

        void render() {
            if (this.x < 0.0f || this.x >= (float)liquidsky.this.width || this.y < 0.0f || this.y >= (float)liquidsky.this.height || this.ip < 0 || this.ip >= liquidsky.this.iMax) {
                return;
            }
            liquidsky.this.bright[this.ip] = this.enemyDetected || this.friendDetected ? 255 : 0;
        }

        private final /* synthetic */ void this() {
            this.MAXSPEED = 7.0f;
            this.ENEMY_ZONE = 60.0f;
            this.TARGET_ZONE = 60.0f;
            this.AVOID_ZONE = 12.0f;
            this.BORDER = 5;
            this.CONSTRAIN_RADIUS = 0.0f;
            this.INNER_CONSTRAIN_RADIUS = 60.0f;
            this.friendDetected = false;
            this.enemyDetected = false;
        }

        Particle(int n, int n2) {
            this.this();
            this.cx = (float)n / 2.0f;
            this.cy = (float)n2 / (float)4;
            this.x = liquidsky.this.random(n);
            this.y = liquidsky.this.random(n2);
            this.vx = 0.0f;
            this.vy = 0.0f;
            this.speed = 0.0f;
            this.targetSpeed = 0.0f;
            this.targetAngle = this.angle = liquidsky.this.random((float)Math.PI * 2);
            this.targets = new Particle[0];
            this.enemies = new Particle[0];
            this.ENEMY_ZONE *= this.ENEMY_ZONE;
            this.TARGET_ZONE *= this.TARGET_ZONE;
            this.AVOID_ZONE *= this.AVOID_ZONE;
            this.CONSTRAIN_RADIUS = (float)(liquidsky.this.min(liquidsky.this.width, liquidsky.this.height) / 2) - this.BORDER;
            this.CONSTRAIN_RADIUS *= this.CONSTRAIN_RADIUS;
        }
    }

    class Gradient {
        Marker[] markers = new Marker[2];
        int[] palette;

        void addMarker(float f, int n) {
            Marker[] markerArray = new Marker[this.markers.length + 1];
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.markers.length) {
                if (this.markers[n3].position < f || n2 == 1) {
                    markerArray[n3 + n2] = this.markers[n3];
                } else {
                    markerArray[n3 + n2] = new Marker(f, n);
                    n2 = 1;
                    markerArray[n3 + n2] = this.markers[n3];
                }
                ++n3;
            }
            this.markers = markerArray;
            this.updatePalette();
        }

        void updatePalette() {
            int n = 0;
            while (n < this.markers.length - 1) {
                Marker marker = this.markers[n];
                Marker marker2 = this.markers[n + 1];
                int n2 = marker.getPalettePos();
                int n3 = marker2.getPalettePos();
                int n4 = n3 - n2;
                int n5 = 0;
                int n6 = n2;
                while (n6 < n3) {
                    int n7 = ((marker.col & 0xFF0000) * (n4 - n5) + (marker2.col & 0xFF0000) * n5) / n4;
                    int n8 = ((marker.col & 0xFF00) * (n4 - n5) + (marker2.col & 0xFF00) * n5) / n4;
                    int n9 = ((marker.col & 0xFF) * (n4 - n5) + (marker2.col & 0xFF) * n5) / n4;
                    this.palette[n6] = 0xFF000000 | n7 & 0xFF0000 | n8 & 0xFF00 | n9 & 0xFF;
                    ++n5;
                    ++n6;
                }
                ++n;
            }
        }

        int getColor(int n) {
            return this.palette[n];
        }

        Gradient(int n, int n2) {
            this.markers[0] = new Marker(0.0f, n);
            this.markers[1] = new Marker(1.0f, n2);
            this.palette = new int[256];
            this.updatePalette();
        }
    }

    class Marker {
        float position;
        int col;

        int getPalettePos() {
            return (int)(this.position * 255.0f);
        }

        Marker(float f, int n) {
            this.position = f;
            this.col = n;
        }
    }
}

