/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class BFont
implements BConstants {
    static final int VLW = 0;
    static final int RAW = 1;
    BGraphics parent;
    boolean valid;
    int kind;
    int firstChar;
    int charCount;
    BImage[] images;
    int cwidth;
    int cheight;
    int left;
    int baseline;
    int leadspace;
    int mboxY;
    int[] height;
    int[] width;
    int[] setWidth;
    int[] topExtent;
    int[] leftExtent;
    float size;
    float defaultLeading;
    float leading;
    boolean cached;
    private char[] c = new char[8192];

    private void load_vlw_font(String string) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(this.parent.loadStream(string));
        this.firstChar = 33;
        this.charCount = dataInputStream.readInt();
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        this.mboxY = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        dataInputStream.readInt();
        int[] nArray = new int[this.charCount];
        this.height = new int[this.charCount];
        this.width = new int[this.charCount];
        this.setWidth = new int[this.charCount];
        this.topExtent = new int[this.charCount];
        this.leftExtent = new int[this.charCount];
        int n4 = 0;
        while (n4 < this.charCount) {
            nArray[n4] = dataInputStream.readInt();
            this.height[n4] = dataInputStream.readInt();
            this.width[n4] = dataInputStream.readInt();
            this.setWidth[n4] = dataInputStream.readInt();
            this.topExtent[n4] = dataInputStream.readInt();
            this.leftExtent[n4] = dataInputStream.readInt();
            dataInputStream.readInt();
            ++n4;
        }
        this.images = new BImage[this.charCount];
        n4 = 0;
        while (n4 < this.charCount) {
            int[] nArray2 = new int[16384];
            this.images[n4] = new BImage(nArray2, 64, 64, 2);
            int n5 = this.height[n4] * this.width[n4];
            byte[] byArray = new byte[n5];
            dataInputStream.readFully(byArray);
            int n6 = this.width[n4];
            int n7 = this.height[n4];
            int n8 = 0;
            while (n8 < n6) {
                int n9 = 0;
                while (n9 < n7) {
                    int n10 = byArray[n9 * n6 + n8] & 0xFF;
                    this.images[n4].pixels[n9 * 64 + n8] = n10 << 24 | n10 << 16 | n10 << 8 | n10;
                    ++n9;
                }
                ++n8;
            }
            ++n4;
        }
        this.defaultLeading = (float)this.mboxY / 64.0f * 1.2f;
        this.kind = 0;
    }

    private void load_fbf_font(String string) throws IOException {
        Properties properties = new Properties();
        properties.load(this.parent.loadStream(string));
        String string2 = (String)((Hashtable)properties).get("filename");
        int n = Integer.parseInt((String)((Hashtable)properties).get("image_width"));
        int n2 = Integer.parseInt((String)((Hashtable)properties).get("image_height"));
        int n3 = Integer.parseInt((String)((Hashtable)properties).get("columns"));
        int n4 = Integer.parseInt((String)((Hashtable)properties).get("rows"));
        this.left = Integer.parseInt((String)((Hashtable)properties).get("left"));
        this.baseline = Integer.parseInt((String)((Hashtable)properties).get("baseline"));
        this.leadspace = Integer.parseInt((String)((Hashtable)properties).get("leading"));
        this.firstChar = Integer.parseInt((String)((Hashtable)properties).get("first_char"));
        this.charCount = Integer.parseInt((String)((Hashtable)properties).get("char_count"));
        DataInputStream dataInputStream = new DataInputStream(this.parent.loadStream(string2));
        byte[] byArray = new byte[n * n2];
        dataInputStream.readFully(byArray);
        dataInputStream.close();
        this.cwidth = n / n3;
        this.cheight = n2 / n4;
        this.images = new BImage[this.charCount];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = 0;
            while (n7 < n3) {
                if (n5 == this.charCount) break;
                int[] nArray = new int[this.cwidth * this.cheight];
                int n8 = 0;
                int n9 = 0;
                while (n9 < this.cheight) {
                    int n10 = 0;
                    while (n10 < this.cwidth) {
                        nArray[n8++] = 255 - byArray[(n6 * this.cheight + n9) * n + n7 * this.cwidth + n10] & 0xFF;
                        ++n10;
                    }
                    ++n9;
                }
                this.images[n5++] = new BImage(nArray, this.cwidth, this.cheight, 2);
                ++n7;
            }
            ++n6;
        }
        this.defaultLeading = this.cheight + this.leadspace;
        this.kind = 1;
    }

    boolean charExists(char c) {
        return c >= this.firstChar && c - this.firstChar < this.charCount;
    }

    public float charWidth(char c) {
        if (c == ' ') {
            return this.charWidth('i');
        }
        if (!this.charExists(c)) {
            return 0.0f;
        }
        if (this.kind == 0) {
            return (float)this.setWidth[c - 33] / 64.0f * this.size;
        }
        return this.cwidth;
    }

    float kernWidth(char c, char c2) {
        return 0.0f;
    }

    public void resetSize() {
        if (this.kind == 0) {
            this.size = 12.0f;
        }
        this.resetLeading();
    }

    public void setSize(float f) {
        if (this.kind == 0) {
            this.size = f;
            this.resetLeading();
        } else {
            System.err.println("BFont: can't set size of fixed-width bitmap fonts");
        }
    }

    public void resetLeading() {
        this.leading = this.kind == 0 ? this.defaultLeading * this.size : this.defaultLeading;
    }

    public void setLeading(float f) {
        this.leading = f;
    }

    public void drawChar(char c, float f, float f2) {
        if (!this.valid) {
            return;
        }
        if (!this.charExists(c)) {
            return;
        }
        if (!this.cached) {
            this.parent.cache(this.images);
            this.cached = true;
        }
        if (this.kind == 0) {
            float f3 = (float)this.height[c - 33] / 64.0f;
            float f4 = (float)this.width[c - 33] / 64.0f;
            float f5 = (float)this.leftExtent[c - 33] / 64.0f;
            float f6 = (float)this.topExtent[c - 33] / 64.0f;
            this.parent.image(this.images[c - 33], f + f5 * this.size, f2 - f6 * this.size, f4 * this.size, f3 * this.size, 0.0f, 0.0f, this.width[c - 33], this.height[c - 33]);
        } else {
            this.parent.project(f - (float)this.left, f2 - (float)this.baseline, 0.0f);
            int n = (int)this.parent.projX;
            int n2 = (int)this.parent.projY;
            this.parent.simage(this.images[c - this.firstChar], n, n2);
        }
    }

    public float stringWidth(String string) {
        if (!this.valid) {
            return 0.0f;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        char c = '\u0000';
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '\n') {
                if (f > f2) {
                    f2 = f;
                }
                f = 0.0f;
                c = '\u0000';
            } else {
                f += this.charWidth(cArray[n]);
                if (c != '\u0000') {
                    f += this.kernWidth(c, cArray[n]);
                }
                c = cArray[n];
            }
            ++n;
        }
        return f2 > f ? f2 : f;
    }

    public void drawString(String string, float f, float f2) {
        if (!this.valid) {
            return;
        }
        this.parent.push();
        float f3 = f;
        int n = 0;
        char c = '\u0000';
        int n2 = string.length();
        if (n2 > this.c.length) {
            this.c = new char[n2 + 10];
        }
        string.getChars(0, n2, this.c, 0);
        while (n < n2) {
            if (this.c[n] == '\n') {
                f = f3;
                f2 += this.leading;
                c = '\u0000';
            } else {
                this.drawChar(this.c[n], f, f2);
                f += this.charWidth(this.c[n]);
                if (c != '\u0000') {
                    f += this.kernWidth(c, this.c[n]);
                }
                c = this.c[n];
            }
            ++n;
        }
        this.parent.pop();
    }

    public BFont() {
    }

    public BFont(String string, BGraphics bGraphics) {
        this.parent = bGraphics;
        this.valid = false;
        try {
            String string2 = string.toLowerCase();
            if (string2.endsWith(".vlw") || string2.endsWith(".vlw.gz")) {
                this.load_vlw_font(string);
            } else if (string2.endsWith(".fbf")) {
                this.load_fbf_font(string);
            } else {
                throw new IOException("don't know what type of file that is");
            }
            this.cached = false;
            this.resetSize();
            this.valid = true;
        }
        catch (IOException iOException) {
            bGraphics.message(1, "could not load font " + string, iOException);
        }
    }
}

