/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BImage
implements BConstants {
    static byte[] tiff_header;
    int format;
    int[] pixels;
    int width;
    int height;
    boolean smooth;
    int cacheIndex;
    int blend_mode;
    private int fracU;
    private int ifU;
    private int fracV;
    private int ifV;
    private int u1;
    private int u2;
    private int v1;
    private int v2;
    private int sX;
    private int sY;
    private int iw;
    private int iw1;
    private int ih1;
    private int ul;
    private int ll;
    private int ur;
    private int lr;
    private int cUL;
    private int cLL;
    private int cUR;
    private int cLR;
    private int srcXOffset;
    private int srcYOffset;
    private int r;
    private int g;
    private int b;
    private int a;
    private int[] srcBuffer;

    public void alpha(int[] nArray) {
        if (nArray.length != this.pixels.length) {
            System.err.println("pixels for the alpha mask must be the same size");
            return;
        }
        int n = 0;
        while (n < this.pixels.length) {
            this.pixels[n] = this.pixels[n] & 0xFFFFFF | (nArray[n] & 0xFF) << 24;
            ++n;
        }
    }

    public void alpha(BImage bImage) {
        this.alpha(bImage.pixels);
    }

    public void blendMode(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                this.blend_mode = n;
                break;
            }
            default: {
                System.err.println("unknown blendMode() requested");
            }
        }
    }

    public int get(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return 0;
        }
        return this.pixels[n2 * this.width + n];
    }

    public BImage get(int n, int n2, int n3, int n4) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n + n3 > this.width) {
            n3 = this.width - n;
        }
        if (n2 + n4 > this.height) {
            n4 = this.height - n2;
        }
        BImage bImage = new BImage(new int[n3 * n4], n3, n4, this.format);
        int n5 = n2 * this.width + n;
        int n6 = 0;
        int n7 = n2;
        while (n7 < n2 + n4) {
            System.arraycopy(this.pixels, n5, bImage.pixels, n6, n3);
            n5 += this.width;
            n6 += n3;
            ++n7;
        }
        return bImage;
    }

    public void set(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return;
        }
        this.pixels[n2 * this.width + n] = n3;
    }

    public void set(int n, int n2, BImage bImage) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = bImage.width;
        int n7 = bImage.height;
        int n8 = n;
        int n9 = n2;
        int n10 = bImage.width;
        int n11 = bImage.height;
        if (n8 < 0) {
            n4 -= n8;
            n6 += n8;
            n10 += n8;
            n8 = 0;
        }
        if (n9 < 0) {
            n5 -= n9;
            n7 += n9;
            n11 += n9;
            n9 = 0;
        }
        if (n8 + n10 > this.width) {
            n3 = n8 + n10 - this.width;
            n6 -= n3;
            n10 -= n3;
        }
        if (n9 + n11 > this.height) {
            n3 = n9 + n11 - this.height;
            n7 -= n3;
            n6 -= n3;
        }
        n3 = n5;
        while (n3 < n5 + n7) {
            System.arraycopy(bImage.pixels, n3 * bImage.width + n4, this.pixels, (n2 + n3) * this.width + n8, n6);
            ++n3;
        }
    }

    public void replicate(int n, int n2, int n3, int n4) {
        if (n >= 0 && n < this.width && n3 >= 0 && n3 < this.width && n2 >= 0 && n2 < this.height && n4 >= 0 && n4 < this.height) {
            this.pixels[n4 * this.width + n3] = this.pixels[n2 * this.width + n];
        }
    }

    public void replicate(int n, int n2, BImage bImage, int n3, int n4) {
        if (n >= 0 && n < this.width && n3 >= 0 && n3 < bImage.width && n2 >= 0 && n2 < this.height && n4 >= 0 && n4 < bImage.height) {
            bImage.pixels[n4 * bImage.width + n3] = this.pixels[n2 * this.width + n];
        }
    }

    public void replicate(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.blit_resize(this, n, n2, n3, n4, this.pixels, this.width, this.height, n5, n6, n7, n8);
    }

    public void replicate(int n, int n2, int n3, int n4, BImage bImage, int n5, int n6, int n7, int n8) {
        this.blit_resize(this, n, n2, n3, n4, bImage.pixels, bImage.width, bImage.height, n5, n6, n7, n8);
    }

    public BImage copy() {
        BImage bImage = new BImage(new int[this.pixels.length], this.width, this.height, this.format);
        System.arraycopy(this.pixels, 0, bImage.pixels, 0, this.pixels.length);
        return bImage;
    }

    public BImage copy(int n, int n2) {
        int n3 = this.blend_mode;
        this.blendMode(0);
        BImage bImage = new BImage(new int[n * n2], n, n2, this.format);
        this.replicate(0, 0, this.width - 1, this.height - 1, bImage, 0, 0, n, n2);
        this.blendMode(n3);
        return bImage;
    }

    private final void blit_resize(BImage bImage, int n, int n2, int n3, int n4, int[] nArray, int n5, int n6, int n7, int n8, int n9, int n10) {
        block44: {
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            block43: {
                int n16 = n3 - n + 1;
                int n17 = n4 - n2 + 1;
                n15 = n9 - n7;
                n14 = n10 - n8;
                if (n15 == 0 || n14 == 0) {
                    return;
                }
                n13 = (int)((float)n16 / (float)n15 * 256.0f);
                n12 = (int)((float)n17 / (float)n14 * 256.0f);
                this.srcXOffset = (n7 < 0 ? -n7 * n13 : n) * 256;
                this.srcYOffset = (n8 < 0 ? -n8 * n12 : n2) * 256;
                if (n7 < 0) {
                    n15 += n7;
                    n7 = 0;
                }
                if (n8 < 0) {
                    n14 += n8;
                    n8 = 0;
                }
                n15 = BImage.low(n15, n5 - n7);
                n14 = BImage.low(n14, n6 - n8);
                n11 = n8 * n5 + n7;
                if (!this.smooth) break block43;
                this.srcBuffer = bImage.pixels;
                this.iw = bImage.width;
                this.iw1 = bImage.width - 1;
                this.ih1 = bImage.height - 1;
                switch (this.blend_mode) {
                    case 1: {
                        int n18 = 0;
                        while (n18 < n14) {
                            this.filter_new_scanline();
                            int n19 = 0;
                            while (n19 < n15) {
                                nArray[n11 + n19] = BImage.blend(nArray[n11 + n19], this.filter_bilinear());
                                this.sX += n13;
                                ++n19;
                            }
                            n11 += n5;
                            this.srcYOffset += n12;
                            ++n18;
                        }
                        break block44;
                    }
                    case 2: {
                        int n20 = 0;
                        while (n20 < n14) {
                            this.filter_new_scanline();
                            int n21 = 0;
                            while (n21 < n15) {
                                nArray[n11 + n21] = BImage.add_pin(nArray[n11 + n21], this.filter_bilinear());
                                this.sX += n13;
                                ++n21;
                            }
                            n11 += n5;
                            this.srcYOffset += n12;
                            ++n20;
                        }
                        break block44;
                    }
                    case 4: {
                        int n22 = 0;
                        while (n22 < n14) {
                            this.filter_new_scanline();
                            int n23 = 0;
                            while (n23 < n15) {
                                nArray[n11 + n23] = BImage.sub_pin(nArray[n11 + n23], this.filter_bilinear());
                                this.sX += n13;
                                ++n23;
                            }
                            n11 += n5;
                            this.srcYOffset += n12;
                            ++n22;
                        }
                        break block44;
                    }
                    case 8: {
                        int n24 = 0;
                        while (n24 < n14) {
                            this.filter_new_scanline();
                            int n25 = 0;
                            while (n25 < n15) {
                                nArray[n11 + n25] = BImage.lightest(nArray[n11 + n25], this.filter_bilinear());
                                this.sX += n13;
                                ++n25;
                            }
                            n11 += n5;
                            this.srcYOffset += n12;
                            ++n24;
                        }
                        break block44;
                    }
                    case 16: {
                        int n26 = 0;
                        while (n26 < n14) {
                            this.filter_new_scanline();
                            int n27 = 0;
                            while (n27 < n15) {
                                nArray[n11 + n27] = BImage.darkest(nArray[n11 + n27], this.filter_bilinear());
                                this.sX += n13;
                                ++n27;
                            }
                            n11 += n5;
                            this.srcYOffset += n12;
                            ++n26;
                        }
                        break block44;
                    }
                    case 0: {
                        int n28 = 0;
                        while (n28 < n14) {
                            this.filter_new_scanline();
                            int n29 = 0;
                            while (n29 < n15) {
                                nArray[n11 + n29] = this.filter_bilinear();
                                this.sX += n13;
                                ++n29;
                            }
                            n11 += n5;
                            this.srcYOffset += n12;
                            ++n28;
                        }
                        break block44;
                    }
                }
                break block44;
            }
            switch (this.blend_mode) {
                case 1: {
                    int n30 = 0;
                    while (n30 < n14) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 8) * bImage.width;
                        int n31 = 0;
                        while (n31 < n15) {
                            nArray[n11 + n31] = BImage.blend(nArray[n11 + n31], bImage.pixels[this.sY + (this.sX >> 8)]);
                            this.sX += n13;
                            ++n31;
                        }
                        n11 += n5;
                        this.srcYOffset += n12;
                        ++n30;
                    }
                    break;
                }
                case 2: {
                    int n32 = 0;
                    while (n32 < n14) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 8) * bImage.width;
                        int n33 = 0;
                        while (n33 < n15) {
                            nArray[n11 + n33] = BImage.add_pin(nArray[n11 + n33], bImage.pixels[this.sY + (this.sX >> 8)]);
                            this.sX += n13;
                            ++n33;
                        }
                        n11 += n5;
                        this.srcYOffset += n12;
                        ++n32;
                    }
                    break;
                }
                case 4: {
                    int n34 = 0;
                    while (n34 < n14) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 8) * bImage.width;
                        int n35 = 0;
                        while (n35 < n15) {
                            nArray[n11 + n35] = BImage.sub_pin(nArray[n11 + n35], bImage.pixels[this.sY + (this.sX >> 8)]);
                            this.sX += n13;
                            ++n35;
                        }
                        n11 += n5;
                        this.srcYOffset += n12;
                        ++n34;
                    }
                    break;
                }
                case 8: {
                    int n36 = 0;
                    while (n36 < n14) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 8) * bImage.width;
                        int n37 = 0;
                        while (n37 < n15) {
                            nArray[n11 + n37] = BImage.lightest(nArray[n11 + n37], bImage.pixels[this.sY + (this.sX >> 8)]);
                            this.sX += n13;
                            ++n37;
                        }
                        n11 += n5;
                        this.srcYOffset += n12;
                        ++n36;
                    }
                    break;
                }
                case 16: {
                    int n38 = 0;
                    while (n38 < n14) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 8) * bImage.width;
                        int n39 = 0;
                        while (n39 < n15) {
                            nArray[n11 + n39] = BImage.darkest(nArray[n11 + n39], bImage.pixels[this.sY + (this.sX >> 8)]);
                            this.sX += n13;
                            ++n39;
                        }
                        n11 += n5;
                        this.srcYOffset += n12;
                        ++n38;
                    }
                    break;
                }
                case 0: {
                    int n40 = 0;
                    while (n40 < n14) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 8) * bImage.width;
                        int n41 = 0;
                        while (n41 < n15) {
                            nArray[n11 + n41] = bImage.pixels[this.sY + (this.sX >> 8)];
                            this.sX += n13;
                            ++n41;
                        }
                        n11 += n5;
                        this.srcYOffset += n12;
                        ++n40;
                    }
                    break;
                }
            }
        }
    }

    private final void filter_new_scanline() {
        this.sX = this.srcXOffset;
        this.fracV = this.srcYOffset & 0xFF;
        this.ifV = 0xFF ^ this.fracV;
        this.v1 = (this.srcYOffset >> 8) * this.iw;
        this.v2 = BImage.low((this.srcYOffset >> 8) + 1, this.ih1) * this.iw;
    }

    private final int filter_bilinear() {
        this.fracU = this.sX & 0xFF;
        this.ifU = 0xFF ^ this.fracU;
        this.ul = this.ifU * this.ifV >> 8;
        this.ll = this.ifU * this.fracV >> 8;
        this.ur = this.fracU * this.ifV >> 8;
        this.lr = this.fracU * this.fracV >> 8;
        this.u1 = this.sX >> 8;
        this.u2 = BImage.low(this.u1 + 1, this.iw1);
        this.cUL = this.srcBuffer[this.v1 + this.u1];
        this.cUR = this.srcBuffer[this.v1 + this.u2];
        this.cLL = this.srcBuffer[this.v2 + this.u1];
        this.cLR = this.srcBuffer[this.v2 + this.u2];
        this.r = (this.ul * (this.cUL & 0xFF0000) + this.ll * (this.cLL & 0xFF0000) + this.ur * (this.cUR & 0xFF0000) + this.lr * (this.cLR & 0xFF0000) & 0xFF000000) >>> 8;
        this.g = (this.ul * (this.cUL & 0xFF00) + this.ll * (this.cLL & 0xFF00) + this.ur * (this.cUR & 0xFF00) + this.lr * (this.cLR & 0xFF00) & 0xFF0000) >>> 8;
        this.b = this.ul * (this.cUL & 0xFF) + this.ll * (this.cLL & 0xFF) + this.ur * (this.cUR & 0xFF) + this.lr * (this.cLR & 0xFF) >>> 8;
        this.a = (this.ul * (this.cUL >>> 24) + this.ll * (this.cLL >>> 24) + this.ur * (this.cUR >>> 24) + this.lr * (this.cLR >>> 24) & 0xFF00) << 16;
        return this.a | this.r | this.g | this.b;
    }

    private static final int low(int n, int n2) {
        return n < n2 ? n : n2;
    }

    private static final int high(int n, int n2) {
        return n > n2 ? n : n2;
    }

    private final float frac(float f) {
        return f - (float)((int)f);
    }

    private static final int mix(int n, int n2, int n3) {
        return n + ((n2 - n) * n3 >> 8);
    }

    private static final int blend(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        return BImage.mix(n & 0xFF0000, n2 & 0xFF0000, n3) & 0xFF0000 | BImage.mix(n & 0xFF00, n2 & 0xFF00, n3) & 0xFF00 | BImage.mix(n & 0xFF, n2 & 0xFF, n3);
    }

    private static final int add_pin(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        return BImage.low((n & 0xFF0000) + ((n2 & 0xFF0000) >> 8) * n3, 0xFF0000) & 0xFF0000 | BImage.low((n & 0xFF00) + ((n2 & 0xFF00) >> 8) * n3, 65280) & 0xFF00 | BImage.low((n & 0xFF) + ((n2 & 0xFF) * n3 >> 8), 255);
    }

    private static final int sub_pin(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        return BImage.high((n & 0xFF0000) - ((n2 & 0xFF0000) >> 8) * n3, 65280) & 0xFF0000 | BImage.high((n & 0xFF00) - ((n2 & 0xFF00) >> 8) * n3, 255) & 0xFF00 | BImage.high((n & 0xFF) - ((n2 & 0xFF) * n3 >> 8), 0);
    }

    private static final int lightest(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        return BImage.high(n & 0xFF0000, ((n2 & 0xFF0000) >> 8) * n3) & 0xFF0000 | BImage.high(n & 0xFF00, ((n2 & 0xFF00) >> 8) * n3) & 0xFF00 | BImage.high(n & 0xFF, (n2 & 0xFF) * n3 >> 8);
    }

    private static final int darkest(int n, int n2) {
        int n3 = (n2 & 0xFF000000) >>> 24;
        return BImage.mix(n & 0xFF0000, BImage.low(n & 0xFF0000, ((n2 & 0xFF0000) >> 8) * n3), n3) & 0xFF0000 | BImage.mix(n & 0xFF00, BImage.low(n & 0xFF00, ((n2 & 0xFF00) >> 8) * n3), n3) & 0xFF00 | BImage.mix(n & 0xFF, BImage.low(n & 0xFF, (n2 & 0xFF) * n3 >> 8), n3);
    }

    static void write_tiff(OutputStream outputStream, int[] nArray, int n, int n2) throws IOException {
        byte[] byArray = new byte[768];
        System.arraycopy(tiff_header, 0, byArray, 0, tiff_header.length);
        byArray[30] = (byte)(n >> 8 & 0xFF);
        byArray[31] = (byte)(n & 0xFF);
        byArray[42] = byArray[102] = (byte)(n2 >> 8 & 0xFF);
        byArray[43] = byArray[103] = (byte)(n2 & 0xFF);
        int n3 = n * n2 * 3;
        byArray[114] = (byte)(n3 >> 24 & 0xFF);
        byArray[115] = (byte)(n3 >> 16 & 0xFF);
        byArray[116] = (byte)(n3 >> 8 & 0xFF);
        byArray[117] = (byte)(n3 & 0xFF);
        outputStream.write(byArray);
        int n4 = 0;
        while (n4 < nArray.length) {
            outputStream.write(nArray[n4] >> 16 & 0xFF);
            outputStream.write(nArray[n4] >> 8 & 0xFF);
            outputStream.write(nArray[n4] & 0xFF);
            ++n4;
        }
        outputStream.flush();
    }

    static void write_targa(OutputStream outputStream, int[] nArray, int n, int n2) throws IOException {
        byte[] byArray = new byte[18];
        byArray[2] = 2;
        byArray[12] = (byte)(n & 0xFF);
        byArray[13] = (byte)(n >> 8);
        byArray[14] = (byte)(n2 & 0xFF);
        byArray[15] = (byte)(n2 >> 8);
        byArray[16] = 32;
        byArray[17] = 8;
        outputStream.write(byArray);
        int n3 = (n2 - 1) * n;
        int n4 = n2 - 1;
        while (n4 >= 0) {
            int n5 = 0;
            while (n5 < n) {
                int n6 = nArray[n3 + n5];
                outputStream.write(n6 & 0xFF);
                outputStream.write(n6 >> 8 & 0xFF);
                outputStream.write(n6 >> 16 & 0xFF);
                outputStream.write(n6 >> 24 & 0xFF);
                ++n5;
            }
            n3 -= n;
            --n4;
        }
        outputStream.flush();
    }

    public void save(String string) {
        try {
            FileOutputStream fileOutputStream = null;
            if (string.toLowerCase().endsWith(".tga")) {
                fileOutputStream = new FileOutputStream(string);
                BImage.write_targa(fileOutputStream, this.pixels, this.width, this.height);
            } else {
                if (!string.toLowerCase().endsWith(".tif") && !string.toLowerCase().endsWith(".tiff")) {
                    string = string + ".tif";
                }
                fileOutputStream = new FileOutputStream(string);
                BImage.write_tiff(fileOutputStream, this.pixels, this.width, this.height);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void save(OutputStream outputStream, int n) {
        try {
            if (n == 1) {
                BImage.write_targa(outputStream, this.pixels, this.width, this.height);
            } else if (n == 0) {
                BImage.write_tiff(outputStream, this.pixels, this.width, this.height);
            } else {
                System.err.println("can't save image as that type");
            }
        }
        catch (IOException iOException) {
            System.err.println("error while trying to save image");
            iOException.printStackTrace();
        }
    }

    private final /* synthetic */ void this() {
        this.smooth = false;
        this.blend_mode = 0;
    }

    public BImage() {
        this.this();
    }

    public BImage(int n, int n2) {
        this(new int[n * n2], n, n2, 1);
    }

    public BImage(int[] nArray, int n, int n2, int n3) {
        this.this();
        this.pixels = nArray;
        this.width = n;
        this.height = n2;
        this.format = n3;
        this.cacheIndex = -1;
    }

    public BImage(Image image) {
        this.this();
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        this.pixels = new int[this.width * this.height];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.pixels, 0, this.width);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.format = 1;
        this.cacheIndex = -1;
    }

    static {
        byte[] byArray = new byte[128];
        byArray[0] = 77;
        byArray[1] = 77;
        byArray[3] = 42;
        byArray[7] = 8;
        byArray[9] = 9;
        byArray[11] = -2;
        byArray[13] = 4;
        byArray[17] = 1;
        byArray[22] = 1;
        byArray[25] = 3;
        byArray[29] = 1;
        byArray[34] = 1;
        byArray[35] = 1;
        byArray[37] = 3;
        byArray[41] = 1;
        byArray[46] = 1;
        byArray[47] = 2;
        byArray[49] = 3;
        byArray[53] = 3;
        byArray[57] = 122;
        byArray[58] = 1;
        byArray[59] = 6;
        byArray[61] = 3;
        byArray[65] = 1;
        byArray[67] = 2;
        byArray[70] = 1;
        byArray[71] = 17;
        byArray[73] = 4;
        byArray[77] = 1;
        byArray[80] = 3;
        byArray[82] = 1;
        byArray[83] = 21;
        byArray[85] = 3;
        byArray[89] = 1;
        byArray[91] = 3;
        byArray[94] = 1;
        byArray[95] = 22;
        byArray[97] = 3;
        byArray[101] = 1;
        byArray[106] = 1;
        byArray[107] = 23;
        byArray[109] = 4;
        byArray[113] = 1;
        byArray[123] = 8;
        byArray[125] = 8;
        byArray[127] = 8;
        tiff_header = byArray;
    }
}

