/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GCScheme;
import guicomponents.GConstants;
import guicomponents.GFont;
import guicomponents.GMessenger;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;

public abstract class GComponent
implements PConstants,
GConstants,
Comparable {
    protected static GComponent focusIsWith;
    protected static GComponent cursorIsOver;
    protected int mdx = Integer.MAX_VALUE;
    protected int mdy = Integer.MAX_VALUE;
    public static GCScheme globalColor;
    public GCScheme localColor;
    public static PFont globalFont;
    public PFont localFont;
    protected static final int PADH = 4;
    protected static final int PADV = 2;
    protected PApplet winApp;
    protected GComponent parent = null;
    protected HashSet<GComponent> children;
    protected Object eventHandlerObject = null;
    protected Method eventHandlerMethod = null;
    protected String eventHandlerMethodName;
    protected String text = "";
    protected int textWidth;
    protected int textAlign = 1;
    protected int alignX = 0;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int minWidth = 20;
    protected int minHeight = 20;
    protected int maxWidth = 200;
    protected int maxHeight = 200;
    protected boolean visible = true;
    protected boolean enabled = true;
    protected int border = 0;
    protected boolean opaque = true;
    public int eventType = 0;
    protected boolean regDraw = false;
    protected boolean regMouse = false;
    protected boolean regPre = false;
    protected boolean regKey = false;

    protected GComponent() {
    }

    public GComponent(PApplet theApplet, int x, int y) {
        this.winApp = theApplet;
        if (globalColor == null) {
            globalColor = GCScheme.getColor(theApplet);
        }
        this.localColor = new GCScheme(globalColor);
        if (globalFont == null) {
            globalFont = GFont.getDefaultFont(theApplet);
        }
        this.localFont = globalFont;
        this.x = x;
        this.y = y;
        G4P.setMainApp(this.winApp);
        G4P.addComponent(this);
    }

    protected void createEventHandler(Object handlerObj, String methodName, Class[] parameters) {
        try {
            this.eventHandlerMethod = handlerObj.getClass().getMethod(methodName, parameters);
            this.eventHandlerObject = handlerObj;
            this.eventHandlerMethodName = methodName;
        }
        catch (Exception e) {
            GMessenger.message(0x1000001, this, new Object[]{methodName, parameters});
            this.eventHandlerObject = null;
        }
    }

    public void addEventHandler(Object obj, String methodName) {
        try {
            this.eventHandlerObject = obj;
            this.eventHandlerMethodName = methodName;
            this.eventHandlerMethod = obj.getClass().getMethod(methodName, this.getClass());
        }
        catch (Exception e) {
            GMessenger.message(0x1000002, this, new Object[]{methodName, new Class[]{this.getClass()}});
            this.eventHandlerObject = null;
            this.eventHandlerMethodName = "";
        }
    }

    public void addEventHandler(Object obj, String methodName, Class[] parameters) {
        if (parameters == null) {
            parameters = new Class[]{};
        }
        try {
            this.eventHandlerObject = obj;
            this.eventHandlerMethodName = methodName;
            this.eventHandlerMethod = obj.getClass().getMethod(methodName, parameters);
        }
        catch (Exception e) {
            GMessenger.message(0x1000002, this.eventHandlerObject, new Object[]{methodName, parameters});
            this.eventHandlerObject = null;
            this.eventHandlerMethodName = "";
        }
    }

    protected void fireEvent() {
        if (this.eventHandlerMethod != null) {
            try {
                this.eventHandlerMethod.invoke(this.eventHandlerObject, this);
            }
            catch (Exception e) {
                GMessenger.message(-2130706429, this.eventHandlerObject, new Object[]{this.eventHandlerMethodName, e});
            }
        }
    }

    public PApplet getPApplet() {
        return this.winApp;
    }

    protected void takeFocus() {
        if (focusIsWith != null && focusIsWith != this) {
            focusIsWith.looseFocus(this);
        }
        focusIsWith = this;
    }

    protected void looseFocus(GComponent grabber) {
        if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        focusIsWith = null;
    }

    public void setFocus(boolean focus) {
        if (focus) {
            this.takeFocus();
        } else {
            this.looseFocus(null);
        }
    }

    public boolean hasFocus() {
        return this == focusIsWith;
    }

    public static GComponent getFocusObject() {
        return focusIsWith;
    }

    public int getEventType() {
        return this.eventType;
    }

    protected boolean mouseHasMoved(int x, int y) {
        return this.mdx != x || this.mdy != y;
    }

    public boolean add(GComponent component) {
        if (component == null || this.children.contains(component)) {
            if (G4P.messages) {
                System.out.println("Either the component doesn't exist or has already been added to this panel");
            }
            return false;
        }
        component.parent = this;
        this.children.add(component);
        this.winApp.unregisterDraw((Object)component);
        component.regDraw = false;
        if (this.localColor.getAlpha() < 255) {
            component.setAlpha(this.localColor.getAlpha());
        }
        return true;
    }

    public void remove(GComponent component) {
        this.children.remove(component);
    }

    public void pre() {
    }

    public void draw() {
    }

    public void mouseEvent(MouseEvent event) {
    }

    public void keyPressed(KeyEvent event) {
    }

    protected void registerAutos_DMPK(boolean draw, boolean mouse, boolean pre, boolean key) {
        if (draw && G4P.isAutoDrawOn()) {
            this.winApp.registerDraw((Object)this);
            this.regDraw = true;
        }
        if (mouse) {
            this.winApp.registerMouseEvent((Object)this);
            this.regMouse = true;
        }
        if (pre) {
            this.winApp.registerPre((Object)this);
            this.regPre = true;
        }
        if (key) {
            this.winApp.registerKeyEvent((Object)this);
            this.regKey = true;
        }
    }

    public void changeWindow(PApplet newWindowApp) {
        if (this.regDraw) {
            this.winApp.unregisterDraw((Object)this);
            newWindowApp.registerDraw((Object)this);
        }
        if (this.regPre) {
            this.winApp.unregisterPre((Object)this);
            newWindowApp.registerPre((Object)this);
        }
        if (this.regMouse) {
            this.winApp.unregisterMouseEvent((Object)this);
            newWindowApp.registerMouseEvent((Object)this);
        }
        if (this.regKey) {
            this.winApp.unregisterKeyEvent((Object)this);
            newWindowApp.registerKeyEvent((Object)this);
        }
        this.winApp = newWindowApp;
        if (this.children != null && !this.children.isEmpty()) {
            Iterator<GComponent> iter = this.children.iterator();
            while (iter.hasNext()) {
                iter.next().changeWindow(newWindowApp);
            }
        }
    }

    public boolean isOver(int ax, int ay) {
        Point p = new Point(0, 0);
        this.calcAbsPosition(p);
        return ax >= p.x && ax <= p.x + this.width && ay >= p.y && ay <= p.y + this.height;
    }

    public void calcAbsPosition(Point d) {
        if (this.parent != null) {
            this.parent.calcAbsPosition(d);
        }
        d.x += this.x;
        d.y += this.y;
    }

    public GComponent getParent() {
        return this.parent;
    }

    public void setColorScheme(int schemeNo) {
        this.localColor = GCScheme.getColor(this.winApp, schemeNo);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.winApp.textFont(this.localFont, (float)this.localFont.size);
        this.textWidth = (int)this.winApp.textWidth(text);
        this.calcAlignX();
    }

    public void setText(String text, int align) {
        this.text = text;
        this.textAlign = align;
        this.winApp.textFont(this.localFont, (float)this.localFont.size);
        this.textWidth = (int)this.winApp.textWidth(text);
        this.calcAlignX();
    }

    public void setTextAlign(int align) {
        this.textAlign = align;
        this.calcAlignX();
    }

    public void setFont(String fontname, int fontsize) {
    }

    protected void calcAlignX() {
        switch (this.textAlign) {
            case 1: {
                this.alignX = this.border + 4;
                break;
            }
            case 2: {
                this.alignX = this.width - this.textWidth - this.border - 4;
                break;
            }
            case 3: {
                this.alignX = (this.width - this.textWidth) / 2;
            }
        }
    }

    public void setXY(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setVisible(boolean visible) {
        if (!visible && focusIsWith == this) {
            this.looseFocus(null);
        }
        this.visible = visible;
    }

    public void setBorder(int border) {
        this.border = border;
        this.calcAlignX();
    }

    public int getBorder() {
        return this.border;
    }

    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }

    public boolean getOpaque() {
        return this.opaque;
    }

    public void setAlpha(int alpha) {
        this.localColor.setAlpha(alpha);
    }

    public int getAlpha() {
        return this.localColor.getAlpha();
    }

    public int compareTo(Object o) {
        return new Integer(this.hashCode()).compareTo(new Integer(o.hashCode()));
    }
}

