/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GComponent;
import java.awt.event.MouseEvent;
import processing.core.PApplet;

public abstract class GSlider
extends GComponent {
    protected int minValue = 0;
    protected int maxValue = 100;
    protected int value = 50;
    protected int thumbMin;
    protected int thumbMax;
    protected int thumbPos;
    protected int thumbTargetPos;
    protected int thumbSize = 10;
    protected int thumbInertia = 1;
    protected int offset;
    protected boolean isValueChanging = false;

    public GSlider(PApplet theApplet, int x, int y, int width, int height) {
        super(theApplet, x, y);
        this.width = width;
        this.height = height;
        this.registerAutos_DMPK(true, true, true, false);
        this.createEventHandler(this.winApp, "handleSliderEvents", new Class[]{GSlider.class});
    }

    public void setLimits(int init, int min, int max) {
        this.minValue = Math.min(min, max);
        this.maxValue = Math.max(min, max);
        init = PApplet.constrain((int)init, (int)this.minValue, (int)this.maxValue);
        if (this.thumbMax - this.thumbMin < this.maxValue - this.minValue && G4P.messages) {
            System.out.println(String.valueOf(this.getClass().getSimpleName()) + ".setLimits");
            System.out.println("  not all values in the range " + min + " - " + max + " can be returned");
            System.out.print("  either reduce the range or make the slider ");
            if (this.getClass().getSimpleName().equals("GHorzSlider")) {
                System.out.print("width");
            } else {
                System.out.print("height");
            }
            System.out.println(" at least " + (max - min + this.thumbSize));
        }
        this.thumbTargetPos = this.thumbPos;
        this.setValue(init, true);
    }

    public void pre() {
        int inertia = this.thumbInertia;
        if (this.thumbPos == this.thumbTargetPos) {
            this.isValueChanging = false;
        } else {
            int change;
            while ((change = (this.thumbTargetPos - this.thumbPos) / inertia) == 0 && --inertia > 0) {
            }
            if (change != 0) {
                this.thumbPos += change;
                int newValue = (int)PApplet.map((float)this.thumbPos, (float)this.thumbMin, (float)this.thumbMax, (float)this.minValue, (float)this.maxValue);
                boolean valueChanged = newValue != this.value;
                this.value = newValue;
                if (valueChanged) {
                    this.eventType = 257;
                    this.fireEvent();
                }
            } else {
                this.isValueChanging = false;
            }
        }
    }

    public void draw() {
    }

    public void mouseEvent(MouseEvent event) {
    }

    public boolean isOver(int ax, int ay) {
        return false;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isValueChanging() {
        return this.isValueChanging;
    }

    public void setValue(int newValue) {
        this.value = PApplet.constrain((int)newValue, (int)this.minValue, (int)this.maxValue);
        this.thumbTargetPos = (int)PApplet.map((float)this.value, (float)this.minValue, (float)this.maxValue, (float)this.thumbMin, (float)this.thumbMax);
    }

    public void setValue(int newValue, boolean ignoreInteria) {
        this.setValue(newValue);
        if (ignoreInteria) {
            this.thumbPos = this.thumbTargetPos;
        }
    }

    public void setInertia(int inertia) {
        this.thumbInertia = PApplet.constrain((int)inertia, (int)1, (int)100);
    }
}

