/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import sun.audio.AudioPlayer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSonic
extends InputStream
implements Runnable {
    public static boolean DEBUG = false;
    public static Vector soundObjects;
    public static final int SAMPLE_MAX = 127;
    public static final int SAMPLE_MIN = -127;
    public static final int SAMPLE_AMPLITUDE = 255;
    public static final int SAMPLING_RATE = 8000;
    public static final int DEFAULT_BUFFER_SIZE = 6000;
    public static final int MAX_SOUNDS = 24;
    public static float volume;
    static final int AU_FILE = 1;
    static final int WAV_FILE = 2;
    static final int MP3_FILE = 3;
    static final short BIAS = 132;
    static final int CLIP = 32635;
    static final int[] law_lut;
    static final int[] linear_lut;
    public boolean started;
    public boolean run;
    public boolean lite;
    private BSonic stream;
    private BApplet owner;
    Thread sonicThread;
    public BSound[] sounds;
    public int scount;
    public int[] samples;
    public int length;
    public byte[] buf;
    public int pos;
    public int mark;
    public int count;
    public int delay;
    public int posc;
    public int size;
    public boolean full;
    public int format;

    public void start(BApplet bApplet) {
        this.owner = bApplet;
        if (this.started || this.lite) {
            if (DEBUG) {
                System.out.println("not starting sonic thread");
            }
            return;
        }
        int n = 0;
        while (n < this.count) {
            this.buf[n] = -1;
            ++n;
        }
        if (this.sonicThread == null) {
            this.sonicThread = new Thread((Runnable)this, "BSonic Thread");
            this.run = true;
        }
        if (DEBUG) {
            System.out.println("starting audio player");
        }
        AudioPlayer.player.start((InputStream)this);
        if (DEBUG) {
            System.out.println("audio player started");
        }
        this.sonicThread.start();
        this.started = true;
    }

    public void stop() {
        this.run = false;
        if (this.sonicThread != null) {
            this.sonicThread = null;
        }
        if (DEBUG) {
            System.out.println("stoping audio player");
        }
        AudioPlayer.player.stop((InputStream)this);
        if (DEBUG) {
            System.out.println("cleaning house for soundObjects");
        }
        if (soundObjects != null) {
            Enumeration enumeration = soundObjects.elements();
            while (enumeration.hasMoreElements()) {
                BSound bSound = (BSound)enumeration.nextElement();
                this.stop(bSound);
                if (!DEBUG) continue;
                System.out.println("stopping " + bSound);
            }
            soundObjects = null;
        } else if (DEBUG) {
            System.out.println("Bsonic.stop soundObjects was null");
        }
        if (DEBUG) {
            System.out.println("BSonic.stop audio player stopped");
        }
    }

    public void run() {
        while (this.run) {
            if (DEBUG) {
                System.out.println("BSonic.run()");
            }
            this.mixing();
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                if (!DEBUG) continue;
                System.out.println("sleep interrupted");
            }
        }
        if (DEBUG) {
            System.out.println("exiting run() for BSonic");
        }
    }

    public synchronized void mixing() {
        if (this.full) {
            ++this.delay;
            if (DEBUG) {
                System.out.println("\n+delay: " + this.delay);
            }
            return;
        }
        int n = 0;
        while (n < this.scount) {
            int n2 = 0;
            while (n2 < this.length) {
                if (n == 0) {
                    this.samples[n2] = 0;
                }
                if (this.sounds[n].play) {
                    int n3 = n2;
                    this.samples[n3] = this.samples[n3] + this.sounds[n].readSample();
                }
                ++n2;
            }
            ++n;
        }
        if (DEBUG) {
            System.out.print(" P:" + this.posc);
        }
        this.owner.soundEvent();
        this.clip();
        n = 0;
        while (n < this.length) {
            if (this.posc > this.size) {
                if (DEBUG) {
                    System.out.print("-" + this.size);
                }
                this.posc = 0;
                this.full = true;
                return;
            }
            if (this.posc < this.count) {
                this.buf[this.posc] = volume == 1.0f ? BSonic.linear2ulaw(this.samples[n] << 8) : (byte)((float)BSonic.linear2ulaw(this.samples[n] << 8) * volume);
            }
            ++this.posc;
            ++n;
        }
        if (DEBUG) {
            System.out.print("-" + this.posc);
        }
    }

    public void clip() {
        int n = 0;
        while (n < this.length) {
            if (this.samples[n] > 127) {
                this.samples[n] = 127;
            }
            if (this.samples[n] < -127) {
                this.samples[n] = -127;
            }
            ++n;
        }
    }

    public void add(BSound bSound) {
        if (this.scount < 23) {
            if (DEBUG) {
                System.out.println("sound added: " + this.scount);
            }
            if (bSound.index < 0) {
                this.sounds[this.scount] = bSound;
                bSound.index = this.scount++;
            } else {
                this.sounds[bSound.index] = bSound;
            }
        }
    }

    public void play(BSound bSound) {
        if (this.lite) {
            bSound.play = true;
            bSound.loop = false;
            if (bSound.position >= bSound.out) {
                bSound.position = bSound.in;
                AudioPlayer.player.stop((InputStream)bSound);
            }
            if (DEBUG) {
                System.out.println("BSonic.play playing lite sound");
            }
            AudioPlayer.player.start((InputStream)bSound);
            if (DEBUG) {
                System.out.println("BSonic.play adding sound object");
            }
            soundObjects.addElement(bSound);
        } else {
            if (bSound.index < 0) {
                this.add(bSound);
            }
            bSound.play();
        }
    }

    public void play(BSound bSound, int n, int n2) {
        bSound.borders(n, n2);
        this.play(bSound);
    }

    public void repeat(BSound bSound) {
        if (this.lite) {
            bSound.play = true;
            bSound.loop = true;
            if (DEBUG) {
                System.out.println("BSonic.repeat repeating lite sound");
            }
            AudioPlayer.player.start((InputStream)bSound);
            if (DEBUG) {
                System.out.println("BSonic.repeat adding sound object");
            }
            soundObjects.addElement(bSound);
        } else {
            if (bSound.index < 0) {
                this.add(bSound);
            }
            bSound.repeat();
        }
    }

    public void repeat(BSound bSound, int n, int n2) {
        bSound.borders(n, n2);
        this.repeat(bSound);
    }

    public void stop(BSound bSound) {
        if (this.lite) {
            bSound.play = false;
            bSound.loop = false;
            bSound.position = 0;
            AudioPlayer.player.stop((InputStream)bSound);
        } else {
            bSound.stop();
        }
    }

    public void pause(BSound bSound) {
        if (this.lite) {
            bSound.play = false;
            AudioPlayer.player.stop((InputStream)bSound);
            return;
        }
        bSound.pause();
    }

    public static void volume(float f) {
        volume = f;
    }

    public static void balance(float f) {
    }

    public static void frequency(float f) {
    }

    public synchronized int read() {
        if (DEBUG) {
            System.out.println("reading audio");
        }
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        if (DEBUG) {
            System.out.println("\n========================");
        }
        if (DEBUG) {
            System.out.println("PRE len: " + n2 + " count: " + this.count + " pos: " + this.pos + " b.length " + byArray.length + " size " + this.size);
        }
        int n3 = this.size = this.size > n2 ? this.size : n2;
        if (!this.full) {
            this.delay -= 10;
            if (this.delay < 0) {
                this.delay = 10;
            }
            if (DEBUG) {
                System.out.println("\n-delay: " + this.delay);
            }
        }
        if (n2 > this.count) {
            return 0;
        }
        System.arraycopy(this.buf, 0, byArray, n, n2);
        if (DEBUG) {
            System.out.println("POS len: " + n2 + " count: " + this.count + " pos: " + this.pos + " b.length " + byArray.length + " size " + this.size);
        }
        if (DEBUG) {
            System.out.println("\n========================");
        }
        this.posc = 0;
        this.full = false;
        return n2;
    }

    public synchronized long skip(long l) {
        if ((long)this.pos + l > (long)this.count) {
            l = this.count - this.pos;
        }
        if (l < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l);
        return l;
    }

    public synchronized int available() {
        return this.count - this.pos;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) {
    }

    public synchronized void reset() {
        this.pos = 0;
    }

    public BSound generate(int n, int n2) {
        return null;
    }

    public BSound microphone() {
        return null;
    }

    public BSound loadSound(String string) {
        BSound bSound = null;
        DataInputStream dataInputStream = null;
        InputStream inputStream = null;
        int[] nArray = null;
        if (string.startsWith("http://")) {
            try {
                URL uRL = new URL(string);
                dataInputStream = new DataInputStream(uRL.openStream());
            }
            catch (IOException iOException) {
                System.err.println("error loading sound from " + string);
                iOException.printStackTrace();
                return null;
            }
        } else {
            inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                inputStream = this.getClass().getResourceAsStream("data/" + string);
            }
            if (inputStream != null) {
                dataInputStream = new DataInputStream(inputStream);
            }
        }
        if (dataInputStream == null) {
            System.err.println("could not load sound file " + string);
            return null;
        }
        if (string.toLowerCase().endsWith(".au")) {
            this.format = 1;
            nArray = this.loadAU(dataInputStream);
        }
        if (string.toLowerCase().endsWith(".wav")) {
            this.format = 2;
            nArray = this.loadWAV(dataInputStream);
        }
        if (string.toLowerCase().endsWith(".mp3")) {
            this.format = 3;
            nArray = this.loadMP3(dataInputStream);
        }
        if (this.format == 0) {
            System.err.println("could not load sound file " + string + " - format unkown");
            return null;
        }
        if (nArray != null) {
            bSound = new BSound(nArray);
            if (!this.lite) {
                this.add(bSound);
            }
        } else {
            System.err.println("could not load sound file " + string + " - error in file");
            return null;
        }
        return bSound;
    }

    public int[] loadAU(DataInputStream dataInputStream) {
        int n = 779316836;
        int n2 = 779314176;
        int n3 = 24;
        int n4 = 1;
        int n5 = 2;
        int n6 = 3;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int[] nArray = null;
        int n13 = 0;
        boolean bl = false;
        try {
            n7 = dataInputStream.readInt();
            if (n7 != n && n7 != n2) {
                throw new Exception();
            }
            n8 = dataInputStream.readInt();
            if (n8 < n3) {
                throw new Exception();
            }
            n9 = dataInputStream.readInt();
            n10 = dataInputStream.readInt();
            if (n10 != n4 && n10 != n5 && n10 != n6) {
                throw new Exception();
            }
            n11 = dataInputStream.readInt();
            if (n11 != 8000) {
                bl = true;
            }
            if ((n12 = dataInputStream.readInt()) != 1 && n12 != 2) {
                throw new Exception();
            }
            dataInputStream.skipBytes(n8 - n3);
        }
        catch (Exception exception) {
            return null;
        }
        if (DEBUG) {
            System.out.println("skip " + (n8 - n3) + " magic: " + n7 + " dataLocation: " + n8 + " dataSize: " + n9 + " dataFormat: " + n10 + " samplingRate: " + n11 + " channelCount: " + n12);
        }
        n13 = n9 / n12;
        if (n10 == n6) {
            n13 /= 2;
        }
        nArray = new int[n13];
        if (DEBUG) {
            System.out.println("new thesamples " + nArray.length);
        }
        int n14 = 0;
        while (n14 < n13) {
            try {
                if (n10 == n4) {
                    nArray[n14] = BSonic.ulaw2linear(dataInputStream.read()) >> 8;
                    if (n12 == 2) {
                        dataInputStream.read();
                    }
                } else if (n10 == n5) {
                    nArray[n14] = dataInputStream.readByte();
                    if (n12 == 2) {
                        dataInputStream.readByte();
                    }
                } else if (n10 == n6) {
                    nArray[n14] = dataInputStream.readShort() >> 8;
                    if (n7 == n2) {
                        nArray[n14] = BSonic.reverseShort(nArray[n14]);
                    }
                    if (n12 == 2) {
                        dataInputStream.readShort();
                    }
                }
            }
            catch (Exception exception) {
                return null;
            }
            ++n14;
        }
        if (bl) {
            return BSonic.resample(nArray, n11, 8000);
        }
        return nArray;
    }

    public int[] loadWAV(DataInputStream dataInputStream) {
        int n = 1380533830;
        int n2 = 1463899717;
        int n3 = 1718449184;
        int n4 = 1684108385;
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int[] nArray = null;
        int n12 = 0;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        int n13 = 0;
        int n14 = 0;
        try {
            n6 = dataInputStream.readInt();
            if (n6 != n) {
                throw new Exception();
            }
            dataInputStream.readInt();
            n6 = dataInputStream.readInt();
            if (n6 != n2) {
                throw new Exception();
            }
            n6 = dataInputStream.readInt();
            if (n6 != n3) {
                throw new Exception();
            }
            n13 = BSonic.reverseInt(dataInputStream.readInt());
            n7 = BSonic.reverseShort(dataInputStream.readUnsignedShort());
            if (n7 != n5) {
                throw new Exception();
            }
            n8 = BSonic.reverseShort(dataInputStream.readUnsignedShort());
            if (n8 != 1 && n8 != 2) {
                throw new Exception();
            }
            n9 = BSonic.reverseInt(dataInputStream.readInt());
            if (n9 != 8000) {
                bl2 = true;
            }
            dataInputStream.readInt();
            dataInputStream.readUnsignedShort();
            n10 = BSonic.reverseShort(dataInputStream.readUnsignedShort());
            if (n10 != 8 && n10 != 16) {
                throw new Exception();
            }
            dataInputStream.skipBytes(n13 - 16);
            while (bl3) {
                n6 = dataInputStream.readInt();
                if (n6 != n4) {
                    n14 = BSonic.reverseInt(dataInputStream.readInt());
                    dataInputStream.skipBytes(n14);
                    continue;
                }
                bl3 = false;
            }
            n11 = BSonic.reverseInt(dataInputStream.readInt());
        }
        catch (Exception exception) {
            return null;
        }
        if (DEBUG) {
            System.out.println(" magic: " + n6 + " dataFormat: " + n7 + " dataSize: " + n11 + " samplingRate: " + n9 + " channelCount: " + n8 + " bitDepth: " + n10);
        }
        n12 = n11 / n8;
        if (n10 == 16) {
            n12 /= 2;
        }
        nArray = new int[n12];
        if (DEBUG) {
            System.out.println("new thesamples " + nArray.length);
        }
        int n15 = 0;
        while (n15 < n12) {
            try {
                if (n7 == n5) {
                    if (n10 == 8) {
                        nArray[n15] = dataInputStream.readUnsignedByte() - 128;
                        if (n8 == 2) {
                            dataInputStream.readUnsignedByte();
                        }
                    } else if (n10 == 16) {
                        nArray[n15] = BSonic.reverseInt(dataInputStream.readUnsignedShort()) >> 24;
                        if (n8 == 2) {
                            dataInputStream.readUnsignedShort();
                        }
                    }
                }
            }
            catch (Exception exception) {
                return null;
            }
            ++n15;
        }
        if (bl2) {
            return BSonic.resample(nArray, n9, 8000);
        }
        return nArray;
    }

    public int[] loadMP3(DataInputStream dataInputStream) {
        int[] nArray = null;
        boolean bl = false;
        return nArray;
    }

    public static byte linear2ulaw(int n) {
        int n2;
        int n3;
        byte by;
        if (n > Short.MAX_VALUE) {
            n = Short.MAX_VALUE;
        } else if (n < Short.MIN_VALUE) {
            n = Short.MIN_VALUE;
        }
        int n4 = n >> 8 & 0x80;
        if (n4 != 0) {
            n = -n;
        }
        if (n > 32635) {
            n = 32635;
        }
        if ((by = (byte)(~(n4 | (n3 = law_lut[(n += 132) >> 7 & 0xFF]) << 4 | (n2 = n >> n3 + 3 & 0xF)))) == 0) {
            by = 2;
        }
        return (byte)by;
    }

    public static int ulaw2linear(int n) {
        int n2 = (n ^= 0xFFFFFFFF) & 0x80;
        int n3 = n >> 4 & 7;
        int n4 = n & 0xF;
        int n5 = linear_lut[n3] + (n4 << n3 + 3);
        if (n2 != 0) {
            n5 = -n5;
        }
        return (short)n5;
    }

    private static final int reverseShort(int n) {
        return n >>> 8 & 0xFF | n << 8 & 0xFF00;
    }

    private static final int reverseInt(int n) {
        return n >> 24 & 0xFF | n >> 8 & 0xFF00 | n << 8 & 0xFF0000 | n << 24 & 0xFF000000;
    }

    private static final int[] resample(int[] nArray, int n, int n2) {
        int[] nArray2 = null;
        float f = 0.0f;
        if (n > n2) {
            f = (float)n / (float)n2;
            int n3 = (int)((float)nArray.length / f);
            nArray2 = new int[n3];
            int n4 = 0;
            while (n4 < n3) {
                nArray2[n4] = nArray[(int)((float)n4 * f)];
                ++n4;
            }
            nArray = null;
            return nArray2;
        }
        if (n > n2) {
            f = (float)n2 / (float)n;
            int n5 = (int)((float)nArray.length * f);
            nArray2 = new int[n5];
            int n6 = 0;
            while (n6 < n5) {
                nArray2[n6] = nArray[(int)((float)n6 * f)];
                ++n6;
            }
            return nArray2;
        }
        if (DEBUG) {
            System.out.println("Done...");
        }
        return nArray;
    }

    private final /* synthetic */ void this() {
        this.started = false;
        this.run = false;
        this.lite = false;
        this.scount = 0;
        this.mark = 0;
        this.full = false;
        this.format = 0;
    }

    public BSonic() {
        this.this();
        if (DEBUG) {
            System.out.println("sonic lite constructor");
        }
        soundObjects = new Vector();
        this.length = 0;
        this.posc = 0;
        this.size = this.length;
        this.pos = 0;
        this.count = 0;
        this.lite = true;
    }

    public BSonic(int[] nArray) {
        this.this();
        if (DEBUG) {
            System.out.println("sonic constructor");
        }
        soundObjects = new Vector();
        this.samples = nArray;
        this.length = this.samples.length;
        this.delay = this.length * 1000 / 16000;
        this.posc = 0;
        this.size = this.length;
        this.buf = new byte[6000];
        this.pos = 0;
        this.count = this.buf.length;
        this.sounds = new BSound[24];
        if (DEBUG) {
            System.out.println("length: " + this.length + " delay: " + this.delay);
        }
    }

    static {
        volume = 1.0f;
        int[] nArray = new int[256];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 2;
        nArray[5] = 2;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 3;
        nArray[9] = 3;
        nArray[10] = 3;
        nArray[11] = 3;
        nArray[12] = 3;
        nArray[13] = 3;
        nArray[14] = 3;
        nArray[15] = 3;
        nArray[16] = 4;
        nArray[17] = 4;
        nArray[18] = 4;
        nArray[19] = 4;
        nArray[20] = 4;
        nArray[21] = 4;
        nArray[22] = 4;
        nArray[23] = 4;
        nArray[24] = 4;
        nArray[25] = 4;
        nArray[26] = 4;
        nArray[27] = 4;
        nArray[28] = 4;
        nArray[29] = 4;
        nArray[30] = 4;
        nArray[31] = 4;
        nArray[32] = 5;
        nArray[33] = 5;
        nArray[34] = 5;
        nArray[35] = 5;
        nArray[36] = 5;
        nArray[37] = 5;
        nArray[38] = 5;
        nArray[39] = 5;
        nArray[40] = 5;
        nArray[41] = 5;
        nArray[42] = 5;
        nArray[43] = 5;
        nArray[44] = 5;
        nArray[45] = 5;
        nArray[46] = 5;
        nArray[47] = 5;
        nArray[48] = 5;
        nArray[49] = 5;
        nArray[50] = 5;
        nArray[51] = 5;
        nArray[52] = 5;
        nArray[53] = 5;
        nArray[54] = 5;
        nArray[55] = 5;
        nArray[56] = 5;
        nArray[57] = 5;
        nArray[58] = 5;
        nArray[59] = 5;
        nArray[60] = 5;
        nArray[61] = 5;
        nArray[62] = 5;
        nArray[63] = 5;
        nArray[64] = 6;
        nArray[65] = 6;
        nArray[66] = 6;
        nArray[67] = 6;
        nArray[68] = 6;
        nArray[69] = 6;
        nArray[70] = 6;
        nArray[71] = 6;
        nArray[72] = 6;
        nArray[73] = 6;
        nArray[74] = 6;
        nArray[75] = 6;
        nArray[76] = 6;
        nArray[77] = 6;
        nArray[78] = 6;
        nArray[79] = 6;
        nArray[80] = 6;
        nArray[81] = 6;
        nArray[82] = 6;
        nArray[83] = 6;
        nArray[84] = 6;
        nArray[85] = 6;
        nArray[86] = 6;
        nArray[87] = 6;
        nArray[88] = 6;
        nArray[89] = 6;
        nArray[90] = 6;
        nArray[91] = 6;
        nArray[92] = 6;
        nArray[93] = 6;
        nArray[94] = 6;
        nArray[95] = 6;
        nArray[96] = 6;
        nArray[97] = 6;
        nArray[98] = 6;
        nArray[99] = 6;
        nArray[100] = 6;
        nArray[101] = 6;
        nArray[102] = 6;
        nArray[103] = 6;
        nArray[104] = 6;
        nArray[105] = 6;
        nArray[106] = 6;
        nArray[107] = 6;
        nArray[108] = 6;
        nArray[109] = 6;
        nArray[110] = 6;
        nArray[111] = 6;
        nArray[112] = 6;
        nArray[113] = 6;
        nArray[114] = 6;
        nArray[115] = 6;
        nArray[116] = 6;
        nArray[117] = 6;
        nArray[118] = 6;
        nArray[119] = 6;
        nArray[120] = 6;
        nArray[121] = 6;
        nArray[122] = 6;
        nArray[123] = 6;
        nArray[124] = 6;
        nArray[125] = 6;
        nArray[126] = 6;
        nArray[127] = 6;
        nArray[128] = 7;
        nArray[129] = 7;
        nArray[130] = 7;
        nArray[131] = 7;
        nArray[132] = 7;
        nArray[133] = 7;
        nArray[134] = 7;
        nArray[135] = 7;
        nArray[136] = 7;
        nArray[137] = 7;
        nArray[138] = 7;
        nArray[139] = 7;
        nArray[140] = 7;
        nArray[141] = 7;
        nArray[142] = 7;
        nArray[143] = 7;
        nArray[144] = 7;
        nArray[145] = 7;
        nArray[146] = 7;
        nArray[147] = 7;
        nArray[148] = 7;
        nArray[149] = 7;
        nArray[150] = 7;
        nArray[151] = 7;
        nArray[152] = 7;
        nArray[153] = 7;
        nArray[154] = 7;
        nArray[155] = 7;
        nArray[156] = 7;
        nArray[157] = 7;
        nArray[158] = 7;
        nArray[159] = 7;
        nArray[160] = 7;
        nArray[161] = 7;
        nArray[162] = 7;
        nArray[163] = 7;
        nArray[164] = 7;
        nArray[165] = 7;
        nArray[166] = 7;
        nArray[167] = 7;
        nArray[168] = 7;
        nArray[169] = 7;
        nArray[170] = 7;
        nArray[171] = 7;
        nArray[172] = 7;
        nArray[173] = 7;
        nArray[174] = 7;
        nArray[175] = 7;
        nArray[176] = 7;
        nArray[177] = 7;
        nArray[178] = 7;
        nArray[179] = 7;
        nArray[180] = 7;
        nArray[181] = 7;
        nArray[182] = 7;
        nArray[183] = 7;
        nArray[184] = 7;
        nArray[185] = 7;
        nArray[186] = 7;
        nArray[187] = 7;
        nArray[188] = 7;
        nArray[189] = 7;
        nArray[190] = 7;
        nArray[191] = 7;
        nArray[192] = 7;
        nArray[193] = 7;
        nArray[194] = 7;
        nArray[195] = 7;
        nArray[196] = 7;
        nArray[197] = 7;
        nArray[198] = 7;
        nArray[199] = 7;
        nArray[200] = 7;
        nArray[201] = 7;
        nArray[202] = 7;
        nArray[203] = 7;
        nArray[204] = 7;
        nArray[205] = 7;
        nArray[206] = 7;
        nArray[207] = 7;
        nArray[208] = 7;
        nArray[209] = 7;
        nArray[210] = 7;
        nArray[211] = 7;
        nArray[212] = 7;
        nArray[213] = 7;
        nArray[214] = 7;
        nArray[215] = 7;
        nArray[216] = 7;
        nArray[217] = 7;
        nArray[218] = 7;
        nArray[219] = 7;
        nArray[220] = 7;
        nArray[221] = 7;
        nArray[222] = 7;
        nArray[223] = 7;
        nArray[224] = 7;
        nArray[225] = 7;
        nArray[226] = 7;
        nArray[227] = 7;
        nArray[228] = 7;
        nArray[229] = 7;
        nArray[230] = 7;
        nArray[231] = 7;
        nArray[232] = 7;
        nArray[233] = 7;
        nArray[234] = 7;
        nArray[235] = 7;
        nArray[236] = 7;
        nArray[237] = 7;
        nArray[238] = 7;
        nArray[239] = 7;
        nArray[240] = 7;
        nArray[241] = 7;
        nArray[242] = 7;
        nArray[243] = 7;
        nArray[244] = 7;
        nArray[245] = 7;
        nArray[246] = 7;
        nArray[247] = 7;
        nArray[248] = 7;
        nArray[249] = 7;
        nArray[250] = 7;
        nArray[251] = 7;
        nArray[252] = 7;
        nArray[253] = 7;
        nArray[254] = 7;
        nArray[255] = 7;
        law_lut = nArray;
        int[] nArray2 = new int[8];
        nArray2[1] = 132;
        nArray2[2] = 396;
        nArray2[3] = 924;
        nArray2[4] = 1980;
        nArray2[5] = 4092;
        nArray2[6] = 8316;
        nArray2[7] = 16764;
        linear_lut = nArray2;
    }
}

