/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MultiProcessing
extends BApplet {
    public static MultiProcessing multiApp;
    static final float DEFAULT_TIME_STEP = 0.5f;
    static final float DEFAULT_GX = 0.0f;
    static final float DEFAULT_GY = 0.03f;
    static final float DEFAULT_GZ = 0.0f;
    static final float DEFAULT_DRAG = 0.03f;
    static final float DEFAULT_SPRING_KM = 0.005f;
    static final float DEFAULT_SPRING_KD = 0.01f;
    static final float DEFAULT_SPRING_REST_LENGTH = 18.0f;
    public static final int DIMENSIONS = 3;
    public static int SYS_X_MAX;
    public static int SYS_Y_MAX;
    public static int SYS_Z_MAX;
    public static int SYS_X_START;
    public static int SYS_Y_START;
    public static int SYS_Z_START;
    final int STATE_STACK_START_SIZE = 100;
    final boolean SURFACE = true;
    final boolean SOLID = false;
    int stateStackPtr;
    boolean[] strokeOnState;
    boolean[] fillOnState;
    int[] strokeState;
    int[] fillState;
    int[] rectModeState;
    int[] ellipseModeState;
    int[] textModeState;
    int[] colorModeState;
    boolean[] lightsOnState;
    boolean[] smoothOnState;
    BFont[] textFontState;
    boolean doneFirstLoop;
    private char dxfKey;
    private String dxfFileName;
    private boolean dxfEnabled;
    private boolean doWriteDXF;
    ArcBall arcball;
    private boolean arcballEnabled;
    public int numTurtles;
    public Turtle[] turtles;
    public int deadTurtles;
    ParticleSystem pSystem;
    private boolean lightsValid;
    private boolean previousSurfaceMode;
    LinkedList importedObjects;
    MultiGraphics mg;
    final int MAX_TRI_LAYERS = 500000;
    final int DXF_NO_LAYER = -1;
    int currentDXFLayer;
    int[] DXFLayerList;
    final int START_PARTICLES = 500;
    final int START_FORCES = 500;
    long inversions;

    public void init() {
        multiApp = this;
        this.doneFirstLoop = false;
        this.numTurtles = 0;
        this.deadTurtles = 0;
        this.pSystem = new ParticleSystem();
        super.init();
    }

    public void initg() {
        this.mg = new MultiGraphics(100, 100);
        this.g = this.mg;
        BGraphics.hints[2] = true;
    }

    void growStateStack() {
        int n = this.strokeOnState.length;
        int n2 = n + 100;
        boolean[] blArray = new boolean[n2];
        System.arraycopy(this.strokeOnState, 0, blArray, 0, n);
        this.strokeOnState = blArray;
        boolean[] blArray2 = new boolean[n2];
        System.arraycopy(this.fillOnState, 0, blArray2, 0, n);
        this.fillOnState = blArray2;
        int[] nArray = new int[n2];
        System.arraycopy(this.strokeState, 0, nArray, 0, n);
        this.strokeState = nArray;
        int[] nArray2 = new int[n2];
        System.arraycopy(this.fillState, 0, nArray2, 0, n);
        this.fillState = nArray2;
        int[] nArray3 = new int[n2];
        System.arraycopy(this.rectModeState, 0, nArray3, 0, n);
        this.rectModeState = nArray3;
        int[] nArray4 = new int[n2];
        System.arraycopy(this.ellipseModeState, 0, nArray4, 0, n);
        this.ellipseModeState = nArray4;
        int[] nArray5 = new int[n2];
        System.arraycopy(this.textModeState, 0, nArray5, 0, n);
        this.textModeState = nArray5;
        int[] nArray6 = new int[n2];
        System.arraycopy(this.colorModeState, 0, nArray6, 0, n);
        this.colorModeState = nArray6;
        boolean[] blArray3 = new boolean[n2];
        System.arraycopy(this.lightsOnState, 0, blArray3, 0, n);
        this.lightsOnState = blArray3;
        boolean[] blArray4 = new boolean[n2];
        System.arraycopy(this.smoothOnState, 0, blArray4, 0, n);
        this.smoothOnState = blArray4;
        BFont[] bFontArray = new BFont[n2];
        System.arraycopy(this.textFontState, 0, bFontArray, 0, n);
        this.textFontState = bFontArray;
    }

    void pushAll() {
        this.push();
        if (this.stateStackPtr >= this.strokeOnState.length) {
            this.growStateStack();
        }
        this.strokeOnState[this.stateStackPtr] = this.g._stroke;
        this.fillOnState[this.stateStackPtr] = this.g._fill;
        this.strokeState[this.stateStackPtr] = this.g.stroke;
        this.fillState[this.stateStackPtr] = this.g.fill;
        this.rectModeState[this.stateStackPtr] = this.g.rect_mode;
        this.ellipseModeState[this.stateStackPtr] = this.g.ellipse_mode;
        this.textModeState[this.stateStackPtr] = this.g.text_mode;
        this.textFontState[this.stateStackPtr] = this.g.text_font;
        this.colorModeState[this.stateStackPtr] = this.g.color_mode;
        this.lightsOnState[this.stateStackPtr] = this.g.lighting;
        this.smoothOnState[this.stateStackPtr] = this.g.smooth;
        ++this.stateStackPtr;
    }

    void popAll() {
        if (this.stateStackPtr <= 0) {
            return;
        }
        --this.stateStackPtr;
        this.pop();
        this.stroke(this.strokeState[this.stateStackPtr]);
        if (!this.strokeOnState[this.stateStackPtr]) {
            this.noStroke();
        }
        this.fill(this.fillState[this.stateStackPtr]);
        if (!this.fillOnState[this.stateStackPtr]) {
            this.noFill();
        }
        this.rectMode(this.rectModeState[this.stateStackPtr]);
        this.ellipseMode(this.ellipseModeState[this.stateStackPtr]);
        this.textMode(this.textModeState[this.stateStackPtr]);
        if (this.textFontState[this.stateStackPtr] != null) {
            this.textFont(this.textFontState[this.stateStackPtr]);
        }
        this.colorMode(this.colorModeState[this.stateStackPtr]);
        if (this.lightsOnState[this.stateStackPtr]) {
            this.lights();
        } else {
            this.noLights();
        }
        if (this.smoothOnState[this.stateStackPtr]) {
            this.smooth();
        } else {
            this.noSmooth();
        }
    }

    void forward(float f) {
        this.line(0.0f, 0.0f, 0.0f, -f);
        this.translate(0.0f, -f);
    }

    void forwardBox(float f) {
        this.forwardBox(f, f, f);
    }

    void forwardBox(float f, float f2, float f3) {
        this.translate(0.0f, -f2 / 2.0f, 0.0f);
        this.box(f, f2, f3);
        this.translate(0.0f, -f2 / 2.0f, 0.0f);
    }

    void backward(float f) {
        this.forward(-f);
    }

    void backwardBox(float f) {
        this.backwardBox(f, f, f);
    }

    void backwardBox(float f, float f2, float f3) {
        this.translate(0.0f, f2 / 2.0f, 0.0f);
        this.box(f, f2, f3);
        this.translate(0.0f, f2 / 2.0f, 0.0f);
    }

    void right(float f) {
        this.rotate(this.radians(f));
    }

    void left(float f) {
        this.rotate(this.radians(-f));
    }

    Turtle spawn(Turtle turtle) {
        return turtle.spawn();
    }

    Particle spawnParticle(Particle particle, float f, float f2, float f3) {
        Particle particle2 = this.spawnParticle(particle);
        particle2.setPos(f, f2, f3);
        return particle2;
    }

    Particle spawnParticle(Particle particle) {
        Particle particle2 = (Particle)particle.spawn();
        this.pSystem.addParticle(particle2);
        return particle2;
    }

    Spring addSpring(Particle particle, Particle particle2) {
        Spring spring = new Spring(particle, particle2);
        this.pSystem.addForce(spring);
        return spring;
    }

    Spring addSpring(Particle particle, Particle particle2, float f, float f2, float f3) {
        Spring spring = new Spring(particle, particle2);
        spring.restLength = f3;
        spring.damping = f2;
        spring.strength = f;
        this.pSystem.addForce(spring);
        return spring;
    }

    Magnet addMagnet(Particle particle) {
        Magnet magnet = new Magnet(particle);
        this.pSystem.addForce(magnet);
        return magnet;
    }

    Magnet addMagnet(Particle particle, float f) {
        Magnet magnet = new Magnet(particle);
        magnet.strength = f;
        this.pSystem.addForce(magnet);
        return magnet;
    }

    void preloop() {
        this.lightsValid = true;
        this.DXFloop();
        if (!this.doneFirstLoop) {
            this.firstLoop();
            this.doneFirstLoop = true;
        }
        if (this.pSystem.nParticles > 0) {
            this.pSystem.zeroForces();
            this.pSystem.applyForces();
            this.pSystem.calcNextState();
            this.pSystem.updateState();
        }
        Iterator iterator = this.importedObjects.iterator();
        while (iterator.hasNext()) {
            ObjImport objImport = (ObjImport)iterator.next();
            objImport.update();
        }
    }

    void firstLoop() {
    }

    void postloop() {
        this.pushAll();
        int n = this.numTurtles;
        int n2 = 0;
        while (n2 < n) {
            Turtle turtle = this.turtles[n2];
            if (turtle != null && turtle.alive) {
                turtle.preloop();
                turtle.inLoop = true;
                turtle.loop();
                turtle.inLoop = false;
                turtle.postloop();
            }
            ++n2;
        }
        this.popAll();
        if (this.doWriteDXF) {
            this.doWriteDXF = false;
            this.DXFwrite(this.dxfFileName);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        if (this.arcballEnabled) {
            this.arcball.mousePressed();
        }
        this.mousePressedToTurtles();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        if (this.arcballEnabled) {
            this.arcball.mouseDragged();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        this.mouseReleasedToTurtles();
    }

    public void keyPressed(KeyEvent keyEvent) {
        super.keyPressed(keyEvent);
        if (this.dxfEnabled && this.key == this.dxfKey) {
            this.doWriteDXF = true;
        }
        this.keyPressedToTurtles();
    }

    public void keyReleased(KeyEvent keyEvent) {
        super.keyReleased(keyEvent);
        this.keyReleasedToTurtles();
    }

    public void keyPressedToTurtles() {
        int n = this.numTurtles;
        int n2 = 0;
        while (n2 < n) {
            Turtle turtle = this.turtles[n2];
            if (turtle != null && turtle.alive) {
                turtle.doKeyPressed = true;
            }
            ++n2;
        }
    }

    public void keyReleasedToTurtles() {
        int n = this.numTurtles;
        int n2 = 0;
        while (n2 < n) {
            Turtle turtle = this.turtles[n2];
            if (turtle != null && turtle.alive) {
                turtle.doKeyReleased = true;
            }
            ++n2;
        }
    }

    public void mousePressedToTurtles() {
        int n = this.numTurtles;
        int n2 = 0;
        while (n2 < n) {
            Turtle turtle = this.turtles[n2];
            if (turtle != null && turtle.alive) {
                turtle.doMousePressed = true;
            }
            ++n2;
        }
    }

    public void mouseReleasedToTurtles() {
        int n = this.numTurtles;
        int n2 = 0;
        while (n2 < n) {
            Turtle turtle = this.turtles[n2];
            if (turtle != null && turtle.alive) {
                turtle.doMouseReleased = true;
            }
            ++n2;
        }
    }

    public void nextFrame() {
        this.mouseX = this.qmouseX;
        this.mouseY = this.qmouseY;
        this.calendar = null;
        if (this.fpsTarget != 0.0f) {
            this.framerate_delay();
        }
        if (!this.drawn) {
            this.g.beginFrame();
            this.draw();
            if (this.drawMethod) {
                this.g.endFrame();
                this.update();
                if (this.isMacintosh) {
                    this.getToolkit().sync();
                }
                this.finished = true;
            }
            this.drawn = true;
        }
        if (!this.drawMethod) {
            this.g.beginFrame();
            this.insideLoop = true;
            this.preloop();
            this.loop();
            this.postloop();
            this.insideLoop = false;
            if (this.qmouseMoved) {
                this.mouseMoved();
                this.qmouseMoved = false;
            }
            if (this.qmouseDragged) {
                this.mouseDragged();
                this.qmouseDragged = false;
            }
            this.g.endFrame();
            this.update();
            if (this.isMacintosh) {
                this.getToolkit().sync();
            }
        }
        if (!this.loopMethod) {
            this.finished = true;
        }
        this.pmouseX = this.mouseX;
        this.pmouseY = this.mouseY;
        ++this.frame;
    }

    public void applyArcball() {
        if (this.arcballEnabled) {
            this.arcball.run();
        }
    }

    void enableArcball() {
        this.enableArcball((float)this.width / 2.0f, (float)this.height / 2.0f, (float)(this.width + this.height) / 2.0f);
    }

    void enableArcball(float f, float f2, float f3) {
        this.arcball = new ArcBall(f, f2, f3);
        this.arcballEnabled = true;
    }

    void enableDXFwrite(String string, char c) {
        this.dxfKey = c;
        this.dxfFileName = string;
        this.dxfEnabled = true;
        this.DXFinit();
    }

    void DXFwrite(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
            this.DXFheader(printWriter);
            this.DXFgraphics(printWriter);
            this.DXFfooter(printWriter);
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.println("DXF file \"" + string + "\" written with " + this.g.triangles_count + " triangles.");
    }

    void DXFinit() {
        this.hint(2);
        this.lights();
    }

    void DXFloop() {
        this.rotateX(0.3926991f);
        this.rotateX(-0.3926991f);
        int n = 0;
        while (n < 500000) {
            this.DXFLayerList[n] = -1;
            ++n;
        }
        this.DXFlayer(0);
    }

    private final void DXFheader(PrintWriter printWriter) throws IOException {
        printWriter.println("0");
        printWriter.println("SECTION");
        printWriter.println("2");
        printWriter.println("ENTITIES");
    }

    private final void DXFfooter(PrintWriter printWriter) throws IOException {
        printWriter.println("0");
        printWriter.println("ENDSEC");
        printWriter.println("0");
        printWriter.println("EOF");
    }

    void DXFlayer(int n) {
        this.currentDXFLayer = n;
        if (this.g.triangles_count >= 500000) {
            return;
        }
        this.DXFLayerList[this.g.triangles_count] = this.currentDXFLayer;
    }

    private final void DXFgraphics(PrintWriter printWriter) throws IOException {
        this.currentDXFLayer = 0;
        int n = 0;
        while (n < this.g.triangles_count) {
            float[] fArray = this.g.vertices[this.g.triangles[n][0]];
            float[] fArray2 = this.g.vertices[this.g.triangles[n][1]];
            float[] fArray3 = this.g.vertices[this.g.triangles[n][2]];
            if ((double)fArray[22] != 0.0 && (double)fArray2[22] != 0.0 && (double)fArray3[22] != 0.0) {
                printWriter.println("0");
                printWriter.println("3DFACE");
                printWriter.println("8");
                if (n < 500000 && this.DXFLayerList[n] >= 0) {
                    this.currentDXFLayer = this.DXFLayerList[n];
                }
                printWriter.println(Integer.toString(this.currentDXFLayer));
                printWriter.println("10");
                printWriter.println(Float.toString(fArray[19] / fArray[22]));
                printWriter.println("20");
                printWriter.println(Float.toString(fArray[20] / fArray[22]));
                printWriter.println("30");
                printWriter.println(Float.toString(fArray[21] / fArray[22]));
                printWriter.println("11");
                printWriter.println(Float.toString(fArray2[19] / fArray2[22]));
                printWriter.println("21");
                printWriter.println(Float.toString(fArray2[20] / fArray2[22]));
                printWriter.println("31");
                printWriter.println(Float.toString(fArray2[21] / fArray2[22]));
                printWriter.println("12");
                printWriter.println(Float.toString(fArray3[19] / fArray3[22]));
                printWriter.println("22");
                printWriter.println(Float.toString(fArray3[20] / fArray3[22]));
                printWriter.println("32");
                printWriter.println(Float.toString(fArray3[21] / fArray3[22]));
                printWriter.println("13");
                printWriter.println(Float.toString(fArray3[19] / fArray3[22]));
                printWriter.println("23");
                printWriter.println(Float.toString(fArray3[20] / fArray3[22]));
                printWriter.println("33");
                printWriter.println(Float.toString(fArray3[21] / fArray3[22]));
            }
            ++n;
        }
    }

    void gravity(float f) {
        this.gravity(0.0f, f, 0.0f);
    }

    void gravity(float f, float f2, float f3) {
        this.pSystem.Gx = f;
        this.pSystem.Gy = f2;
        this.pSystem.Gz = f3;
    }

    void drag(float f) {
        this.pSystem.kDrag = f;
    }

    void particleSystemTimeStep(float f) {
        this.pSystem.timeStep = f;
    }

    void defaultSpringStrength(float f) {
        this.pSystem.defaultKm = f;
    }

    void defaultSpringDamping(float f) {
        this.pSystem.defaultKd = f;
    }

    void defaultSpringRestLength(float f) {
        this.pSystem.defaultSpringRestLength = f;
    }

    void drawSprings() {
        this.pSystem.drawSprings();
    }

    float distance(float[] fArray, float[] fArray2) {
        return this.sqrt(this.sq(fArray[0] - fArray2[0]) + this.sq(fArray[1] - fArray2[1]) + this.sq(fArray[2] - fArray2[2]));
    }

    float distanceSq(float[] fArray, float[] fArray2) {
        return this.sq(fArray[0] - fArray2[0]) + this.sq(fArray[1] - fArray2[1]) + this.sq(fArray[2] - fArray2[2]);
    }

    public void push() {
        super.push();
        this.mg.normMat.push();
    }

    public void pop() {
        super.pop();
        this.mg.normMat.pop();
    }

    public void rotate(float f) {
        super.rotate(f);
        this.mg.normMat.invRotate(f);
    }

    public void rotate(float f, float f2, float f3, float f4) {
        super.rotate(f, f2, f3, f4);
        this.mg.normMat.invRotate(f, f2, f3, f4);
    }

    public void rotateX(float f) {
        super.rotateX(f);
        this.mg.normMat.invRotateX(f);
    }

    public void rotateY(float f) {
        super.rotateY(f);
        this.mg.normMat.invRotateY(f);
    }

    public void rotateZ(float f) {
        super.rotateZ(f);
        this.mg.normMat.invRotateZ(f);
    }

    public void scale(float f) {
        super.scale(f);
        this.mg.normMat.invScale(f);
    }

    public void scale(float f, float f2) {
        super.scale(f, f2);
        this.mg.normMat.invScale(f, f2);
    }

    public void scale(float f, float f2, float f3) {
        super.scale(f, f2, f3);
        this.mg.normMat.invScale(f, f2, f3);
    }

    public void translate(float f, float f2) {
        super.translate(f, f2);
        this.mg.normMat.invTranslate(f, f2);
    }

    public void translate(float f, float f2, float f3) {
        super.translate(f, f2, f3);
        this.mg.normMat.invTranslate(f, f2, f3);
    }

    public void transform(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        super.transform(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
        this.invalidateLights();
    }

    public void ellipse(float f, float f2, float f3, float f4) {
        this.revalidateLights();
        super.ellipse(f, f2, f3, f4);
    }

    public void endCamera() {
        this.revalidateLights();
        super.endCamera();
    }

    public void endShape() {
        this.revalidateLights();
        super.endShape();
    }

    public void setSurfaceMode(boolean bl) {
        this.mg.surfaceModeNormals = bl;
    }

    public void quad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.revalidateLights();
        this.previousSurfaceMode = this.mg.surfaceModeNormals;
        this.mg.surfaceModeNormals = true;
        super.quad(f, f2, f3, f4, f5, f6, f7, f8);
        this.mg.surfaceModeNormals = this.previousSurfaceMode;
    }

    public void rect(float f, float f2, float f3, float f4) {
        this.revalidateLights();
        this.previousSurfaceMode = this.mg.surfaceModeNormals;
        this.mg.surfaceModeNormals = true;
        super.rect(f, f2, f3, f4);
        this.mg.surfaceModeNormals = this.previousSurfaceMode;
    }

    public void sphere(float f) {
        this.revalidateLights();
        super.sphere(f);
    }

    public void text(char c, float f, float f2) {
        this.revalidateLights();
        super.text(c, f, f2);
    }

    public void text(float f, float f2, float f3) {
        this.revalidateLights();
        super.text(f, f2, f3);
    }

    public void text(int n, float f, float f2) {
        this.revalidateLights();
        super.text(n, f, f2);
    }

    public void triangle(float f, float f2, float f3, float f4, float f5, float f6) {
        this.revalidateLights();
        this.previousSurfaceMode = this.mg.surfaceModeNormals;
        this.mg.surfaceModeNormals = true;
        super.triangle(f, f2, f3, f4, f5, f6);
        this.mg.surfaceModeNormals = this.previousSurfaceMode;
    }

    public void text(String string, float f, float f2) {
        this.revalidateLights();
        super.text(string, f, f2);
    }

    protected void invalidateLights() {
        this.lightsValid = false;
    }

    protected void revalidateLights() {
        if (this.lightsValid) {
            return;
        }
        MultiGraphics multiGraphics = (MultiGraphics)this.g;
        multiGraphics.normMat.set(this.g.m00, this.g.m01, this.g.m02, this.g.m03, this.g.m10, this.g.m11, this.g.m12, this.g.m13, this.g.m20, this.g.m21, this.g.m22, this.g.m23, this.g.m30, this.g.m31, this.g.m32, this.g.m33);
        multiGraphics.normMat.invert();
        ++this.inversions;
        this.lightsValid = true;
    }

    void lightPos(int n, float f, float f2, float f3) {
        if (!this.g.lighting) {
            this.lights();
        }
        if (n > 0) {
            if (n < 10) {
                this.g.lightX[n] = this.g.m00 * f + this.g.m01 * f2 + this.g.m02 * f3 + this.g.m03;
                this.g.lightY[n] = this.g.m10 * f + this.g.m11 * f2 + this.g.m12 * f3 + this.g.m13;
                this.g.lightZ[n] = this.g.m20 * f + this.g.m21 * f2 + this.g.m22 * f3 + this.g.m23;
            }
        }
    }

    void lightColor(int n, float f, float f2, float f3) {
        if (!this.g.lighting) {
            this.lights();
        }
        if (n >= 0) {
            if (n < 10) {
                this.g.lightR[n] = f;
                this.g.lightG[n] = f2;
                this.g.lightB[n] = f3;
                this.g.lightKind[n] = 2;
                if (f == 0.0f && f2 == 0.0f && f3 == 0.0f) {
                    this.g.lightKind[n] = 0;
                }
            }
        }
    }

    public void box(float f) {
        this.box(f, f, f);
    }

    public void box(float f, float f2, float f3) {
        float f4 = -f / 2.0f;
        float f5 = f / 2.0f;
        float f6 = -f2 / 2.0f;
        float f7 = f2 / 2.0f;
        float f8 = -f3 / 2.0f;
        float f9 = f3 / 2.0f;
        this.revalidateLights();
        if (BGraphics.hints[2]) {
            this.g.triangle.setCulling(true);
        }
        this.beginShape(128);
        this.normal(0.0f, 0.0f, -1.0f);
        this.vertex(f4, f6, f8);
        this.vertex(f5, f6, f8);
        this.vertex(f5, f7, f8);
        this.vertex(f4, f7, f8);
        this.normal(1.0f, 0.0f, 0.0f);
        this.vertex(f5, f6, f8);
        this.vertex(f5, f6, f9);
        this.vertex(f5, f7, f9);
        this.vertex(f5, f7, f8);
        this.normal(0.0f, 0.0f, 1.0f);
        this.vertex(f5, f6, f9);
        this.vertex(f4, f6, f9);
        this.vertex(f4, f7, f9);
        this.vertex(f5, f7, f9);
        this.normal(-1.0f, 0.0f, 0.0f);
        this.vertex(f4, f6, f9);
        this.vertex(f4, f6, f8);
        this.vertex(f4, f7, f8);
        this.vertex(f4, f7, f9);
        this.normal(0.0f, -1.0f, 0.0f);
        this.vertex(f4, f6, f9);
        this.vertex(f5, f6, f9);
        this.vertex(f5, f6, f8);
        this.vertex(f4, f6, f8);
        this.normal(0.0f, 1.0f, 0.0f);
        this.vertex(f4, f7, f8);
        this.vertex(f5, f7, f8);
        this.vertex(f5, f7, f9);
        this.vertex(f4, f7, f9);
        this.endShape();
        if (BGraphics.hints[2]) {
            this.g.triangle.setCulling(false);
        }
    }

    private final /* synthetic */ void this() {
        this.STATE_STACK_START_SIZE = 100;
        this.SURFACE = true;
        this.SOLID = false;
        this.stateStackPtr = 0;
        this.strokeOnState = new boolean[100];
        this.fillOnState = new boolean[100];
        this.strokeState = new int[100];
        this.fillState = new int[100];
        this.rectModeState = new int[100];
        this.ellipseModeState = new int[100];
        this.textModeState = new int[100];
        this.colorModeState = new int[100];
        this.lightsOnState = new boolean[100];
        this.smoothOnState = new boolean[100];
        this.textFontState = new BFont[100];
        this.dxfEnabled = false;
        this.doWriteDXF = false;
        this.arcballEnabled = false;
        this.numTurtles = 0;
        this.turtles = new Turtle[1000];
        this.deadTurtles = 0;
        this.lightsValid = true;
        this.importedObjects = new LinkedList();
        this.MAX_TRI_LAYERS = 500000;
        this.DXF_NO_LAYER = -1;
        this.currentDXFLayer = 0;
        this.DXFLayerList = new int[500000];
        this.START_PARTICLES = 500;
        this.START_FORCES = 500;
        this.inversions = 0L;
    }

    public MultiProcessing() {
        this.this();
    }

    static {
        SYS_X_MAX = 1000;
        SYS_Y_MAX = 1000;
        SYS_Z_MAX = 1000;
        SYS_X_START = -1000;
        SYS_Y_START = -1000;
        SYS_Z_START = -1000;
    }

    class ArcBall {
        float center_x;
        float center_y;
        float radius;
        Vec3 v_down;
        Vec3 v_drag;
        Quat q_now;
        Quat q_down;
        Quat q_drag;
        Vec3[] axisSet;
        int axis;

        void mousePressed() {
            this.v_down = this.mouse_to_sphere(MultiProcessing.this.mouseX, MultiProcessing.this.mouseY);
            this.q_down.set(this.q_now);
            this.q_drag.reset();
        }

        void mouseDragged() {
            this.v_drag = this.mouse_to_sphere(MultiProcessing.this.mouseX, MultiProcessing.this.mouseY);
            this.q_drag.set(Vec3.dot(this.v_down, this.v_drag), Vec3.cross(this.v_down, this.v_drag));
        }

        void run() {
            this.q_now = Quat.mul(this.q_drag, this.q_down);
            this.applyQuat2Matrix(this.q_now);
        }

        Vec3 mouse_to_sphere(float f, float f2) {
            Vec3 vec3 = new Vec3();
            vec3.x = (f - this.center_x) / this.radius;
            vec3.y = (f2 - this.center_y) / this.radius;
            float f3 = vec3.x * vec3.x + vec3.y * vec3.y;
            if (f3 > 1.0f) {
                vec3.normalize();
            } else {
                vec3.z = MultiProcessing.this.sqrt(1.0f - f3);
            }
            return this.axis == -1 ? vec3 : this.constrain_vector(vec3, this.axisSet[this.axis]);
        }

        Vec3 constrain_vector(Vec3 vec3, Vec3 vec32) {
            Vec3 vec33 = new Vec3();
            vec33.sub(vec3, Vec3.mul(vec32, Vec3.dot(vec32, vec3)));
            vec33.normalize();
            return vec33;
        }

        void applyQuat2Matrix(Quat quat) {
            float[] fArray = quat.getValue();
            MultiProcessing.this.rotate(fArray[0], fArray[1], fArray[2], fArray[3]);
        }

        ArcBall(float f, float f2, float f3) {
            this.center_x = f;
            this.center_y = f2;
            this.radius = f3;
            this.v_down = new Vec3();
            this.v_drag = new Vec3();
            this.q_now = new Quat();
            this.q_down = new Quat();
            this.q_drag = new Quat();
            this.axisSet = new Vec3[]{new Vec3(1.0f, 0.0f, 0.0f), new Vec3(0.0f, 1.0f, 0.0f), new Vec3(0.0f, 0.0f, 1.0f)};
            this.axis = -1;
        }
    }

    static class Vec3 {
        float x;
        float y;
        float z;

        void normalize() {
            float f = this.length();
            this.x /= f;
            this.y /= f;
            this.z /= f;
        }

        float length() {
            return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        }

        static Vec3 cross(Vec3 vec3, Vec3 vec32) {
            Vec3 vec33 = new Vec3();
            vec33.x = vec3.y * vec32.z - vec3.z * vec32.y;
            vec33.y = vec3.z * vec32.x - vec3.x * vec32.z;
            vec33.z = vec3.x * vec32.y - vec3.y * vec32.x;
            return vec33;
        }

        static float dot(Vec3 vec3, Vec3 vec32) {
            return vec3.x * vec32.x + vec3.y * vec32.y + vec3.z * vec32.z;
        }

        static Vec3 mul(Vec3 vec3, float f) {
            Vec3 vec32 = new Vec3();
            vec32.x = vec3.x * f;
            vec32.y = vec3.y * f;
            vec32.z = vec3.z * f;
            return vec32;
        }

        void sub(Vec3 vec3, Vec3 vec32) {
            this.x = vec3.x - vec32.x;
            this.y = vec3.y - vec32.y;
            this.z = vec3.z - vec32.z;
        }

        Vec3() {
        }

        Vec3(float f, float f2, float f3) {
            this.x = f;
            this.y = f2;
            this.z = f3;
        }
    }

    static class Quat {
        float w;
        float x;
        float y;
        float z;

        void reset() {
            this.w = 1.0f;
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 0.0f;
        }

        void set(float f, Vec3 vec3) {
            this.w = f;
            this.x = vec3.x;
            this.y = vec3.y;
            this.z = vec3.z;
        }

        void set(Quat quat) {
            this.w = quat.w;
            this.x = quat.x;
            this.y = quat.y;
            this.z = quat.z;
        }

        static Quat mul(Quat quat, Quat quat2) {
            Quat quat3 = new Quat();
            quat3.w = quat.w * quat2.w - quat.x * quat2.x - quat.y * quat2.y - quat.z * quat2.z;
            quat3.x = quat.w * quat2.x + quat.x * quat2.w + quat.y * quat2.z - quat.z * quat2.y;
            quat3.y = quat.w * quat2.y + quat.y * quat2.w + quat.z * quat2.x - quat.x * quat2.z;
            quat3.z = quat.w * quat2.z + quat.z * quat2.w + quat.x * quat2.y - quat.y * quat2.x;
            return quat3;
        }

        float[] getValue() {
            float[] fArray = new float[4];
            float f = (float)Math.sqrt(1.0f - this.w * this.w);
            if (f < 1.0E-4f) {
                f = 1.0f;
            }
            fArray[0] = (float)Math.acos(this.w) * 2.0f;
            fArray[1] = this.x / f;
            fArray[2] = this.y / f;
            fArray[3] = this.z / f;
            return fArray;
        }

        Quat() {
            this.reset();
        }

        Quat(float f, float f2, float f3, float f4) {
            this.w = f;
            this.x = f2;
            this.y = f3;
            this.z = f4;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Turtle {
        public static final int NUM_START_TURTLES = 1000;
        private static final int CLEAN_DEAD_THRESHOLD = 100;
        boolean alive;
        boolean stateInitialized;
        int generation;
        int age;
        boolean doneFirstLoop;
        Turtle parent;
        public boolean inLoop;
        int numDeferredSpawns;
        public boolean keyPressed;
        public boolean doMousePressed;
        public boolean doMouseReleased;
        public boolean doKeyPressed;
        public boolean doKeyReleased;
        float[] matrix;
        float[][] normalMat;
        boolean strokeOnState;
        boolean fillOnState;
        int strokeState;
        int fillState;
        int rectModeState;
        int ellipseModeState;
        int textModeState;
        int colorModeState;
        boolean lightsOnState;
        boolean smoothOnState;
        BFont textFontState;

        void mousePressed() {
        }

        void mouseReleased() {
        }

        void keyPressed() {
        }

        void keyReleased() {
        }

        private final void addTurtle(Turtle turtle) {
            if (MultiProcessing.this.numTurtles >= MultiProcessing.this.turtles.length) {
                Turtle[] turtleArray = new Turtle[MultiProcessing.this.numTurtles + 1000];
                System.arraycopy(MultiProcessing.this.turtles, 0, turtleArray, 0, MultiProcessing.this.numTurtles);
                MultiProcessing.this.turtles = turtleArray;
            }
            MultiProcessing.this.turtles[MultiProcessing.this.numTurtles] = turtle;
            ++MultiProcessing.this.numTurtles;
        }

        private final void compactTurtles() {
            Turtle[] turtleArray = new Turtle[MultiProcessing.this.turtles.length];
            int n = 0;
            int n2 = 0;
            while (n2 < MultiProcessing.this.numTurtles) {
                if (MultiProcessing.this.turtles[n2] != null && MultiProcessing.this.turtles[n2].alive) {
                    turtleArray[n] = MultiProcessing.this.turtles[n2];
                    ++n;
                } else {
                    MultiProcessing.this.turtles[n2] = null;
                }
                ++n2;
            }
            MultiProcessing.this.numTurtles = n;
            MultiProcessing.this.turtles = turtleArray;
            MultiProcessing.this.deadTurtles = 0;
            System.gc();
        }

        public void saveState() {
            if (MultiProcessing.this.g == null) {
                return;
            }
            this.stateInitialized = true;
            this.matrix[0] = MultiProcessing.this.g.m00;
            this.matrix[1] = MultiProcessing.this.g.m01;
            this.matrix[2] = MultiProcessing.this.g.m02;
            this.matrix[3] = MultiProcessing.this.g.m03;
            this.matrix[4] = MultiProcessing.this.g.m10;
            this.matrix[5] = MultiProcessing.this.g.m11;
            this.matrix[6] = MultiProcessing.this.g.m12;
            this.matrix[7] = MultiProcessing.this.g.m13;
            this.matrix[8] = MultiProcessing.this.g.m20;
            this.matrix[9] = MultiProcessing.this.g.m21;
            this.matrix[10] = MultiProcessing.this.g.m22;
            this.matrix[11] = MultiProcessing.this.g.m23;
            this.matrix[12] = MultiProcessing.this.g.m30;
            this.matrix[13] = MultiProcessing.this.g.m31;
            this.matrix[14] = MultiProcessing.this.g.m32;
            this.matrix[15] = MultiProcessing.this.g.m33;
            this.normalMat[0][0] = MultiProcessing.this.mg.normMat.m00;
            this.normalMat[0][1] = MultiProcessing.this.mg.normMat.m01;
            this.normalMat[0][2] = MultiProcessing.this.mg.normMat.m02;
            this.normalMat[0][3] = MultiProcessing.this.mg.normMat.m03;
            this.normalMat[1][0] = MultiProcessing.this.mg.normMat.m10;
            this.normalMat[1][1] = MultiProcessing.this.mg.normMat.m11;
            this.normalMat[1][2] = MultiProcessing.this.mg.normMat.m12;
            this.normalMat[1][3] = MultiProcessing.this.mg.normMat.m13;
            this.normalMat[2][0] = MultiProcessing.this.mg.normMat.m20;
            this.normalMat[2][1] = MultiProcessing.this.mg.normMat.m21;
            this.normalMat[2][2] = MultiProcessing.this.mg.normMat.m22;
            this.normalMat[2][3] = MultiProcessing.this.mg.normMat.m23;
            this.normalMat[3][0] = MultiProcessing.this.mg.normMat.m30;
            this.normalMat[3][1] = MultiProcessing.this.mg.normMat.m31;
            this.normalMat[3][2] = MultiProcessing.this.mg.normMat.m32;
            this.normalMat[3][3] = MultiProcessing.this.mg.normMat.m33;
            this.strokeOnState = MultiProcessing.this.g._stroke;
            this.fillOnState = MultiProcessing.this.g._fill;
            this.strokeState = MultiProcessing.this.g.stroke;
            this.fillState = MultiProcessing.this.g.fill;
            this.rectModeState = MultiProcessing.this.g.rect_mode;
            this.ellipseModeState = MultiProcessing.this.g.ellipse_mode;
            this.textModeState = MultiProcessing.this.g.text_mode;
            this.textFontState = MultiProcessing.this.g.text_font;
            this.colorModeState = MultiProcessing.this.g.color_mode;
            this.lightsOnState = MultiProcessing.this.g.lighting;
            this.smoothOnState = MultiProcessing.this.g.smooth;
        }

        public void restoreState() {
            if (MultiProcessing.this.g == null) {
                return;
            }
            MultiProcessing.this.g.m00 = this.matrix[0];
            MultiProcessing.this.g.m01 = this.matrix[1];
            MultiProcessing.this.g.m02 = this.matrix[2];
            MultiProcessing.this.g.m03 = this.matrix[3];
            MultiProcessing.this.g.m10 = this.matrix[4];
            MultiProcessing.this.g.m11 = this.matrix[5];
            MultiProcessing.this.g.m12 = this.matrix[6];
            MultiProcessing.this.g.m13 = this.matrix[7];
            MultiProcessing.this.g.m20 = this.matrix[8];
            MultiProcessing.this.g.m21 = this.matrix[9];
            MultiProcessing.this.g.m22 = this.matrix[10];
            MultiProcessing.this.g.m23 = this.matrix[11];
            MultiProcessing.this.g.m30 = this.matrix[12];
            MultiProcessing.this.g.m31 = this.matrix[13];
            MultiProcessing.this.g.m32 = this.matrix[14];
            MultiProcessing.this.g.m33 = this.matrix[15];
            MultiProcessing.this.mg.normMat.m00 = this.normalMat[0][0];
            MultiProcessing.this.mg.normMat.m01 = this.normalMat[0][1];
            MultiProcessing.this.mg.normMat.m02 = this.normalMat[0][2];
            MultiProcessing.this.mg.normMat.m03 = this.normalMat[0][3];
            MultiProcessing.this.mg.normMat.m10 = this.normalMat[1][0];
            MultiProcessing.this.mg.normMat.m11 = this.normalMat[1][1];
            MultiProcessing.this.mg.normMat.m12 = this.normalMat[1][2];
            MultiProcessing.this.mg.normMat.m13 = this.normalMat[1][3];
            MultiProcessing.this.mg.normMat.m20 = this.normalMat[2][0];
            MultiProcessing.this.mg.normMat.m21 = this.normalMat[2][1];
            MultiProcessing.this.mg.normMat.m22 = this.normalMat[2][2];
            MultiProcessing.this.mg.normMat.m23 = this.normalMat[2][3];
            MultiProcessing.this.mg.normMat.m30 = this.normalMat[3][0];
            MultiProcessing.this.mg.normMat.m31 = this.normalMat[3][1];
            MultiProcessing.this.mg.normMat.m32 = this.normalMat[3][2];
            MultiProcessing.this.mg.normMat.m33 = this.normalMat[3][3];
            MultiProcessing.this.g.translate(0.0f, 0.0f);
            MultiProcessing.this.g.stroke(this.strokeState);
            if (!this.strokeOnState) {
                MultiProcessing.this.g.noStroke();
            }
            MultiProcessing.this.g.fill(this.fillState);
            if (!this.fillOnState) {
                MultiProcessing.this.g.noFill();
            }
            MultiProcessing.this.g.rectMode(this.rectModeState);
            MultiProcessing.this.g.ellipseMode(this.ellipseModeState);
            MultiProcessing.this.g.textMode(this.textModeState);
            if (this.textFontState != null) {
                MultiProcessing.this.g.textFont(this.textFontState);
            }
            MultiProcessing.this.g.colorMode(this.colorModeState);
            if (this.lightsOnState) {
                MultiProcessing.this.g.lights();
            } else {
                MultiProcessing.this.g.noLights();
            }
            if (this.smoothOnState) {
                MultiProcessing.this.g.smooth();
            } else {
                MultiProcessing.this.g.noSmooth();
            }
        }

        public Turtle spawn(Turtle turtle) {
            return turtle.spawn();
        }

        public Turtle spawn() {
            try {
                Constructor<?> constructor = this.getClass().getConstructor(null);
                Turtle turtle = (Turtle)constructor.newInstance(null);
                turtle.alive = true;
                turtle.age = 0;
                turtle.generation = this.generation + 1;
                turtle.doneFirstLoop = false;
                turtle.parent = this;
                this.addTurtle(turtle);
                turtle.saveState();
                turtle.stateInitialized = true;
                turtle.init();
                return turtle;
            }
            catch (Exception exception) {
                try {
                    Class[] classArray = new Class[]{multiApp.getClass()};
                    Object[] objectArray = new MultiProcessing[]{multiApp};
                    Constructor<?> constructor = this.getClass().getConstructor(classArray);
                    Turtle turtle = (Turtle)constructor.newInstance(objectArray);
                    turtle.alive = true;
                    turtle.age = 0;
                    turtle.generation = this.generation + 1;
                    turtle.doneFirstLoop = false;
                    turtle.parent = this;
                    this.addTurtle(turtle);
                    turtle.saveState();
                    turtle.stateInitialized = true;
                    turtle.init();
                    return turtle;
                }
                catch (Exception exception2) {
                    System.out.println("Spawn failed. " + exception2.getMessage());
                    exception2.printStackTrace();
                    return null;
                }
            }
        }

        void die() {
            this.alive = false;
            ++MultiProcessing.this.deadTurtles;
        }

        void init() {
        }

        void setup() {
        }

        void preloop() {
            if (!this.stateInitialized) {
                if (this.parent != null) {
                    this.parent.restoreState();
                }
                this.saveState();
                this.stateInitialized = true;
            } else {
                this.restoreState();
            }
            ++this.age;
            this.keyPressed = MultiProcessing.this.keyPressed;
            if (!this.doneFirstLoop) {
                MultiProcessing.this.push();
                this.setup();
                MultiProcessing.this.pop();
                this.firstLoop();
                this.doneFirstLoop = true;
            }
            if (this.doMousePressed) {
                this.doMousePressed = false;
                this.mousePressed();
            }
            if (this.doMouseReleased) {
                this.doMouseReleased = false;
                this.mouseReleased();
            }
            if (this.doKeyPressed) {
                this.doKeyPressed = false;
                this.keyPressed();
            }
            if (this.doKeyReleased) {
                this.doKeyReleased = false;
                this.keyReleased();
            }
        }

        void firstLoop() {
        }

        void loop() {
        }

        void postloop() {
            this.saveState();
            if (MultiProcessing.this.deadTurtles > 100) {
                this.compactTurtles();
            }
        }

        private final /* synthetic */ void this() {
            this.stateInitialized = false;
            this.doneFirstLoop = false;
            this.inLoop = false;
            this.numDeferredSpawns = 0;
            this.doMousePressed = false;
            this.doMouseReleased = false;
            this.doKeyPressed = false;
            this.doKeyReleased = false;
            this.matrix = new float[16];
            this.normalMat = new float[4][4];
        }

        public Turtle() {
            this.this();
            this.age = 0;
            this.generation = 0;
            this.alive = false;
            this.saveState();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ParticleSystem {
        float Gx;
        float Gy;
        float Gz;
        float timeStep;
        float time;
        float kDrag;
        int nParticles;
        int nForces;
        Particle[] particles;
        Force[] forces;
        public float defaultSpringRestLength;
        public float defaultKd;
        public float defaultKm;

        void drawSprings() {
            int n = 0;
            while (n < this.nForces) {
                if (this.forces[n] instanceof Spring) {
                    ((Spring)this.forces[n]).draw();
                }
                ++n;
            }
        }

        void init() {
            this.Gx = 0.0f;
            this.Gy = 0.03f;
            this.Gz = 0.0f;
            this.kDrag = 0.03f;
            this.defaultKd = 0.01f;
            this.defaultKm = 0.005f;
            this.defaultSpringRestLength = 18.0f;
            this.nParticles = 0;
            this.nForces = 0;
            this.timeStep = 0.5f;
        }

        void addParticle(Particle particle) {
            particle.pSystem = this;
            if (this.nParticles >= this.particles.length) {
                Particle[] particleArray = new Particle[this.nParticles + 500];
                System.arraycopy(this.particles, 0, particleArray, 0, this.nParticles);
                this.particles = particleArray;
            }
            this.particles[this.nParticles] = particle;
            ++this.nParticles;
        }

        void removeParticle(int n) {
            System.arraycopy(this.particles, n + 1, this.particles, n, this.nParticles - n - 1);
            this.particles[this.nParticles] = null;
            --this.nParticles;
        }

        void removeParticle(Particle particle) {
            int n = 0;
            while (n < this.nParticles) {
                if (this.particles[n] == particle) {
                    int n2 = 0;
                    while (n2 < this.nForces) {
                        if (this.forces[n2] instanceof Spring) {
                            if (((Spring)this.forces[n2]).a == particle || ((Spring)this.forces[n2]).b == particle) {
                                this.removeForce(n2);
                            }
                        } else if (this.forces[n2] instanceof Magnet) {
                            if (((Magnet)this.forces[n2]).a == particle) {
                                this.removeForce(n2);
                            }
                        } else if (this.forces[n2] instanceof CollisionForce && ((CollisionForce)this.forces[n2]).a == particle) {
                            this.removeForce(n2);
                        }
                        ++n2;
                    }
                    this.removeParticle(n);
                }
                ++n;
            }
        }

        void addForce(Force force) {
            if (this.nForces >= this.forces.length) {
                Force[] forceArray = new Force[this.nForces + 500];
                System.arraycopy(this.forces, 0, forceArray, 0, this.nForces);
                this.forces = forceArray;
            }
            this.forces[this.nForces] = force;
            ++this.nForces;
        }

        void removeForce(int n) {
            System.arraycopy(this.forces, n + 1, this.forces, n, this.nForces - n - 1);
            this.forces[this.nForces] = null;
            --this.nForces;
        }

        void removeForce(Force force) {
            int n = 0;
            while (n < this.nForces) {
                if (this.forces[n] == force) {
                    this.removeForce(n);
                }
                ++n;
            }
        }

        void zeroForces() {
            int n = 0;
            while (n < this.nParticles) {
                this.particles[n].clearForce();
                ++n;
            }
        }

        void applyForces() {
            Force force = null;
            int n = 0;
            while (n < this.nForces) {
                force = this.forces[n];
                if (force.on) {
                    force.applyForce();
                }
                ++n;
            }
            Particle particle = null;
            int n2 = 0;
            while (n2 < this.nParticles) {
                particle = this.particles[n2];
                if (!particle.fixed) {
                    particle.addForce(-this.kDrag * particle.velocity[0], -this.kDrag * particle.velocity[1], -this.kDrag * particle.velocity[2]);
                    particle.addForce(this.Gx, this.Gy, this.Gz);
                }
                ++n2;
            }
        }

        void applyForces(Particle particle) {
            if (particle.fixed) {
                return;
            }
            Force force = null;
            int n = 0;
            while (n < this.nForces) {
                force = this.forces[n];
                if (force.on) {
                    force.applyForce(particle);
                }
                ++n;
            }
            particle.addForce(-this.kDrag * particle.velocity[0], -this.kDrag * particle.velocity[1], -this.kDrag * particle.velocity[2]);
            particle.addForce(this.Gx, this.Gy, this.Gz);
        }

        void calcNextState() {
            this.calcNextState(this.timeStep);
        }

        void calcNextState(float f) {
            Particle particle = null;
            int n = 0;
            while (n < this.nParticles) {
                particle = this.particles[n];
                if (!particle.fixed) {
                    particle.calculateNext(f);
                }
                ++n;
            }
        }

        void updateState() {
            Particle particle = null;
            int n = 0;
            while (n < this.nParticles) {
                particle = this.particles[n];
                if (!particle.fixed) {
                    particle.updateNext();
                }
                ++n;
            }
        }

        private final /* synthetic */ void this() {
            this.nParticles = 0;
            this.nForces = 0;
            this.particles = new Particle[500];
            this.forces = new Force[500];
        }

        ParticleSystem() {
            this.this();
            this.init();
        }
    }

    public class Force {
        boolean on = true;

        void applyForce() {
        }

        void applyForce(Particle particle) {
        }

        Force() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Particle
    extends Turtle {
        ParticleSystem pSystem;
        boolean fixed;
        CollisionForce collisionForce;
        float mass;
        float collisionRadius;
        float minCollisionForce;
        float maxCollisionForce;
        float[] pos;
        float[] velocity;
        float[] force;
        float[] nextpos;
        float[] nextVelocity;
        float[] k1;
        float[] k2;
        float[] k3;
        float[] k4;
        float[] vsave;

        void die() {
            super.die();
            this.pSystem.removeParticle(this);
        }

        Particle[] particlesWithin(float f) {
            float f2 = MultiProcessing.this.sq(f);
            int n = 0;
            int n2 = 0;
            while (n2 < this.pSystem.nParticles) {
                if (this.pSystem.particles[n2] != this && MultiProcessing.this.distanceSq(this.pos, this.pSystem.particles[n2].pos) <= f2) {
                    ++n;
                }
                ++n2;
            }
            Particle[] particleArray = new Particle[n];
            n = 0;
            int n3 = 0;
            while (n3 < this.pSystem.nParticles) {
                if (this.pSystem.particles[n3] != this && MultiProcessing.this.distanceSq(this.pos, this.pSystem.particles[n3].pos) <= f2) {
                    particleArray[n] = this.pSystem.particles[n3];
                    ++n;
                }
                ++n3;
            }
            return particleArray;
        }

        void enableCollision() {
            if (this.collisionForce == null) {
                this.collisionForce = new CollisionForce(this);
                this.pSystem.addForce(this.collisionForce);
            }
        }

        void enableCollision(float f) {
            this.collisionRadius = f;
            this.enableCollision();
        }

        void disableCollision() {
            if (this.collisionForce != null) {
                this.collisionForce.on = false;
            }
        }

        void setPos(float f, float f2, float f3) {
            this.pos[0] = MultiProcessing.this.max(MultiProcessing.this.min(f, (float)(SYS_X_MAX - 1)), (float)SYS_X_START);
            this.pos[1] = MultiProcessing.this.max(MultiProcessing.this.min(f2, (float)(SYS_Y_MAX - 1)), (float)SYS_Y_START);
            this.pos[2] = MultiProcessing.this.max(MultiProcessing.this.min(f3, (float)(SYS_Z_MAX - 1)), (float)SYS_Z_START);
        }

        void setVelocity(float f, float f2, float f3) {
            this.velocity[0] = f;
            this.velocity[1] = f2;
            this.velocity[2] = f3;
        }

        void setForce(float f, float f2, float f3) {
            this.force[0] = f;
            this.force[1] = f2;
            this.force[2] = f3;
        }

        void addForce(float f, float f2, float f3) {
            this.force[0] = this.force[0] + f;
            this.force[1] = this.force[1] + f2;
            this.force[2] = this.force[2] + f3;
        }

        void clearForce() {
            this.force[0] = 0.0f;
            this.force[1] = 0.0f;
            this.force[2] = 0.0f;
        }

        void calculateNext(float f) {
            this.vsave[0] = this.velocity[0];
            this.vsave[1] = this.velocity[1];
            this.vsave[2] = this.velocity[2];
            this.k1[0] = f * this.force[0] / this.mass;
            this.k1[1] = f * this.force[1] / this.mass;
            this.k1[2] = f * this.force[2] / this.mass;
            this.velocity[0] = this.velocity[0] + this.k1[0] / 2.0f;
            this.velocity[1] = this.velocity[1] + this.k1[1] / 2.0f;
            this.velocity[2] = this.velocity[2] + this.k1[2] / 2.0f;
            this.clearForce();
            this.pSystem.applyForces(this);
            this.k2[0] = f * this.force[0] / this.mass;
            this.k2[1] = f * this.force[1] / this.mass;
            this.k2[2] = f * this.force[2] / this.mass;
            this.velocity[0] = this.vsave[0] + this.k2[0] / 2.0f;
            this.velocity[1] = this.vsave[1] + this.k2[1] / 2.0f;
            this.velocity[2] = this.vsave[2] + this.k2[2] / 2.0f;
            this.clearForce();
            this.pSystem.applyForces(this);
            this.k3[0] = f * this.force[0] / this.mass;
            this.k3[1] = f * this.force[1] / this.mass;
            this.k3[2] = f * this.force[2] / this.mass;
            this.velocity[0] = this.vsave[0] + this.k3[0];
            this.velocity[1] = this.vsave[1] + this.k3[1];
            this.velocity[2] = this.vsave[2] + this.k3[2];
            this.clearForce();
            this.pSystem.applyForces(this);
            this.k4[0] = f * this.force[0] / this.mass;
            this.k4[1] = f * this.force[1] / this.mass;
            this.k4[2] = f * this.force[2] / this.mass;
            this.velocity[0] = this.vsave[0];
            this.velocity[1] = this.vsave[1];
            this.velocity[2] = this.vsave[2];
            this.nextVelocity[0] = this.velocity[0] + (this.k1[0] + 2.0f * this.k2[0] + 2.0f * this.k3[0] + this.k4[0]) / 6.0f;
            this.nextVelocity[1] = this.velocity[1] + (this.k1[1] + 2.0f * this.k2[1] + 2.0f * this.k3[1] + this.k4[1]) / 6.0f;
            this.nextVelocity[2] = this.velocity[2] + (this.k1[2] + 2.0f * this.k2[2] + 2.0f * this.k3[2] + this.k4[2]) / 6.0f;
            this.nextpos[0] = this.pos[0] + f * this.nextVelocity[0];
            this.nextpos[1] = this.pos[1] + f * this.nextVelocity[1];
            this.nextpos[2] = this.pos[2] + f * this.nextVelocity[2];
        }

        void updateNext() {
            this.setPos(this.nextpos[0], this.nextpos[1], this.nextpos[2]);
            this.velocity[0] = this.nextVelocity[0];
            this.velocity[1] = this.nextVelocity[1];
            this.velocity[2] = this.nextVelocity[2];
        }

        void trace() {
        }

        private final /* synthetic */ void this() {
            this.collisionForce = null;
            this.pos = new float[3];
            this.velocity = new float[3];
            this.force = new float[3];
            this.nextpos = new float[3];
            this.nextVelocity = new float[3];
            this.k1 = new float[3];
            this.k2 = new float[3];
            this.k3 = new float[3];
            this.k4 = new float[3];
            this.vsave = new float[3];
        }

        Particle() {
            this.this();
            this.fixed = false;
            this.mass = 1.0f;
            this.collisionRadius = 10.0f;
            this.minCollisionForce = 1.0f;
            this.maxCollisionForce = 2.0f;
            this.pSystem = null;
            int n = 0;
            while (n < 3) {
                this.pos[n] = 0.0f;
                this.velocity[n] = 0.0f;
                this.force[n] = 0.0f;
                this.nextpos[n] = 0.0f;
                this.nextVelocity[n] = 0.0f;
                ++n;
            }
        }
    }

    public class Spring
    extends Force {
        Particle a;
        Particle b;
        float restLength;
        float strength;
        float damping;
        float dist;
        float Fx;
        float Fy;
        float Fz;
        float Lx;
        float Ly;
        float Lz;

        void draw() {
            MultiProcessing.this.line(this.a.pos[0], this.a.pos[1], this.a.pos[2], this.b.pos[0], this.b.pos[1], this.b.pos[2]);
        }

        void applyForce() {
            this.dist = MultiProcessing.this.distance(this.a.pos, this.b.pos);
            if (this.dist == 0.0f) {
                return;
            }
            this.Lx = this.a.pos[0] - this.b.pos[0];
            this.Ly = this.a.pos[1] - this.b.pos[1];
            this.Lz = this.a.pos[2] - this.b.pos[2];
            this.Fx = -(this.strength * (this.dist - this.restLength) + this.damping * (this.a.velocity[0] - this.b.velocity[0]) * this.Lx / this.dist) * this.Lx / this.dist;
            this.Fy = -(this.strength * (this.dist - this.restLength) + this.damping * (this.a.velocity[1] - this.b.velocity[1]) * this.Ly / this.dist) * this.Ly / this.dist;
            this.Fz = -(this.strength * (this.dist - this.restLength) + this.damping * (this.a.velocity[2] - this.b.velocity[2]) * this.Lz / this.dist) * this.Lz / this.dist;
            this.a.addForce(this.Fx, this.Fy, this.Fz);
            this.b.addForce(-this.Fx, -this.Fy, -this.Fz);
        }

        void applyForce(Particle particle) {
            if (this.a != particle && this.b != particle) {
                return;
            }
            this.dist = MultiProcessing.this.distance(this.a.pos, this.b.pos);
            if (this.dist == 0.0f) {
                return;
            }
            this.Lx = this.a.pos[0] - this.b.pos[0];
            this.Ly = this.a.pos[1] - this.b.pos[1];
            this.Lz = this.a.pos[2] - this.b.pos[2];
            this.Fx = -(this.strength * (this.dist - this.restLength) + this.damping * (this.a.velocity[0] - this.b.velocity[0]) * this.Lx / this.dist) * this.Lx / this.dist;
            this.Fy = -(this.strength * (this.dist - this.restLength) + this.damping * (this.a.velocity[1] - this.b.velocity[1]) * this.Ly / this.dist) * this.Ly / this.dist;
            this.Fz = -(this.strength * (this.dist - this.restLength) + this.damping * (this.a.velocity[2] - this.b.velocity[2]) * this.Lz / this.dist) * this.Lz / this.dist;
            if (this.a == particle) {
                this.a.addForce(this.Fx, this.Fy, this.Fz);
            } else {
                this.b.addForce(-this.Fx, -this.Fy, -this.Fz);
            }
        }

        Spring(Particle particle, Particle particle2) {
            this();
            this.a = particle;
            this.b = particle2;
        }

        Spring() {
            this.strength = MultiProcessing.this.pSystem.defaultKm;
            this.damping = MultiProcessing.this.pSystem.defaultKd;
            this.restLength = MultiProcessing.this.pSystem.defaultSpringRestLength;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Magnet
    extends Force {
        Particle a;
        float maxForce;
        int type;
        float strength;
        Vector ignoreTypes;
        float dist;
        float Fx;
        float Fy;
        float Fz;
        float Lx;
        float Ly;
        float Lz;
        float falloffStrength;

        void ignoreType(Particle particle) {
            if (this.ignoreTypes.contains(particle.getClass())) {
                return;
            }
            this.ignoreTypes.add(particle.getClass());
        }

        float falloff(float f) {
            if (f == 0.0f) {
                return 1.0f;
            }
            return 1.0f / f;
        }

        void applyForce() {
            int n = 0;
            while (n < MultiProcessing.this.pSystem.nParticles) {
                Particle particle = MultiProcessing.this.pSystem.particles[n];
                this.applyForce(particle);
                ++n;
            }
        }

        void applyForce(Particle particle) {
            if (this.a == particle) {
                return;
            }
            if (particle.fixed) {
                return;
            }
            Iterator iterator = this.ignoreTypes.iterator();
            while (iterator.hasNext()) {
                Class clazz = (Class)iterator.next();
                if (!clazz.isInstance(particle)) continue;
                return;
            }
            this.dist = MultiProcessing.this.distance(this.a.pos, particle.pos);
            this.Lx = this.a.pos[0] - particle.pos[0];
            this.Ly = this.a.pos[1] - particle.pos[1];
            this.Lz = this.a.pos[2] - particle.pos[2];
            this.falloffStrength = MultiProcessing.this.constrain(this.strength * this.falloff(this.dist), -MultiProcessing.this.abs(this.maxForce), MultiProcessing.this.abs(this.maxForce));
            this.Fx = this.falloffStrength * this.Lx / this.dist;
            this.Fy = this.falloffStrength * this.Ly / this.dist;
            this.Fz = this.falloffStrength * this.Lz / this.dist;
            particle.addForce(this.Fx, this.Fy, this.Fz);
        }

        private final /* synthetic */ void this() {
            this.ignoreTypes = new Vector();
        }

        Magnet() {
            this.this();
            this.type = 0;
            this.maxForce = 1.0f;
            this.strength = 1.0f;
        }

        Magnet(Particle particle) {
            this();
            this.a = particle;
        }
    }

    public class CollisionForce
    extends Force {
        Particle a;
        float radius;
        float minStrength;
        float maxStrength;
        float dist;
        float Fx;
        float Fy;
        float Fz;
        float Lx;
        float Ly;
        float Lz;

        float falloff(float f) {
            if (f == 0.0f) {
                return 1.0f;
            }
            return 1.0f / f;
        }

        void applyForce() {
            int n = 0;
            while (n < MultiProcessing.this.pSystem.nParticles) {
                Particle particle = MultiProcessing.this.pSystem.particles[n];
                this.applyForce(particle);
                ++n;
            }
        }

        void applyForce(Particle particle) {
            if (this.a == particle) {
                return;
            }
            if (particle.fixed || particle.collisionForce == null || !particle.collisionForce.on || this.a.collisionRadius + particle.collisionRadius <= 0.0f) {
                return;
            }
            this.minStrength = this.a.minCollisionForce;
            this.maxStrength = this.a.maxCollisionForce;
            this.radius = this.a.collisionRadius;
            this.dist = MultiProcessing.this.distance(this.a.pos, particle.pos);
            float f = this.dist - this.radius - particle.collisionRadius;
            if (f > 0.0f) {
                return;
            }
            float f2 = -f / (this.radius + particle.collisionRadius);
            float f3 = this.minStrength + f2 * (this.maxStrength - this.minStrength);
            this.Lx = this.a.pos[0] - particle.pos[0];
            this.Ly = this.a.pos[1] - particle.pos[1];
            this.Lz = this.a.pos[2] - particle.pos[2];
            this.Fx = -f3 * this.Lx / this.dist;
            this.Fy = -f3 * this.Ly / this.dist;
            this.Fz = -f3 * this.Lz / this.dist;
            particle.addForce(this.Fx, this.Fy, this.Fz);
        }

        CollisionForce(Particle particle) {
            this.a = particle;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ObjImport {
        BImage texture;
        float[][] verts;
        int[] vertLayers;
        float[][] normals;
        int[][] tris;
        int[][] triNorms;
        int[][] triTex;
        int[][] quads;
        int[][] quadNorms;
        int[][] quadTex;
        float[][] texCoords;
        Particle[] vertexParticles;
        float[][] centroids;
        int[] layerVertCounts;
        Particle[] centroidParticles;
        int nTris;
        int nQuads;
        int nVerts;
        int nNorms;
        int nTexCoords;
        int nLayers;
        boolean hasNorms;
        boolean hasParticles;
        boolean hasTexCoords;
        Vector layers;

        void setTexture(BImage bImage) {
            this.texture = bImage;
        }

        void setTexture(String string) {
            this.texture = MultiProcessing.this.loadImage(string);
        }

        void allocateArrays(int n, int n2, int n3) {
            this.verts = new float[3][n];
            this.texCoords = new float[2][n];
            this.vertLayers = new int[n];
            this.normals = new float[3][n];
            this.tris = new int[3][n2];
            this.triNorms = new int[3][n2];
            this.triTex = new int[3][n2];
            this.quads = new int[4][n3];
            this.quadNorms = new int[4][n3];
            this.quadTex = new int[4][n3];
            this.vertexParticles = new Particle[n];
            int n4 = 0;
            while (n4 < n) {
                this.vertexParticles[n4] = null;
                ++n4;
            }
        }

        boolean addSpringsToOriginalShape(String string) {
            return this.addSpringsToOriginalShape(string, 0.005f, 0.0f, 0.01f);
        }

        boolean addSpringsToOriginalShape(String string, float f) {
            return this.addSpringsToOriginalShape(string, f, 0.0f, 0.01f);
        }

        boolean addSpringsToOriginalShape(String string, float f, float f2, float f3) {
            int n = this.layers.indexOf(string);
            if (n < 0) {
                return false;
            }
            int n2 = 0;
            while (n2 < this.nVerts) {
                if (this.vertLayers[n2] == n && this.vertexParticles[n2] != null) {
                    Particle particle = new Particle();
                    MultiProcessing.this.pSystem.addParticle(particle);
                    particle.init();
                    particle.fixed = true;
                    particle.pos[0] = this.vertexParticles[n2].pos[0];
                    particle.pos[1] = this.vertexParticles[n2].pos[1];
                    particle.pos[2] = this.vertexParticles[n2].pos[2];
                    Spring spring = MultiProcessing.this.addSpring(this.vertexParticles[n2], particle);
                    spring.strength = f;
                    spring.restLength = f2;
                    spring.damping = f3;
                }
                ++n2;
            }
            return true;
        }

        boolean applyParticles(String string, Particle particle) {
            int n = this.layers.indexOf(string);
            if (n < 0) {
                return false;
            }
            int n2 = 0;
            while (n2 < this.nVerts) {
                if (this.vertLayers[n2] == n) {
                    this.applyParticle(n2, particle);
                }
                ++n2;
            }
            return true;
        }

        Particle attachParticleToCentroid(String string, Particle particle) {
            Particle particle2;
            int n = this.layers.indexOf(string);
            if (n < 0) {
                return null;
            }
            this.centroidParticles[n] = particle2 = MultiProcessing.this.spawnParticle(particle);
            particle2.fixed = true;
            this.hasParticles = true;
            return particle2;
        }

        boolean applyParticle(int n, Particle particle) {
            Particle particle2;
            if (n >= this.nVerts) {
                return false;
            }
            this.vertexParticles[n] = particle2 = MultiProcessing.this.spawnParticle(particle);
            particle2.pos[0] = this.verts[0][n];
            particle2.pos[1] = this.verts[1][n];
            particle2.pos[2] = this.verts[2][n];
            this.hasParticles = true;
            return true;
        }

        boolean allocateForObject(String string) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(MultiProcessing.this.loadStream(string)));
                String string2 = bufferedReader.readLine();
                String[] stringArray = null;
                n3 = 1;
                while (string2 != null) {
                    boolean bl = true;
                    try {
                        stringArray = MultiProcessing.splitStrings(string2, ' ');
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    if (bl) {
                        if (stringArray[0].equals("v")) {
                            ++n3;
                        } else if (stringArray[0].equals("f")) {
                            if (stringArray.length > 4) {
                                ++n2;
                            } else {
                                ++n;
                            }
                        }
                    }
                    string2 = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                return false;
            }
            this.allocateArrays(n3, n, n2);
            return true;
        }

        boolean load(String string) {
            this.allocateForObject(string);
            this.nTris = 0;
            this.nQuads = 0;
            this.nLayers = 0;
            int n = 0;
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(MultiProcessing.this.loadStream(string)));
                String string2 = bufferedReader.readLine();
                String[] stringArray = null;
                this.nVerts = 1;
                this.nNorms = 1;
                this.nTexCoords = 1;
                while (string2 != null) {
                    boolean bl = true;
                    try {
                        stringArray = MultiProcessing.splitStrings(string2, ' ');
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    if (bl) {
                        if (stringArray[0].equals("g")) {
                            if (!this.layers.contains(stringArray[1])) {
                                this.layers.add(stringArray[1]);
                                ++this.nLayers;
                            }
                            n = this.layers.indexOf(stringArray[1]);
                        } else if (stringArray[0].equals("v")) {
                            this.verts[0][this.nVerts] = Float.parseFloat(stringArray[1]);
                            this.verts[1][this.nVerts] = Float.parseFloat(stringArray[2]);
                            this.verts[2][this.nVerts] = Float.parseFloat(stringArray[3]);
                            this.vertLayers[this.nVerts] = n;
                            ++this.nVerts;
                        } else if (stringArray[0].equals("vn")) {
                            this.normals[0][this.nNorms] = Float.parseFloat(stringArray[1]);
                            this.normals[1][this.nNorms] = Float.parseFloat(stringArray[2]);
                            this.normals[2][this.nNorms] = Float.parseFloat(stringArray[3]);
                            ++this.nNorms;
                        } else if (stringArray[0].equals("vt")) {
                            this.texCoords[0][this.nTexCoords] = Float.parseFloat(stringArray[1]);
                            this.texCoords[1][this.nTexCoords] = Float.parseFloat(stringArray[2]);
                            ++this.nTexCoords;
                        } else if (stringArray[0].equals("f")) {
                            String[] stringArray2;
                            if (stringArray.length > 4) {
                                int n2 = 0;
                                while (n2 < 4) {
                                    stringArray2 = MultiProcessing.splitStrings(stringArray[n2 + 1], '/');
                                    this.quads[n2][this.nQuads] = Integer.parseInt(stringArray2[0]);
                                    if (this.hasTexCoords) {
                                        try {
                                            this.quadTex[n2][this.nQuads] = Integer.parseInt(stringArray2[1]);
                                        }
                                        catch (Exception exception) {
                                            this.hasTexCoords = false;
                                            System.err.println("Bad texture coords.");
                                        }
                                    }
                                    if (this.hasNorms) {
                                        try {
                                            this.quadNorms[n2][this.nQuads] = Integer.parseInt(stringArray2[2]);
                                        }
                                        catch (Exception exception) {
                                            this.hasNorms = false;
                                            System.err.println("Bad normals.");
                                        }
                                    }
                                    ++n2;
                                }
                                ++this.nQuads;
                            } else {
                                int n3 = 0;
                                while (n3 < 3) {
                                    stringArray2 = MultiProcessing.splitStrings(stringArray[n3 + 1], '/');
                                    this.tris[n3][this.nTris] = Integer.parseInt(stringArray2[0]);
                                    if (this.hasTexCoords) {
                                        try {
                                            this.triTex[n3][this.nTris] = Integer.parseInt(stringArray2[1]);
                                        }
                                        catch (Exception exception) {
                                            this.hasTexCoords = false;
                                            System.err.println("Bad texture coords.");
                                        }
                                    }
                                    if (this.hasNorms) {
                                        try {
                                            this.triNorms[n3][this.nTris] = Integer.parseInt(stringArray2[2]);
                                        }
                                        catch (Exception exception) {
                                            this.hasNorms = false;
                                            System.err.println("Bad normals.");
                                        }
                                    }
                                    ++n3;
                                }
                                ++this.nTris;
                            }
                        }
                    }
                    string2 = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                return false;
            }
            this.centroids = new float[3][this.nLayers];
            this.layerVertCounts = new int[this.nLayers];
            this.centroidParticles = new Particle[this.nLayers];
            int n4 = 0;
            while (n4 < this.nLayers) {
                this.centroidParticles[n4] = null;
                ++n4;
            }
            this.scale(10.0f);
            return true;
        }

        void update() {
            if (!this.hasParticles) {
                return;
            }
            int n = 0;
            while (n < this.nLayers) {
                this.centroids[0][n] = 0.0f;
                this.centroids[1][n] = 0.0f;
                this.centroids[2][n] = 0.0f;
                this.layerVertCounts[n] = 0;
                ++n;
            }
            n = 0;
            while (n < this.nVerts) {
                if (this.vertexParticles[n] != null) {
                    this.verts[0][n] = this.vertexParticles[n].pos[0];
                    this.verts[1][n] = this.vertexParticles[n].pos[1];
                    this.verts[2][n] = this.vertexParticles[n].pos[2];
                    float[] fArray = this.centroids[0];
                    int n2 = this.vertLayers[n];
                    fArray[n2] = fArray[n2] + this.vertexParticles[n].pos[0];
                    float[] fArray2 = this.centroids[1];
                    int n3 = this.vertLayers[n];
                    fArray2[n3] = fArray2[n3] + this.vertexParticles[n].pos[1];
                    float[] fArray3 = this.centroids[2];
                    int n4 = this.vertLayers[n];
                    fArray3[n4] = fArray3[n4] + this.vertexParticles[n].pos[2];
                }
                int n5 = this.vertLayers[n];
                this.layerVertCounts[n5] = this.layerVertCounts[n5] + 1;
                ++n;
            }
            n = 0;
            while (n < this.nLayers) {
                if (this.layerVertCounts[n] > 0) {
                    float[] fArray = this.centroids[0];
                    int n6 = n;
                    fArray[n6] = fArray[n6] / (float)this.layerVertCounts[n];
                    float[] fArray4 = this.centroids[1];
                    int n7 = n;
                    fArray4[n7] = fArray4[n7] / (float)this.layerVertCounts[n];
                    float[] fArray5 = this.centroids[2];
                    int n8 = n;
                    fArray5[n8] = fArray5[n8] / (float)this.layerVertCounts[n];
                    if (this.centroidParticles[n] != null) {
                        this.centroidParticles[n].setPos(this.centroids[0][n], this.centroids[1][n], this.centroids[2][n]);
                    }
                }
                ++n;
            }
        }

        float mag(float[] fArray) {
            return (float)Math.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2]);
        }

        void scale(float f) {
            int n = 0;
            while (n < this.nVerts) {
                float[] fArray = this.verts[0];
                int n2 = n;
                fArray[n2] = fArray[n2] * f;
                float[] fArray2 = this.verts[1];
                int n3 = n;
                fArray2[n3] = fArray2[n3] * f;
                float[] fArray3 = this.verts[2];
                int n4 = n++;
                fArray3[n4] = fArray3[n4] * f;
            }
        }

        void draw() {
            int n;
            boolean bl = false;
            if (this.hasTexCoords && this.texture != null) {
                bl = true;
            }
            boolean bl2 = bl;
            MultiProcessing.this.mg.forceGouraud = true;
            MultiProcessing.this.beginShape(64);
            if (bl2) {
                MultiProcessing.this.g.texture(this.texture);
                MultiProcessing.this.g.textureMode(0);
            }
            int n2 = 0;
            while (n2 < this.nTris) {
                n = 0;
                while (n < 3) {
                    if (this.hasNorms) {
                        MultiProcessing.this.normal(this.normals[0][this.triNorms[n][n2]], this.normals[1][this.triNorms[n][n2]], this.normals[2][this.triNorms[n][n2]]);
                    }
                    if (bl2) {
                        MultiProcessing.this.g.vertex_texture(this.texCoords[0][this.triTex[n][n2]], this.texCoords[1][this.triTex[n][n2]]);
                    }
                    MultiProcessing.this.vertex(this.verts[0][this.tris[n][n2]], this.verts[1][this.tris[n][n2]], this.verts[2][this.tris[n][n2]]);
                    ++n;
                }
                ++n2;
            }
            MultiProcessing.this.endShape();
            MultiProcessing.this.beginShape(128);
            if (bl2) {
                MultiProcessing.this.g.texture(this.texture);
                MultiProcessing.this.g.textureMode(0);
            }
            n2 = 0;
            while (n2 < this.nQuads) {
                n = 0;
                while (n < 4) {
                    if (this.hasNorms) {
                        MultiProcessing.this.normal(this.normals[0][this.quadNorms[n][n2]], this.normals[1][this.quadNorms[n][n2]], this.normals[2][this.quadNorms[n][n2]]);
                    }
                    if (bl2) {
                        MultiProcessing.this.g.vertex_texture(this.texCoords[0][this.quadTex[n][n2]], this.texCoords[1][this.quadTex[n][n2]]);
                    }
                    MultiProcessing.this.vertex(this.verts[0][this.quads[n][n2]], this.verts[1][this.quads[n][n2]], this.verts[2][this.quads[n][n2]]);
                    ++n;
                }
                ++n2;
            }
            MultiProcessing.this.endShape();
            MultiProcessing.this.mg.forceGouraud = false;
        }

        private final /* synthetic */ void this() {
            this.texture = null;
            this.hasNorms = true;
            this.hasParticles = false;
            this.hasTexCoords = true;
            this.layers = new Vector();
        }

        ObjImport() {
            this.this();
            MultiProcessing.this.importedObjects.add(this);
        }

        ObjImport(String string) {
            this.this();
            this.load(string);
            MultiProcessing.this.importedObjects.add(this);
        }
    }
}

