/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import java.util.Vector;

public class InternetIncome
extends BApplet {
    String[] logo = new String[]{"**", "**", "**", "**  ** ** ** ****  ****** ***", "** **  *****    ** **   **  **", "****   **    ***** **   **  **", "** **  **   **  ** **   **  **", "**  ** **    ***** **   **  **"};
    static int MAX_NUM_IMAGES = 300;
    static int NUM_IMAGE_FILES = 16;
    imageDownloader theDownloader;
    Vector frameImages = new Vector();
    static int frameImageWidth = 16;
    static int frameImageHeight = 16;
    particle[][] pixelParticles = new particle[frameImageWidth][frameImageHeight];
    int[] framePixels = new int[frameImageWidth * frameImageHeight];
    Image frameOffImage;
    Graphics frameOffGraphics;
    PixelGrabber framePixelGrabber;
    int numImagesLoaded = 0;
    int thisImageIndex = 0;
    long lastFrameTime = 0L;
    particle cameraRotation = new particle(3.0f, 0.7f, (float)Math.PI, 1.0f, 1.0f);
    float[] cameraRotationDestination = new float[3];
    long creditTextTimer;

    void setup() {
        this.size(300, 300);
        this.background(49.0f, 81.0f, 74.0f);
        this.noStroke();
        this.colorMode(0, 100.0f);
        int n = 0;
        while (n < frameImageWidth) {
            int n2 = 0;
            while (n2 < frameImageHeight) {
                this.pixelParticles[n][n2] = new particle(4.0f, 0.8f, 0.0f, 0.0f, 0.0f);
                ++n2;
            }
            ++n;
        }
        this.creditTextTimer = this.millis();
    }

    void mousePressed() {
        this.cameraRotationDestination[0] = (float)(this.mouseX - this.width / 2) / 2.0f * ((float)Math.PI / 180);
        this.cameraRotationDestination[1] = (float)(this.mouseY - this.height / 2) / 2.0f * ((float)Math.PI / 180);
        this.cameraRotationDestination[2] = 100.0f;
    }

    void mouseDragged() {
        this.cameraRotationDestination[0] = (float)(this.mouseX - this.width / 2) / 2.0f * ((float)Math.PI / 180);
        this.cameraRotationDestination[1] = (float)(this.mouseY - this.height / 2) / 2.0f * ((float)Math.PI / 180);
        this.cameraRotationDestination[2] = 100.0f;
    }

    void mouseReleased() {
        this.cameraRotationDestination[0] = 0.0f;
        this.cameraRotationDestination[1] = 0.0f;
        this.cameraRotationDestination[2] = 0.0f;
    }

    void drawBoxTop(float f, float f2, float f3, float f4, float f5, float f6) {
        this.beginShape(128);
        this.vertex(f, f4, f6);
        this.vertex(f, f3, f6);
        this.vertex(f2, f3, f6);
        this.vertex(f2, f4, f6);
        this.vertex(f2, f4, f6);
        this.vertex(f2, f3, f6);
        this.vertex(f2, f3, f5);
        this.vertex(f2, f4, f5);
        this.vertex(f2, f4, f5);
        this.vertex(f2, f3, f5);
        this.vertex(f, f3, f5);
        this.vertex(f, f4, f5);
        this.vertex(f, f4, f5);
        this.vertex(f, f3, f5);
        this.vertex(f, f3, f6);
        this.vertex(f, f4, f6);
        this.endShape();
    }

    static Color getPixelColor(int[] nArray, int n, int n2, int n3) {
        int n4 = nArray[n2 * n3 + n];
        int n5 = n4 >> 24 & 0xFF;
        int n6 = n4 >> 16 & 0xFF;
        int n7 = n4 >> 8 & 0xFF;
        int n8 = n4 & 0xFF;
        return new Color(n6, n7, n8);
    }

    void drawLogo(int n, int n2) {
        int n3 = this.color(100.0f, 100.0f, 100.0f);
        int n4 = 0;
        while (n4 < this.logo.length) {
            String string = this.logo[n4];
            int n5 = this.max(0, -n);
            while (n5 < string.length()) {
                if (string.charAt(n5) != ' ') {
                    this.setPixel(n + n5, n2 + n4, n3);
                }
                ++n5;
            }
            ++n4;
        }
    }

    void loop() {
        if (this.frameOffImage == null || this.frameOffGraphics == null) {
            this.theDownloader = new imageDownloader(this);
            int n = 0;
            while (n < NUM_IMAGE_FILES) {
                this.theDownloader.downloadFile("media/images" + n + ".jpg");
                ++n;
            }
            this.frameOffImage = this.createImage(frameImageWidth, frameImageHeight);
            this.frameOffGraphics = this.frameOffImage.getGraphics();
            this.creditTextTimer = this.millis();
        }
        this.cameraRotation.iterate(this.cameraRotationDestination[0] - this.cameraRotation.x, this.cameraRotationDestination[1] - this.cameraRotation.y, this.cameraRotationDestination[2] - this.cameraRotation.z);
        long l = this.millis();
        Vector vector = this.theDownloader.fetchDownloadedImages();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                this.frameImages.addElement(vector.elementAt(n));
                ++n;
            }
        }
        if (l - this.lastFrameTime > 450L) {
            this.thisImageIndex = this.thisImageIndex < MAX_NUM_IMAGES - 1 && this.frameImages.size() > this.thisImageIndex + 1 && (this.checkImage((Image)this.frameImages.elementAt(this.thisImageIndex + 1), null) & 0x20) != 0 ? ++this.thisImageIndex : 0;
            this.lastFrameTime = l;
        }
        if (this.frameImages.size() < 1 || (this.checkImage((Image)this.frameImages.elementAt(this.thisImageIndex), null) & 0x20) == 0) {
            return;
        }
        this.frameOffGraphics.drawImage((Image)this.frameImages.elementAt(this.thisImageIndex), 0, 0, null);
        this.framePixelGrabber = new PixelGrabber(this.frameOffImage, 0, 0, frameImageWidth, frameImageHeight, this.framePixels, 0, frameImageWidth);
        try {
            this.framePixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return;
        }
        catch (Exception exception) {
            System.out.println("grabbing pixels>>>>" + exception.toString());
            exception.printStackTrace(System.out);
        }
        if ((this.framePixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return;
        }
        int n = 0;
        while (n < frameImageWidth - 1) {
            int n2 = 0;
            while (n2 < frameImageHeight - 1) {
                Color color = InternetIncome.getPixelColor(this.framePixels, n, n2, frameImageWidth);
                this.pixelParticles[n][n2].iterate((float)(color.getRed() * 100 / 255) - this.pixelParticles[n][n2].x, (float)(color.getGreen() * 100 / 255) - this.pixelParticles[n][n2].y, (float)(color.getBlue() * 100 / 255) - this.pixelParticles[n][n2].z);
                ++n2;
            }
            ++n;
        }
        this.push();
        this.translate(this.width / 2, this.height / 2, 0.0f);
        this.rotateY(this.cameraRotation.x);
        this.rotateX(-this.cameraRotation.y);
        float f = (float)frameImageWidth / 2.0f - 1.0f;
        float f2 = (float)frameImageHeight / 2.0f - 1.0f;
        float f3 = 4.0f;
        int n3 = 0;
        while (n3 < frameImageWidth - 1) {
            int n4 = 0;
            while (n4 < frameImageHeight - 1) {
                float f4 = 3.0f * ((float)n3 - f);
                float f5 = 3.0f * ((float)n4 - f2);
                int n5 = this.color(this.pixelParticles[n3][n4].x, this.pixelParticles[n3][n4].y, this.pixelParticles[n3][n4].z);
                float f6 = this.red(n5) / 6.0f;
                this.push();
                this.translate(f3 * f4, f3 * f5);
                this.fill(this.red(n5), this.green(n5), this.blue(n5));
                this.drawBoxTop(-f3, f3, -f3, f3, -f3 * f6, f3 * f6);
                this.pop();
                ++n4;
            }
            ++n3;
        }
        this.pop();
        if (l - this.creditTextTimer <= 15000L) {
            this.drawLogo(5, this.height - 5 - 8);
        } else if (l - this.creditTextTimer < 18000L) {
            this.drawLogo((int)(5.0 - (double)(60L * (l - this.creditTextTimer - 15000L)) / 700.0), this.height - 5 - 8);
        }
    }

    class particle {
        float x;
        float y;
        float z;
        float Vx;
        float Vy;
        float Vz;
        float Ax;
        float Ay;
        float Az;
        float mass;
        float drag;

        particle(float f, float f2, float f3, float f4, float f5) {
            this.x = f3;
            this.y = f4;
            this.z = f5;
            this.Vx = 0.0f;
            this.Vy = 0.0f;
            this.Vz = 0.0f;
            this.Ax = 0.0f;
            this.Ay = 0.0f;
            this.Az = 0.0f;
            this.mass = f;
            this.drag = f2;
        }

        void iterate(float f, float f2, float f3) {
            float f4 = f;
            float f5 = f2;
            float f6 = f3;
            this.Ax = f4 / this.mass;
            this.Ay = f5 / this.mass;
            this.Az = f6 / this.mass;
            this.Vx += this.Ax;
            this.Vy += this.Ay;
            this.Vz += this.Az;
            this.Vx *= 1.0f - this.drag;
            this.Vy *= 1.0f - this.drag;
            this.Vz *= 1.0f - this.drag;
            this.x += this.Vx;
            this.y += this.Vy;
            this.z += this.Vz;
        }
    }

    class imageDownloader
    implements Runnable {
        Vector imagesToDownload;
        Vector inbox;
        Thread runner;
        BApplet parent;

        public imageDownloader(BApplet bApplet) {
            this.parent = bApplet;
            this.imagesToDownload = new Vector();
            this.inbox = new Vector();
            this.runner = new Thread(this);
        }

        public void downloadFile(String string) {
            this.imagesToDownload.addElement(string);
            if (!this.runner.isAlive()) {
                this.runner.start();
            }
        }

        public Vector fetchDownloadedImages() {
            Vector vector = (Vector)this.inbox.clone();
            if (this.inbox != null) {
                this.inbox.removeAllElements();
            }
            if (this.imagesToDownload.size() < 1 && this.runner.isAlive()) {
                this.runner.stop();
            }
            return vector;
        }

        public void run() {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = null;
            while (true) {
                try {
                    while (true) {
                        if (image != null && (toolkit.checkImage(image, -1, -1, null) & 0x20) != 0) {
                            int n = image.getWidth(null);
                            int n2 = 0;
                            while (n2 < image.getHeight(null) / n) {
                                Image image2 = this.parent.createImage(n, n);
                                if (image2 == null) {
                                    System.out.println("unable to allocate offscreen graphics. need more memory.");
                                    break;
                                }
                                Graphics graphics = image2.getGraphics();
                                graphics.drawImage(image, 0, 0, 16, 16, 0, n2 * n, 16, (n2 + 1) * n - 1, null);
                                this.inbox.addElement(image2);
                                ++n2;
                            }
                            image = null;
                        }
                        Thread.sleep(200L);
                        if (image != null || this.imagesToDownload.size() <= 0) continue;
                        String string = (String)this.imagesToDownload.elementAt(0);
                        this.imagesToDownload.removeElementAt(0);
                        image = toolkit.getImage(this.getClass().getResource(string));
                        toolkit.prepareImage(image, -1, -1, null);
                    }
                }
                catch (Exception exception) {
                    System.out.println("downloading image >>>>" + exception.toString());
                    exception.printStackTrace(System.out);
                    continue;
                }
                break;
            }
        }
    }
}

