/*
 * Decompiled with CFR 0.152.
 */
public class sodaprocessing
extends BApplet {
    Mass[] masses;
    int massCount;
    float mouseTolerance;
    Mass dragMass;
    float dragDx;
    float dragDy;
    float tempDistance;
    Mass drawMass;
    Mass overMass;
    Spring[] springs;
    int springCount;
    Spring overSpring;
    Control[] controls;
    Control activeControl;
    Button make;
    Button move;
    Button delete;
    Slider g;
    Slider f;
    Slider k;
    int sliderHeight;
    static final float speedFrictionThreshold = 20.0f;
    BFont font;
    int mode;
    static final int MAKE = 0;
    static final int MOVE = 1;
    static final int DELETE = 2;
    String[] toolTips;

    void setup() {
        this.size(280, 255);
        this.background(255);
        this.ellipseMode(3);
        this.masses = new Mass[8];
        this.springs = new Spring[8];
        this.font = this.loadFont("RotisSanSer-Bold.vlw.gz");
        this.setFont(this.font, 15.0f);
        this.hint(0);
        this.smooth();
        this.controls = new Control[6];
        boolean bl = false;
        int n = 0;
        int n2 = this.width / this.controls.length + 1;
        int n3 = n++;
        this.make = new Button(0, 0, n2 - 1, this.sliderHeight, "make");
        this.controls[n3] = this.make;
        int n4 = n++;
        this.move = new Button(this.controls[n - 2].x + this.controls[n - 2].w, 0, n2 - 1, this.sliderHeight, "move");
        this.controls[n4] = this.move;
        int n5 = n++;
        this.delete = new Button(this.controls[n - 2].x + this.controls[n - 2].w, 0, n2 - 1, this.sliderHeight, "delete");
        this.controls[n5] = this.delete;
        int n6 = n++;
        this.g = new Slider(this.controls[n - 2].x + this.controls[n - 2].w, 0, n2, this.sliderHeight, 0.0f, 4.0f, 0.0f, "g");
        this.controls[n6] = this.g;
        int n7 = n++;
        this.f = new Slider(this.controls[n - 2].x + this.controls[n - 2].w, 0, n2, this.sliderHeight, 0.0f, 1.0f, 0.1f, "f");
        this.controls[n7] = this.f;
        int n8 = n++;
        this.k = new Slider(this.controls[n - 2].x + this.controls[n - 2].w, 0, n2, this.sliderHeight, 0.0f, 0.75f, 0.5f, "k");
        this.controls[n8] = this.k;
        this.make.selected = true;
        this.checkMode();
        this.toolTips = new String[]{": click to make masses and springs", ": click, drag and throw masses", ": click to delete masses and springs", " = gravity (hint, set to zero to before choosing to make)", " = friction", " = spring stiffness"};
    }

    void loop() {
        this.doUpdate();
        this.display();
    }

    void checkMode() {
        int n = 0;
        while (n < this.controls.length) {
            if (this.controls[n] instanceof Button && ((Button)this.controls[n]).selected) {
                this.mode = n;
            }
            ++n;
        }
        if (this.mode != 0) {
            this.drawMass = null;
        }
    }

    void mouseMoved() {
        int n = 0;
        while (n < this.controls.length) {
            this.controls[n].mouseIn();
            ++n;
        }
        this.tempDistance = -1.0f;
        Mass mass = null;
        if (this.mode == 1 || this.mode == 0 || this.mode == 2) {
            mass = this.mouseMass();
        }
        float f = this.tempDistance;
        this.tempDistance = -1.0f;
        Spring spring = null;
        if (this.mode == 2) {
            spring = this.mouseSpring();
        }
        float f2 = this.tempDistance;
        if (!(mass == null || f == -1.0f || f > f2 && f2 != -1.0f || f >= this.mouseTolerance)) {
            this.overMass = mass;
            this.overSpring = null;
            return;
        }
        if (!(spring == null || f2 == -1.0f || f2 >= f && f != -1.0f || f2 >= this.mouseTolerance)) {
            this.overSpring = spring;
            this.overMass = null;
            return;
        }
        this.overMass = null;
        this.overSpring = null;
    }

    void mouseDragged() {
        if (this.activeControl != null) {
            this.activeControl.mouseDragged();
            return;
        }
        if (this.dragMass != null) {
            this.dragMass.x = (float)this.mouseX + this.dragDx;
            this.dragMass.y = (float)this.mouseY + this.dragDy;
            this.dragMass.xv = this.mouseX - this.pmouseX;
            this.dragMass.yv = this.mouseY - this.pmouseY;
            this.dragMass.clamp();
        }
    }

    void mouseReleased() {
        if (this.activeControl != null) {
            if (this.activeControl.mouseReleased() && this.activeControl instanceof Button) {
                int n = 0;
                while (n < this.controls.length) {
                    if (this.controls[n] != this.activeControl && this.controls[n] instanceof Button) {
                        ((Button)this.controls[n]).selected = false;
                    }
                    ++n;
                }
                this.checkMode();
            }
            this.activeControl = null;
        }
        if (this.dragMass != null) {
            if (this.overMass == this.dragMass) {
                this.overMass = null;
            }
            this.dragMass = null;
        }
    }

    void mousePressed() {
        this.activeControl = null;
        int n = 0;
        while (n < this.controls.length && this.activeControl == null) {
            if (!(!this.controls[n].mousePressed() || this.controls[n] instanceof Button && ((Button)this.controls[n]).selected)) {
                this.activeControl = this.controls[n];
            }
            ++n;
        }
        if (this.activeControl == null) {
            switch (this.mode) {
                case 0: {
                    Mass mass = this.mouseMass();
                    if (mass != null && !(this.tempDistance >= this.mouseTolerance)) {
                        if (this.drawMass != null) {
                            if (this.drawMass != mass) {
                                boolean bl = false;
                                int n2 = 0;
                                while (n2 < this.springCount && !bl) {
                                    bl = this.springs[n2].a == this.drawMass && this.springs[n2].b == mass || this.springs[n2].b == this.drawMass && this.springs[n2].a == mass;
                                    ++n2;
                                }
                                if (!bl) {
                                    this.addSpring(new Spring(this.drawMass, mass));
                                }
                            }
                            this.drawMass = null;
                            return;
                        }
                        this.drawMass = mass;
                        return;
                    }
                    Mass mass2 = new Mass(this.mouseX, this.mouseY);
                    this.addMass(mass2);
                    if (this.drawMass != null) {
                        this.addSpring(new Spring(this.drawMass, mass2));
                    }
                    this.drawMass = mass2;
                    return;
                }
                case 1: {
                    Mass mass = this.mouseMass();
                    if (mass != null && !(this.tempDistance >= this.mouseTolerance)) {
                        this.overMass = this.dragMass = mass;
                        this.dragDx = mass.x - (float)this.mouseX;
                        this.dragDy = mass.y - (float)this.mouseY;
                        return;
                    }
                    this.dragMass = null;
                    this.overMass = null;
                    return;
                }
                case 2: {
                    if (this.overMass != null) {
                        int n3 = 0;
                        while (n3 < this.springCount) {
                            if (this.springs[n3].a == this.overMass || this.springs[n3].b == this.overMass) {
                                this.deleteSpring(this.springs[n3--]);
                            }
                            ++n3;
                        }
                        this.deleteMass(this.overMass);
                        if (this.overMass == this.dragMass) {
                            this.dragMass = null;
                        }
                        this.overMass = null;
                        return;
                    }
                    if (this.overSpring == null) break;
                    this.deleteSpring(this.overSpring);
                    this.overSpring = null;
                }
            }
        }
    }

    Mass mouseMass() {
        this.tempDistance = -1.0f;
        Mass mass = null;
        int n = 0;
        while (n < this.massCount) {
            float f = this.masses[n].distanceTo(this.mouseX, this.mouseY);
            if (!(f == -1.0f || f >= this.tempDistance && this.tempDistance != -1.0f)) {
                this.tempDistance = f;
                mass = this.masses[n];
            }
            ++n;
        }
        return mass;
    }

    Spring mouseSpring() {
        this.tempDistance = -1.0f;
        Spring spring = null;
        int n = 0;
        while (n < this.springCount) {
            float f = this.springs[n].distanceTo(this.mouseX, this.mouseY);
            if (!(f == -1.0f || f >= this.tempDistance && this.tempDistance != -1.0f)) {
                this.tempDistance = f;
                spring = this.springs[n];
            }
            ++n;
        }
        return spring;
    }

    void doUpdate() {
        int n = 0;
        while (n < this.springCount) {
            this.springs[n].applyForces();
            ++n;
        }
        n = 0;
        while (n < this.massCount) {
            if (this.masses[n] != this.dragMass) {
                this.masses[n].update();
            }
            ++n;
        }
    }

    void display() {
        this.stroke(0.0f, 153.0f, 255.0f);
        this.fill(255.0f, 255.0f, 255.0f);
        this.rect(0.0f, 0.0f, this.width - 1, this.height - 1);
        int n = 0;
        while (n < this.springCount) {
            this.springs[n].display();
            ++n;
        }
        if (this.drawMass != null) {
            this.stroke(0.0f, 153.0f, 255.0f);
            this.line(this.drawMass.x, this.drawMass.y, this.mouseX, this.mouseY);
        }
        n = 0;
        while (n < this.massCount) {
            this.masses[n].display();
            ++n;
        }
        n = 0;
        while (n < this.controls.length) {
            this.controls[n].display();
            ++n;
        }
        this.fill(0.0f, 153.0f, 255.0f);
        n = 0;
        while (n < this.controls.length) {
            if (this.controls[n].over) {
                this.text(this.controls[n].label + this.toolTips[n], 2.0f, (float)(this.sliderHeight * 3 - 3));
            }
            ++n;
        }
    }

    void addMass(Mass mass) {
        if (this.massCount == this.masses.length) {
            Mass[] massArray = new Mass[this.massCount * 2];
            System.arraycopy(this.masses, 0, massArray, 0, this.massCount);
            this.masses = massArray;
        }
        this.masses[this.massCount++] = mass;
    }

    void deleteMass(Mass mass) {
        int n = this.massIndex(mass);
        if (n >= 0) {
            this.deleteMassIndex(n);
        }
    }

    void deleteMassIndex(int n) {
        if (n < this.massCount) {
            System.arraycopy(this.masses, n + 1, this.masses, n, this.massCount - n);
        }
        this.massCount += -1;
    }

    int massIndex(Mass mass) {
        int n = 0;
        while (n < this.massCount) {
            if (this.masses[n] == mass) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void addSpring(Spring spring) {
        if (this.springCount == this.springs.length) {
            Spring[] springArray = new Spring[this.springCount * 2];
            System.arraycopy(this.springs, 0, springArray, 0, this.springCount);
            this.springs = springArray;
        }
        this.springs[this.springCount++] = spring;
    }

    void deleteSpring(Spring spring) {
        int n = this.springIndex(spring);
        if (n >= 0) {
            this.deleteSpringIndex(n);
        }
    }

    void deleteSpringIndex(int n) {
        if (n < this.springCount) {
            System.arraycopy(this.springs, n + 1, this.springs, n, this.springCount - n);
        }
        this.springCount += -1;
    }

    int springIndex(Spring spring) {
        int n = 0;
        while (n < this.springCount) {
            if (this.springs[n] == spring) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public sodaprocessing() {
        this.Block$();
    }

    private void Block$() {
        this.massCount = 0;
        this.mouseTolerance = 15.0f;
        this.dragMass = null;
        this.drawMass = null;
        this.springCount = 0;
        this.activeControl = null;
        this.sliderHeight = 13;
    }

    class Mass {
        static final float diamter = 5.0f;
        static final float radius = 3.5f;
        float x;
        float y;
        float xv;
        float yv;

        Mass(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        void update() {
            this.yv += sodaprocessing.this.g.value;
            double d = sodaprocessing.this.sqrt(this.xv * this.xv + this.yv * this.yv);
            double d2 = 1.0f - sodaprocessing.this.f.value;
            if (d > 20.0) {
                d2 *= 20.0 / d;
            }
            this.xv *= (float)d2;
            this.yv *= (float)d2;
            this.x += this.xv;
            this.y += this.yv;
            if (!(this.x >= 3.5f)) {
                this.x -= this.x - 3.5f;
                this.xv = -this.xv;
            } else if (this.x > (float)sodaprocessing.this.width - 3.5f) {
                this.x -= this.x - ((float)sodaprocessing.this.width - 3.5f);
                this.xv = -this.xv;
            }
            if (!(this.y >= (float)sodaprocessing.this.sliderHeight + 3.5f)) {
                this.y -= this.y - ((float)sodaprocessing.this.sliderHeight + 3.5f);
                this.yv = -this.yv;
                return;
            }
            if (this.y > (float)sodaprocessing.this.height - 3.5f) {
                this.y -= this.y - ((float)sodaprocessing.this.height - 3.5f);
                this.yv = -this.yv;
            }
        }

        void clamp() {
            if (!(this.x >= 3.5f)) {
                this.x = 3.5f;
            } else if (this.x > (float)sodaprocessing.this.width - 3.5f) {
                this.x = (float)sodaprocessing.this.width - 3.5f;
            }
            if (!(this.y >= (float)sodaprocessing.this.sliderHeight + 3.5f)) {
                this.y = (float)sodaprocessing.this.sliderHeight + 3.5f;
                return;
            }
            if (this.y > (float)sodaprocessing.this.height - 3.5f) {
                this.y = (float)sodaprocessing.this.height - 3.5f;
            }
        }

        void display() {
            if (this == sodaprocessing.this.overMass) {
                sodaprocessing.this.stroke(0.0f, 153.0f, 255.0f);
                sodaprocessing.this.line(this.x, this.y, sodaprocessing.this.mouseX, sodaprocessing.this.mouseY);
                sodaprocessing.this.noStroke();
                sodaprocessing.this.fill(0.0f, 153.0f, 255.0f);
            } else {
                sodaprocessing.this.noStroke();
                sodaprocessing.this.fill(0);
            }
            sodaprocessing.this.ellipse(this.x, this.y, 5.0f, 5.0f);
        }

        float distanceTo(Mass mass) {
            return this.distanceTo(mass.x, mass.y);
        }

        float distanceTo(float f, float f2) {
            float f3 = this.x - f;
            float f4 = this.y - f2;
            return sodaprocessing.this.sqrt(f3 * f3 + f4 * f4);
        }
    }

    class Spring {
        Mass a;
        Mass b;
        float restLength;

        Spring(Mass mass, Mass mass2) {
            this.a = mass;
            this.b = mass2;
            this.restLength = mass.distanceTo(mass2);
        }

        void display() {
            if (this == sodaprocessing.this.overSpring) {
                sodaprocessing.this.stroke(0.0f, 153.0f, 255.0f);
                float f = this.b.x - this.a.x;
                float f2 = this.b.y - this.a.y;
                float f3 = f * f + f2 * f2;
                float f4 = (float)sodaprocessing.this.mouseX - this.a.x;
                float f5 = (float)sodaprocessing.this.mouseY - this.a.y;
                float f6 = f * f4 + f2 * f5;
                float f7 = f6 / f3;
                f7 = sodaprocessing.this.min(f7, 1.0f);
                f7 = sodaprocessing.this.max(f7, 0.0f);
                float f8 = this.b.x * f7 + this.a.x * (1.0f - f7);
                float f9 = this.b.y * f7 + this.a.y * (1.0f - f7);
                sodaprocessing.this.line(f8, f9, sodaprocessing.this.mouseX, sodaprocessing.this.mouseY);
            } else {
                sodaprocessing.this.stroke(0);
            }
            sodaprocessing.this.line(this.a.x, this.a.y, this.b.x, this.b.y);
        }

        void applyForces() {
            double d = this.a.distanceTo(this.b);
            if (d > 0.0) {
                double d2 = (d - (double)this.restLength) * (double)sodaprocessing.this.k.value;
                double d3 = d2 / d * (double)(this.a.x - this.b.x);
                double d4 = d2 / d * (double)(this.a.y - this.b.y);
                this.a.xv -= (float)d3;
                this.a.yv -= (float)d4;
                this.b.xv += (float)d3;
                this.b.yv += (float)d4;
            }
        }

        float distanceTo(float f, float f2) {
            if (f > sodaprocessing.this.min(this.a.x, this.b.x) - sodaprocessing.this.mouseTolerance && !(f >= sodaprocessing.this.max(this.a.x, this.b.x) + sodaprocessing.this.mouseTolerance) && f2 > sodaprocessing.this.min(this.a.y, this.b.y) - sodaprocessing.this.mouseTolerance && !(f2 >= sodaprocessing.this.max(this.a.y, this.b.y) + sodaprocessing.this.mouseTolerance)) {
                float f3 = this.b.x - this.a.x;
                float f4 = f - this.a.x;
                float f5 = this.b.y - this.a.y;
                float f6 = f2 - this.a.y;
                float f7 = f3 * f4 + f5 * f6;
                float f8 = f3 * f3 + f5 * f5;
                float f9 = f7 / f8;
                if (!(f9 >= 0.0f)) {
                    float f10 = this.a.distanceTo(f, f2);
                    if (!(f10 > sodaprocessing.this.mouseTolerance)) {
                        return f10;
                    }
                    return -1.0f;
                }
                if (f9 > 1.0f) {
                    float f11 = this.b.distanceTo(f, f2);
                    if (!(f11 > sodaprocessing.this.mouseTolerance)) {
                        return f11;
                    }
                    return -1.0f;
                }
                float f12 = this.b.x * f9 + this.a.x * (1.0f - f9) - f;
                float f13 = this.b.y * f9 + this.a.y * (1.0f - f9) - f2;
                float f14 = sodaprocessing.this.sqrt(f12 * f12 + f13 * f13);
                if (!(f14 > sodaprocessing.this.mouseTolerance)) {
                    return f14;
                }
                return -1.0f;
            }
            return -1.0f;
        }
    }

    class Control {
        int x;
        int y;
        int w;
        int h;
        boolean over;
        String label;

        Control(int n, int n2, int n3, int n4, String string) {
            this.Block$();
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
            this.label = string;
        }

        boolean mouseIn() {
            this.over = sodaprocessing.this.mouseX > this.x && sodaprocessing.this.mouseX < this.x + this.w && sodaprocessing.this.mouseY > this.y && sodaprocessing.this.mouseY < this.y + this.h;
            return this.over;
        }

        boolean mousePressed() {
            return this.mouseIn();
        }

        void mouseDragged() {
            this.mouseIn();
        }

        boolean mouseReleased() {
            return this.mouseIn();
        }

        void display() {
            sodaprocessing.this.stroke(0.0f, 153.0f, 255.0f);
            if (this.over) {
                sodaprocessing.this.fill(221.0f, 221.0f, 221.0f);
            } else {
                sodaprocessing.this.fill(255.0f, 255.0f, 255.0f);
            }
            sodaprocessing.this.rect(this.x, this.y, this.w, this.h);
            this.drawContents();
            sodaprocessing.this.stroke(0);
            sodaprocessing.this.fill(0);
            sodaprocessing.this.text(this.label, (float)(this.x + 2), (float)(this.y + this.h - 3));
        }

        void drawContents() {
        }

        private void Block$() {
            this.over = false;
        }
    }

    class Button
    extends Control {
        boolean selected;
        boolean down;

        Button(int n, int n2, int n3, int n4, String string) {
            super(n, n2, n3, n4, string);
            this.Block$();
        }

        boolean mousePressed() {
            if (super.mousePressed() && !this.selected) {
                this.down = true;
            }
            return this.down;
        }

        boolean mouseReleased() {
            this.down = false;
            if (super.mouseIn()) {
                this.selected ^= true;
                return true;
            }
            return false;
        }

        void drawContents() {
            if (this.selected || this.down) {
                if (!this.selected && this.over ^ this.down) {
                    sodaprocessing.this.fill(221.0f, 221.0f, 221.0f);
                } else {
                    sodaprocessing.this.fill(0.0f, 153.0f, 255.0f);
                }
                sodaprocessing.this.noStroke();
                sodaprocessing.this.rect(this.x + 1, this.y + 1, this.w - 1, this.h - 1);
            }
        }

        private void Block$() {
            this.selected = false;
            this.down = false;
        }
    }

    class Slider
    extends Control {
        float min;
        float max;
        float value;
        int labelW;

        Slider(int n, int n2, int n3, int n4, float f, float f2, float f3, String string) {
            super(n, n2, n3, n4, string);
            this.Block$();
            this.min = f;
            this.max = f2;
            this.value = f3;
        }

        void mouseDragged() {
            this.setValueToMouse();
        }

        boolean mousePressed() {
            boolean bl = super.mousePressed();
            if (bl) {
                this.setValueToMouse();
            }
            return bl;
        }

        void setValueToMouse() {
            int n = this.w - this.labelW - 1;
            float f = ((float)sodaprocessing.this.mouseX - ((float)(this.x + this.labelW) + 1.0f)) / (float)n;
            this.value = f > 0.0f ? this.min + f * f * (this.max - this.min) : this.min;
            this.value = sodaprocessing.this.min(this.value, this.max);
        }

        void drawContents() {
            sodaprocessing.this.fill(0.0f, 153.0f, 255.0f);
            sodaprocessing.this.noStroke();
            int n = this.w - this.labelW - 1;
            float f = sodaprocessing.this.sqrt((this.value - this.min) / (this.max - this.min)) * (float)n;
            sodaprocessing.this.rect(this.x + this.labelW + 1, this.y + 1, f, this.h - 1);
        }

        void display() {
            super.display();
            sodaprocessing.this.stroke(0.0f, 153.0f, 255.0f);
            sodaprocessing.this.line(this.x + this.labelW, this.y, this.x + this.labelW, this.y + this.h);
        }

        private void Block$() {
            this.labelW = 8;
        }
    }
}

