/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;

public class softcinema
extends BApplet {
    String[] dataLines;
    String[][] finalData;
    ScreenMatrix[] sm;
    GeoLocation[] gl;
    String[] geoLocation;
    BFont fontA;
    BImage swLogo;
    int[] geoCount;
    static int NAME = 0;
    static int ACTIVITY = 1;
    static int GREYSCALE = 2;
    static int MOTION = 4;
    static int DISTANCE = 5;
    static int GEOLOCATION = 6;
    static int SUBJECT = 8;
    static float SGREY = 240.0f;
    static char SEPARATOR = (char)9;
    static int TEXTSHOWTIME = 48;
    static float FAR;
    static float MEDIUM;
    static float CLOSE;
    static float VERYCLOSE;
    static float NODIST;
    static float fixedist;
    int frameCounter;
    int clipselect;
    float maxgrey;

    void setup() {
        this.size(640, 480);
        this.colorMode(0, 255.0f);
        this.background(255.0f, 255.0f, 255.0f);
        VERYCLOSE = (float)this.width / fixedist;
        CLOSE = (float)this.width / (fixedist * 2.0f);
        FAR = (float)this.width / (fixedist * 4.0f);
        MEDIUM = (float)this.width / (fixedist * 8.0f);
        NODIST = (float)this.width / (fixedist * 16.0f);
        this.fontA = this.loadFont("Univers55.vlw.gz");
        this.setFont(this.fontA);
        this.swLogo = this.loadImage("schoenerwissen.gif");
        this.loadData();
        this.computeGeolocations();
        this.organizeLocations();
        this.calculateMatrix();
    }

    void loop() {
        int n = 0;
        while (n < this.gl.length) {
            this.gl[n].draw();
            ++n;
        }
        this.paintStandards();
        n = 0;
        while (n < this.sm.length) {
            this.sm[n].update();
            this.sm[n].draw();
            ++n;
        }
        if (this.frameCounter > TEXTSHOWTIME) {
            this.clipselect = (int)this.random(this.sm.length);
            this.frameCounter = 0;
        }
        ++this.frameCounter;
        this.sm[this.clipselect].subject(this.finalData[this.clipselect][SUBJECT]);
    }

    void loadData() {
        this.dataLines = this.loadStrings("sc.db");
        this.finalData = new String[this.dataLines.length][];
        int n = 0;
        while (n < this.dataLines.length) {
            this.finalData[n] = this.splitStrings(this.dataLines[n], SEPARATOR);
            ++n;
        }
    }

    void calculateMatrix() {
        this.sm = new ScreenMatrix[this.dataLines.length];
        int n = 0;
        while (n < this.dataLines.length) {
            float f = Float.valueOf(this.finalData[n][GREYSCALE]).floatValue();
            if (f > this.maxgrey) {
                this.maxgrey = f;
            }
            int n2 = 0;
            while (n2 < this.geoCount.length) {
                if (this.gl[n2].name.equals(this.finalData[n][GEOLOCATION])) {
                    float f2 = this.calculateDistance(this.finalData[n][DISTANCE]);
                    float f3 = Float.valueOf(this.finalData[n][ACTIVITY]).floatValue() * ((float)this.width / 800.0f);
                    Point point = this.calculateMotion(this.finalData[n][MOTION]);
                    this.sm[n] = new ScreenMatrix(f2 * (float)point.x, f2 * (float)point.y, this.gl[n2].x, this.gl[n2].y, f2, f3 * 100.0f, point, this.gl[n2].c1, f);
                }
                ++n2;
            }
            ++n;
        }
    }

    void computeGeolocations() {
        String string = "";
        int n = 0;
        while (n < this.dataLines.length) {
            if (string.indexOf(this.finalData[n][GEOLOCATION]) == -1) {
                string = string.concat(this.finalData[n][GEOLOCATION] + SEPARATOR);
            }
            ++n;
        }
        this.geoLocation = this.splitStrings(string, SEPARATOR);
        this.geoCount = new int[this.geoLocation.length];
        n = 0;
        while (n < this.dataLines.length) {
            int n2 = 0;
            while (n2 < this.geoLocation.length) {
                if (this.finalData[n][GEOLOCATION].equals(this.geoLocation[n2])) {
                    this.geoCount[n2] = this.geoCount[n2] + 1;
                }
                ++n2;
            }
            ++n;
        }
    }

    void organizeLocations() {
        int n;
        this.gl = new GeoLocation[this.geoCount.length];
        float f = 0.0f;
        int[] nArray = new int[this.geoCount.length];
        String[] stringArray = new String[this.geoCount.length];
        int n2 = 0;
        while (n2 < this.geoCount.length) {
            n = this.maxPoint(this.geoCount);
            nArray[n2] = this.geoCount[n];
            stringArray[n2] = this.geoLocation[n];
            this.geoCount[n] = 0;
            ++n2;
        }
        n2 = this.geoCount.length / 2;
        n = 0;
        while (n < this.geoCount.length) {
            this.geoCount[n2] = nArray[n];
            this.geoLocation[n2] = stringArray[n];
            --n2;
            n += 2;
        }
        n2 = this.geoCount.length - 1;
        n = this.geoCount.length - 2;
        while (n > 0) {
            this.geoCount[n2] = nArray[n];
            this.geoLocation[n2] = stringArray[n];
            --n2;
            n -= 2;
        }
        n = 0;
        while (n < this.geoCount.length) {
            float f2 = this.width / this.geoCount.length * n + this.width / this.geoCount.length / 2;
            f = this.height / this.geoCount.length * n + this.height / this.geoCount.length / 2;
            float f3 = this.random(255.0f);
            float f4 = this.random(255.0f);
            float f5 = this.random(255.0f);
            this.gl[n] = new GeoLocation(f2, f, this.geoLocation[n], f3, f4, f5);
            ++n;
        }
    }

    float calculateDistance(String string) {
        float f = 0.0f;
        f = string.equals("far") ? FAR : (string.equals("medium") ? MEDIUM : (string.equals("close") ? CLOSE : (string.equals("very_close") ? VERYCLOSE : NODIST)));
        return f;
    }

    Point calculateMotion(String string) {
        Point point = new Point(0, 0);
        if (string.equals("forward")) {
            point.x = 0;
            point.y = -1;
        } else if (string.equals("right")) {
            point.x = 1;
            point.y = 0;
        } else if (string.equals("left")) {
            point.x = -1;
            point.y = 0;
        } else if (string.equals("away")) {
            point.x = 0;
            point.y = 1;
        } else {
            point.x = 0;
            point.y = 0;
        }
        return point;
    }

    int maxPoint(int[] nArray) {
        int n = Integer.MIN_VALUE;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] > n) {
                n = nArray[n3];
                n2 = n3;
            }
            ++n3;
        }
        return n2;
    }

    void paintStandards() {
        this.stroke(SGREY);
        this.line(0.0f, 0.0f, this.width, this.height);
        this.unhint(0);
        this.image(this.swLogo, 0.0f, this.height - 50);
        this.hint(0);
    }

    public softcinema() {
        this.Block$();
    }

    static {
        fixedist = 6.6f;
    }

    private void Block$() {
        this.frameCounter = TEXTSHOWTIME + 1;
        this.clipselect = 0;
        this.maxgrey = 0.0f;
    }

    class GeoLocation {
        float x;
        float y;
        float c1;
        float c2;
        float c3;
        float cross;
        String name;

        GeoLocation(float f, float f2, String string, float f3, float f4, float f5) {
            this.x = f;
            this.y = f2;
            this.name = string;
            this.c1 = f3;
            this.c2 = f4;
            this.c3 = f5;
            this.cross = 15.0f;
            if (this.name.length() > 6) {
                this.cross = 30.0f;
            }
        }

        void draw() {
            softcinema.this.stroke(SGREY);
            softcinema.this.line(0.0f, this.y, softcinema.this.width, this.y);
            softcinema.this.line(this.x, 0.0f, this.x, softcinema.this.height);
            softcinema.this.fill(0);
            softcinema.this.push();
            softcinema.this.scale(1.2f);
            softcinema.this.text(this.name, (this.x - this.cross) / 1.2f, (this.y - 5.0f) / 1.2f);
            softcinema.this.pop();
        }
    }

    class ScreenMatrix {
        float x;
        float y;
        float xc;
        float yc;
        float distance;
        float activity;
        float angle;
        float cross;
        float col;
        float grey;
        Point motion;

        ScreenMatrix(float f, float f2, float f3, float f4, float f5, float f6, Point point, float f7, float f8) {
            this.x = f3 + f;
            this.y = f4 + f2;
            this.xc = f3;
            this.yc = f4;
            this.distance = f5;
            this.activity = f6;
            this.motion = point;
            this.col = f7;
            this.grey = f8;
            this.angle = 0.0f;
            this.cross = this.distance / 8.0f;
        }

        void update() {
            this.x += (float)this.motion.x * this.activity;
            this.y += (float)this.motion.y * this.activity;
            if (this.motion.x == 0 && this.motion.y == 0) {
                if (this.angle > 360.0f) {
                    this.angle = 0.0f;
                }
                this.x = this.xc + this.distance * softcinema.this.sin((float)Math.PI * this.angle);
                this.y = this.yc + -this.distance * softcinema.this.cos((float)Math.PI * this.angle);
                this.angle += this.activity * 0.01f;
                return;
            }
            if (this.x > (float)softcinema.this.width) {
                this.x = 0.0f;
                return;
            }
            if (!(this.x >= 0.0f)) {
                this.x = softcinema.this.width;
                return;
            }
            if (this.y > (float)softcinema.this.height) {
                this.y = 0.0f;
                return;
            }
            if (!(this.y >= 0.0f)) {
                this.y = softcinema.this.height;
            }
        }

        void draw() {
            softcinema.this.noStroke();
            softcinema.this.colorMode(1, 255.0f);
            softcinema.this.fill(this.col, 255.0f - this.grey * 255.0f / softcinema.this.maxgrey, 255.0f - this.grey * 255.0f / softcinema.this.maxgrey);
            softcinema.this.rect(this.x, this.y, this.cross, this.cross);
            softcinema.this.colorMode(0, 255.0f);
        }

        void subject(String string) {
            softcinema.this.stroke(160);
            softcinema.this.rect(this.x, this.y, this.cross, this.cross);
            softcinema.this.line(this.x, this.y, this.xc, this.yc);
            softcinema.this.push();
            softcinema.this.scale(1.5f);
            softcinema.this.noStroke();
            softcinema.this.fill(255.0f, 0.0f, 255.0f);
            softcinema.this.text(string, (this.x + 5.0f) / 1.5f, (this.y - 5.0f) / 1.5f);
            softcinema.this.pop();
        }
    }
}

