/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSound
extends InputStream {
    public int[] samples;
    public int index;
    public boolean play;
    public boolean loop;
    public float volume;
    public float speed;
    public int position;
    public int length;
    public int in;
    public int out;
    private float posf;

    public int readSample() {
        this.posf += this.speed;
        this.position = (int)this.posf;
        if (this.position >= this.out) {
            this.position = this.in;
            this.posf = this.in;
            if (!this.loop) {
                this.play = false;
            }
        }
        if (this.position < this.in) {
            this.position = this.in;
            this.posf = this.in;
        }
        return (int)((float)this.samples[this.position] * this.volume);
    }

    public void volume(float f) {
        this.volume = f >= 0.0f ? f : 0.0f;
    }

    public void speed(float f) {
        this.speed = f;
    }

    public void play() {
        if (this.samples == null) {
            return;
        }
        if (!this.play) {
            this.play = true;
            BSonic.soundObjects.addElement(this);
        }
    }

    public void repeat() {
        if (this.samples == null) {
            return;
        }
        this.loop = true;
        if (!this.play) {
            this.play = true;
            BSonic.soundObjects.addElement(this);
        }
    }

    public void pause() {
        this.play = false;
    }

    public void stop() {
        this.play = false;
        this.position = this.in;
    }

    public void jump(int n) {
        n = Math.abs(n);
        this.posf = n;
        this.position = (int)this.posf;
        if (this.position >= this.out) {
            this.posf = this.out - 1;
        }
        if (this.position < this.in) {
            this.posf = this.in;
        }
        this.position = (int)this.posf;
    }

    public boolean playing() {
        return this.play;
    }

    public void in(int n) {
        this.position = (int)this.posf;
        this.in = (n = Math.abs(n)) > 0 ? (n < this.out ? n : this.out) : 0;
        if (this.position < this.in) {
            this.posf = this.in;
        }
    }

    public void out(int n) {
        this.position = (int)this.posf;
        this.out = (n = Math.abs(n)) < this.length ? (n > this.in ? n : this.in) : this.length;
        if (this.position >= this.out) {
            this.posf = this.out - 1;
        }
    }

    public void borders(int n, int n2) {
        this.position = (int)this.posf;
        n = Math.abs(n);
        if ((n2 = Math.abs(n2)) < n) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        if (n2 == n) {
            ++n2;
            --n;
        }
        if (n2 > this.length) {
            n2 = this.length;
        }
        if (n < 0) {
            n = 0;
        }
        this.in = n;
        this.out = n2;
        if (this.position < this.in) {
            this.position = this.in;
        }
        if (this.position >= this.out) {
            this.position = this.out - 1;
        }
    }

    public synchronized int read() {
        int n;
        if (BSonic.DEBUG) {
            System.out.println("BSound.read() single");
        }
        this.position = (int)this.posf;
        int n2 = n = this.position < this.out ? (int)BSonic.linear2ulaw(this.samples[this.position++]) : -1;
        if (this.position >= this.out && this.loop) {
            this.position = this.in;
            n = BSonic.linear2ulaw(this.samples[this.position++]);
        } else if (!this.loop) {
            n = this.volume == 1.0f ? (int)BSonic.linear2ulaw(this.samples[this.position++] << 8) : (int)((byte)((float)BSonic.linear2ulaw(this.samples[this.position++] << 8) * this.volume));
        }
        return n;
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        if (BSonic.DEBUG) {
            System.out.println("BSound.read() block");
        }
        if (!this.play) {
            if (BSonic.DEBUG) {
                System.out.println("BSound.read no play for you");
            }
            return -1;
        }
        if (BSonic.DEBUG) {
            System.out.println("BSound.read still playing");
        }
        if (!this.loop) {
            return this.sread(byArray, n, n2);
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.sread(byArray, n + n3, n2 - n3);
            if (n4 >= 0) {
                n3 += n4;
                continue;
            }
            this.posf = this.in;
        }
        return n3;
    }

    public synchronized int sread(byte[] byArray, int n, int n2) {
        this.position = (int)this.posf;
        if (this.position >= this.out) {
            return -1;
        }
        if (this.position + n2 > this.out) {
            n2 = this.out - this.position;
        }
        if (n2 <= 0) {
            return 0;
        }
        int n3 = 0;
        while (n3 < n2) {
            byArray[n + n3] = BSonic.linear2ulaw(this.readSample() << 8);
            ++n3;
        }
        this.position += n2;
        return n2;
    }

    public synchronized long skip(long l) {
        if ((long)this.position + l > (long)this.out) {
            l = this.out - this.position;
        }
        if (l < 0L) {
            return 0L;
        }
        this.posf += (float)l;
        return l;
    }

    public synchronized int available() {
        return this.out - this.position;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) {
    }

    public synchronized void reset() {
        this.posf = this.in;
    }

    private final /* synthetic */ void this() {
        this.samples = null;
        this.index = -1;
        this.play = false;
        this.loop = false;
        this.volume = 1.0f;
        this.speed = 1.0f;
        this.posf = 0.0f;
    }

    public BSound(int n) {
        this.this();
        if (n < 1) {
            n = 1;
        }
        this.samples = new int[n];
        this.length = this.samples.length;
        this.in = 0;
        this.out = this.length;
        this.position = 0;
        int n2 = 0;
        while (n2 < this.length) {
            this.samples[n2] = 0;
            ++n2;
        }
    }

    public BSound(int[] nArray) {
        this.this();
        this.samples = nArray;
        this.length = this.samples.length;
        this.in = 0;
        this.out = this.length;
        this.position = 0;
    }
}

