/*
 * Decompiled with CFR 0.152.
 */
public class pond
extends BApplet {
    int W;
    int H;
    int NUM;
    Fish[] flock;
    Fish bigfish1;
    Fish bigfish2;
    Fish bigfish3;
    float rippleX;
    float rippleY;
    float[] ripple;
    boolean hasRipple;
    int hasPredator;
    int precision;
    float[][] bp;
    int bcount;

    void setup() {
        this.size(600, 400);
        this.W = this.width;
        this.H = this.height;
        this.background(6.0f, 22.0f, 48.0f);
        this.colorMode(1, 360.0f, 100.0f, 100.0f);
        this.framerate(24.0f);
        float f = 50.0f;
        int n = 0;
        while (n < this.NUM) {
            this.flock[n] = new Fish(this.random(this.W), this.random(this.H), 1.0f, this.random((float)Math.PI), this.random(5.0f, 8.0f));
            this.flock[n].setSpeedLimit(this.random(3.0f, 4.0f), 0.5f);
            this.flock[n].setColor(207.0f, this.random(50.0f), 100.0f);
            ++n;
        }
        n = 0;
        while (n < this.ripple.length) {
            this.ripple[n] = 999.0f;
            ++n;
        }
        this.bigfish1 = new Fish(this.random(this.W), this.random(this.H), 1.0f, this.random((float)Math.PI), 12.0f);
        this.bigfish1.setSpeedLimit(2.0f, 1.0f);
        this.bigfish1.setColor(30.0f, 66.0f, 79.0f);
        this.bigfish2 = new Fish(this.random(this.W), this.random(this.H), 1.0f, this.random((float)Math.PI), 15.0f);
        this.bigfish2.setSpeedLimit(2.0f, 1.0f);
        this.bigfish2.setColor(20.0f, 66.0f, 79.0f);
        this.bigfish3 = new Fish(this.random(this.W), this.random(this.H), 1.0f, this.random((float)Math.PI), 20.0f);
        this.bigfish3.setSpeedLimit(2.0f, 1.0f);
        this.bigfish3.setColor(10.0f, 66.0f, 79.0f);
    }

    void loop() {
        this.stroke(207.0f, 66.0f, 79.0f);
        this.noFill();
        if (this.hasPredator > 0) {
            this.bigfish1.scanPrey(this.flock, 150.0f);
            this.bigfish1.predator(this.bigfish2.x, this.bigfish2.y, 100.0f, 0.10471976f, 2.0f);
            this.bigfish1.predator(this.bigfish3.x, this.bigfish3.y, 100.0f, 0.10471976f, 2.0f);
            this.bigfish1.predator(this.mouseX, this.mouseY, 50.0f, 0.08726647f, 1.0f);
            this.bigfish1.move();
            this.stroke(this.bigfish1.colour[0], this.bigfish1.colour[1], this.bigfish1.colour[2]);
            this.bigfish1.getFish();
            if (this.hasPredator > 1) {
                this.bigfish2.scanPrey(this.flock, 120.0f);
                this.bigfish2.predator(this.bigfish1.x, this.bigfish1.y, 100.0f, 0.08726647f, 1.5f);
                this.bigfish2.predator(this.bigfish3.x, this.bigfish3.y, 100.0f, 0.08726647f, 1.5f);
                this.bigfish2.predator(this.mouseX, this.mouseY, 50.0f, 0.06981317f, 0.8f);
                this.bigfish2.move();
                this.stroke(this.bigfish2.colour[0], this.bigfish2.colour[1], this.bigfish2.colour[2]);
                this.bigfish2.getFish();
                if (this.hasPredator > 2) {
                    this.bigfish3.scanPrey(this.flock, 100.0f);
                    this.bigfish3.predator(this.bigfish1.x, this.bigfish1.y, 100.0f, 0.08726647f, 1.5f);
                    this.bigfish3.predator(this.bigfish2.x, this.bigfish2.y, 100.0f, 0.08726647f, 1.5f);
                    this.bigfish3.predator(this.mouseX, this.mouseY, 50.0f, 0.05235988f, 0.5f);
                    this.bigfish3.move();
                    this.stroke(this.bigfish3.colour[0], this.bigfish3.colour[1], this.bigfish3.colour[2]);
                    this.bigfish3.getFish();
                }
            }
        }
        this.noStroke();
        int n = 0;
        while (n < this.flock.length) {
            this.fill(this.flock[n].colour[0], this.flock[n].colour[1] + this.flock[n].tone, this.flock[n].colour[2]);
            if (this.hasRipple) {
                this.flock[n].swarm(this.rippleX, this.rippleY, 200.0f);
            }
            this.flock[n].scanFlock(this.flock, 200.0f, 50.0f);
            if (this.hasPredator > 0) {
                this.flock[n].predator(this.bigfish1.x, this.bigfish1.y, 100.0f, 0.13962634f, 1.5f);
                if (this.hasPredator > 1) {
                    this.flock[n].predator(this.bigfish2.x, this.bigfish2.y, 100.0f, 0.13962634f, 1.5f);
                    if (this.hasPredator > 2) {
                        this.flock[n].predator(this.bigfish3.x, this.bigfish3.y, 100.0f, 0.13962634f, 1.5f);
                    }
                }
            }
            if (!this.hasRipple) {
                this.flock[n].predator(this.mouseX, this.mouseY, 100.0f, 0.08726647f, 1.0f);
            }
            this.flock[n].move();
            this.flock[n].getFish();
            ++n;
        }
        this.stroke(207.0f, 100.0f, 30.0f);
        this.noFill();
        this.hasRipple = false;
        n = 0;
        while (n < this.ripple.length) {
            if (!(this.ripple[n] >= (float)this.W)) {
                this.ripple[n] = this.ripple[n] + 3.0f * (float)(n + 4);
                this.ellipse(this.rippleX - this.ripple[n] / 2.0f, this.rippleY - this.ripple[n] / 2.0f, this.ripple[n], this.ripple[n]);
                this.hasRipple = true;
            }
            ++n;
        }
    }

    void mouseDragged() {
        this.rippleX = this.mouseX;
        this.rippleY = this.mouseY;
    }

    void mousePressed() {
        this.rippleX = this.mouseX;
        this.rippleY = this.mouseY;
    }

    void mouseReleased() {
        if (!this.hasRipple) {
            int n = 0;
            while (n < this.ripple.length) {
                this.ripple[n] = 0.0f;
                ++n;
            }
            this.hasRipple = true;
        }
    }

    void keyPressed() {
        if (this.key == 49) {
            this.hasPredator = 1;
            return;
        }
        if (this.key == 50) {
            this.hasPredator = 2;
            return;
        }
        if (this.key == 51) {
            this.hasPredator = 3;
            return;
        }
        if (this.key == 48) {
            this.hasPredator = 0;
        }
    }

    static float[] linear(float[] fArray, float[] fArray2, float f) {
        float[] fArray3 = new float[]{(1.0f - f) * fArray[0] + f * fArray2[0], (1.0f - f) * fArray[1] + f * fArray2[1]};
        return fArray3;
    }

    static float[] bezier(float[][] fArray, float f) {
        float[][] fArray2 = fArray;
        while (fArray2.length > 1) {
            float[][] fArray3 = fArray2;
            fArray2 = new float[fArray3.length - 1][2];
            int n = 0;
            while (n < fArray3.length - 1) {
                fArray2[n] = pond.linear(fArray3[n], fArray3[n + 1], f);
                ++n;
            }
        }
        return fArray2[0];
    }

    void bezierVertex2(float f, float f2) {
        float[] fArray = new float[]{f, f2};
        this.bp[this.bcount++] = fArray;
        if (this.bcount > 3) {
            int n = 0;
            while (n <= this.precision) {
                float[] fArray2 = pond.bezier(this.bp, (float)n / (float)this.precision);
                this.vertex(fArray2[0], fArray2[1]);
                ++n;
            }
            this.bp[0] = this.bp[3];
            this.bcount = 1;
        }
    }

    void endBezier() {
        this.bcount = 0;
    }

    public pond() {
        this.Block$();
    }

    private void Block$() {
        this.NUM = 40;
        this.flock = new Fish[this.NUM];
        this.ripple = new float[50];
        this.hasPredator = 0;
        this.precision = 10;
        this.bp = new float[4][2];
        this.bcount = 0;
    }

    class Fish {
        float fsize;
        float[] tailP;
        float[] tailPC;
        float tailLength;
        float x;
        float y;
        float angle;
        float speed;
        float maxSpeed;
        float minSpeed;
        float energy;
        float wave;
        int wcount;
        int uturn;
        int boundTime;
        float[] colour;
        float tone;
        boolean isBound;

        Fish(float f, float f2, float f3, float f4, float f5) {
            this.Block$();
            this.tailP[1] = this.tailLength;
            this.tailPC[1] = this.tailLength;
            this.x = f;
            this.y = f2;
            this.angle = f4;
            this.speed = f3;
            this.fsize = f5;
        }

        void getFish() {
            pond.this.beginShape(256);
            float[] fArray = this.calc(0.0f, -1.0f, this.fsize);
            pond.this.bezierVertex2(fArray[0], fArray[1]);
            fArray = this.calc(0.5f, -1.0f, this.fsize);
            pond.this.bezierVertex2(fArray[0], fArray[1]);
            fArray = this.calc(1.0f, -0.5f, this.fsize);
            pond.this.bezierVertex2(fArray[0], fArray[1]);
            fArray = this.calc(1.0f, 0.0f, this.fsize);
            pond.this.bezierVertex2(fArray[0], fArray[1]);
            fArray = this.calc(1.0f, 1.0f, this.fsize);
            pond.this.bezierVertex2(fArray[0], fArray[1]);
            fArray = this.calc(this.tailPC[0], this.tailPC[1], this.fsize);
            pond.this.bezierVertex2(fArray[0], fArray[1]);
            fArray = this.calc(this.tailP[0], this.tailP[1], this.fsize);
            pond.this.bezierVertex2(fArray[0], fArray[1]);
            fArray = this.calc(this.tailPC[0], this.tailPC[1], this.fsize);
            pond.this.bezierVertex2(fArray[0], fArray[1]);
            fArray = this.calc(-1.0f, 1.0f, this.fsize);
            pond.this.bezierVertex2(fArray[0], fArray[1]);
            fArray = this.calc(-1.0f, 0.0f, this.fsize);
            pond.this.bezierVertex2(fArray[0], fArray[1]);
            fArray = this.calc(-1.0f, -0.5f, this.fsize);
            pond.this.bezierVertex2(fArray[0], fArray[1]);
            fArray = this.calc(-0.5f, -1.0f, this.fsize);
            pond.this.bezierVertex2(fArray[0], fArray[1]);
            fArray = this.calc(0.0f, -1.0f, this.fsize);
            pond.this.bezierVertex2(fArray[0], fArray[1]);
            pond.this.endBezier();
            pond.this.endShape();
        }

        void setTail(float f, float f2) {
            this.tailP[0] = f * f2;
            this.tailP[1] = this.tailLength + this.tailLength / 2.0f - pond.this.abs(this.tailLength / 4.0f * f * f2);
            this.tailPC[0] = f * f2 * -1.0f;
        }

        float[] calc(float f, float f2, float f3) {
            float f4 = pond.this.atan2(f2, f) + this.angle + 1.5707964f;
            float f5 = pond.this.sqrt(f * f + f2 * f2);
            float[] fArray = new float[]{this.x + f5 * f3 * pond.this.cos(f4), this.y + f5 * f3 * pond.this.sin(f4)};
            return fArray;
        }

        protected void wriggle() {
            if (this.energy > 1.0f) {
                this.wcount += (int)(this.energy * 2.0f);
            }
            if (this.wcount > 120) {
                this.wcount = 0;
                this.energy = 0.0f;
            }
            this.wave = pond.this.sin((float)(this.wcount * 3) * (float)Math.PI / 180.0f);
            float f = this.energy / 5.0f * this.tailLength / 2.0f;
            this.setTail(f, this.wave);
            this.move();
        }

        float dist(float f, float f2) {
            return pond.this.sqrt((f -= this.x) * f + (f2 -= this.y) * f2);
        }

        float dist(Fish fish) {
            float f = fish.x - this.x;
            float f2 = fish.y - this.y;
            return pond.this.sqrt(f * f + f2 * f2);
        }

        float angle(float f, float f2) {
            return pond.this.atan2(f2 - this.y, f - this.x);
        }

        float angle(Fish fish) {
            return pond.this.atan2(fish.y - this.y, fish.x - this.x);
        }

        void move() {
            this.x += pond.this.cos(this.angle) * this.speed;
            this.y += pond.this.sin(this.angle) * this.speed;
        }

        void speedChange(float f) {
            this.speed += f;
            if (!(this.speed >= this.minSpeed)) {
                this.speed = this.minSpeed;
            }
            if (this.speed > this.maxSpeed) {
                this.speed = this.maxSpeed;
            }
        }

        void angleChange(float f) {
            this.angle += f;
        }

        void setSpeedLimit(float f, float f2) {
            this.maxSpeed = f;
            this.minSpeed = f2;
        }

        void setAngle(float f) {
            this.angle = f;
        }

        void turnTo(float f, float f2) {
            if (!(this.angle >= f)) {
                this.angleChange(f2);
                return;
            }
            this.angleChange(f2 * -1.0f);
        }

        void setColor(float f, float f2, float f3) {
            this.colour[0] = f;
            this.colour[1] = f2;
            this.colour[2] = f3;
        }

        void copyFish(Fish fish) {
            this.x = fish.x;
            this.y = fish.y;
            this.angle = fish.angle;
            this.speed = fish.speed;
        }

        boolean checkBounds(float f) {
            boolean bl = false;
            float f2 = this.speed * (float)Math.PI / 2.0f / (f += (float)(this.boundTime / 100));
            if (f2 > (float)(pond.this.W / 4)) {
                f2 = pond.this.W / 4;
                f = f2 / this.speed / (float)Math.PI / 2.0f;
            }
            if (!(this.x - f2 >= 0.0f) || this.x + f2 > (float)pond.this.W || !(this.y - f2 >= 0.0f) || this.y + f2 > (float)pond.this.H) {
                if (this.uturn == 0) {
                    float f3 = this.angle;
                    if (!(f3 >= 0.0f)) {
                        f3 += (float)Math.PI * 2;
                    }
                    this.uturn = f3 > 0.0f && !(f3 >= 1.5707964f) ? 1 : (f3 > 1.5707964f && !(f3 >= (float)Math.PI) ? -1 : (f3 > (float)Math.PI && !(f3 >= 4.712389f) ? 1 : (f3 > 4.712389f && !(f3 >= (float)Math.PI * 2) ? -1 : 1)));
                    if (!(this.y - f2 >= 0.0f) || this.y + f2 > (float)pond.this.H) {
                        this.uturn *= -1;
                    }
                }
                this.angleChange(f * (float)this.uturn);
                bl = true;
            } else {
                this.uturn = 0;
                bl = false;
            }
            float f4 = !(this.x >= 0.0f) ? 0.0f : (this.x = this.x > (float)pond.this.W ? (float)pond.this.W : this.x);
            this.y = !(this.y >= 0.0f) ? 0.0f : (this.y > (float)pond.this.H ? (float)pond.this.H : this.y);
            this.isBound = bl;
            this.boundTime = bl ? this.boundTime + 1 : 0;
            return bl;
        }

        void align(Fish fish, float f, float f2) {
            this.turnTo(fish.angle, f + pond.this.random(f * 3.0f));
            if (this.speed > fish.speed) {
                this.speedChange(f2 * (-1.0f - pond.this.random(1.0f)));
                return;
            }
            this.speedChange(f2);
        }

        void cohere(Fish[] fishArray, float f, float f2) {
            float f3 = 0.0f;
            float f4 = 0.0f;
            int n = 0;
            while (n < fishArray.length) {
                f3 += fishArray[n].x;
                f4 += fishArray[n].y;
                ++n;
            }
            this.turnTo(this.angle(f3 /= (float)fishArray.length, f4 /= (float)fishArray.length), f + pond.this.random(f * 2.0f));
            this.speedChange(f2);
        }

        void seperate(Fish[] fishArray, float f, float f2) {
            float f3 = 0.0f;
            int n = 0;
            while (n < fishArray.length) {
                f3 += fishArray[n].angle + (float)Math.PI;
                ++n;
            }
            this.turnTo(f3 /= (float)fishArray.length, f + pond.this.random(f * 2.0f));
            this.speedChange(f2);
        }

        void avoid(Fish[] fishArray, float f, float f2) {
            int n = 0;
            while (n < fishArray.length) {
                float f3 = this.angle(fishArray[n]) + (float)Math.PI;
                this.x += pond.this.cos(f3) * f2 / 2.0f;
                this.y += pond.this.sin(f3) * f2 / 2.0f;
                this.turnTo(f3, f + pond.this.random(f));
                ++n;
            }
            this.speedChange(f2);
        }

        void predator(float f, float f2, float f3, float f4, float f5) {
            float f6 = this.dist(f, f2);
            if (!(f6 >= f3)) {
                float f7 = this.angle(f, f2) + (float)Math.PI;
                this.x += pond.this.cos(f7) * f5;
                this.y += pond.this.sin(f7) * f5;
                this.turnTo(f7, f4 + pond.this.random(f4));
                if (!(this.tone >= 50.0f)) {
                    this.tone += 5.0f;
                }
            } else if (this.tone > 0.0f) {
                this.tone -= 2.0f;
            }
            this.speedChange(f5);
        }

        void swarm(float f, float f2, float f3) {
            float f4 = this.angle(f, f2);
            float f5 = this.dist(f, f2);
            this.turnTo(f4, 0.31415927f);
            if (this.isBound) {
                this.turnTo(f4, 0.31415927f);
            }
        }

        void scanFlock(Fish[] fishArray, float f, float f2) {
            Fish[] fishArray2 = new Fish[pond.this.NUM];
            int n = 0;
            Fish[] fishArray3 = new Fish[pond.this.NUM];
            int n2 = 0;
            Fish[] fishArray4 = new Fish[pond.this.NUM];
            int n3 = 0;
            Fish fish = null;
            float f3 = 99999.0f;
            float f4 = this.angle;
            float f5 = this.speed;
            boolean bl = pond.this.hasPredator > 0 ? this.checkBounds(0.19634955f) : this.checkBounds(0.1308997f);
            int n4 = 0;
            while (n4 < fishArray.length) {
                float f6;
                Fish fish2 = fishArray[n4];
                if (fish2 != this && !((f6 = this.dist(fish2)) >= f)) {
                    fishArray2[n++] = fish2;
                    if (f3 > f6) {
                        f3 = f6;
                        fish = fish2;
                    }
                    if (!(f6 > f2)) {
                        fishArray3[n2++] = fish2;
                        if (!(f6 > f2 / 2.0f)) {
                            fishArray4[n3++] = fish2;
                        }
                    }
                }
                Fish[] fishArray5 = new Fish[n];
                Fish[] fishArray6 = new Fish[n2];
                Fish[] fishArray7 = new Fish[n3];
                int n5 = 0;
                n5 = 0;
                while (n5 < n) {
                    fishArray5[n5] = fishArray2[n5];
                    ++n5;
                }
                n5 = 0;
                while (n5 < n2) {
                    fishArray6[n5] = fishArray3[n5];
                    ++n5;
                }
                n5 = 0;
                while (n5 < n3) {
                    fishArray7[n5] = fishArray4[n5];
                    ++n5;
                }
                if (!bl && !pond.this.hasRipple) {
                    if (fish != null) {
                        this.align(fish, 0.0017453294f, 0.2f);
                    }
                    this.cohere(fishArray5, 0.0017453294f, -0.1f);
                }
                this.seperate(fishArray6, (pond.this.random(0.1f) + 0.1f) * (float)Math.PI / 180.0f, 0.05f);
                this.avoid(fishArray7, (pond.this.random(0.2f) + 0.2f) * (float)Math.PI / 180.0f, 0.1f);
                ++n4;
            }
            float f7 = (this.angle - f4) * 5.0f;
            float f8 = (this.speed - f5) / 3.0f;
            float f9 = f7 * 180.0f / (float)Math.PI;
            this.energy += pond.this.abs(f9 / 150.0f);
            this.wriggle();
        }

        void scanPrey(Fish[] fishArray, float f) {
            float f2;
            Fish[] fishArray2 = new Fish[pond.this.NUM];
            boolean bl = false;
            Fish[] fishArray3 = new Fish[pond.this.NUM];
            boolean bl2 = false;
            Fish[] fishArray4 = new Fish[pond.this.NUM];
            boolean bl3 = false;
            Fish fish = null;
            float f3 = 99999.0f;
            float f4 = this.angle;
            float f5 = this.speed;
            int n = 0;
            while (n < fishArray.length) {
                f2 = this.dist(fishArray[n]);
                if (f3 > f2) {
                    f3 = f2;
                    fish = fishArray[n];
                }
                ++n;
            }
            if (!(f3 >= f)) {
                float f6 = f3 / f;
                if (f3 > f / 2.0f) {
                    this.speedChange(0.5f);
                } else {
                    this.speedChange(-0.5f);
                }
                this.turnTo(this.angle(fish), 0.05f);
                f2 = (this.angle - f4) * 10.0f;
                float f7 = (this.speed - f5) * 5.0f;
                float f8 = f2 * 180.0f / (float)Math.PI;
                this.energy += pond.this.abs(f8 / 150.0f);
            }
            boolean bl4 = this.checkBounds(0.19634955f);
            this.wriggle();
        }

        private void Block$() {
            this.tailP = new float[]{0.0f, 0.0f};
            this.tailPC = new float[]{0.0f, 0.0f};
            this.tailLength = 3.0f;
            this.energy = 1.0f;
            this.wave = 0.0f;
            this.wcount = 0;
            this.uturn = 0;
            this.boundTime = 0;
            this.colour = new float[]{255.0f, 255.0f, 255.0f};
            this.tone = 0.0f;
            this.isBound = false;
        }
    }
}

