/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class base26oop
extends BApplet {
    Vocabulary vocab;
    VoxelSpace surface;
    GUI gui;
    GUIElement[] bt_filters;
    FastText ft_default;
    FastText ft_caps;
    Node rollOverNode;
    BImage bg;
    boolean updateView;
    boolean updateVolume;
    boolean updateRotation;
    boolean autoRotate;
    boolean helpRequested;
    boolean helpActive;
    float stepSize;
    float isoValue;
    float isoExponent;
    float minPotential;
    float basePotential;
    float xRot;
    float yRot;
    float currXRot;
    float currYRot;
    float autoAlpha;
    float autoRotR;
    float centerX;
    float centerY;
    float clickX;
    float clickY;
    int typeMask;
    float snapDistance;
    String[] usage;

    void setup() {
        this.size(500, 600);
        this.rectMode(1);
        this.bg = this.loadImage("bg.jpg");
        GUIElement[] gUIElementArray = new GUIElement[13];
        gUIElementArray[0] = new ImagePanel("initial", this.loadImage("alphabet2.gif"), 220, 0, 60, 60, 216, 2);
        BImage bImage = this.loadImage("icons.gif");
        gUIElementArray[1] = new IconButton("help", bImage, 0, 16, 16, 20, 22, 4, 2);
        gUIElementArray[2] = new IconButton("autoR", bImage, 1, 16, 16, 40, 22, 4, 2);
        gUIElementArray[3] = new IconButton("resMinus", bImage, 2, 16, 16, 440, 22, 4, 2);
        gUIElementArray[4] = new IconButton("resPlus", bImage, 3, 16, 16, 460, 22, 4, 2);
        gUIElementArray[5] = new IconButton("isoMinus", bImage, 2, 16, 16, 380, 22, 4, 2);
        gUIElementArray[6] = new IconButton("isoPlus", bImage, 3, 16, 16, 400, 22, 4, 2);
        gUIElementArray[7] = new IncrementorButton("nextIni", 1.0f, 0.0f, 25.0f, 300, 20, 310, 40);
        gUIElementArray[8] = new IncrementorButton("prevIni", -1.0f, 0.0f, 25.0f, 190, 20, 200, 40);
        this.bt_filters = new BitToggleButton[4];
        this.bt_filters[0] = gUIElementArray[9] = new BitToggleButton("filter0", this.typeMask, 0, 228, 570, 8, 8);
        this.bt_filters[1] = gUIElementArray[10] = new BitToggleButton("filter1", this.typeMask, 1, 240, 570, 8, 8);
        this.bt_filters[2] = gUIElementArray[11] = new BitToggleButton("filter2", this.typeMask, 2, 252, 570, 8, 8);
        this.bt_filters[3] = gUIElementArray[12] = new BitToggleButton("filter3", this.typeMask, 3, 264, 570, 8, 8);
        this.gui = new GUI(gUIElementArray);
        this.ft_default = new FastText("fffharmony.gif");
        this.ft_caps = new FastText("fffleader_caps2.gif");
        this.vocab = new Vocabulary("4letters.txt");
        this.surface = new VoxelSpace(26, 26, 26, 24, 24, 24, 17000);
    }

    void loop() {
        if (!this.firstFrame) {
            if (this.helpRequested) {
                if (!this.helpActive) {
                    this.showHelp();
                }
                return;
            }
            if (this.updateRotation) {
                this.xRot = this.min(this.max(this.xRot + (this.clickY - (float)this.mouseY) * 7.0E-4f, 2.2f), 3.5f);
                this.yRot += (this.clickX - (float)this.mouseX) * 7.0E-4f;
                this.updateView = true;
            }
            this.currXRot = this.xRot;
            this.currYRot = this.yRot;
            if (this.autoRotate) {
                this.currXRot += this.autoRotR * this.sin(this.autoAlpha);
                this.currYRot += this.autoRotR * this.cos(this.autoAlpha);
                this.autoAlpha += this.rollOverNode != null ? 0.0f : 0.02f;
                this.updateView = true;
            }
            boolean bl = false;
            if (this.updateVolume || this.updateIsoValue()) {
                bl = this.updateVolume = true;
            }
            if (this.updateVolume || this.updateView) {
                this.background(this.bg);
                this.push();
                this.translate(this.centerX, this.centerY, 0.0f);
                this.rotateX(this.currXRot);
                this.rotateY(this.currYRot);
                this.scale(11.0f);
                this.rollOverNode = null;
                this.showNodes(this.vocab.currInitial);
                this.drawGrid();
                if (this.updateVolume) {
                    this.surface.update(this.stepSize, this.isoValue);
                    this.updateVolume = false;
                } else {
                    this.surface.render();
                }
                this.pop();
                if (this.rollOverNode != null) {
                    this.rollOverNode.showLabel();
                }
                ((ImagePanel)this.gui.getElementForID("initial")).setOffsetX((int)(this.vocab.currInitial * 60.0f));
                this.gui.draw();
                this.updateView = false;
            }
        }
    }

    void mouseMoved() {
        this.gui.checkElements(false);
        this.updateView = true;
    }

    void mousePressed() {
        if (this.rollOverNode == null) {
            this.clickX = this.mouseX;
            this.clickY = this.mouseY;
            this.updateRotation = true;
        }
    }

    void mouseReleased() {
        if (this.helpRequested) {
            this.helpRequested = false;
            this.updateView = true;
        }
        if (this.rollOverNode != null) {
            this.link("http://dictionary.reference.com/search?q=" + this.rollOverNode.desc.value, "_new");
        } else {
            this.gui.checkElements(true);
        }
        this.helpActive = false;
        this.updateRotation = false;
    }

    void keyReleased() {
        if (this.key == 16 || this.key == 16 || this.key == 18) {
            return;
        }
        if (!(this.key != 63 && this.key != 47 || this.helpActive)) {
            this.helpRequested = true;
            this.helpActive = false;
            return;
        }
        this.helpActive = false;
        this.helpRequested = false;
        if (this.key >= 97 && this.key <= 122 || this.key >= 65 && this.key <= 90) {
            this.vocab.setInitial((this.key | 0x20) - 97);
            this.updateVolume = true;
        } else if (this.key >= 49 && this.key <= 56) {
            this.typeMask = this.key - 48;
            int n = 0;
            while (n < 4) {
                BitToggleButton bitToggleButton = (BitToggleButton)this.bt_filters[n];
                boolean bl = false;
                if ((this.typeMask & 1 << n) > 0) {
                    bl = true;
                }
                bitToggleButton.set(bl);
                ++n;
            }
            this.updateVolume = true;
            this.updateView = true;
        } else if (this.key == 57 || this.key == 48) {
            this.typeMask = 15;
            int n = 0;
            while (n < 4) {
                ((BitToggleButton)this.bt_filters[n]).set(true);
                ++n;
            }
            this.updateVolume = true;
            this.updateView = true;
        } else if (this.key == 44 || this.key == 60 || this.key == 37) {
            this.vocab.setInitial(this.max(this.vocab.newInitial -= 1.0f, 0.0f));
        } else if (this.key == 46 || this.key == 62 || this.key == 39) {
            this.vocab.setInitial(this.min(this.vocab.newInitial += 1.0f, 25.0f));
        } else if (this.key == 61 || this.key == 43) {
            this.adjustSurfaceResolution(-0.15f);
        } else if (this.key == 45 || this.key == 95) {
            this.adjustSurfaceResolution(0.15f);
        } else if (this.key == 91) {
            this.adjustIsoOffset(-0.05f);
        } else if (this.key == 93) {
            this.adjustIsoOffset(0.05f);
        } else if (this.key == 32) {
            this.toggleAutoRotate();
        }
    }

    void handleGUIElement(GUIElement gUIElement) {
        if (gUIElement.id == "prevIni") {
            this.vocab.setInitial(((IncrementorButton)gUIElement).apply(this.vocab.newInitial));
        } else if (gUIElement.id == "nextIni") {
            this.vocab.setInitial(((IncrementorButton)gUIElement).apply(this.vocab.newInitial));
        } else if (gUIElement.id == "help") {
            if (this.helpActive) {
                this.helpActive = false;
                this.helpRequested = false;
            } else {
                this.helpRequested = true;
                this.helpActive = false;
            }
        } else if (gUIElement.id == "autoR") {
            this.toggleAutoRotate();
        } else if (gUIElement.id == "resMinus") {
            this.adjustSurfaceResolution(0.15f);
        } else if (gUIElement.id == "resPlus") {
            this.adjustSurfaceResolution(-0.15f);
        } else if (gUIElement.id == "isoMinus") {
            this.adjustIsoOffset(-0.05f);
        } else if (gUIElement.id == "isoPlus") {
            this.adjustIsoOffset(0.05f);
        } else if (gUIElement.id.indexOf("filter") != -1) {
            this.typeMask = ((BitToggleButton)gUIElement).toggle(this.typeMask);
            this.updateVolume = true;
            this.updateView = true;
        }
    }

    void adjustSurfaceResolution(float f) {
        this.stepSize = this.max(this.min(this.stepSize + f, 2.0f), 0.6f);
        this.updateVolume = true;
        this.updateView = true;
    }

    void adjustIsoOffset(float f) {
        this.isoExponent = this.max(this.min(this.isoExponent + f, 1.5f), 0.75f);
        this.updateVolume = true;
        this.updateView = true;
    }

    void toggleAutoRotate() {
        this.autoRotate ^= true;
        if (!this.autoRotate) {
            this.xRot = this.currXRot;
            this.yRot = this.currYRot;
        } else {
            this.xRot -= this.autoRotR * this.sin(this.autoAlpha);
            this.yRot -= this.autoRotR * this.cos(this.autoAlpha);
        }
    }

    void showHelp() {
        this.blur(3);
        int n = 0;
        while (n < this.pixels.length) {
            this.g.zbuffer[n] = Float.MAX_VALUE;
            ++n;
        }
        this.fill(255.0f, 192.0f);
        this.noStroke();
        n = 160;
        this.rect(0.0f, n, this.width, n + 260);
        if (this.usage == null) {
            this.usage = this.loadStrings("usage.txt");
        }
        this.ft_default.setColor(0);
        this.ft_default.write(this.g, this.usage[0], 50, n += 20, true);
        this.ft_default.write(this.g, this.usage[0], 51, n, true);
        n += 30;
        int n2 = 1;
        while (n2 < this.usage.length) {
            this.ft_default.write(this.g, this.usage[n2], 50, n, true);
            n += 20;
            ++n2;
        }
        this.rollOverNode = null;
        this.helpActive = true;
    }

    void blur(int n) {
        int n2 = 0;
        while (n2 <= n) {
            int n3 = this.width - 1;
            int n4 = this.height - 1;
            int n5 = 0;
            int n6 = 0;
            while (n6 < this.height) {
                int n7 = n6 > 0 ? -this.width : n4 * this.width;
                int n8 = n6 == n4 ? -n4 * this.width : this.width;
                int n9 = 0;
                while (n9 < this.width) {
                    int n10 = n9 > 0 ? -1 : n3;
                    int n11 = 1;
                    if (n9 >= n3) {
                        n11 = -n3;
                    }
                    int n12 = n11;
                    int n13 = this.pixels[n5];
                    int n14 = this.pixels[n10 + n5];
                    int n15 = this.pixels[n12 + n5];
                    int n16 = this.pixels[n7 + n5];
                    int n17 = this.pixels[n8 + n5];
                    int n18 = ((n14 >> 16 & 0xFF) + (n15 >> 16 & 0xFF) + (n13 >> 16 & 0xFF) + (n16 >> 16 & 0xFF) + (n17 >> 16 & 0xFF)) / 5;
                    int n19 = ((n14 >> 8 & 0xFF) + (n15 >> 8 & 0xFF) + (n13 >> 8 & 0xFF) + (n16 >> 8 & 0xFF) + (n17 >> 8 & 0xFF)) / 5;
                    int n20 = ((n14 & 0xFF) + (n15 & 0xFF) + (n13 & 0xFF) + (n16 & 0xFF) + (n17 & 0xFF)) / 5;
                    this.pixels[n5++] = (n18 << 16) + (n19 << 8) + n20;
                    ++n9;
                }
                ++n6;
            }
            ++n2;
        }
    }

    boolean updateIsoValue() {
        float f = this.sqrt(this.surface.totalP) + this.pow(this.surface.numNodes, this.isoExponent);
        if (this.isoValue != f || this.abs(this.vocab.newInitial - this.vocab.currInitial) > 0.01f) {
            this.vocab.currInitial += (this.vocab.newInitial - this.vocab.currInitial) * this.vocab.iniSpeed;
            if (this.abs(f - this.isoValue) > 0.49f) {
                this.isoValue += (f - this.isoValue) * 0.45f;
                return true;
            }
            this.vocab.currInitial = this.vocab.newInitial;
            this.isoValue = f;
            return true;
        }
        return false;
    }

    void drawGrid() {
        this.ft_default.setColor(0x777777);
        this.ft_caps.setColor(0x777777);
        int n = 65;
        int n2 = -13;
        while (n2 < 13) {
            int n3 = -14;
            this.stroke(0.0f, 20.0f);
            if (this.rollOverNode != null) {
                if (this.rollOverNode.desc.value.charAt(2) - 32 == n) {
                    this.ft_caps.putchar(this.g, n - 65, (int)this.screenX(n3 -= 2, 1.0f, n2), (int)this.screenY(n3, 1.0f, n2), false);
                    this.stroke(0.0f, 80.0f);
                } else {
                    this.ft_default.putchar(this.g, n, (int)this.screenX(n3, 1.0f, n2), (int)this.screenY(n3, 1.0f, n2), false);
                }
            } else {
                this.ft_default.putchar(this.g, n, (int)this.screenX(n3, 1.0f, n2), (int)this.screenY(n3, 1.0f, n2), false);
            }
            ++n;
            this.beginShape(32);
            this.vertex(n3 + 1, 0.0f, n2);
            this.vertex(12.0f, 0.0f, n2);
            this.endShape();
            ++n2;
        }
        this.ft_default.setColor(0x444444);
        this.ft_caps.setColor(0x444444);
        n = 65;
        n2 = -13;
        while (n2 < 13) {
            int n4 = -14;
            this.stroke(0.0f, 20.0f);
            if (this.rollOverNode != null) {
                if (this.rollOverNode.desc.value.charAt(1) - 32 == n) {
                    this.ft_caps.putchar(this.g, n - 65, (int)this.screenX(n2, 1.0f, n4 -= 2), (int)this.screenY(n2, 1.0f, n4), false);
                    this.stroke(0.0f, 80.0f);
                } else {
                    this.ft_default.putchar(this.g, n, (int)this.screenX(n2, 1.0f, n4), (int)this.screenY(n2, 1.0f, n4), false);
                }
            } else {
                this.ft_default.putchar(this.g, n, (int)this.screenX(n2, 1.0f, n4), (int)this.screenY(n2, 1.0f, n4), false);
            }
            ++n;
            this.beginShape(32);
            this.vertex(n2, 0.0f, n4 + 1);
            this.vertex(n2, 0.0f, 12.0f);
            this.endShape();
            ++n2;
        }
    }

    void showNodes(float f) {
        float f2;
        int n;
        int n2 = (int)f;
        int n3 = (n2 + 1) % 26;
        float f3 = f - (float)n2;
        float f4 = 1.0f - f3;
        float f5 = f4 * 0.33f;
        Node[] nodeArray = this.vocab.items[n2];
        int n4 = 0;
        if (f4 > 0.1f) {
            n4 = this.vocab.itemCounts[n2];
        }
        int n5 = 0;
        if (f3 > 0.1f) {
            n5 = this.vocab.itemCounts[n3];
        }
        Node[] nodeArray2 = new Node[n4 + n5];
        int n6 = 0;
        float f6 = 0.0f;
        if (f4 > 0.1f) {
            n = 0;
            while (n < this.vocab.itemCounts[n2]) {
                if ((nodeArray[n].desc.type & this.typeMask) > 0) {
                    nodeArray[n].potential = f2 = f4 * nodeArray[n].maxP;
                    nodeArray[n].show(f5);
                    nodeArray2[n6++] = nodeArray[n];
                    f6 += f2;
                }
                ++n;
            }
        }
        if (f3 > 0.1f) {
            f5 = f3 * 0.33f;
            nodeArray = this.vocab.items[n3];
            n = 0;
            while (n < this.vocab.itemCounts[n3]) {
                if ((nodeArray[n].desc.type & this.typeMask) > 0) {
                    nodeArray[n].potential = f2 = f3 * nodeArray[n].maxP;
                    nodeArray[n].show(f5);
                    nodeArray2[n6++] = nodeArray[n];
                    f6 += f2;
                }
                ++n;
            }
        }
        this.surface.setNodes(nodeArray2, n6, f6);
        this.ft_default.setColor(0xFFFFFF);
        this.ft_default.write(this.g, "words: " + base26oop.nf(this.surface.numNodes, 3), 223, 70, true);
    }

    private final /* synthetic */ void this() {
        this.updateView = true;
        this.updateVolume = true;
        this.updateRotation = false;
        this.autoRotate = true;
        this.helpRequested = false;
        this.helpActive = false;
        this.stepSize = 1.0f;
        this.isoValue = 25.0f;
        this.isoExponent = 1.25f;
        this.minPotential = 150.0f;
        this.basePotential = 200.0f;
        this.xRot = 2.88f;
        this.yRot = -0.64f;
        this.autoAlpha = 0.0f;
        this.autoRotR = 0.1f;
        this.centerX = 240.0f;
        this.centerY = 396.0f;
        this.typeMask = 15;
        this.snapDistance = 10.0f;
    }

    public base26oop() {
        this.this();
    }

    class Node {
        float x;
        float y;
        float z;
        float potential;
        float maxP;
        int scrX;
        int scrY;
        boolean isMouseOver;
        Descriptor desc;

        void show(float f) {
            base26oop.this.push();
            base26oop.this.translate(this.x - 13.0f, this.y, this.z - 13.0f);
            this.scrX = (int)base26oop.this.screenX(0.0f, 0.0f, 0.0f);
            this.scrY = (int)base26oop.this.screenY(0.0f, 0.0f, 0.0f);
            boolean bl = false;
            if ((float)(base26oop.this.abs(base26oop.this.mouseX - this.scrX) + base26oop.this.abs(base26oop.this.mouseY - this.scrY)) < base26oop.this.snapDistance) {
                bl = this.isMouseOver = true;
            }
            if (this.isMouseOver) {
                if (base26oop.this.rollOverNode != null) {
                    boolean bl2 = false;
                    if (base26oop.this.screenZ(this.x, this.y, this.z) < base26oop.this.screenZ(base26oop.this.rollOverNode.x, base26oop.this.rollOverNode.y, base26oop.this.rollOverNode.z)) {
                        bl2 = this.isMouseOver = true;
                    }
                }
                if (this.isMouseOver) {
                    base26oop.this.stroke(0);
                    base26oop.this.beginShape(32);
                    base26oop.this.vertex(0.0f, 0.0f, 0.0f);
                    base26oop.this.vertex(0.0f, -this.y, 0.0f);
                    base26oop.this.endShape();
                    base26oop.this.beginShape(33);
                    base26oop.this.vertex(-0.25f, -this.y, -0.25f);
                    base26oop.this.vertex(0.25f, -this.y, -0.25f);
                    base26oop.this.vertex(0.25f, -this.y, 0.25f);
                    base26oop.this.vertex(-0.25f, -this.y, 0.25f);
                    base26oop.this.vertex(-0.25f, -this.y, -0.25f);
                    base26oop.this.endShape();
                    base26oop.this.noStroke();
                    base26oop.this.fill(0);
                    f *= 2.0f;
                    base26oop.this.rollOverNode = this;
                }
            }
            if (!this.isMouseOver) {
                int n = NodeTypes.palette[this.desc.type];
                base26oop.this.fill(n >> 16, n >> 8 & 0xFF, n & 0xFF);
            }
            base26oop.this.box(f);
            base26oop.this.pop();
        }

        void showLabel() {
            base26oop.this.noStroke();
            base26oop.this.fill(255);
            base26oop.this.rect(this.scrX, this.scrY - 16, base26oop.this.width, this.scrY);
            base26oop.this.rect(0.0f, this.scrY, base26oop.this.width, this.scrY + 1);
            base26oop.this.rect(0.0f, this.scrY, 16.0f, this.scrY + 16);
            base26oop.this.ft_default.setColor(0);
            base26oop.this.ft_default.write(base26oop.this.g, this.desc.label, this.scrX + 10, this.scrY - 12, true);
            base26oop.this.ft_default.write(base26oop.this.g, this.desc.label, this.scrX + 11, this.scrY - 12, true);
            base26oop.this.ft_default.write(base26oop.this.g, "> " + NodeTypes.labels[this.desc.type], this.scrX + 45, this.scrY - 12, true);
            base26oop.this.ft_default.putchar(base26oop.this.g, this.desc.value.charAt(3) - 64, 4, this.scrY + 3, true);
        }

        Node(float f, float f2, float f3, String string) {
            this.x = f;
            this.y = f2;
            this.z = f3;
            this.potential = 0.0f;
            this.desc = new Descriptor(string);
        }
    }

    static final class NodeTypes {
        static int[] palette;
        static String[] labels;

        NodeTypes() {
        }

        static {
            int[] nArray = new int[9];
            nArray[1] = 0xFF0044;
            nArray[2] = 0xFFFF00;
            nArray[3] = 0xFF9900;
            nArray[4] = (char)-1;
            nArray[5] = 0xFF66FF;
            nArray[6] = 0x77FF00;
            nArray[7] = 0xFFFFFF;
            nArray[8] = 0x336666;
            palette = nArray;
            labels = new String[]{"", "adjective / adverb", "noun", "adjective + noun", "verb", "adjective + verb", "noun + verb", "adj. + noun + verb", "other"};
        }
    }

    class Descriptor {
        String label;
        String value;
        int type;

        Descriptor(String string) {
            String[] stringArray = base26oop.splitStrings(string, ',');
            if (stringArray.length > 1) {
                this.value = stringArray[0];
                if (stringArray[1].charAt(0) >= 'a') {
                    this.label = stringArray[1];
                    if (stringArray.length > 2) {
                        this.type = Integer.parseInt(stringArray[2]);
                    }
                } else {
                    this.label = this.value;
                    this.type = Integer.parseInt(stringArray[1]);
                }
            } else {
                this.label = this.value = stringArray[0];
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Vocabulary {
        Node[][] items;
        int[] itemCounts;
        float currInitial;
        float iniSpeed;
        float newInitial;

        float normalizeChar(char c) {
            return c - 97;
        }

        void setInitial(float f) {
            this.iniSpeed = base26oop.this.max(1.0f / (base26oop.this.abs(f - this.currInitial) + 1.0f), 0.2f);
            this.newInitial = f;
            base26oop.this.isoValue -= 0.5f;
        }

        private final /* synthetic */ void this() {
            this.currInitial = 0.1f;
            this.iniSpeed = 0.5f;
            this.newInitial = 0.0f;
        }

        Vocabulary(String string) {
            this.this();
            String[] stringArray = base26oop.this.loadStrings(string);
            this.items = new Node[26][];
            this.itemCounts = new int[26];
            int n = 0;
            int n2 = 0;
            char c = '\u0000';
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>(stringArray.length / 2);
            int n3 = 0;
            while (n3 < stringArray.length) {
                String string2;
                if (stringArray[n3].charAt(0) != c) {
                    c = stringArray[n3].charAt(0);
                    n = c - 97;
                    this.items[n] = new Node[200];
                    this.itemCounts[n] = 0;
                    n2 = 0;
                }
                if (!hashtable.containsKey(string2 = stringArray[n3].substring(1, 4))) {
                    hashtable.put(string2, new Integer(1));
                } else {
                    int n4 = (Integer)hashtable.get(string2) + 1;
                    hashtable.remove(string2);
                    hashtable.put(string2, new Integer(n4));
                }
                this.items[n][n2++] = new Node(this.normalizeChar(stringArray[n3].charAt(1)), this.normalizeChar(stringArray[n3].charAt(3)), this.normalizeChar(stringArray[n3].charAt(2)), stringArray[n3]);
                int n5 = n;
                this.itemCounts[n5] = this.itemCounts[n5] + 1;
                ++n3;
            }
            base26oop.this.println("total words: " + stringArray.length);
            base26oop.this.println("unique points: " + hashtable.size());
            n3 = 0;
            while (n3 < 26) {
                int n6 = 0;
                while (n6 < this.itemCounts[n3]) {
                    this.items[n3][n6].maxP = base26oop.this.minPotential + base26oop.this.basePotential * (float)((Integer)hashtable.get(this.items[n3][n6].desc.value.substring(1, 4))).intValue();
                    ++n6;
                }
                ++n3;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class VoxelSpace {
        int w;
        int h;
        int d;
        int w2;
        int h2;
        int d2;
        int gridX;
        int gridY;
        int gridZ;
        float xscale;
        float yscale;
        float zscale;
        int numNodes;
        float totalP;
        float[] cacheX;
        float[] cacheY;
        float[] cacheZ;
        Node[] nodes;
        float[][] _sliceData;
        boolean[][] _edgeFlags;
        int[][] _edges;
        int[][] _offsets;
        int[][] _lines;
        int vCount;

        void setNodes(Node[] nodeArray, int n, float f) {
            this.nodes = nodeArray;
            this.numNodes = n;
            this.totalP = f;
        }

        void update(float f, float f2) {
            this.vCount = 0;
            float f3 = 0.0f;
            while (f3 <= (float)this.d) {
                this.renderSlice(true, f3, f2);
                this.renderSlice(false, f3, f2);
                f3 += f;
            }
            this.nodes = null;
        }

        void render() {
            base26oop.this.beginShape(32);
            int n = 0;
            while (n < this.vCount) {
                base26oop.this.stroke(0.0f, 16.0f + this.cacheY[n] * 2.0f);
                base26oop.this.vertex(this.cacheX[n], this.cacheY[n], this.cacheZ[n]);
                ++n;
            }
            base26oop.this.endShape();
        }

        void renderSlice(boolean bl, float f, float f2) {
            float f3;
            float f4;
            float f5;
            int n;
            float f6;
            int n2;
            float f7;
            int n3;
            if (bl) {
                float f8 = 0.0f;
                n3 = 0;
                while (n3 < this.gridX) {
                    f7 = 0.0f;
                    n2 = 0;
                    while (n2 < this.gridY) {
                        this._edgeFlags[n3][n2] = false;
                        f6 = 0.0f;
                        n = 0;
                        while (n < this.numNodes) {
                            f5 = f8 - this.nodes[n].x;
                            f4 = f7 - this.nodes[n].y;
                            f3 = f - this.nodes[n].z;
                            f6 += this.nodes[n].potential / (f5 * f5 + f4 * f4 + f3 * f3 + 1.0E-4f);
                            ++n;
                        }
                        this._sliceData[n3][n2] = f6;
                        f7 += this.yscale;
                        ++n2;
                    }
                    f8 += this.xscale;
                    ++n3;
                }
                f -= (float)this.d2;
            } else {
                float f9 = 0.0f;
                n3 = 0;
                while (n3 < this.gridZ) {
                    f7 = 0.0f;
                    n2 = 0;
                    while (n2 < this.gridY) {
                        this._edgeFlags[n3][n2] = false;
                        f6 = 0.0f;
                        n = 0;
                        while (n < this.numNodes) {
                            f5 = f - this.nodes[n].x;
                            f4 = f7 - this.nodes[n].y;
                            f3 = f9 - this.nodes[n].z;
                            f6 += this.nodes[n].potential / (f5 * f5 + f4 * f4 + f3 * f3 + 1.0E-4f);
                            ++n;
                        }
                        this._sliceData[n3][n2] = f6;
                        f7 += this.yscale;
                        ++n2;
                    }
                    f9 += this.zscale;
                    ++n3;
                }
                f -= (float)this.w2;
            }
            base26oop.this.beginShape(32);
            int n4 = bl ? this.gridX - 1 : this.gridZ - 1;
            int n5 = this.gridY - 1;
            int n6 = 0;
            while (n6 < n5) {
                int n7 = n6 + 1;
                int n8 = 0;
                int n9 = 1;
                while (n8 < n4) {
                    if (!this._edgeFlags[n8][n6]) {
                        int n10 = 0;
                        if (this._sliceData[n8][n6] < f2) {
                            n10 |= 1;
                        }
                        if (this._sliceData[n9][n6] < f2) {
                            n10 |= 2;
                        }
                        if (this._sliceData[n9][n7] < f2) {
                            n10 |= 4;
                        }
                        if (this._sliceData[n8][n7] < f2) {
                            n10 |= 8;
                        }
                        if (n10 > 0 && n10 < 15) {
                            int n11 = 0;
                            int[] nArray = this._lines[n10];
                            while (nArray[n11] != -1) {
                                int[] nArray2 = this._edges[nArray[n11++]];
                                int[] nArray3 = this._edges[nArray[n11++]];
                                int[] nArray4 = this._offsets[nArray2[1]];
                                int n12 = n8 + nArray4[0];
                                int n13 = n6 + nArray4[1];
                                int[] nArray5 = this._offsets[nArray2[0]];
                                n = n8 + nArray5[0];
                                int n14 = n6 + nArray5[1];
                                float f10 = this._sliceData[n][n14];
                                float f11 = this._sliceData[n12][n13] - f10;
                                float f12 = f11 != 0.0f ? (f2 - f10) / f11 : 0.5f;
                                float f13 = this.xscale * ((float)n + f12 * (float)(n12 - n)) - (float)this.w2;
                                float f14 = this.yscale * ((float)n14 + f12 * (float)(n13 - n14));
                                nArray5 = this._offsets[nArray3[0]];
                                nArray4 = this._offsets[nArray3[1]];
                                n = n8 + nArray5[0];
                                n14 = n6 + nArray5[1];
                                n12 = n8 + nArray4[0];
                                n13 = n6 + nArray4[1];
                                f10 = this._sliceData[n][n14];
                                f11 = this._sliceData[n12][n13] - f10;
                                f12 = f11 != 0.0f ? (f2 - f10) / f11 : 0.5f;
                                float f15 = this.xscale * ((float)n + f12 * (float)(n12 - n)) - (float)this.w2;
                                float f16 = this.yscale * ((float)n14 + f12 * (float)(n13 - n14));
                                if (bl) {
                                    base26oop.this.vertex(f13, f14, f);
                                    base26oop.this.vertex(f15, f16, f);
                                    this.cacheX[this.vCount] = f13;
                                    this.cacheY[this.vCount] = f14;
                                    this.cacheZ[this.vCount++] = f;
                                    this.cacheX[this.vCount] = f15;
                                    this.cacheY[this.vCount] = f16;
                                    this.cacheZ[this.vCount++] = f;
                                } else {
                                    base26oop.this.vertex(f, f14, f13);
                                    base26oop.this.vertex(f, f16, f15);
                                    this.cacheX[this.vCount] = f;
                                    this.cacheY[this.vCount] = f14;
                                    this.cacheZ[this.vCount++] = f13;
                                    this.cacheX[this.vCount] = f;
                                    this.cacheY[this.vCount] = f16;
                                    this.cacheZ[this.vCount++] = f15;
                                }
                                this._edgeFlags[n8][n6] = true;
                            }
                        }
                    }
                    ++n9;
                    ++n8;
                }
                ++n6;
            }
            base26oop.this.endShape();
        }

        private final /* synthetic */ void this() {
            int[][] nArrayArray = new int[4][];
            int[] nArray = new int[2];
            nArray[1] = 1;
            nArrayArray[0] = nArray;
            nArrayArray[1] = new int[]{1, 2};
            nArrayArray[2] = new int[]{2, 3};
            int[] nArray2 = new int[2];
            nArray2[0] = 3;
            nArrayArray[3] = nArray2;
            this._edges = nArrayArray;
            int[][] nArrayArray2 = new int[4][];
            nArrayArray2[0] = new int[2];
            int[] nArray3 = new int[2];
            nArray3[0] = 1;
            nArrayArray2[1] = nArray3;
            nArrayArray2[2] = new int[]{1, 1};
            int[] nArray4 = new int[2];
            nArray4[1] = 1;
            nArrayArray2[3] = nArray4;
            this._offsets = nArrayArray2;
            int[][] nArrayArray3 = new int[16][];
            nArrayArray3[0] = new int[]{-1, -1, -1, -1, -1};
            int[] nArray5 = new int[5];
            nArray5[1] = 3;
            nArray5[2] = -1;
            nArray5[3] = -1;
            nArray5[4] = -1;
            nArrayArray3[1] = nArray5;
            int[] nArray6 = new int[5];
            nArray6[1] = 1;
            nArray6[2] = -1;
            nArray6[3] = -1;
            nArray6[4] = -1;
            nArrayArray3[2] = nArray6;
            nArrayArray3[3] = new int[]{3, 1, -1, -1, -1};
            nArrayArray3[4] = new int[]{1, 2, -1, -1, -1};
            int[] nArray7 = new int[5];
            nArray7[0] = 1;
            nArray7[1] = 2;
            nArray7[3] = 3;
            nArray7[4] = -1;
            nArrayArray3[5] = nArray7;
            int[] nArray8 = new int[5];
            nArray8[1] = 2;
            nArray8[2] = -1;
            nArray8[3] = -1;
            nArray8[4] = -1;
            nArrayArray3[6] = nArray8;
            nArrayArray3[7] = new int[]{3, 2, -1, -1, -1};
            nArrayArray3[8] = new int[]{3, 2, -1, -1, -1};
            int[] nArray9 = new int[5];
            nArray9[1] = 2;
            nArray9[2] = -1;
            nArray9[3] = -1;
            nArray9[4] = -1;
            nArrayArray3[9] = nArray9;
            int[] nArray10 = new int[5];
            nArray10[0] = 3;
            nArray10[1] = 2;
            nArray10[3] = 2;
            nArray10[4] = -1;
            nArrayArray3[10] = nArray10;
            nArrayArray3[11] = new int[]{1, 2, -1, -1, -1};
            nArrayArray3[12] = new int[]{3, 1, -1, -1, -1};
            int[] nArray11 = new int[5];
            nArray11[1] = 1;
            nArray11[2] = -1;
            nArray11[3] = -1;
            nArray11[4] = -1;
            nArrayArray3[13] = nArray11;
            int[] nArray12 = new int[5];
            nArray12[1] = 3;
            nArray12[2] = -1;
            nArray12[3] = -1;
            nArray12[4] = -1;
            nArrayArray3[14] = nArray12;
            nArrayArray3[15] = new int[]{-1, -1, -1, -1, -1};
            this._lines = nArrayArray3;
        }

        VoxelSpace(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            this.this();
            this.w = n;
            this.h = n2;
            this.d = n3;
            this.w2 = this.w >> 1;
            this.d2 = this.d >> 1;
            this.xscale = (float)this.w / (float)n4;
            this.yscale = (float)this.h / (float)n5;
            this.zscale = (float)this.d / (float)n6;
            this.gridX = n4 + 1;
            this.gridY = n5 + 1;
            this.gridZ = n6 + 1;
            this._sliceData = new float[this.gridX][this.gridY];
            this._edgeFlags = new boolean[this.gridX][this.gridY];
            this.cacheX = new float[n7];
            this.cacheY = new float[n7];
            this.cacheZ = new float[n7];
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class FastText {
        int characters;
        int[] charWidth;
        int charHeight;
        int[][] chars;
        int lineHeight;
        int col;
        int wh;
        BImage img;

        void setLineHeight(int n) {
            this.lineHeight = n;
        }

        void setColor(int n) {
            this.col = n;
        }

        void loadFont(String string) {
            this.img = base26oop.this.loadImage(string);
        }

        void putchar(BImage bImage, int n, int n2, int n3, boolean bl) {
            int[] nArray = bImage.pixels;
            n3 *= bImage.width;
            int n4 = 0;
            while (n4 < this.charWidth[n] * this.charHeight) {
                int n5 = n2 + n4 % this.charWidth[n];
                int n6 = n5 + n3 + n4 / this.charWidth[n] * bImage.width;
                if (this.chars[n][n4] == -16777216 && n5 < bImage.width && n6 > 0 && n6 < this.wh) {
                    nArray[n6] = this.col;
                    if (bl) {
                        base26oop.this.g.zbuffer[n6] = 0.0f;
                    }
                }
                ++n4;
            }
        }

        void write(BImage bImage, String string, int n, int n2, int n3, boolean bl) {
            int n4 = 0;
            int n5 = 0;
            while (n5 < string.length()) {
                char c = string.charAt(n5);
                if (c == '\n' || n3 > 0 && n4 > n3) {
                    n4 = 0;
                    n2 += this.lineHeight;
                }
                if (c != '\n') {
                    this.putchar(bImage, c - 32, n + n4, n2, bl);
                    n4 += this.charWidth[c - 32];
                }
                ++n5;
            }
        }

        void write(BImage bImage, String string, int n, int n2, boolean bl) {
            this.write(bImage, string, n, n2, -1, bl);
        }

        private final /* synthetic */ void this() {
            this.charWidth = new int[255];
            this.wh = base26oop.this.width * base26oop.this.height;
        }

        FastText(String string) {
            this.this();
            this.loadFont(string);
            this.lineHeight = this.charHeight = this.img.height;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.img.width) {
                ++n;
                if (this.img.pixels[n3] == -65536) {
                    this.charWidth[this.characters++] = n;
                    if (n > n2) {
                        n2 = n;
                    }
                    n = 0;
                }
                ++n3;
            }
            this.chars = new int[this.characters][n2 * this.charHeight];
            n3 = 0;
            int n4 = 0;
            while (n4 < this.characters) {
                int n5 = 0;
                while (n5 < this.charWidth[n4] * this.charHeight) {
                    this.chars[n4][n5] = this.img.pixels[n3 + n5 / this.charWidth[n4] * this.img.width + n5 % this.charWidth[n4]];
                    ++n5;
                }
                n3 += this.charWidth[n4];
                ++n4;
            }
        }
    }

    class GUI {
        GUIElement[] elements;
        int numElements;

        void addElement(GUIElement gUIElement) {
            if (this.numElements == this.elements.length) {
                GUIElement[] gUIElementArray = new GUIElement[this.numElements << 1];
                System.arraycopy(this.elements, 0, gUIElementArray, 0, this.numElements);
            }
            this.elements[this.numElements++] = gUIElement;
        }

        GUIElement getElementForID(String string) {
            int n = 0;
            while (n < this.numElements) {
                if (this.elements[n].id == string) {
                    return this.elements[n];
                }
                ++n;
            }
            return null;
        }

        void checkElements(boolean bl) {
            GUIElement gUIElement = null;
            int n = 0;
            while (n < this.numElements) {
                if (this.elements[n].mouseOver() && bl) {
                    gUIElement = this.elements[n];
                }
                ++n;
            }
            if (gUIElement != null) {
                base26oop.this.handleGUIElement(gUIElement);
            }
        }

        void draw() {
            int n = 0;
            while (n < this.numElements) {
                this.elements[n].draw();
                ++n;
            }
        }

        GUI() {
            this(1);
        }

        GUI(int n) {
            this.elements = new GUIElement[n];
            this.numElements = 0;
        }

        GUI(GUIElement[] gUIElementArray) {
            this.elements = gUIElementArray;
            this.numElements = gUIElementArray.length;
        }
    }

    abstract class GUIElement {
        boolean active;
        boolean enabled;
        String id;
        int x1;
        int y1;
        int x2;
        int y2;

        boolean mouseOver() {
            if (this.enabled) {
                boolean bl = false;
                if (base26oop.this.mouseX >= this.x1 && base26oop.this.mouseX <= this.x2 && base26oop.this.mouseY >= this.y1 && base26oop.this.mouseY <= this.y2) {
                    bl = true;
                }
                this.active = bl;
                return bl;
            }
            return false;
        }

        void enable() {
            this.enabled = true;
        }

        void disable() {
            this.enabled = false;
        }

        abstract void draw();

        GUIElement() {
        }
    }

    class IncrementorButton
    extends GUIElement {
        float value;
        float minV;
        float maxV;

        void draw() {
            base26oop.this.fill(this.active ? 255 : 153);
            base26oop.this.noStroke();
            base26oop.this.beginShape(64);
            if (this.value > 0.0f) {
                base26oop.this.vertex(this.x1, this.y1);
                base26oop.this.vertex(this.x2, (float)(this.y1 + this.y2) * 0.5f);
                base26oop.this.vertex(this.x1, this.y2);
            } else {
                base26oop.this.vertex(this.x2, this.y1);
                base26oop.this.vertex(this.x1, (float)(this.y1 + this.y2) * 0.5f);
                base26oop.this.vertex(this.x2, this.y2);
            }
            base26oop.this.endShape();
        }

        float apply(float f) {
            return base26oop.this.max(this.minV, base26oop.this.min(this.maxV, f + this.value));
        }

        IncrementorButton(String string, float f, float f2, float f3, int n, int n2, int n3, int n4) {
            this.id = string;
            this.value = f;
            this.minV = f2;
            this.maxV = f3;
            this.x1 = n;
            this.y1 = n2;
            this.x2 = n3;
            this.y2 = n4;
            this.enabled = true;
        }
    }

    class IconButton
    extends GUIElement {
        BImage icon;
        int offX;
        int w;
        int h;
        int drawModeOff;
        int drawModeOn;

        void draw() {
            if (this.active) {
                base26oop.this.blend(this.icon, this.offX, this.h, this.offX + this.w, 2 * this.h, this.x1, this.y1, this.x2, this.y2, this.drawModeOn);
            } else {
                base26oop.this.blend(this.icon, this.offX, 0, this.offX + this.w, this.h, this.x1, this.y1, this.x2, this.y2, this.drawModeOff);
            }
        }

        IconButton(String string, BImage bImage, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            this.icon = bImage;
            this.id = string;
            this.w = n2;
            this.h = n3;
            this.offX = n * this.w;
            this.x1 = n4;
            this.y1 = n5;
            this.x2 = this.x1 + this.w;
            this.y2 = this.y1 + this.h;
            this.drawModeOff = n6;
            this.drawModeOn = n7;
            this.enabled = true;
        }
    }

    class ImagePanel
    extends GUIElement {
        BImage img;
        int w;
        int h;
        int bgCol;
        int drawMode;
        int offsetX;
        int offsetY;
        int minW;
        int minH;
        int ox;
        int oy;

        void draw() {
            base26oop.this.noStroke();
            base26oop.this.fill(this.bgCol);
            base26oop.this.rect(this.x1, this.y1, this.x2, this.y2);
            base26oop.this.fill(255);
            base26oop.this.rect(this.x1, this.y1 - 4, this.x2, this.y1);
            base26oop.this.rect(this.x1 - 4, this.y1, this.x1, this.y2 + 4);
            base26oop.this.rect(this.x2, this.y1, this.x2 + 4, this.y2 + 4);
            base26oop.this.rect(this.x1, this.y2, this.x2, this.y2 + 4);
            base26oop.this.blend(this.img, this.offsetX, this.offsetY, this.offsetX + this.minW, this.offsetY + this.minH, this.ox, this.oy, this.ox + this.minW, this.oy + this.minH, this.drawMode);
        }

        void setOffsetX(int n) {
            this.offsetX = n;
        }

        void setOffsetY(int n) {
            this.offsetY = n;
        }

        ImagePanel(String string, BImage bImage, int n, int n2, int n3, int n4, int n5, int n6) {
            this.id = string;
            this.img = bImage;
            this.x1 = n;
            this.y1 = n2;
            this.w = n3;
            this.h = n4;
            this.x2 = this.x1 + this.w;
            this.y2 = this.y1 + this.h;
            this.bgCol = n5;
            this.drawMode = n6;
            this.minW = base26oop.this.min(this.img.width, this.w);
            this.minH = base26oop.this.min(this.img.height, this.h);
            int n7 = 0;
            if (this.img.width < this.w) {
                n7 = (this.w - this.img.width) / 2;
            }
            this.ox = this.x1 + n7;
            int n8 = 0;
            if (this.img.height < this.h) {
                n8 = (this.h - this.img.height) / 2;
            }
            this.oy = this.y1 + n8;
        }
    }

    class BitToggleButton
    extends GUIElement {
        int bit;
        int bitVal;
        int complBitVal;
        boolean state;
        int y12;

        void draw() {
            base26oop.this.stroke(this.active ? 255 : 153);
            base26oop.this.fill(192);
            base26oop.this.rect(this.x1, this.y1, this.x2, this.y12);
            base26oop.this.rect(this.x1, this.y12 + 2, this.x2, this.y2);
            base26oop.this.noStroke();
            base26oop.this.fill(NodeTypes.palette[this.bitVal] >> 16 & 0xFF, NodeTypes.palette[this.bitVal] >> 8 & 0xFF, NodeTypes.palette[this.bitVal] & 0xFF);
            if (this.state) {
                base26oop.this.rect(this.x1 + 2, this.y1 + 2, this.x2 - 1, this.y12 - 1);
            } else {
                base26oop.this.rect(this.x1 + 2, this.y12 + 4, this.x2 - 1, this.y2 - 1);
            }
        }

        int toggle(int n) {
            this.state ^= true;
            int n2 = 0;
            if (this.state) {
                n2 = this.bitVal;
            }
            return n & this.complBitVal | n2;
        }

        void set(boolean bl) {
            this.state = bl;
        }

        BitToggleButton(String string, int n, int n2, int n3, int n4, int n5, int n6) {
            this.id = string;
            this.x1 = n3;
            this.y1 = n4;
            this.x2 = this.x1 + n5;
            this.y12 = this.y1 + n6;
            this.y2 = this.y1 + 2 * n6 + 2;
            this.bit = n2;
            this.bitVal = 1 << this.bit;
            this.complBitVal = 0xFFFFFFFF ^ this.bitVal;
            boolean bl = false;
            if ((n & this.bitVal) != 0) {
                bl = true;
            }
            this.state = bl;
            this.enabled = true;
        }
    }
}

