/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Calendar;

public class BApplet
extends Applet
implements BConstants,
Runnable,
MouseListener,
MouseMotionListener,
KeyListener {
    static final int DEFAULT_WIDTH = 100;
    static final int DEFAULT_HEIGHT = 100;
    static final int DEFAULT_SAMPLES_LENGTH = 512;
    static byte[] tiffHeader = new byte[]{77, 77, 0, 42, 0, 0, 0, 8, 0, 9, 0, -2, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 3, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 3, 0, 0, 0, 1, 0, 0, 0, 0, 1, 2, 0, 3, 0, 0, 0, 3, 0, 0, 0, 122, 1, 6, 0, 3, 0, 0, 0, 1, 0, 2, 0, 0, 1, 17, 0, 4, 0, 0, 0, 1, 0, 0, 3, 0, 1, 21, 0, 3, 0, 0, 0, 1, 0, 3, 0, 0, 1, 22, 0, 3, 0, 0, 0, 1, 0, 0, 0, 0, 1, 23, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 8, 0, 8};
    private static NumberFormat float_nf;
    private static int float_nf_left;
    private static int float_nf_right;
    private static NumberFormat int_nf;
    private static int int_nf_digits;
    public BGraphics g;
    public int[] pixels;
    DirectColorModel cm;
    MemoryImageSource mis;
    Image image;
    public int mouseX;
    public int mouseY;
    public int pmouseX;
    public int pmouseY;
    boolean firstMouseEvent;
    public boolean mousePressed;
    public MouseEvent mouseEvent;
    public int key;
    public boolean keyPressed;
    public KeyEvent keyEvent;
    boolean timing;
    long actualMillis;
    long millisOffset;
    Calendar calendar;
    protected float fps = 10.0f;
    protected long fpsLastMillis = 0L;
    protected long fpsLastDelayTime = 0L;
    protected float fpsTarget = 0.0f;
    boolean drawMethod;
    boolean loopMethod;
    boolean firstFrame;
    boolean finished;
    boolean drawn;
    Thread thread;
    Exception exception;
    int width;
    int height;
    BServer server;
    BClient client;
    String net;
    int net_mode = 0;
    BSonic sonic;
    public int[] samples;
    public int length = -1;
    public int frequency = -1;
    public boolean sonicInit = false;
    int screenGrabCount = -1;
    boolean isMacintosh;

    public void init() {
        this.checkParams();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.timing = true;
        this.millisOffset = System.currentTimeMillis();
        this.finished = false;
        this.drawn = false;
        this.firstFrame = true;
        this.drawMethod = true;
        this.loopMethod = true;
        this.firstMouseEvent = true;
        try {
            this.setup();
        }
        catch (NullPointerException nullPointerException) {
            this.size(100, 100);
            this.setup();
        }
        if (this.g == null) {
            this.size(100, 100);
        }
        if (!this.sonicInit) {
            this.length = 0;
        } else if (this.sonic == null) {
            this.beginSound();
        }
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
        if (this.sonic != null) {
            this.sonic.start(this);
        }
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
        }
        Thread[] threadArray = new Thread[Thread.activeCount()];
        Thread.enumerate(threadArray);
        int n = 0;
        while (n < threadArray.length) {
            if (threadArray[n] != null && threadArray[n].getName().indexOf("Thread-") == 0) {
                threadArray[n].stop();
            }
            ++n;
        }
        if (this.sonic != null) {
            this.sonic.stop();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    void setup() {
    }

    void draw() {
        this.drawMethod = false;
    }

    void loop() {
        this.loopMethod = false;
    }

    public void size(int n, int n2) {
        if (this.g != null) {
            return;
        }
        this.width = n;
        this.height = n2;
        this.allocate();
        this.g.applet = this;
    }

    public void allocate() {
        this.cm = new DirectColorModel(32, 0xFF0000, 65280, 255);
        this.g = new BGraphics(this.width, this.height);
        this.pixels = this.g.pixels;
        int n = 0;
        while (n < this.pixels.length) {
            this.pixels[n] = -1;
            ++n;
        }
        this.mis = new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width);
        this.mis.setFullBufferUpdates(true);
        this.mis.setAnimated(true);
        this.image = Toolkit.getDefaultToolkit().createImage(this.mis);
    }

    public void paint(Graphics graphics) {
        this.mis.newPixels(this.pixels, (ColorModel)this.cm, 0, this.width);
        graphics.drawImage(this.image, 0, 0, null);
    }

    public void update() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paint(graphics);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void run() {
        while (Thread.currentThread() == this.thread && !this.finished) {
            this.nextFrame();
            if (this.firstFrame) {
                this.firstFrame = false;
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void nextFrame() {
        if (this.timing) {
            this.actualMillis = System.currentTimeMillis();
            this.calendar = null;
        }
        if (this.fpsTarget != 0.0f) {
            this.framerate_delay();
        }
        if (!this.drawn) {
            this.g.beginFrame();
            this.draw();
            if (this.drawMethod) {
                this.g.endFrame();
                this.update();
                if (this.isMacintosh) {
                    this.getToolkit().sync();
                }
                this.finished = true;
            }
            this.drawn = true;
        }
        if (!this.drawMethod) {
            this.g.beginFrame();
            this.loop();
            this.g.endFrame();
            this.update();
            if (this.isMacintosh) {
                this.getToolkit().sync();
            }
        }
        if (!this.loopMethod) {
            this.finished = true;
        }
        this.pmouseX = this.mouseX;
        this.pmouseY = this.mouseY;
    }

    void mouseClicked() {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseClicked();
    }

    void mousePressed() {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseEvent = mouseEvent;
        this.mousePressed = true;
        this.mousePressed();
    }

    void mouseReleased() {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseEvent = mouseEvent;
        this.mousePressed = false;
        this.mouseReleased();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    void mouseDragged() {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseEvent = mouseEvent;
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        if (this.firstMouseEvent) {
            this.pmouseX = this.mouseX;
            this.pmouseY = this.mouseY;
            this.firstMouseEvent = false;
        }
        this.mousePressed = true;
        this.mouseDragged();
    }

    void mouseMoved() {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseEvent = mouseEvent;
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        if (this.firstMouseEvent) {
            this.pmouseX = this.mouseX;
            this.pmouseY = this.mouseY;
            this.firstMouseEvent = false;
        }
        this.mousePressed = false;
        this.mouseMoved();
    }

    void keyTyped() {
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.key = keyEvent.getKeyChar();
        if (this.key == 65535) {
            this.key = keyEvent.getKeyCode();
        }
        this.keyTyped();
    }

    void keyPressed() {
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.keyPressed = true;
        this.key = keyEvent.getKeyChar();
        if (this.key == 65535) {
            this.key = keyEvent.getKeyCode();
        }
        this.keyPressed();
    }

    void keyReleased() {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.keyPressed = false;
        this.key = keyEvent.getKeyChar();
        if (this.key == 65535) {
            this.key = keyEvent.getKeyCode();
        }
        this.keyReleased();
    }

    public int millis() {
        return (int)(this.actualMillis - this.millisOffset);
    }

    public int second() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        return this.calendar.get(13);
    }

    public int minute() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        return this.calendar.get(12);
    }

    public int hour() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        return this.calendar.get(11);
    }

    public int day() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        return this.calendar.get(5);
    }

    public int month() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        return this.calendar.get(2) + 1;
    }

    public int year() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        return this.calendar.get(1);
    }

    public void delay(int n) {
        if (this.firstFrame) {
            return;
        }
        if (n > 0) {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public float framerate() {
        float f;
        if (this.fpsLastMillis != 0L && (f = (float)(this.actualMillis - this.fpsLastMillis)) != 0.0f) {
            this.fps = this.fps * 0.9f + 1.0f / (f / 1000.0f) * 0.1f;
        }
        this.fpsLastMillis = this.actualMillis;
        return this.fps;
    }

    public void framerate(float f) {
        this.fpsTarget = f;
    }

    protected void framerate_delay() {
        if (this.fpsLastDelayTime == 0L) {
            this.fpsLastDelayTime = this.actualMillis;
            return;
        }
        long l = this.fpsLastDelayTime + (long)(1000.0f / this.fpsTarget);
        int n = (int)(l - this.actualMillis);
        this.fpsLastDelayTime = l;
        this.delay(n);
    }

    void link(String string) {
        try {
            this.getAppletContext().showDocument(new URL(string));
        }
        catch (Exception exception) {
            System.err.println("Error while try to show URL: " + string);
            exception.printStackTrace();
        }
    }

    void link(String string, String string2) {
        try {
            this.getAppletContext().showDocument(new URL(string), string2);
        }
        catch (Exception exception) {
            System.err.println("Error while try to show URL: " + string);
            exception.printStackTrace();
        }
    }

    public void beginNet(String string, int n) {
        this.net_mode = 0;
        this.client = new BClient(this, string, n);
        this.client.start();
    }

    public void beginNet(int n) {
        this.net_mode = 1;
        this.server = new BServer(this, n);
        this.server.start();
    }

    void netEvent() {
    }

    void netEvent(int n) {
    }

    public void netWrite(String string) {
        if (this.net_mode == 0) {
            this.client.writeData(string);
        } else if (this.net_mode == 1) {
            this.server.broadcast(string);
        }
    }

    public void endNet() {
        if (this.net_mode == 0) {
            if (this.client != null) {
                this.client.destroy();
            }
        } else if (this.net_mode == 1 && this.server != null) {
            this.server.destroy();
        }
    }

    public void beginSound() {
        this.sonicInit = true;
        if (this.length == -1) {
            this.length = 512;
        }
        this.allocateSound();
    }

    public void beginSound(int n) {
        this.sonicInit = true;
        this.length = n;
        this.allocateSound();
    }

    public void allocateSound() {
        if (this.sonic != null) {
            return;
        }
        this.frequency = 8000;
        this.samples = new int[this.length];
        this.sonic = new BSonic(this.samples);
    }

    public BSound loadSound(String string) {
        BSound bSound = this.sonic.loadSound(string);
        if (bSound == null) {
            bSound = new BSound(1);
        }
        return bSound;
    }

    void soundEvent() {
    }

    public void volume(float f) {
        BSonic.volume(f);
    }

    public void length(int n) {
        if (this.sonic != null) {
            return;
        }
        this.length = n;
    }

    void frequency(int n) {
        if (this.sonic != null) {
            return;
        }
    }

    public void volume(BSound bSound, float f) {
        bSound.volume(f);
    }

    public void speed(BSound bSound, float f) {
        bSound.speed(f);
    }

    public void play(BSound bSound) {
        bSound.play();
    }

    public void pause(BSound bSound) {
        bSound.pause();
    }

    public void repeat(BSound bSound) {
        bSound.repeat();
    }

    public void stop(BSound bSound) {
        bSound.stop();
    }

    public void seek(BSound bSound, int n) {
        bSound.seek(n);
    }

    public void in(BSound bSound, int n) {
        bSound.in(n);
    }

    public void out(BSound bSound, int n) {
        bSound.out(n);
    }

    static byte[] makeTiffData(int[] nArray, int n, int n2) {
        byte[] byArray = new byte[768 + n * n2 * 3];
        System.arraycopy(tiffHeader, 0, byArray, 0, tiffHeader.length);
        byArray[30] = (byte)(n >> 8 & 0xFF);
        byArray[31] = (byte)(n & 0xFF);
        byArray[42] = byArray[102] = (byte)(n2 >> 8 & 0xFF);
        byArray[43] = byArray[103] = (byte)(n2 & 0xFF);
        int n3 = n * n2 * 3;
        byArray[114] = (byte)(n3 >> 24 & 0xFF);
        byArray[115] = (byte)(n3 >> 16 & 0xFF);
        byArray[116] = (byte)(n3 >> 8 & 0xFF);
        byArray[117] = (byte)(n3 & 0xFF);
        int n4 = 768;
        int n5 = 0;
        while (n5 < nArray.length) {
            byArray[n4++] = (byte)(nArray[n5] >> 16 & 0xFF);
            byArray[n4++] = (byte)(nArray[n5] >> 8 & 0xFF);
            byArray[n4++] = (byte)(nArray[n5] & 0xFF);
            ++n5;
        }
        return byArray;
    }

    public void screenGrab() {
        if (this.screenGrabCount == -1) {
            File file = null;
            do {
                ++this.screenGrabCount;
            } while ((file = new File("screen-" + BApplet.nf(this.screenGrabCount, 4) + ".tif")).exists());
        }
        this.screenGrab("screen-" + BApplet.nf(this.screenGrabCount++, 4) + ".tif");
    }

    public void screenGrab(String string) {
        try {
            if (string.toLowerCase().indexOf(".tif") == -1) {
                string = string + ".tif";
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(BApplet.makeTiffData(this.pixels, this.width, this.height));
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void print(boolean bl) {
        System.out.print(bl);
        System.out.flush();
    }

    public void print(char c) {
        System.out.print(c);
        System.out.flush();
    }

    public void print(int n) {
        System.out.print(n);
        System.out.flush();
    }

    public void print(float f) {
        System.out.print(f);
        System.out.flush();
    }

    public void print(double d) {
        System.out.print(d);
        System.out.flush();
    }

    public void print(String string) {
        System.out.print(string);
        System.out.flush();
    }

    public void print(Object object) {
        System.out.print(object.toString());
        System.out.flush();
    }

    public void println(boolean bl) {
        this.print(bl);
        System.out.println();
    }

    public void println(char c) {
        this.print(c);
        System.out.println();
    }

    public void println(int n) {
        this.print(n);
        System.out.println();
    }

    public void println(float f) {
        this.print(f);
        System.out.println();
    }

    public void println(double d) {
        this.print(d);
        System.out.println();
    }

    public void println(String string) {
        this.print(string);
        System.out.println();
    }

    public void println(Object object) {
        System.out.println(object.toString());
    }

    public void println() {
        System.out.println();
    }

    public final float abs(float f) {
        return f < 0.0f ? -f : f;
    }

    public final int abs(int n) {
        return n < 0 ? -n : n;
    }

    public final float sq(float f) {
        return f * f;
    }

    public final float sqrt(float f) {
        return (float)Math.sqrt(f);
    }

    public final float pow(float f, float f2) {
        return (float)Math.pow(f, f2);
    }

    public final float max(float f, float f2) {
        return Math.max(f, f2);
    }

    public final float max(float f, float f2, float f3) {
        return Math.max(f, Math.max(f2, f3));
    }

    public final float min(float f, float f2) {
        return Math.min(f, f2);
    }

    public final float min(float f, float f2, float f3) {
        return Math.min(f, Math.min(f2, f3));
    }

    public final float constrain(float f, float f2, float f3) {
        return f < f2 ? f2 : (f > f3 ? f3 : f);
    }

    public final int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public final int max(int n, int n2, int n3) {
        return n > n2 ? (n > n3 ? n : n3) : n2;
    }

    public final int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public final int min(int n, int n2, int n3) {
        return n < n2 ? (n < n3 ? n : n3) : n2;
    }

    public final int constrain(int n, int n2, int n3) {
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    public final float sin(float f) {
        return (float)Math.sin(f);
    }

    public final float cos(float f) {
        return (float)Math.cos(f);
    }

    public final float tan(float f) {
        return (float)Math.tan(f);
    }

    public final float atan2(float f, float f2) {
        return (float)Math.atan2(f, f2);
    }

    public final float degrees(float f) {
        return f * 57.295776f;
    }

    public final float radians(float f) {
        return f * ((float)Math.PI / 180);
    }

    public final float ceil(float f) {
        return (float)Math.ceil(f);
    }

    public final float floor(float f) {
        return (float)Math.floor(f);
    }

    public final float round(float f) {
        return Math.round(f);
    }

    public final float dist(float f, float f2, float f3, float f4) {
        return this.sqrt(this.sq(f3 - f) + this.sq(f4 - f2));
    }

    public final float dist(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.sqrt(this.sq(f4 - f) + this.sq(f5 - f2) + this.sq(f6 - f3));
    }

    public final float random(float f) {
        return (float)Math.random() * f;
    }

    public final float random(float f, float f2) {
        float f3 = f2 - f;
        return f + (float)Math.random() * f3;
    }

    public static String[] splitStrings(String string) {
        return BApplet.splitStrings(string, ' ');
    }

    public static String[] splitStrings(String string, char c) {
        char[] cArray = string.toCharArray();
        int n = 1;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == c) {
                ++n;
            }
            ++n2;
        }
        if (cArray[cArray.length - 1] == c) {
            --n;
        }
        if (n == 0) {
            String[] stringArray = new String[]{new String(string)};
            return stringArray;
        }
        String[] stringArray = new String[n];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < cArray.length) {
            if (cArray[n5] == c) {
                stringArray[n3++] = new String(cArray, n4, n5 - n4);
                n4 = n5 + 1;
            }
            ++n5;
        }
        if (n4 != cArray.length) {
            stringArray[n3] = new String(cArray, n4, cArray.length - n4);
        }
        return stringArray;
    }

    public static int[] splitInts(String string) {
        return BApplet.splitInts(string, ' ', 0);
    }

    public static int[] splitInts(String string, char c) {
        return BApplet.splitInts(string, c, 0);
    }

    public static int[] splitInts(String string, char c, int n) {
        String[] stringArray = BApplet.splitStrings(string, c);
        if (stringArray == null) {
            return null;
        }
        int[] nArray = new int[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            try {
                nArray[n2] = Integer.parseInt(stringArray[n2]);
            }
            catch (NumberFormatException numberFormatException) {
                nArray[n2] = n;
            }
            ++n2;
        }
        return nArray;
    }

    public static long[] splitLongs(String string) {
        return BApplet.splitLongs(string, ' ', 0L);
    }

    public static long[] splitLongs(String string, char c) {
        return BApplet.splitLongs(string, c, 0L);
    }

    public static long[] splitLongs(String string, char c, long l) {
        String[] stringArray = BApplet.splitStrings(string, c);
        if (stringArray == null) {
            return null;
        }
        long[] lArray = new long[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            try {
                lArray[n] = Long.parseLong(stringArray[n]);
            }
            catch (NumberFormatException numberFormatException) {
                lArray[n] = l;
            }
            ++n;
        }
        return lArray;
    }

    public static float[] splitFloats(String string) {
        return BApplet.splitFloats(string, ' ', Float.NaN);
    }

    public static float[] splitFloats(String string, char c) {
        return BApplet.splitFloats(string, c, Float.NaN);
    }

    public static float[] splitFloats(String string, char c, float f) {
        String[] stringArray = BApplet.splitStrings(string, c);
        if (stringArray == null) {
            return null;
        }
        float[] fArray = new float[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            try {
                fArray[n] = new Float(stringArray[n]).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                fArray[n] = f;
            }
            ++n;
        }
        return fArray;
    }

    public static double[] splitDoubles(String string) {
        return BApplet.splitDoubles(string, ' ', Double.NaN);
    }

    public static double[] splitDoubles(String string, char c) {
        return BApplet.splitDoubles(string, c, Double.NaN);
    }

    public static double[] splitDoubles(String string, char c, double d) {
        String[] stringArray = BApplet.splitStrings(string, c);
        if (stringArray == null) {
            return null;
        }
        double[] dArray = new double[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            try {
                dArray[n] = new Double(stringArray[n]);
            }
            catch (NumberFormatException numberFormatException) {
                dArray[n] = d;
            }
            ++n;
        }
        return dArray;
    }

    public static String join(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n != 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String join(int[] nArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray.length) {
            if (n != 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(nArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String join(int[] nArray, String string, int n) {
        if (n == 0) {
            return BApplet.join(nArray, string);
        }
        NumberFormat numberFormat = null;
        numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(n);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n2 != 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(numberFormat.format(nArray[n2]));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String join(long[] lArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < lArray.length) {
            if (n != 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(lArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String join(long[] lArray, String string, int n) {
        if (n == 0) {
            return BApplet.join(lArray, string);
        }
        NumberFormat numberFormat = null;
        numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumIntegerDigits(n);
        numberFormat.setGroupingUsed(false);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < lArray.length) {
            if (n2 != 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(numberFormat.format(lArray[n2]));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String join(float[] fArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < fArray.length) {
            if (n != 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(fArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String join(float[] fArray, String string, int n, int n2) {
        if (n == 0 && n2 == 0) {
            return BApplet.join(fArray, string);
        }
        NumberFormat numberFormat = null;
        numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        if (n != 0) {
            numberFormat.setMinimumIntegerDigits(n);
        }
        if (n2 != 0) {
            numberFormat.setMinimumFractionDigits(n2);
            numberFormat.setMaximumFractionDigits(n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < fArray.length) {
            if (n3 != 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(numberFormat.format(fArray[n3]));
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String join(double[] dArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < dArray.length) {
            if (n != 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(dArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String join(double[] dArray, String string, int n, int n2) {
        if (n == 0 && n2 == 0) {
            return BApplet.join(dArray, string);
        }
        NumberFormat numberFormat = null;
        numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        if (n != 0) {
            numberFormat.setMinimumIntegerDigits(n);
        }
        if (n2 != 0) {
            numberFormat.setMinimumFractionDigits(n2);
            numberFormat.setMaximumFractionDigits(n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < dArray.length) {
            if (n3 != 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(numberFormat.format(dArray[n3]));
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String nf(float f, int n, int n2) {
        if (float_nf != null && float_nf_left == n && float_nf_right == n2) {
            return float_nf.format(f);
        }
        float_nf = NumberFormat.getInstance();
        float_nf.setGroupingUsed(false);
        if (n != 0) {
            float_nf.setMinimumIntegerDigits(n);
        }
        if (n2 != 0) {
            float_nf.setMinimumFractionDigits(n2);
            float_nf.setMaximumFractionDigits(n2);
        }
        float_nf_left = n;
        float_nf_right = n2;
        return float_nf.format(f);
    }

    public static String nf(int n, int n2) {
        if (int_nf != null && int_nf_digits == n2) {
            return int_nf.format(n);
        }
        int_nf = NumberFormat.getInstance();
        int_nf.setGroupingUsed(false);
        int_nf.setMinimumIntegerDigits(n2);
        int_nf_digits = n2;
        return int_nf.format(n);
    }

    public static String nfs(float f, int n, int n2) {
        return BApplet.nfs(f, n, n2, false);
    }

    public static String nfs(float f, int n, int n2, boolean bl) {
        if (f < 0.0f) {
            return BApplet.nf(f, n, n2);
        }
        return (bl ? (char)'+' : ' ') + BApplet.nf(f, n, n2);
    }

    public static String nfs(int n, int n2) {
        return BApplet.nfs(n, n2, false);
    }

    public static String nfs(int n, int n2, boolean bl) {
        if (n < 0) {
            return BApplet.nf(n, n2);
        }
        return (bl ? (char)'+' : ' ') + BApplet.nf(n, n2);
    }

    void checkParams() {
        this.isMacintosh = System.getProperty("os.name").toLowerCase().indexOf("mac") != -1;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("error: BApplet <appletname>");
            System.exit(1);
        }
        try {
            Frame frame = new Frame();
            Class<?> clazz = Class.forName(stringArray[0]);
            BApplet bApplet = (BApplet)clazz.newInstance();
            bApplet.init();
            bApplet.start();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            frame.setLayout(new BorderLayout());
            frame.add((Component)bApplet, "Center");
            frame.pack();
            ((Component)frame).setLocation((dimension.width - bApplet.g.width) / 2, (dimension.height - bApplet.g.height) / 2);
            frame.show();
            bApplet.requestFocus();
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void defaults() {
        this.g.defaults();
    }

    public void beginFrame() {
        this.g.beginFrame();
    }

    public void clear() {
        this.g.clear();
    }

    public void endFrame() {
        this.g.endFrame();
    }

    public void beginShape() {
        this.g.beginShape();
    }

    public void beginShape(int n) {
        this.g.beginShape(n);
    }

    public void textureImage(BImage bImage) {
        this.g.textureImage(bImage);
    }

    public void vertexTexture(float f, float f2) {
        this.g.vertexTexture(f, f2);
    }

    public void vertexNormal(float f, float f2, float f3) {
        this.g.vertexNormal(f, f2, f3);
    }

    public void vertex(float f, float f2) {
        this.g.vertex(f, f2);
    }

    public void vertex(float f, float f2, float f3) {
        this.g.vertex(f, f2, f3);
    }

    public void bezierVertex(float f, float f2) {
        this.g.bezierVertex(f, f2);
    }

    public void bezierVertex(float f, float f2, float f3) {
        this.g.bezierVertex(f, f2, f3);
    }

    public void curveVertex(float f, float f2) {
        this.g.curveVertex(f, f2);
    }

    public void curveVertex(float f, float f2, float f3) {
        this.g.curveVertex(f, f2, f3);
    }

    public void endShape() {
        this.g.endShape();
    }

    public void simage(BImage bImage, int n, int n2) {
        this.g.simage(bImage, n, n2);
    }

    public void point(float f, float f2) {
        this.g.point(f, f2);
    }

    public void point(float f, float f2, float f3) {
        this.g.point(f, f2, f3);
    }

    public void line(float f, float f2, float f3, float f4) {
        this.g.line(f, f2, f3, f4);
    }

    public void line(float f, float f2, float f3, float f4, float f5, float f6) {
        this.g.line(f, f2, f3, f4, f5, f6);
    }

    public void triangle(float f, float f2, float f3, float f4, float f5, float f6) {
        this.g.triangle(f, f2, f3, f4, f5, f6);
    }

    public void quad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.g.quad(f, f2, f3, f4, f5, f6, f7, f8);
    }

    public void rectMode(int n) {
        this.g.rectMode(n);
    }

    public void rect(float f, float f2, float f3, float f4) {
        this.g.rect(f, f2, f3, f4);
    }

    public void ellipseMode(int n) {
        this.g.ellipseMode(n);
    }

    public void ellipse(float f, float f2, float f3, float f4) {
        this.g.ellipse(f, f2, f3, f4);
    }

    public void box(float f) {
        this.g.box(f);
    }

    public void box(float f, float f2, float f3) {
        this.g.box(f, f2, f3);
    }

    public void sphere(float f) {
        this.g.sphere(f);
    }

    public void potato() {
        this.g.potato();
    }

    public void bezier(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.g.bezier(f, f2, f3, f4, f5, f6, f7, f8);
    }

    public void bezier(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.g.bezier(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    public void curve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.g.curve(f, f2, f3, f4, f5, f6, f7, f8);
    }

    public void curve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.g.curve(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    public BImage loadImage(String string) {
        return this.g.loadImage(string);
    }

    public BImage loadImage(String string, boolean bl) {
        return this.g.loadImage(string, bl);
    }

    public void imageMode(int n) {
        this.g.imageMode(n);
    }

    public void image(BImage bImage, float f, float f2) {
        this.g.image(bImage, f, f2);
    }

    public void image(BImage bImage, float f, float f2, float f3, float f4) {
        this.g.image(bImage, f, f2, f3, f4);
    }

    public void image(BImage bImage, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.g.image(bImage, f, f2, f3, f4, f5, f6, f7, f8);
    }

    public void cache(BImage bImage) {
        this.g.cache(bImage);
    }

    public void cache(BImage[] bImageArray) {
        this.g.cache(bImageArray);
    }

    public BFont loadFont(String string) {
        return this.g.loadFont(string);
    }

    public void setFont(BFont bFont) {
        this.g.setFont(bFont);
    }

    public void setFont(BFont bFont, float f) {
        this.g.setFont(bFont, f);
    }

    public void text(char c, float f, float f2) {
        this.g.text(c, f, f2);
    }

    public void text(String string, float f, float f2) {
        this.g.text(string, f, f2);
    }

    public void push() {
        this.g.push();
    }

    public void pop() {
        this.g.pop();
    }

    public void resetMatrix() {
        this.g.resetMatrix();
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.g.applyMatrix(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    public void beginCamera() {
        this.g.beginCamera();
    }

    public void cameraMode(int n) {
        this.g.cameraMode(n);
    }

    public void endCamera() {
        this.g.endCamera();
    }

    public float screenX(float f, float f2, float f3) {
        return this.g.screenX(f, f2, f3);
    }

    public float screenY(float f, float f2, float f3) {
        return this.g.screenY(f, f2, f3);
    }

    public float screenZ(float f, float f2, float f3) {
        return this.g.screenZ(f, f2, f3);
    }

    public float objectX(float f, float f2, float f3) {
        return this.g.objectX(f, f2, f3);
    }

    public float objectY(float f, float f2, float f3) {
        return this.g.objectY(f, f2, f3);
    }

    public float objectZ(float f, float f2, float f3) {
        return this.g.objectZ(f, f2, f3);
    }

    public void ortho(float f, float f2, float f3, float f4, float f5, float f6) {
        this.g.ortho(f, f2, f3, f4, f5, f6);
    }

    public void perspective(float f, float f2, float f3, float f4) {
        this.g.perspective(f, f2, f3, f4);
    }

    public void frustum(float f, float f2, float f3, float f4, float f5, float f6) {
        this.g.frustum(f, f2, f3, f4, f5, f6);
    }

    public void lookat(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.g.lookat(f, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    public void translate(float f, float f2) {
        this.g.translate(f, f2);
    }

    public void translate(float f, float f2, float f3) {
        this.g.translate(f, f2, f3);
    }

    public void shearX(float f) {
        this.g.shearX(f);
    }

    public void shearY(float f) {
        this.g.shearY(f);
    }

    public void rotateX(float f) {
        this.g.rotateX(f);
    }

    public void rotateY(float f) {
        this.g.rotateY(f);
    }

    public void rotate(float f) {
        this.g.rotate(f);
    }

    public void rotateZ(float f) {
        this.g.rotateZ(f);
    }

    public void rotate(float f, float f2, float f3, float f4) {
        this.g.rotate(f, f2, f3, f4);
    }

    public void scale(float f) {
        this.g.scale(f);
    }

    public void scale(float f, float f2) {
        this.g.scale(f, f2);
    }

    public void scale(float f, float f2, float f3) {
        this.g.scale(f, f2, f3);
    }

    public void transform(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.g.transform(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    public void colorMode(int n) {
        this.g.colorMode(n);
    }

    public void colorMode(int n, float f) {
        this.g.colorMode(n, f);
    }

    public void colorMode(int n, float f, float f2, float f3) {
        this.g.colorMode(n, f, f2, f3);
    }

    public void colorMode(int n, float f, float f2, float f3, float f4) {
        this.g.colorMode(n, f, f2, f3, f4);
    }

    public void noFill() {
        this.g.noFill();
    }

    public int fill() {
        return this.g.fill();
    }

    public void fill(int n) {
        this.g.fill(n);
    }

    public void fill(float f) {
        this.g.fill(f);
    }

    public void fill(float f, float f2) {
        this.g.fill(f, f2);
    }

    public void fill(float f, float f2, float f3) {
        this.g.fill(f, f2, f3);
    }

    public void fill(float f, float f2, float f3, float f4) {
        this.g.fill(f, f2, f3, f4);
    }

    public void strokeWidth(float f) {
        this.g.strokeWidth(f);
    }

    public void strokeMode(int n) {
        this.g.strokeMode(n);
    }

    public void noStroke() {
        this.g.noStroke();
    }

    public int stroke() {
        return this.g.stroke();
    }

    public void stroke(int n) {
        this.g.stroke(n);
    }

    public void stroke(float f) {
        this.g.stroke(f);
    }

    public void stroke(float f, float f2) {
        this.g.stroke(f, f2);
    }

    public void stroke(float f, float f2, float f3) {
        this.g.stroke(f, f2, f3);
    }

    public void stroke(float f, float f2, float f3, float f4) {
        this.g.stroke(f, f2, f3, f4);
    }

    public void noBackground() {
        this.g.noBackground();
    }

    public int background() {
        return this.g.background();
    }

    public void background(int n) {
        this.g.background(n);
    }

    public void background(float f) {
        this.g.background(f);
    }

    public void background(float f, float f2, float f3) {
        this.g.background(f, f2, f3);
    }

    public void lights() {
        this.g.lights();
    }

    public void noLights() {
        this.g.noLights();
    }

    public void smooth() {
        this.g.smooth();
    }

    public void noSmooth() {
        this.g.noSmooth();
    }

    public void hint(int n) {
        this.g.hint(n);
    }

    public void unhint(int n) {
        this.g.unhint(n);
    }

    public void message(int n, String string) {
        this.g.message(n, string);
    }

    public void message(int n, String string, Exception exception) {
        this.g.message(n, string, exception);
    }

    public InputStream loadStream(String string) throws IOException {
        return this.g.loadStream(string);
    }

    public byte[] loadBytes(String string) {
        return this.g.loadBytes(string);
    }

    public byte[] loadBytes(InputStream inputStream) {
        return this.g.loadBytes(inputStream);
    }

    public String[] loadStrings(String string) {
        return this.g.loadStrings(string);
    }

    public String[] loadStrings(InputStream inputStream) {
        return this.g.loadStrings(inputStream);
    }

    public void sort(String[] stringArray) {
        this.g.sort(stringArray);
    }

    public void sort(int[] nArray) {
        this.g.sort(nArray);
    }

    public void sort(float[] fArray) {
        this.g.sort(fArray);
    }

    public void sort(double[] dArray) {
        this.g.sort(dArray);
    }

    public void sort(String[] stringArray, int n) {
        this.g.sort(stringArray, n);
    }

    public void sort(int[] nArray, int n) {
        this.g.sort(nArray, n);
    }

    public void sort(float[] fArray, int n) {
        this.g.sort(fArray, n);
    }

    public void sort(double[] dArray, int n) {
        this.g.sort(dArray, n);
    }

    public int getPixel(int n, int n2) {
        return this.g.getPixel(n, n2);
    }

    public void setPixel(int n, int n2, int n3) {
        this.g.setPixel(n, n2, n3);
    }

    public final int color(float f, float f2, float f3) {
        return this.g.color(f, f2, f3);
    }

    public final int color(float f, float f2, float f3, float f4) {
        return this.g.color(f, f2, f3, f4);
    }

    public final float red(int n) {
        return this.g.red(n);
    }

    public final float green(int n) {
        return this.g.green(n);
    }

    public final float blue(int n) {
        return this.g.blue(n);
    }

    public final float hue(int n) {
        return this.g.hue(n);
    }

    public final float saturation(int n) {
        return this.g.saturation(n);
    }

    public final float brightness(int n) {
        return this.g.brightness(n);
    }
}

