/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;

public class BServer
implements Runnable {
    BApplet parent;
    Thread runner = null;
    private Vector clients = new Vector();
    ServerSocket server;
    int port;
    int numClients = 0;
    int nextclientID = 0;

    public synchronized void broadcast(String string) {
        string = string + "\u0000";
        Enumeration enumeration = this.clients.elements();
        while (enumeration.hasMoreElements()) {
            BServerClient bServerClient = (BServerClient)enumeration.nextElement();
            bServerClient.send(string);
        }
    }

    public void removeClient(BServerClient bServerClient) {
        this.printLog(bServerClient.getIP() + " has left the server");
        this.clients.removeElement(bServerClient);
        this.parent.netEvent(1);
    }

    public void printLog(String string) {
        Calendar calendar = Calendar.getInstance();
        string = "[" + calendar.get(2) + "/" + calendar.get(5) + "/" + calendar.get(1) + " " + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13) + "] " + string + "\n";
        System.out.print(string);
    }

    private void killServer() {
        try {
            this.server.close();
            this.printLog("Server stopped");
        }
        catch (IOException iOException) {
            this.printLog("Error while stopping server");
        }
    }

    public void start() {
        if (this.runner == null) {
            this.runner = new Thread(this);
            this.runner.start();
        }
    }

    public void run() {
        while (Thread.currentThread() == this.runner) {
            try {
                Socket socket = this.server.accept();
                BServerClient bServerClient = new BServerClient(this, socket);
                this.printLog(bServerClient.getIP() + " connected to the server");
                this.clients.addElement(bServerClient);
                bServerClient.start();
                this.numClients = this.clients.size();
            }
            catch (IOException iOException) {
                this.printLog("Network server error...stopping server");
                this.killServer();
            }
            try {
                Thread.sleep(8L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public void destroy() {
        this.runner = null;
        this.killServer();
    }

    public void stop() {
    }

    public BServer(BApplet bApplet, int n) {
        this.parent = bApplet;
        this.port = n;
        this.printLog("Starting network server...");
        try {
            this.server = new ServerSocket(this.port);
            System.out.println("Network server started on port: " + n);
        }
        catch (IOException iOException) {
            this.printLog("Network server error... stopping server");
            this.killServer();
        }
    }

    public class BServerClient
    extends Thread {
        private Thread thrThis;
        private Socket socket;
        private BServer server;
        private String ip;
        protected BufferedReader in;
        protected PrintWriter out;

        public void run() {
            try {
                try {
                    char[] cArray = new char[1];
                    while (this.in.read(cArray, 0, 1) != -1) {
                        StringBuffer stringBuffer = new StringBuffer(8192);
                        while (cArray[0] != '\u0000') {
                            stringBuffer.append(cArray[0]);
                            this.in.read(cArray, 0, 1);
                        }
                        BServer.this.parent.net = stringBuffer.toString();
                        this.server.broadcast(stringBuffer.toString());
                        BServer.this.parent.netEvent();
                    }
                }
                catch (IOException iOException) {
                    this.server.printLog("Client IP: " + this.ip + " caused a read error " + iOException + " : " + iOException.getMessage() + "and has been disconnected.");
                    Object var2_5 = null;
                    this.killClient();
                }
                Object var2_4 = null;
                this.killClient();
            }
            catch (Throwable throwable) {
                Object var2_6 = null;
                this.killClient();
                throw throwable;
            }
        }

        public String getIP() {
            return this.ip;
        }

        public void send(String string) {
            this.out.print(string);
            this.out.flush();
            if (this.out.checkError()) {
                this.server.printLog("Client IP: " + this.ip + " caused a write error " + "and has been disconnected.");
                this.killClient();
            }
        }

        private void killClient() {
            this.server.removeClient(this);
            try {
                this.in.close();
                this.out.close();
                this.socket.close();
                this.thrThis = null;
            }
            catch (IOException iOException) {
                this.server.printLog("Client IP: " + this.ip + " caused an error " + "while disconnecting.");
            }
        }

        public BServerClient(BServer bServer2, Socket socket) {
            this.server = bServer2;
            this.socket = socket;
            this.ip = socket.getInetAddress().getHostAddress();
            try {
                this.in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                this.out = new PrintWriter(socket.getOutputStream(), true);
            }
            catch (IOException iOException) {
                bServer2.printLog("Client IP: " + this.ip + " could not be " + "initialized and has been disconnected.");
                this.killClient();
            }
        }
    }
}

