###`sources.conf`
* Contains a categorized list of the contributions' properties file URLs.
* Edited by a human in three easy steps:
    1. Remember the value of _Next ID_ at the top.
	1. Add the URL in the right category, prefixed by the next ID number.
	1. Increment the value of _Next ID_ at the top.

###`broken.conf`
* Contains IDs of broken contributions. These will still appear in the PDE but will be disabled (greyed out).
* Edited by a human.
* Read by `build_listing.py`.

###`skipped.conf`
* Contains IDs of contributions to skip. These will not appear in the PDE. This list currently holds 2.x entries that have a 3.x counterpart, so that they are not listed twice.
* Edited by a human.
* Read by `build_listing.py`.

###`build_listing.py`
* Reads `sources.conf` and writes `contribs.txt`
* Use it by running the following in the command line:

	```
	python build_listing.py
	```

* Pass in arguments for the input and output files:

	```
	python build_listing.py sources.conf contribs.txt
	```

* Pass in arguments for the compatible Processing revisions: 

	```
	python build_listing.py sources.conf contribs.txt 216 227
	```

	* Entries out of range will be skipped
	* You can use `0` to ignore the limit: `python build_listing.py sources.conf contribs.txt 228 0`

###`contribs.txt`
* Contains all the data for all the contributions.
* Generated by a machine using the `build_listing.py` script.

###`legacy.txt`
* Contains all the data for the older contributions that have not been updated for the new system.
* Edited by a human by copy/pasting/editing.

###Processing 2.x
* Processing 2.x read data from the `contributions.txt` file and should only include compatible entries. This file must be generated using the `build_listing_legacy.py` script:

	```
	python build_listing_legacy.py
	```
