Gem::Specification.new do |s|
  s.specification_version = 2 if s.respond_to? :specification_version=
  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.rubygems_version = '1.3.5'

  ## Leave these as is they will be modified for you by the rake gemspec task.
  ## If your rubyforge_project name is different, then edit it and comment out
  ## the sub! line in the Rakefile
  s.name              = 'fog'
  s.version           = '0.3.7'
  s.date              = '2010-09-29'
  s.rubyforge_project = 'fog'

  ## Make sure your summary is short. The description may be as long
  ## as you like.
  s.summary     = "brings clouds to you"
  s.description = "The Ruby cloud computing library."

  ## List the primary authors. If there are a bunch of authors, it's probably
  ## better to set the email to an email list or something. If you don't have
  ## a custom homepage, consider using your GitHub URL or the like.
  s.authors  = ["geemus (Wesley Beary)"]
  s.email    = 'geemus@gmail.com'
  s.homepage = 'http://github.com/geemus/fog'

  ## This gets added to the $LOAD_PATH so that 'lib/NAME.rb' can be required as
  ## require 'NAME.rb' or'/lib/NAME/file.rb' can be as require 'NAME/file.rb'
  s.require_paths = %w[lib]

  ## This sections is only necessary if you have C extensions.
  # s.require_paths << 'ext'
  # s.extensions = %w[ext/extconf.rb]

  ## If your gem includes any executables, list them here.
  s.executables = ["fog"]
  s.default_executable = 'fog'

  ## Specify any RDoc options here. You'll want to add your README and
  ## LICENSE files to the extra_rdoc_files list.
  s.rdoc_options = ["--charset=UTF-8"]
  s.extra_rdoc_files = %w[README.rdoc]

  ## List your runtime dependencies here. Runtime dependencies are those
  ## that are needed for an end user to actually USE your code.
  s.add_dependency('builder')
  s.add_dependency('excon', '>=0.2.3')
  s.add_dependency('formatador', '>=0.0.15')
  s.add_dependency('json')
  s.add_dependency('mime-types')
  s.add_dependency('net-ssh')
  s.add_dependency('nokogiri', '>=1.4.3.1')
  s.add_dependency('ruby-hmac')

  ## List your development dependencies here. Development dependencies are
  ## those that are only needed during development
  s.add_development_dependency('rake')
  s.add_development_dependency('rspec')
  s.add_development_dependency('shindo', '0.1.6')

  ## Leave this section as-is. It will be automatically generated from the
  ## contents of your Git repository via the gemspec task. DO NOT REMOVE
  ## THE MANIFEST COMMENTS, they are used as delimiters by the task.
  # = MANIFEST =
  s.files = %w[
    Gemfile
    Gemfile.lock
    README.rdoc
    Rakefile
    benchs/fog_vs.rb
    benchs/params.rb
    benchs/parse_vs_push.rb
    bin/fog
    examples/bluebox_create.rb
    fog.gemspec
    lib/fog.rb
    lib/fog/attributes.rb
    lib/fog/aws.rb
    lib/fog/aws/bin.rb
    lib/fog/aws/compute.rb
    lib/fog/aws/ec2.rb
    lib/fog/aws/elb.rb
    lib/fog/aws/models/compute/address.rb
    lib/fog/aws/models/compute/addresses.rb
    lib/fog/aws/models/compute/flavor.rb
    lib/fog/aws/models/compute/flavors.rb
    lib/fog/aws/models/compute/image.rb
    lib/fog/aws/models/compute/images.rb
    lib/fog/aws/models/compute/key_pair.rb
    lib/fog/aws/models/compute/key_pairs.rb
    lib/fog/aws/models/compute/security_group.rb
    lib/fog/aws/models/compute/security_groups.rb
    lib/fog/aws/models/compute/server.rb
    lib/fog/aws/models/compute/servers.rb
    lib/fog/aws/models/compute/snapshot.rb
    lib/fog/aws/models/compute/snapshots.rb
    lib/fog/aws/models/compute/volume.rb
    lib/fog/aws/models/compute/volumes.rb
    lib/fog/aws/models/storage/directories.rb
    lib/fog/aws/models/storage/directory.rb
    lib/fog/aws/models/storage/file.rb
    lib/fog/aws/models/storage/files.rb
    lib/fog/aws/parsers/compute/allocate_address.rb
    lib/fog/aws/parsers/compute/attach_volume.rb
    lib/fog/aws/parsers/compute/basic.rb
    lib/fog/aws/parsers/compute/create_image.rb
    lib/fog/aws/parsers/compute/create_key_pair.rb
    lib/fog/aws/parsers/compute/create_snapshot.rb
    lib/fog/aws/parsers/compute/create_volume.rb
    lib/fog/aws/parsers/compute/deregister_image.rb
    lib/fog/aws/parsers/compute/describe_addresses.rb
    lib/fog/aws/parsers/compute/describe_availability_zones.rb
    lib/fog/aws/parsers/compute/describe_images.rb
    lib/fog/aws/parsers/compute/describe_instances.rb
    lib/fog/aws/parsers/compute/describe_key_pairs.rb
    lib/fog/aws/parsers/compute/describe_regions.rb
    lib/fog/aws/parsers/compute/describe_reserved_instances.rb
    lib/fog/aws/parsers/compute/describe_security_groups.rb
    lib/fog/aws/parsers/compute/describe_snapshots.rb
    lib/fog/aws/parsers/compute/describe_volumes.rb
    lib/fog/aws/parsers/compute/detach_volume.rb
    lib/fog/aws/parsers/compute/get_console_output.rb
    lib/fog/aws/parsers/compute/import_key_pair.rb
    lib/fog/aws/parsers/compute/register_image.rb
    lib/fog/aws/parsers/compute/run_instances.rb
    lib/fog/aws/parsers/compute/start_stop_instances.rb
    lib/fog/aws/parsers/compute/terminate_instances.rb
    lib/fog/aws/parsers/elb/create_load_balancer.rb
    lib/fog/aws/parsers/elb/delete_load_balancer.rb
    lib/fog/aws/parsers/elb/deregister_instances_from_load_balancer.rb
    lib/fog/aws/parsers/elb/describe_instance_health.rb
    lib/fog/aws/parsers/elb/describe_load_balancers.rb
    lib/fog/aws/parsers/elb/disable_availability_zones_for_load_balancer.rb
    lib/fog/aws/parsers/elb/enable_availability_zones_for_load_balancer.rb
    lib/fog/aws/parsers/elb/register_instances_with_load_balancer.rb
    lib/fog/aws/parsers/simpledb/basic.rb
    lib/fog/aws/parsers/simpledb/domain_metadata.rb
    lib/fog/aws/parsers/simpledb/get_attributes.rb
    lib/fog/aws/parsers/simpledb/list_domains.rb
    lib/fog/aws/parsers/simpledb/select.rb
    lib/fog/aws/parsers/storage/access_control_list.rb
    lib/fog/aws/parsers/storage/copy_object.rb
    lib/fog/aws/parsers/storage/get_bucket.rb
    lib/fog/aws/parsers/storage/get_bucket_location.rb
    lib/fog/aws/parsers/storage/get_bucket_logging.rb
    lib/fog/aws/parsers/storage/get_bucket_object_versions.rb
    lib/fog/aws/parsers/storage/get_bucket_versioning.rb
    lib/fog/aws/parsers/storage/get_request_payment.rb
    lib/fog/aws/parsers/storage/get_service.rb
    lib/fog/aws/requests/compute/allocate_address.rb
    lib/fog/aws/requests/compute/associate_address.rb
    lib/fog/aws/requests/compute/attach_volume.rb
    lib/fog/aws/requests/compute/authorize_security_group_ingress.rb
    lib/fog/aws/requests/compute/create_image.rb
    lib/fog/aws/requests/compute/create_key_pair.rb
    lib/fog/aws/requests/compute/create_security_group.rb
    lib/fog/aws/requests/compute/create_snapshot.rb
    lib/fog/aws/requests/compute/create_volume.rb
    lib/fog/aws/requests/compute/delete_key_pair.rb
    lib/fog/aws/requests/compute/delete_security_group.rb
    lib/fog/aws/requests/compute/delete_snapshot.rb
    lib/fog/aws/requests/compute/delete_volume.rb
    lib/fog/aws/requests/compute/deregister_image.rb
    lib/fog/aws/requests/compute/describe_addresses.rb
    lib/fog/aws/requests/compute/describe_availability_zones.rb
    lib/fog/aws/requests/compute/describe_images.rb
    lib/fog/aws/requests/compute/describe_instances.rb
    lib/fog/aws/requests/compute/describe_key_pairs.rb
    lib/fog/aws/requests/compute/describe_regions.rb
    lib/fog/aws/requests/compute/describe_reserved_instances.rb
    lib/fog/aws/requests/compute/describe_security_groups.rb
    lib/fog/aws/requests/compute/describe_snapshots.rb
    lib/fog/aws/requests/compute/describe_volumes.rb
    lib/fog/aws/requests/compute/detach_volume.rb
    lib/fog/aws/requests/compute/disassociate_address.rb
    lib/fog/aws/requests/compute/get_console_output.rb
    lib/fog/aws/requests/compute/import_key_pair.rb
    lib/fog/aws/requests/compute/modify_image_attributes.rb
    lib/fog/aws/requests/compute/modify_snapshot_attribute.rb
    lib/fog/aws/requests/compute/reboot_instances.rb
    lib/fog/aws/requests/compute/register_image.rb
    lib/fog/aws/requests/compute/release_address.rb
    lib/fog/aws/requests/compute/revoke_security_group_ingress.rb
    lib/fog/aws/requests/compute/run_instances.rb
    lib/fog/aws/requests/compute/start_instances.rb
    lib/fog/aws/requests/compute/stop_instances.rb
    lib/fog/aws/requests/compute/terminate_instances.rb
    lib/fog/aws/requests/elb/create_load_balancer.rb
    lib/fog/aws/requests/elb/delete_load_balancer.rb
    lib/fog/aws/requests/elb/deregister_instances_from_load_balancer.rb
    lib/fog/aws/requests/elb/describe_instance_health.rb
    lib/fog/aws/requests/elb/describe_load_balancers.rb
    lib/fog/aws/requests/elb/disable_availability_zones_for_load_balancer.rb
    lib/fog/aws/requests/elb/enable_availability_zones_for_load_balancer.rb
    lib/fog/aws/requests/elb/register_instances_with_load_balancer.rb
    lib/fog/aws/requests/simpledb/batch_put_attributes.rb
    lib/fog/aws/requests/simpledb/create_domain.rb
    lib/fog/aws/requests/simpledb/delete_attributes.rb
    lib/fog/aws/requests/simpledb/delete_domain.rb
    lib/fog/aws/requests/simpledb/domain_metadata.rb
    lib/fog/aws/requests/simpledb/get_attributes.rb
    lib/fog/aws/requests/simpledb/list_domains.rb
    lib/fog/aws/requests/simpledb/put_attributes.rb
    lib/fog/aws/requests/simpledb/select.rb
    lib/fog/aws/requests/storage/copy_object.rb
    lib/fog/aws/requests/storage/delete_bucket.rb
    lib/fog/aws/requests/storage/delete_object.rb
    lib/fog/aws/requests/storage/get_bucket.rb
    lib/fog/aws/requests/storage/get_bucket_acl.rb
    lib/fog/aws/requests/storage/get_bucket_location.rb
    lib/fog/aws/requests/storage/get_bucket_logging.rb
    lib/fog/aws/requests/storage/get_bucket_object_versions.rb
    lib/fog/aws/requests/storage/get_bucket_versioning.rb
    lib/fog/aws/requests/storage/get_object.rb
    lib/fog/aws/requests/storage/get_object_acl.rb
    lib/fog/aws/requests/storage/get_object_torrent.rb
    lib/fog/aws/requests/storage/get_object_url.rb
    lib/fog/aws/requests/storage/get_request_payment.rb
    lib/fog/aws/requests/storage/get_service.rb
    lib/fog/aws/requests/storage/head_object.rb
    lib/fog/aws/requests/storage/put_bucket.rb
    lib/fog/aws/requests/storage/put_bucket_acl.rb
    lib/fog/aws/requests/storage/put_bucket_logging.rb
    lib/fog/aws/requests/storage/put_bucket_versioning.rb
    lib/fog/aws/requests/storage/put_object.rb
    lib/fog/aws/requests/storage/put_object_url.rb
    lib/fog/aws/requests/storage/put_request_payment.rb
    lib/fog/aws/s3.rb
    lib/fog/aws/simpledb.rb
    lib/fog/aws/storage.rb
    lib/fog/bin.rb
    lib/fog/bluebox.rb
    lib/fog/bluebox/bin.rb
    lib/fog/bluebox/compute.rb
    lib/fog/bluebox/models/compute/flavor.rb
    lib/fog/bluebox/models/compute/flavors.rb
    lib/fog/bluebox/models/compute/image.rb
    lib/fog/bluebox/models/compute/images.rb
    lib/fog/bluebox/models/compute/server.rb
    lib/fog/bluebox/models/compute/servers.rb
    lib/fog/bluebox/requests/compute/create_block.rb
    lib/fog/bluebox/requests/compute/destroy_block.rb
    lib/fog/bluebox/requests/compute/get_block.rb
    lib/fog/bluebox/requests/compute/get_blocks.rb
    lib/fog/bluebox/requests/compute/get_product.rb
    lib/fog/bluebox/requests/compute/get_products.rb
    lib/fog/bluebox/requests/compute/get_template.rb
    lib/fog/bluebox/requests/compute/get_templates.rb
    lib/fog/bluebox/requests/compute/reboot_block.rb
    lib/fog/collection.rb
    lib/fog/connection.rb
    lib/fog/credentials.rb
    lib/fog/deprecation.rb
    lib/fog/errors.rb
    lib/fog/go_grid.rb
    lib/fog/go_grid/bin.rb
    lib/fog/go_grid/compute.rb
    lib/fog/go_grid/requests/compute/common_lookup_list.rb
    lib/fog/go_grid/requests/compute/grid_image_list.rb
    lib/fog/go_grid/requests/compute/grid_ip_list.rb
    lib/fog/go_grid/requests/compute/grid_loadbalancer_list.rb
    lib/fog/go_grid/requests/compute/grid_server_add.rb
    lib/fog/go_grid/requests/compute/grid_server_delete.rb
    lib/fog/go_grid/requests/compute/grid_server_get.rb
    lib/fog/go_grid/requests/compute/grid_server_list.rb
    lib/fog/go_grid/requests/compute/grid_server_power.rb
    lib/fog/google.rb
    lib/fog/google/bin.rb
    lib/fog/google/models/storage/directories.rb
    lib/fog/google/models/storage/directory.rb
    lib/fog/google/models/storage/file.rb
    lib/fog/google/models/storage/files.rb
    lib/fog/google/parsers/storage/access_control_list.rb
    lib/fog/google/parsers/storage/copy_object.rb
    lib/fog/google/parsers/storage/get_bucket.rb
    lib/fog/google/parsers/storage/get_bucket_logging.rb
    lib/fog/google/parsers/storage/get_bucket_object_versions.rb
    lib/fog/google/parsers/storage/get_bucket_versioning.rb
    lib/fog/google/parsers/storage/get_request_payment.rb
    lib/fog/google/parsers/storage/get_service.rb
    lib/fog/google/requests/storage/copy_object.rb
    lib/fog/google/requests/storage/delete_bucket.rb
    lib/fog/google/requests/storage/delete_object.rb
    lib/fog/google/requests/storage/get_bucket.rb
    lib/fog/google/requests/storage/get_bucket_acl.rb
    lib/fog/google/requests/storage/get_object.rb
    lib/fog/google/requests/storage/get_object_acl.rb
    lib/fog/google/requests/storage/get_object_torrent.rb
    lib/fog/google/requests/storage/get_object_url.rb
    lib/fog/google/requests/storage/get_service.rb
    lib/fog/google/requests/storage/head_object.rb
    lib/fog/google/requests/storage/put_bucket.rb
    lib/fog/google/requests/storage/put_bucket_acl.rb
    lib/fog/google/requests/storage/put_object.rb
    lib/fog/google/requests/storage/put_object_url.rb
    lib/fog/google/storage.rb
    lib/fog/hmac.rb
    lib/fog/linode.rb
    lib/fog/linode/bin.rb
    lib/fog/linode/compute.rb
    lib/fog/linode/requests/compute/avail_datacenters.rb
    lib/fog/linode/requests/compute/avail_distributions.rb
    lib/fog/linode/requests/compute/avail_kernels.rb
    lib/fog/linode/requests/compute/avail_linodeplans.rb
    lib/fog/linode/requests/compute/avail_stackscripts.rb
    lib/fog/linode/requests/compute/linode_create.rb
    lib/fog/linode/requests/compute/linode_delete.rb
    lib/fog/linode/requests/compute/linode_list.rb
    lib/fog/linode/requests/compute/linode_reboot.rb
    lib/fog/local.rb
    lib/fog/local/bin.rb
    lib/fog/local/models/storage/directories.rb
    lib/fog/local/models/storage/directory.rb
    lib/fog/local/models/storage/file.rb
    lib/fog/local/models/storage/files.rb
    lib/fog/local/storage.rb
    lib/fog/model.rb
    lib/fog/new_servers.rb
    lib/fog/new_servers/bin.rb
    lib/fog/new_servers/compute.rb
    lib/fog/new_servers/requests/compute/add_server.rb
    lib/fog/new_servers/requests/compute/cancel_server.rb
    lib/fog/new_servers/requests/compute/get_server.rb
    lib/fog/new_servers/requests/compute/list_images.rb
    lib/fog/new_servers/requests/compute/list_plans.rb
    lib/fog/new_servers/requests/compute/list_servers.rb
    lib/fog/new_servers/requests/compute/reboot_server.rb
    lib/fog/parser.rb
    lib/fog/provider.rb
    lib/fog/rackspace.rb
    lib/fog/rackspace/bin.rb
    lib/fog/rackspace/compute.rb
    lib/fog/rackspace/files.rb
    lib/fog/rackspace/models/compute/flavor.rb
    lib/fog/rackspace/models/compute/flavors.rb
    lib/fog/rackspace/models/compute/image.rb
    lib/fog/rackspace/models/compute/images.rb
    lib/fog/rackspace/models/compute/server.rb
    lib/fog/rackspace/models/compute/servers.rb
    lib/fog/rackspace/models/storage/directories.rb
    lib/fog/rackspace/models/storage/directory.rb
    lib/fog/rackspace/models/storage/file.rb
    lib/fog/rackspace/models/storage/files.rb
    lib/fog/rackspace/requests/compute/create_image.rb
    lib/fog/rackspace/requests/compute/create_server.rb
    lib/fog/rackspace/requests/compute/delete_image.rb
    lib/fog/rackspace/requests/compute/delete_server.rb
    lib/fog/rackspace/requests/compute/get_flavor_details.rb
    lib/fog/rackspace/requests/compute/get_image_details.rb
    lib/fog/rackspace/requests/compute/get_server_details.rb
    lib/fog/rackspace/requests/compute/list_addresses.rb
    lib/fog/rackspace/requests/compute/list_flavors.rb
    lib/fog/rackspace/requests/compute/list_flavors_detail.rb
    lib/fog/rackspace/requests/compute/list_images.rb
    lib/fog/rackspace/requests/compute/list_images_detail.rb
    lib/fog/rackspace/requests/compute/list_private_addresses.rb
    lib/fog/rackspace/requests/compute/list_public_addresses.rb
    lib/fog/rackspace/requests/compute/list_servers.rb
    lib/fog/rackspace/requests/compute/list_servers_detail.rb
    lib/fog/rackspace/requests/compute/reboot_server.rb
    lib/fog/rackspace/requests/compute/update_server.rb
    lib/fog/rackspace/requests/storage/delete_container.rb
    lib/fog/rackspace/requests/storage/delete_object.rb
    lib/fog/rackspace/requests/storage/get_container.rb
    lib/fog/rackspace/requests/storage/get_containers.rb
    lib/fog/rackspace/requests/storage/get_object.rb
    lib/fog/rackspace/requests/storage/head_container.rb
    lib/fog/rackspace/requests/storage/head_containers.rb
    lib/fog/rackspace/requests/storage/head_object.rb
    lib/fog/rackspace/requests/storage/put_container.rb
    lib/fog/rackspace/requests/storage/put_object.rb
    lib/fog/rackspace/servers.rb
    lib/fog/rackspace/storage.rb
    lib/fog/service.rb
    lib/fog/slicehost.rb
    lib/fog/slicehost/bin.rb
    lib/fog/slicehost/compute.rb
    lib/fog/slicehost/models/compute/flavor.rb
    lib/fog/slicehost/models/compute/flavors.rb
    lib/fog/slicehost/models/compute/image.rb
    lib/fog/slicehost/models/compute/images.rb
    lib/fog/slicehost/models/compute/server.rb
    lib/fog/slicehost/models/compute/servers.rb
    lib/fog/slicehost/parsers/compute/create_slice.rb
    lib/fog/slicehost/parsers/compute/get_backups.rb
    lib/fog/slicehost/parsers/compute/get_flavor.rb
    lib/fog/slicehost/parsers/compute/get_flavors.rb
    lib/fog/slicehost/parsers/compute/get_image.rb
    lib/fog/slicehost/parsers/compute/get_images.rb
    lib/fog/slicehost/parsers/compute/get_slice.rb
    lib/fog/slicehost/parsers/compute/get_slices.rb
    lib/fog/slicehost/requests/compute/create_slice.rb
    lib/fog/slicehost/requests/compute/delete_slice.rb
    lib/fog/slicehost/requests/compute/get_backups.rb
    lib/fog/slicehost/requests/compute/get_flavor.rb
    lib/fog/slicehost/requests/compute/get_flavors.rb
    lib/fog/slicehost/requests/compute/get_image.rb
    lib/fog/slicehost/requests/compute/get_images.rb
    lib/fog/slicehost/requests/compute/get_slice.rb
    lib/fog/slicehost/requests/compute/get_slices.rb
    lib/fog/slicehost/requests/compute/reboot_slice.rb
    lib/fog/ssh.rb
    lib/fog/terremark.rb
    lib/fog/terremark/bin.rb
    lib/fog/terremark/ecloud.rb
    lib/fog/terremark/models/shared/address.rb
    lib/fog/terremark/models/shared/addresses.rb
    lib/fog/terremark/models/shared/network.rb
    lib/fog/terremark/models/shared/networks.rb
    lib/fog/terremark/models/shared/server.rb
    lib/fog/terremark/models/shared/servers.rb
    lib/fog/terremark/models/shared/task.rb
    lib/fog/terremark/models/shared/tasks.rb
    lib/fog/terremark/models/shared/vdc.rb
    lib/fog/terremark/models/shared/vdcs.rb
    lib/fog/terremark/parser.rb
    lib/fog/terremark/parsers/shared/get_catalog.rb
    lib/fog/terremark/parsers/shared/get_catalog_item.rb
    lib/fog/terremark/parsers/shared/get_internet_services.rb
    lib/fog/terremark/parsers/shared/get_network_ips.rb
    lib/fog/terremark/parsers/shared/get_node_services.rb
    lib/fog/terremark/parsers/shared/get_organization.rb
    lib/fog/terremark/parsers/shared/get_organizations.rb
    lib/fog/terremark/parsers/shared/get_public_ips.rb
    lib/fog/terremark/parsers/shared/get_tasks_list.rb
    lib/fog/terremark/parsers/shared/get_vapp_template.rb
    lib/fog/terremark/parsers/shared/get_vdc.rb
    lib/fog/terremark/parsers/shared/instantiate_vapp_template.rb
    lib/fog/terremark/parsers/shared/internet_service.rb
    lib/fog/terremark/parsers/shared/network.rb
    lib/fog/terremark/parsers/shared/node_service.rb
    lib/fog/terremark/parsers/shared/public_ip.rb
    lib/fog/terremark/parsers/shared/task.rb
    lib/fog/terremark/parsers/shared/vapp.rb
    lib/fog/terremark/requests/shared/add_internet_service.rb
    lib/fog/terremark/requests/shared/add_node_service.rb
    lib/fog/terremark/requests/shared/create_internet_service.rb
    lib/fog/terremark/requests/shared/delete_internet_service.rb
    lib/fog/terremark/requests/shared/delete_node_service.rb
    lib/fog/terremark/requests/shared/delete_public_ip.rb
    lib/fog/terremark/requests/shared/delete_vapp.rb
    lib/fog/terremark/requests/shared/deploy_vapp.rb
    lib/fog/terremark/requests/shared/get_catalog.rb
    lib/fog/terremark/requests/shared/get_catalog_item.rb
    lib/fog/terremark/requests/shared/get_internet_services.rb
    lib/fog/terremark/requests/shared/get_network.rb
    lib/fog/terremark/requests/shared/get_network_ips.rb
    lib/fog/terremark/requests/shared/get_node_services.rb
    lib/fog/terremark/requests/shared/get_organization.rb
    lib/fog/terremark/requests/shared/get_organizations.rb
    lib/fog/terremark/requests/shared/get_public_ip.rb
    lib/fog/terremark/requests/shared/get_public_ips.rb
    lib/fog/terremark/requests/shared/get_task.rb
    lib/fog/terremark/requests/shared/get_tasks_list.rb
    lib/fog/terremark/requests/shared/get_vapp.rb
    lib/fog/terremark/requests/shared/get_vapp_template.rb
    lib/fog/terremark/requests/shared/get_vdc.rb
    lib/fog/terremark/requests/shared/instantiate_vapp_template.rb
    lib/fog/terremark/requests/shared/power_off.rb
    lib/fog/terremark/requests/shared/power_on.rb
    lib/fog/terremark/requests/shared/power_reset.rb
    lib/fog/terremark/requests/shared/power_shutdown.rb
    lib/fog/terremark/shared.rb
    lib/fog/terremark/vcloud.rb
    lib/fog/vcloud.rb
    lib/fog/vcloud/bin.rb
    lib/fog/vcloud/collection.rb
    lib/fog/vcloud/generators.rb
    lib/fog/vcloud/model.rb
    lib/fog/vcloud/models/vdc.rb
    lib/fog/vcloud/models/vdcs.rb
    lib/fog/vcloud/requests/get_network.rb
    lib/fog/vcloud/requests/get_organization.rb
    lib/fog/vcloud/requests/get_vdc.rb
    lib/fog/vcloud/requests/get_versions.rb
    lib/fog/vcloud/requests/login.rb
    lib/fog/vcloud/terremark/ecloud.rb
    lib/fog/vcloud/terremark/ecloud/models/catalog.rb
    lib/fog/vcloud/terremark/ecloud/models/catalog_item.rb
    lib/fog/vcloud/terremark/ecloud/models/firewall_acl.rb
    lib/fog/vcloud/terremark/ecloud/models/firewall_acls.rb
    lib/fog/vcloud/terremark/ecloud/models/internet_service.rb
    lib/fog/vcloud/terremark/ecloud/models/internet_services.rb
    lib/fog/vcloud/terremark/ecloud/models/ip.rb
    lib/fog/vcloud/terremark/ecloud/models/ips.rb
    lib/fog/vcloud/terremark/ecloud/models/network.rb
    lib/fog/vcloud/terremark/ecloud/models/networks.rb
    lib/fog/vcloud/terremark/ecloud/models/node.rb
    lib/fog/vcloud/terremark/ecloud/models/nodes.rb
    lib/fog/vcloud/terremark/ecloud/models/public_ip.rb
    lib/fog/vcloud/terremark/ecloud/models/public_ips.rb
    lib/fog/vcloud/terremark/ecloud/models/server.rb
    lib/fog/vcloud/terremark/ecloud/models/servers.rb
    lib/fog/vcloud/terremark/ecloud/models/task.rb
    lib/fog/vcloud/terremark/ecloud/models/tasks.rb
    lib/fog/vcloud/terremark/ecloud/models/vdc.rb
    lib/fog/vcloud/terremark/ecloud/models/vdcs.rb
    lib/fog/vcloud/terremark/ecloud/requests/add_internet_service.rb
    lib/fog/vcloud/terremark/ecloud/requests/add_node.rb
    lib/fog/vcloud/terremark/ecloud/requests/clone_vapp.rb
    lib/fog/vcloud/terremark/ecloud/requests/configure_internet_service.rb
    lib/fog/vcloud/terremark/ecloud/requests/configure_network.rb
    lib/fog/vcloud/terremark/ecloud/requests/configure_network_ip.rb
    lib/fog/vcloud/terremark/ecloud/requests/configure_node.rb
    lib/fog/vcloud/terremark/ecloud/requests/configure_vapp.rb
    lib/fog/vcloud/terremark/ecloud/requests/delete_internet_service.rb
    lib/fog/vcloud/terremark/ecloud/requests/delete_node.rb
    lib/fog/vcloud/terremark/ecloud/requests/delete_vapp.rb
    lib/fog/vcloud/terremark/ecloud/requests/get_catalog.rb
    lib/fog/vcloud/terremark/ecloud/requests/get_catalog_item.rb
    lib/fog/vcloud/terremark/ecloud/requests/get_customization_options.rb
    lib/fog/vcloud/terremark/ecloud/requests/get_firewall_acl.rb
    lib/fog/vcloud/terremark/ecloud/requests/get_firewall_acls.rb
    lib/fog/vcloud/terremark/ecloud/requests/get_internet_services.rb
    lib/fog/vcloud/terremark/ecloud/requests/get_network.rb
    lib/fog/vcloud/terremark/ecloud/requests/get_network_extensions.rb
    lib/fog/vcloud/terremark/ecloud/requests/get_network_ip.rb
    lib/fog/vcloud/terremark/ecloud/requests/get_network_ips.rb
    lib/fog/vcloud/terremark/ecloud/requests/get_node.rb
    lib/fog/vcloud/terremark/ecloud/requests/get_nodes.rb
    lib/fog/vcloud/terremark/ecloud/requests/get_public_ip.rb
    lib/fog/vcloud/terremark/ecloud/requests/get_public_ips.rb
    lib/fog/vcloud/terremark/ecloud/requests/get_task.rb
    lib/fog/vcloud/terremark/ecloud/requests/get_task_list.rb
    lib/fog/vcloud/terremark/ecloud/requests/get_vapp.rb
    lib/fog/vcloud/terremark/ecloud/requests/get_vapp_template.rb
    lib/fog/vcloud/terremark/ecloud/requests/get_vdc.rb
    lib/fog/vcloud/terremark/ecloud/requests/instantiate_vapp_template.rb
    lib/fog/vcloud/terremark/ecloud/requests/power_off.rb
    lib/fog/vcloud/terremark/ecloud/requests/power_on.rb
    lib/fog/vcloud/terremark/ecloud/requests/power_reset.rb
    lib/fog/vcloud/terremark/ecloud/requests/power_shutdown.rb
    lib/fog/vcloud/terremark/vcloud.rb
    lib/fog/vcloud/terremark/vcloud/requests/get_vdc.rb
    spec/aws/models/compute/address_spec.rb
    spec/aws/models/compute/addresses_spec.rb
    spec/aws/models/compute/flavors_spec.rb
    spec/aws/models/compute/key_pair_spec.rb
    spec/aws/models/compute/key_pairs_spec.rb
    spec/aws/models/compute/security_group_spec.rb
    spec/aws/models/compute/security_groups_spec.rb
    spec/aws/models/compute/server_spec.rb
    spec/aws/models/compute/servers_spec.rb
    spec/aws/models/compute/snapshot_spec.rb
    spec/aws/models/compute/snapshots_spec.rb
    spec/aws/models/compute/volume_spec.rb
    spec/aws/models/compute/volumes_spec.rb
    spec/aws/models/storage/directories_spec.rb
    spec/aws/models/storage/directory_spec.rb
    spec/aws/models/storage/file_spec.rb
    spec/aws/models/storage/files_spec.rb
    spec/aws/requests/simpledb/batch_put_attributes_spec.rb
    spec/aws/requests/simpledb/create_domain_spec.rb
    spec/aws/requests/simpledb/delete_attributes_spec.rb
    spec/aws/requests/simpledb/delete_domain_spec.rb
    spec/aws/requests/simpledb/domain_metadata_spec.rb
    spec/aws/requests/simpledb/get_attributes_spec.rb
    spec/aws/requests/simpledb/list_domains_spec.rb
    spec/aws/requests/simpledb/put_attributes_spec.rb
    spec/aws/requests/simpledb/select_spec.rb
    spec/aws/requests/storage/copy_object_spec.rb
    spec/aws/requests/storage/delete_bucket_spec.rb
    spec/aws/requests/storage/delete_object_spec.rb
    spec/aws/requests/storage/get_bucket_location_spec.rb
    spec/aws/requests/storage/get_bucket_spec.rb
    spec/aws/requests/storage/get_object_spec.rb
    spec/aws/requests/storage/get_request_payment_spec.rb
    spec/aws/requests/storage/get_service_spec.rb
    spec/aws/requests/storage/head_object_spec.rb
    spec/aws/requests/storage/put_bucket_spec.rb
    spec/aws/requests/storage/put_object_spec.rb
    spec/aws/requests/storage/put_request_payment_spec.rb
    spec/bluebox/models/compute/flavors_spec.rb
    spec/bluebox/models/compute/server_spec.rb
    spec/bluebox/models/compute/servers_spec.rb
    spec/compact_progress_bar_formatter.rb
    spec/google/models/storage/directories_spec.rb
    spec/google/models/storage/directory_spec.rb
    spec/google/models/storage/file_spec.rb
    spec/google/models/storage/files_spec.rb
    spec/google/requests/storage/copy_object_spec.rb
    spec/google/requests/storage/delete_bucket_spec.rb
    spec/google/requests/storage/delete_object_spec.rb
    spec/google/requests/storage/get_bucket_spec.rb
    spec/google/requests/storage/get_object_spec.rb
    spec/google/requests/storage/get_service_spec.rb
    spec/google/requests/storage/head_object_spec.rb
    spec/google/requests/storage/put_bucket_spec.rb
    spec/google/requests/storage/put_object_spec.rb
    spec/lorem.txt
    spec/rackspace/models/compute/flavors_spec.rb
    spec/rackspace/models/compute/server_spec.rb
    spec/rackspace/models/compute/servers_spec.rb
    spec/rackspace/requests/storage/delete_container_spec.rb
    spec/rackspace/requests/storage/delete_object_spec.rb
    spec/rackspace/requests/storage/get_container_spec.rb
    spec/rackspace/requests/storage/get_containers_spec.rb
    spec/rackspace/requests/storage/get_object_spec.rb
    spec/rackspace/requests/storage/head_container_spec.rb
    spec/rackspace/requests/storage/head_containers_spec.rb
    spec/rackspace/requests/storage/head_object_spec.rb
    spec/rackspace/requests/storage/put_container_spec.rb
    spec/rackspace/requests/storage/put_object_spec.rb
    spec/shared_examples/flavors_examples.rb
    spec/shared_examples/server_examples.rb
    spec/shared_examples/servers_examples.rb
    spec/slicehost/models/compute/flavors_spec.rb
    spec/slicehost/models/compute/server_spec.rb
    spec/slicehost/models/compute/servers_spec.rb
    spec/spec_helper.rb
    spec/vcloud/bin_spec.rb
    spec/vcloud/models/vdc_spec.rb
    spec/vcloud/models/vdcs_spec.rb
    spec/vcloud/requests/get_network_spec.rb
    spec/vcloud/requests/get_organization_spec.rb
    spec/vcloud/requests/get_vdc_spec.rb
    spec/vcloud/requests/get_versions_spec.rb
    spec/vcloud/requests/login_spec.rb
    spec/vcloud/spec_helper.rb
    spec/vcloud/terremark/ecloud/models/internet_service_spec.rb
    spec/vcloud/terremark/ecloud/models/internet_services_spec.rb
    spec/vcloud/terremark/ecloud/models/ip_spec.rb
    spec/vcloud/terremark/ecloud/models/ips_spec.rb
    spec/vcloud/terremark/ecloud/models/network_spec.rb
    spec/vcloud/terremark/ecloud/models/networks_spec.rb
    spec/vcloud/terremark/ecloud/models/node_spec.rb
    spec/vcloud/terremark/ecloud/models/nodes_spec.rb
    spec/vcloud/terremark/ecloud/models/public_ip_spec.rb
    spec/vcloud/terremark/ecloud/models/public_ips_spec.rb
    spec/vcloud/terremark/ecloud/models/vdc_spec.rb
    spec/vcloud/terremark/ecloud/models/vdcs_spec.rb
    spec/vcloud/terremark/ecloud/requests/add_internet_service_spec.rb
    spec/vcloud/terremark/ecloud/requests/add_node_spec.rb
    spec/vcloud/terremark/ecloud/requests/configure_internet_service_spec.rb
    spec/vcloud/terremark/ecloud/requests/configure_node_spec.rb
    spec/vcloud/terremark/ecloud/requests/delete_internet_service_spec.rb
    spec/vcloud/terremark/ecloud/requests/delete_node_spec.rb
    spec/vcloud/terremark/ecloud/requests/get_internet_services_spec.rb
    spec/vcloud/terremark/ecloud/requests/get_network_ip_spec.rb
    spec/vcloud/terremark/ecloud/requests/get_network_ips_spec.rb
    spec/vcloud/terremark/ecloud/requests/get_network_spec.rb
    spec/vcloud/terremark/ecloud/requests/get_node_spec.rb
    spec/vcloud/terremark/ecloud/requests/get_nodes_spec.rb
    spec/vcloud/terremark/ecloud/requests/get_public_ip_spec.rb
    spec/vcloud/terremark/ecloud/requests/get_public_ips_spec.rb
    spec/vcloud/terremark/ecloud/requests/get_vdc_spec.rb
    spec/vcloud/terremark/ecloud/requests/login_spec.rb
    spec/vcloud/vcloud_spec.rb
    tests/aws/helper.rb
    tests/aws/models/storage/directory_tests.rb
    tests/aws/requests/compute/address_tests.rb
    tests/aws/requests/compute/availability_zone_tests.rb
    tests/aws/requests/compute/image_tests.rb
    tests/aws/requests/compute/instance_tests.rb
    tests/aws/requests/compute/key_pair_tests.rb
    tests/aws/requests/compute/region_tests.rb
    tests/aws/requests/compute/security_group_tests.rb
    tests/aws/requests/compute/snapshot_tests.rb
    tests/aws/requests/compute/volume_tests.rb
    tests/bluebox/helper.rb
    tests/bluebox/requests/compute/block_tests.rb
    tests/bluebox/requests/compute/product_tests.rb
    tests/bluebox/requests/compute/template_tests.rb
    tests/helper.rb
    tests/helper_tests.rb
    tests/helpers/model_helper.rb
    tests/linode/helper.rb
    tests/linode/requests/compute/datacenter_tests.rb
    tests/linode/requests/compute/distribution_tests.rb
    tests/linode/requests/compute/linode_tests.rb
    tests/linode/requests/compute/linodeplans_tests.rb
    tests/rackspace/helper.rb
    tests/rackspace/requests/compute/address_tests.rb
    tests/rackspace/requests/compute/flavor_tests.rb
    tests/rackspace/requests/compute/image_tests.rb
    tests/rackspace/requests/compute/server_tests.rb
    tests/slicehost/helper.rb
    tests/slicehost/requests/compute/backup_tests.rb
    tests/slicehost/requests/compute/flavor_tests.rb
    tests/slicehost/requests/compute/image_tests.rb
    tests/slicehost/requests/compute/slice_tests.rb
  ]
  # = MANIFEST =

  ## Test files will be grabbed from the file list. Make sure the path glob
  ## matches what you actually use.
  s.test_files = s.files.select { |path| path =~ /^[spec|tests]\/.*_[spec|tests]\.rb/ }
end
