require File.dirname(__FILE__) + '/../../../spec_helper'

describe 'Fog::AWS::EC2::Addresses' do

  describe "#all" do

    it "should return a Fog::AWS::EC2::Addresses" do
      AWS[:ec2].addresses.all.should be_a(Fog::AWS::EC2::Addresses)
    end

    it "should include persisted addresses" do
      address = AWS[:ec2].addresses.create
      AWS[:ec2].addresses.get(address.public_ip).should_not be_nil
      address.destroy
    end

  end

  describe "#create" do

    before(:each) do
      @address = AWS[:ec2].addresses.create
    end

    after(:each) do
      @address.destroy
    end

    it "should return a Fog::AWS::EC2::Address" do
      @address.should be_a(Fog::AWS::EC2::Address)
    end

    it "should exist on ec2" do
      AWS[:ec2].addresses.get(@address.public_ip).should_not be_nil
    end

  end

  describe "#get" do

    it "should return a Fog::AWS::EC2::Address if a matching address exists" do
      address = AWS[:ec2].addresses.create
      get = AWS[:ec2].addresses.get(address.public_ip)
      address.attributes.should == get.attributes
      address.destroy
    end

    it "should return nil if no matching address exists" do
      AWS[:ec2].addresses.get('0.0.0.0').should be_nil
    end

  end

  describe "#new" do

    it "should return a Fog::AWS::EC2::Address" do
      AWS[:ec2].addresses.new.should be_a(Fog::AWS::EC2::Address)
    end

  end

  describe "#reload" do

    it "should return a Fog::AWS::EC2::Addresses" do
      AWS[:ec2].addresses.all.reload.should be_a(Fog::AWS::EC2::Addresses)
    end

  end

end
