require File.dirname(__FILE__) + '/../../../spec_helper'

describe 'Fog::AWS::EC2::Volumes' do

  describe "#all" do

    it "should return a Fog::AWS::EC2::Volumes" do
      AWS[:ec2].volumes.all.should be_a(Fog::AWS::EC2::Volumes)
    end

    it "should include persisted volumes" do
      volume = AWS[:ec2].volumes.create(:availability_zone => 'us-east-1a', :size => 1, :device => 'dev/sdz1')
      AWS[:ec2].volumes.get(volume.id).should_not be_nil
      volume.destroy
    end

  end

  describe "#create" do

    before(:each) do
      @volume = AWS[:ec2].volumes.create(:availability_zone => 'us-east-1a', :size => 1, :device => 'dev/sdz1')
    end

    after(:each) do
      @volume.destroy
    end

    it "should return a Fog::AWS::EC2::Volume" do
      @volume.should be_a(Fog::AWS::EC2::Volume)
    end

    it "should exist on ec2" do
      AWS[:ec2].volumes.get(@volume.id).should_not be_nil
    end

  end

  describe "#get" do

    it "should return a Fog::AWS::EC2::Volume if a matching volume exists" do
      volume = AWS[:ec2].volumes.create(:availability_zone => 'us-east-1a', :size => 1, :device => 'dev/sdz1')
      volume.wait_for { ready? }
      get = AWS[:ec2].volumes.get(volume.id)
      volume.attributes.should == get.attributes
      volume.destroy
    end

    it "should return nil if no matching address exists" do
      AWS[:ec2].volumes.get('vol-00000000').should be_nil
    end

  end

  describe "#new" do

    it "should return a Fog::AWS::EC2::Volume" do
      AWS[:ec2].volumes.new.should be_a(Fog::AWS::EC2::Volume)
    end

  end

  describe "#reload" do

    it "should return a Fog::AWS::EC2::Volumes" do
      AWS[:ec2].volumes.all.reload.should be_a(Fog::AWS::EC2::Volumes)
    end

  end

end
